/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.bcxin.ars.dao.supervision.OtherPunishDao;
import com.bcxin.ars.dao.supervision.OtherPunishInvolverDao;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.OtherPunishPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.OtherPunish;
import com.bcxin.ars.model.supervision.OtherPunishInvolver;
import com.bcxin.ars.service.supervision.OtherPunishService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OtherPunishServiceImpl
implements OtherPunishService {
    @Autowired
    private OtherPunishDao otherPunishDao;
    @Autowired
    private OtherPunishInvolverDao otherPunishInvolverDao;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(OtherPunish record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.otherPunishDao.delete(record);
    }

    public void save(OtherPunish record) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setCreateTime(new Date());
        } else {
            OtherPunish dbRecord = this.otherPunishDao.findById(record.getId());
            boolean flag = false;
            if (!dbRecord.getPunishType().equals(record.getPunishType()) && "1".equals(record.getPunishType())) {
                flag = true;
            }
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
            if (flag) {
                record.setCompanyName(null);
                record.setAddress(null);
            }
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.otherPunishDao.save(record);
        if (!"1".equals(record.getPunishType())) {
            this.otherPunishInvolverDao.deleteByPunishId(record.getId());
            if (record.getInvolvers() != null && record.getInvolvers().size() > 0) {
                ArrayList<OtherPunishInvolver> involverList = new ArrayList<OtherPunishInvolver>();
                for (OtherPunishInvolver involver : record.getInvolvers()) {
                    if (!StringUtil.isNotEmpty((String)involver.getName()) || !StringUtil.isNotEmpty((String)involver.getIdnum())) continue;
                    involver.setActive(Boolean.valueOf(true));
                    involver.setCreateTime(new Date());
                    involver.setUpdateTime(new Date());
                    involver.setUpdateBy(currentUser.getUsername());
                    involver.setUpdateflag(Boolean.valueOf(true));
                    involver.setPunishId(record.getId());
                    involverList.add(involver);
                }
                if (involverList.size() > 0) {
                    this.otherPunishInvolverDao.saveBatch(involverList);
                }
            }
        }
    }

    public OtherPunish findById(Long id) {
        OtherPunish otherPunish = this.otherPunishDao.findById(id);
        if (!"1".equals(otherPunish.getPunishType())) {
            otherPunish.setInvolvers(this.otherPunishInvolverDao.findByPunishId(id));
        }
        return otherPunish;
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch(dto);
        this.otherPunishDao.searchForPage((OtherPunishPageSearchDto)dto, page);
    }
}

