/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.CompanyInspectionDao;
import com.bcxin.ars.dao.supervision.CompanyInspectionDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.CompanyInspectionPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.CompanyInspection;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.supervision.CompanyInspectionService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CompanyInspection.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=CompanyInspection.class, getImportType=ImportType.BATCH)
public class CompanyInspectionServiceImpl
extends BaseService
implements CompanyInspectionService {
    @Autowired
    private CompanyInspectionDao companyInspectionDao;
    @Autowired
    private CompanyInspectionDaoAop companyInspectionDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;

    public int delete(CompanyInspection record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.companyInspectionDaoAop.delete(record);
    }

    public void save(CompanyInspection record) {
        String isInSystem;
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setCreateTime(new Date());
            if (StringUtil.isNotEmpty((String)record.getSignImgPath())) {
                record.setSignImgPath(this.saveBase64Img(record.getSignImgPath()));
            }
        } else {
            CompanyInspection dbRecord = this.companyInspectionDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
        }
        if (!StringUtils.isEmpty((Object)(isInSystem = record.getIsInSystem())) && isInSystem.equals("2")) {
            String companyNameDefine = record.getCompanyNameDefine();
            record.setCompanyName(companyNameDefine);
            record.setCompanyId(null);
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setUserid(currentUser.getId());
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.companyInspectionDaoAop.save(record);
    }

    public CompanyInspection findById(Long id) {
        return this.companyInspectionDao.findById(id);
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch(dto);
        CompanyInspectionPageSearchDto searchDto = (CompanyInspectionPageSearchDto)dto;
        if (StringUtil.isNotEmpty((String)searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        this.companyInspectionDao.searchForPage((CompanyInspectionPageSearchDto)dto, page);
    }

    public List<CompanyInspection> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.companyInspectionDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(List<CompanyInspection> list) {
        ArrayList<CompanyInspection> dbList = new ArrayList<CompanyInspection>();
        for (CompanyInspection companyInspection : list) {
            CompanyInspection companyInspectionIn = this.companyInspectionDao.findById(companyInspection.getId());
            if (companyInspectionIn == null) {
                companyInspection.setUpdateflag(Boolean.valueOf(false));
                continue;
            }
            if (companyInspection.getUpdateTime().getTime() < companyInspectionIn.getUpdateTime().getTime()) {
                dbList.add(companyInspection);
            }
            companyInspection.setUpdateflag(Boolean.valueOf(true));
        }
        list.removeAll(dbList);
        this.companyInspectionDaoAop.saveBatch(list);
    }

    public List<CompanyInspection> findDSOutList(String startDate) {
        return this.companyInspectionDao.findDSOutList(startDate);
    }

    public void importBatch(List<CompanyInspection> list) {
        List dbList = this.companyInspectionDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CompanyInspection companyInspection : list) {
                companyInspection.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    companyInspection.setUpdateTime(DateUtil.dateAdd((int)6, (Date)companyInspection.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.companyInspectionDaoAop.saveBatch(list);
        }
    }
}

