/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.supervision;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.supervision.CompanyAwardDao;
import com.bcxin.ars.dao.supervision.CompanyAwardDaoAop;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.supervision.CompanyAwardPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.supervision.CompanyAward;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.supervision.CompanyAwardService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CompanyAward.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=CompanyAward.class, getImportType=ImportType.BATCH)
public class CompanyAwardServiceImpl
extends BaseService
implements CompanyAwardService {
    @Autowired
    private CompanyAwardDao companyAwardDao;
    @Autowired
    private CompanyAwardDaoAop companyAwardDaoAop;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private IdWorker idWorker;

    public int delete(CompanyAward record) {
        User currentUser = this.arsUtil.getCurrentUser();
        record.setUpdateTime(new Date());
        record.setUpdateBy(currentUser.getUsername());
        return this.companyAwardDaoAop.delete(record);
    }

    public void save(CompanyAward record) {
        String isInSystem;
        User currentUser = this.arsUtil.getCurrentUser();
        if (record.getId() == null) {
            record.setId(Long.valueOf(this.idWorker.nextId()));
            record.setCreateTime(new Date());
            if (StringUtil.isNotEmpty((String)record.getSignImgPath())) {
                record.setSignImgPath(this.saveBase64Img(record.getSignImgPath()));
            }
        } else {
            CompanyAward dbRecord = this.companyAwardDao.findById(record.getId());
            BeanUtils.copyPropertiesIgnore((Object)record, (Object)dbRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbRecord, (Object)record, (Boolean)false);
        }
        if (!StringUtils.isEmpty((Object)(isInSystem = record.getIsInSystem())) && isInSystem.equals("2")) {
            String companyNameDefine = record.getCompanyNameDefine();
            record.setCompanyName(companyNameDefine);
            record.setCompanyId(null);
        }
        record.setActive(Boolean.valueOf(true));
        record.setUpdateBy(currentUser.getUsername());
        record.setUpdateTime(new Date());
        record.setUpdateflag(Boolean.valueOf(true));
        record.setUserid(currentUser.getId());
        record.setAreaCode(currentUser.getPolice().getAreacode());
        this.companyAwardDaoAop.save(record);
    }

    public CompanyAward findById(Long id) {
        return this.companyAwardDao.findById(id);
    }

    public void searchForPage(SearchDto dto, AjaxPageResponse page) {
        dto.setPoliceBusiness(false);
        this.arsUtil.setPoliceSearch(dto);
        CompanyAwardPageSearchDto searchDto = (CompanyAwardPageSearchDto)dto;
        if (StringUtil.isNotEmpty((String)searchDto.getOrgAreaCode())) {
            if (searchDto.getOrgAreaCode().endsWith("0000")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 2) + "____");
            } else if (searchDto.getOrgAreaCode().endsWith("00")) {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode().substring(0, 4) + "__");
            } else {
                searchDto.setOrgAreaCode(searchDto.getOrgAreaCode());
            }
        }
        this.companyAwardDao.searchForPage((CompanyAwardPageSearchDto)dto, page);
    }

    public List<CompanyAward> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.companyAwardDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(List<CompanyAward> list) {
        ArrayList<CompanyAward> dbList = new ArrayList<CompanyAward>();
        for (CompanyAward companyAward : list) {
            CompanyAward companyAwardIn = this.companyAwardDao.findById(companyAward.getId());
            if (companyAwardIn == null) {
                companyAward.setUpdateflag(Boolean.valueOf(false));
                continue;
            }
            if (companyAward.getUpdateTime().getTime() < companyAwardIn.getUpdateTime().getTime()) {
                dbList.add(companyAward);
            }
            companyAward.setUpdateflag(Boolean.valueOf(true));
        }
        list.removeAll(dbList);
        this.companyAwardDaoAop.saveBatch(list);
    }

    public List<CompanyAward> findDSOutList(String startDate) {
        return this.companyAwardDao.findDSOutList(startDate);
    }

    public void importBatch(List<CompanyAward> list) {
        List dbList = this.companyAwardDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CompanyAward companyAward : list) {
                companyAward.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    companyAward.setUpdateTime(DateUtil.dateAdd((int)6, (Date)companyAward.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.companyAwardDaoAop.saveBatch(list);
        }
    }
}

