/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.subsidy.impl;

import com.bcxin.ars.dao.sb.GradeSubsidyBatchDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.SubsidyOfflineBatchDao;
import com.bcxin.ars.dao.subsidy.SubsidyOfflineDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.subsidy.SubsidyOfflinePageSearchDto;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.model.BaseModel;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.msg.SysAttachment;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.subsidy.SubsidyOffline;
import com.bcxin.ars.model.subsidy.SubsidyOfflineBatch;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.msg.SysAttachmentService;
import com.bcxin.ars.service.subsidy.SubsidyOfflineService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.ItextPDFUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SubsidyOfflineServiceImpl
implements SubsidyOfflineService {
    Logger logger = LoggerFactory.getLogger(SubsidyOfflineServiceImpl.class);
    @Autowired
    private SubsidyOfflineDao subsidyOfflineDao;
    @Autowired
    private GradeSubsidyBatchDao gradeSubsidyBatchDao;
    @Autowired
    private SubsidyOfflineBatchDao subsidyOfflineBatchDao;
    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalLogDao approvalLogDao;
    @Autowired
    private SysAttachmentService sysAttachmentService;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(SubsidyOffline subsidyOffline) {
        User currentUser = this.arsUtil.getCurrentUser();
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateBy(currentUser.getUsername());
        return this.subsidyOfflineDao.delete(subsidyOffline);
    }

    public int save(SubsidyOffline subsidyOffline) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (subsidyOffline.getId() == null) {
            subsidyOffline.setCreateTime(new Date());
        } else {
            SubsidyOffline dbSubsidyOffline = this.subsidyOfflineDao.findById(subsidyOffline.getId());
            BeanUtils.copyPropertiesIgnore((Object)subsidyOffline, (Object)dbSubsidyOffline, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbSubsidyOffline, (Object)subsidyOffline, (Boolean)false);
        }
        subsidyOffline.setActive(Boolean.valueOf(true));
        subsidyOffline.setUpdateBy(currentUser.getUsername());
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateflag(Boolean.valueOf(true));
        subsidyOffline.setUserId(currentUser.getId());
        subsidyOffline.setAreaCode(currentUser.getPolice().getAreacode());
        return this.subsidyOfflineDao.save(subsidyOffline);
    }

    public SubsidyOffline findById(Long id) {
        return this.subsidyOfflineDao.findById(id);
    }

    public void searchForPage(SubsidyOfflinePageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.subsidyOfflineDao.searchForPage(dto, page);
    }

    public void importBatch(List<SubsidyOffline> list) {
        List dbList = this.subsidyOfflineDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (SubsidyOffline subsidyOffline : list) {
                subsidyOffline.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    subsidyOffline.setUpdateTime(DateUtil.dateAdd((int)6, (Date)subsidyOffline.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.subsidyOfflineDao.saveBatch(list);
        }
    }

    public List<SubsidyOffline> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.subsidyOfflineDao.searchForDataSynchronization(dto);
    }

    public List<SubsidyOffline> findDSOutList(String startDate) {
        return this.subsidyOfflineDao.findDSOutList(startDate);
    }

    public List<SubsidyOffline> findByBatchId(List<SubsidyOffline> list) {
        return this.subsidyOfflineDao.findByBatchId(list);
    }

    public void create(Long[] batchIds) {
        User user = this.arsUtil.getCurrentUser();
        Police police = user.getPolice();
        List batchList = this.gradeSubsidyBatchDao.findbyIds(batchIds);
        SubsidyOffline subsidyOffline = new SubsidyOffline();
        subsidyOffline.setId(Long.valueOf(this.idWorker.nextId()));
        subsidyOffline.setOrgId(user.getOrgid());
        subsidyOffline.setUserId(user.getId());
        subsidyOffline.setOffApprovalState("0051");
        subsidyOffline.setBatchNum(Integer.valueOf(batchIds.length));
        subsidyOffline.setUpdateflag(Boolean.valueOf(true));
        subsidyOffline.setActive(Boolean.valueOf(true));
        subsidyOffline.setCreateTime(new Date());
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateBy(user.getUsername());
        subsidyOffline.setAreaCode(police.getAreacode());
        HashMap<Long, String> comMap = new HashMap<Long, String>();
        Date minDate = new Date();
        SubsidyOfflineBatch subsidyOfflineBatch = null;
        ArrayList<SubsidyOfflineBatch> batches = new ArrayList<SubsidyOfflineBatch>();
        BigDecimal subsidyMoney = new BigDecimal("0.00");
        for (GradeSubsidyBatch gradeSubsidyBatch : batchList) {
            subsidyOfflineBatch = new SubsidyOfflineBatch();
            subsidyOfflineBatch.setOfflineId(subsidyOffline.getId());
            subsidyOfflineBatch.setBatchId(gradeSubsidyBatch.getId());
            subsidyOfflineBatch.setUpdateflag(Boolean.valueOf(true));
            subsidyOfflineBatch.setId(Long.valueOf(this.idWorker.nextId()));
            subsidyOfflineBatch.setActive(Boolean.valueOf(true));
            subsidyOfflineBatch.setUsed(Boolean.valueOf(true));
            subsidyOfflineBatch.setCreateTime(new Date());
            subsidyOfflineBatch.setUpdateTime(new Date());
            subsidyOfflineBatch.setUpdateBy(user.getUsername());
            batches.add(subsidyOfflineBatch);
            comMap.put(gradeSubsidyBatch.getCompanyid(), gradeSubsidyBatch.getCompanyname());
            if (minDate.getTime() > gradeSubsidyBatch.getCreateTime().getTime()) {
                minDate = gradeSubsidyBatch.getCreateTime();
            }
            subsidyMoney = subsidyMoney.add(new BigDecimal(gradeSubsidyBatch.getSubsidyMoney()));
            gradeSubsidyBatch.setOffApprovalState("0051");
        }
        subsidyOffline.setSubsidyMoney(subsidyMoney.toString());
        subsidyOffline.setComNum(Integer.valueOf(comMap.size()));
        subsidyOffline.setCycle(DateUtil.convertDateToString((Date)minDate, (String)"yyyy\u5e74MM\u6708dd\u65e5") + "\u2014" + DateUtil.getCurrentDate((String)"yyyy\u5e74MM\u6708dd\u65e5"));
        this.createApprovePDF(subsidyOffline, batchList);
        this.subsidyOfflineDao.save(subsidyOffline);
        this.subsidyOfflineBatchDao.saveBatch(batches);
        this.gradeSubsidyBatchDao.saveBatch(batchList);
    }

    private void createApprovePDF(SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) {
        try {
            Map<String, List<GradeSubsidyBatch>> typeGroupMap = batchList.stream().collect(Collectors.groupingBy(GradeSubsidyBatch::getSubsidyCerType));
            Map<Long, List<GradeSubsidyBatch>> batchGroupMap = batchList.stream().collect(Collectors.groupingBy(BusinessCommon::getCompanyid));
            Document document = new Document(PageSize.A4, 10.0f, 10.0f, 10.0f, 10.0f);
            String dirDate = DateUtil.getCurrentDate();
            String filePath = this.configUtils.sysAttachmentFolder + dirDate;
            String fileName = System.currentTimeMillis() + ".pdf";
            File dir = new File(filePath);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String key = "sysAttachment/" + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = filePath + "/" + fileName;
            PdfWriter writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(targetPath));
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            this.addApprove(document, writer, subsidyOffline, typeGroupMap);
            for (Long comId : batchGroupMap.keySet()) {
                document.newPage();
                this.addReport(document, writer, subsidyOffline, batchGroupMap.get(comId));
            }
            document.close();
            ArrayList<String> files = new ArrayList<String>();
            files.add(fileName);
            this.logger.info("\u538b\u7f29\u5e76\u4fdd\u5b58...");
            File targetFile = new File(targetPath);
            SysAttachment sysAttachment = new SysAttachment();
            sysAttachment.setPath(url);
            sysAttachment.setFileName(fileName);
            sysAttachment.setFileSize(Long.valueOf(targetFile.length()));
            this.sysAttachmentService.saveOrUpdate(sysAttachment);
            this.logger.info("\u672c\u5730\u6587\u4ef6\u4e0a\u4f20\u6210\u529f!");
            subsidyOffline.setAppAttachmentId(sysAttachment.getId());
            subsidyOffline.setApprovePath(url);
            FileUtil.deleteFile((String)fileName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }

    private void addReport(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) throws DocumentException {
        String[] titles;
        PdfPTable table = new PdfPTable(6);
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(570.0f);
        table.setTotalWidth(new float[]{70.0f, 95.0f, 130.0f, 80.0f, 100.0f, 95.0f});
        table.setLockedWidth(true);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        table.getDefaultCell().setBorder(0);
        PdfPCell cell1 = new PdfPCell((Phrase)new Paragraph("\u4fdd\u5b89\u5458\u57f9\u8bad\u8865\u8d34\u8d44\u91d1\u60c5\u51b5\u6c47\u603b\u8868", ItextPDFUtil.setFont((int)22)));
        cell1.setColspan(6);
        cell1.setRowspan(1);
        cell1.setFixedHeight(120.0f);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        cell1.setBorder(0);
        table.addCell(cell1);
        String comName = batchList.get(0).getCompanyname();
        PdfPCell cell2 = new PdfPCell((Phrase)new Paragraph("\u5b66\u6821\u540d\u79f0\uff1a" + comName, ItextPDFUtil.setFont((int)16)));
        cell2.setColspan(6);
        cell2.setRowspan(1);
        cell2.setFixedHeight(40.0f);
        cell2.setHorizontalAlignment(0);
        cell2.setVerticalAlignment(5);
        cell2.setBorder(0);
        table.addCell(cell2);
        for (String title : titles = new String[]{"\u5e8f\u53f7", "\u8865\u8d34\u79cd\u7c7b", "\u8865\u8d34\u6279\u6b21", "\u8865\u8d34\u4eba\u6570", "\u8865\u8d34\u91d1\u989d", "\u5408\u8ba1"}) {
            PdfPCell cellTile = new PdfPCell((Phrase)new Paragraph(title, ItextPDFUtil.setFont((int)16)));
            cellTile.setColspan(1);
            cellTile.setRowspan(1);
            cellTile.setFixedHeight(40.0f);
            cellTile.setHorizontalAlignment(1);
            cellTile.setVerticalAlignment(5);
            table.addCell(cellTile);
        }
        Map<String, List<GradeSubsidyBatch>> typeGroupMap = batchList.stream().collect(Collectors.groupingBy(GradeSubsidyBatch::getSubsidyCerType));
        BigDecimal totalMoney = new BigDecimal(0);
        Date minDate = new Date();
        Date maxDate = new Date();
        int totalCount = 1;
        for (String subsidyCerType : typeGroupMap.keySet()) {
            int count = 1;
            String title = SubsidyCerType.getByCode((String)subsidyCerType).getCName();
            List<GradeSubsidyBatch> typeList = typeGroupMap.get(subsidyCerType);
            BigDecimal subsidyMoney = typeList.stream().map(GradeSubsidyBatch::getSubsidyMoney_value).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMoney = totalMoney.add(subsidyMoney);
            for (GradeSubsidyBatch gradeSubsidyBatch : typeList) {
                PdfPCell cellIndex = new PdfPCell((Phrase)new Paragraph(totalCount + "", ItextPDFUtil.setFont((int)16)));
                cellIndex.setColspan(1);
                cellIndex.setRowspan(1);
                cellIndex.setMinimumHeight(40.0f);
                cellIndex.setHorizontalAlignment(1);
                cellIndex.setVerticalAlignment(5);
                table.addCell(cellIndex);
                if (count == 1) {
                    PdfPCell cellType = new PdfPCell((Phrase)new Paragraph(title, ItextPDFUtil.setFont((int)16)));
                    cellType.setColspan(1);
                    cellType.setRowspan(typeList.size());
                    cellType.setMinimumHeight(40.0f);
                    cellType.setHorizontalAlignment(1);
                    cellType.setVerticalAlignment(5);
                    table.addCell(cellType);
                }
                PdfPCell cellText1 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyBatch.getBatchName(), ItextPDFUtil.setFont((int)16)));
                cellText1.setColspan(1);
                cellText1.setRowspan(1);
                cellText1.setMinimumHeight(40.0f);
                cellText1.setHorizontalAlignment(1);
                cellText1.setVerticalAlignment(5);
                table.addCell(cellText1);
                PdfPCell cellText2 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyBatch.getPerNum(), ItextPDFUtil.setFont((int)16)));
                cellText2.setColspan(1);
                cellText2.setRowspan(1);
                cellText2.setMinimumHeight(40.0f);
                cellText2.setHorizontalAlignment(1);
                cellText2.setVerticalAlignment(5);
                table.addCell(cellText2);
                PdfPCell cellText3 = new PdfPCell((Phrase)new Paragraph("\uffe5" + gradeSubsidyBatch.getSubsidyMoney(), ItextPDFUtil.setFont((int)16)));
                cellText3.setColspan(1);
                cellText3.setRowspan(1);
                cellText3.setMinimumHeight(40.0f);
                cellText3.setHorizontalAlignment(1);
                cellText3.setVerticalAlignment(5);
                table.addCell(cellText3);
                if (count == 1) {
                    PdfPCell cellType = new PdfPCell((Phrase)new Paragraph("\uffe5" + subsidyMoney.toString(), ItextPDFUtil.setFont((int)16)));
                    cellType.setColspan(1);
                    cellType.setRowspan(typeList.size());
                    cellType.setMinimumHeight(40.0f);
                    cellType.setHorizontalAlignment(1);
                    cellType.setVerticalAlignment(5);
                    table.addCell(cellType);
                    maxDate = gradeSubsidyBatch.getCreateTime();
                }
                if (minDate.getTime() > gradeSubsidyBatch.getCreateTime().getTime()) {
                    minDate = gradeSubsidyBatch.getCreateTime();
                }
                if (maxDate.getTime() < gradeSubsidyBatch.getCreateTime().getTime()) {
                    maxDate = gradeSubsidyBatch.getCreateTime();
                }
                ++count;
                ++totalCount;
            }
        }
        PdfPCell cellType = new PdfPCell((Phrase)new Paragraph("\u603b\u8ba1", ItextPDFUtil.setFont((int)16)));
        cellType.setColspan(4);
        cellType.setRowspan(1);
        cellType.setFixedHeight(40.0f);
        cellType.setHorizontalAlignment(1);
        cellType.setVerticalAlignment(5);
        table.addCell(cellType);
        PdfPCell cellTotal = new PdfPCell((Phrase)new Paragraph("\uffe5" + totalMoney.toString(), ItextPDFUtil.setFont((int)16)));
        cellTotal.setColspan(2);
        cellTotal.setRowspan(1);
        cellTotal.setFixedHeight(40.0f);
        cellTotal.setHorizontalAlignment(1);
        cellTotal.setVerticalAlignment(5);
        table.addCell(cellTotal);
        PdfPCell cellTime = new PdfPCell((Phrase)new Paragraph("\u7533\u8bf7\u65f6\u95f4\uff1a" + DateUtil.convertDateToString((Date)minDate, (String)"yyyy\u5e74MM\u6708dd\u65e5") + "\u2014" + DateUtil.convertDateToString((Date)maxDate, (String)"yyyy\u5e74MM\u6708dd\u65e5"), ItextPDFUtil.setFont((int)16)));
        cellTime.setColspan(6);
        cellTime.setRowspan(1);
        cellTime.setFixedHeight(60.0f);
        cellTime.setHorizontalAlignment(2);
        cellTime.setVerticalAlignment(5);
        cellTime.setBorder(0);
        table.addCell(cellTime);
        document.add((Element)table);
        for (String subsidyCerType : typeGroupMap.keySet()) {
            document.newPage();
            switch (subsidyCerType) {
                case "01": {
                    this.addGradeDetail(document, writer, subsidyOffline, typeGroupMap.get(subsidyCerType));
                    break;
                }
                case "02": {
                    this.addSeniorityDetail(document, writer, subsidyOffline, typeGroupMap.get(subsidyCerType));
                    break;
                }
            }
        }
    }

    private void addGradeDetail(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) throws DocumentException {
        String[] titles;
        PdfPTable table = new PdfPTable(6);
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(570.0f);
        table.setTotalWidth(new float[]{60.0f, 85.0f, 155.0f, 80.0f, 95.0f, 95.0f});
        table.setLockedWidth(true);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        table.getDefaultCell().setBorder(0);
        PdfPCell cell1 = new PdfPCell((Phrase)new Paragraph("\u4fdd\u5b89\u5458\u804c\u4e1a\u6280\u80fd\u57f9\u8bad\u8865\u8d34\u4eba\u5458\u82b1\u540d\u518c", ItextPDFUtil.setFont((int)22)));
        cell1.setColspan(6);
        cell1.setRowspan(1);
        cell1.setFixedHeight(90.0f);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        cell1.setBorder(0);
        table.addCell(cell1);
        String comName = batchList.get(0).getCompanyname();
        PdfPCell cell2 = new PdfPCell((Phrase)new Paragraph("\u5b66\u6821\u540d\u79f0\uff1a" + comName, ItextPDFUtil.setFont((int)16)));
        cell2.setColspan(6);
        cell2.setRowspan(1);
        cell2.setFixedHeight(40.0f);
        cell2.setHorizontalAlignment(0);
        cell2.setVerticalAlignment(5);
        cell2.setBorder(0);
        table.addCell(cell2);
        for (String title : titles = new String[]{"\u5e8f\u53f7", "\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7", "\u8865\u8d34\u91d1\u989d", "\u8bc1\u4e66\u7c7b\u578b", "\u8bc1\u4e66\u7f16\u53f7"}) {
            PdfPCell cellTile = new PdfPCell((Phrase)new Paragraph(title, ItextPDFUtil.setFont((int)16)));
            cellTile.setColspan(1);
            cellTile.setRowspan(1);
            cellTile.setFixedHeight(40.0f);
            cellTile.setHorizontalAlignment(1);
            cellTile.setVerticalAlignment(5);
            table.addCell(cellTile);
        }
        int count = 1;
        Date minDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(BaseModel::getCreateTime).distinct().min((e1, e2) -> e1.compareTo((Date)e2)).get();
        Date maxDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(BaseModel::getCreateTime).distinct().max((e1, e2) -> e1.compareTo((Date)e2)).get();
        List rosterList = this.gradeSubsidyRosterDao.findBySubsidyBatchIds(batchList);
        for (GradeSubsidyRoster gradeSubsidyRoster : rosterList) {
            PdfPCell cellIndex = new PdfPCell((Phrase)new Paragraph(count + "", ItextPDFUtil.setFont((int)16)));
            cellIndex.setColspan(1);
            cellIndex.setRowspan(1);
            cellIndex.setFixedHeight(40.0f);
            cellIndex.setHorizontalAlignment(1);
            cellIndex.setVerticalAlignment(5);
            table.addCell(cellIndex);
            PdfPCell cellText1 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getName(), ItextPDFUtil.setFont((int)16)));
            cellText1.setColspan(1);
            cellText1.setRowspan(1);
            cellText1.setFixedHeight(40.0f);
            cellText1.setHorizontalAlignment(1);
            cellText1.setVerticalAlignment(5);
            table.addCell(cellText1);
            PdfPCell cellText2 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getIdNum(), ItextPDFUtil.setFont((int)16)));
            cellText2.setColspan(1);
            cellText2.setRowspan(1);
            cellText2.setFixedHeight(40.0f);
            cellText2.setHorizontalAlignment(1);
            cellText2.setVerticalAlignment(5);
            table.addCell(cellText2);
            PdfPCell cellText3 = new PdfPCell((Phrase)new Paragraph("\uffe5" + gradeSubsidyRoster.getSubsidyMoney(), ItextPDFUtil.setFont((int)16)));
            cellText3.setColspan(1);
            cellText3.setRowspan(1);
            cellText3.setFixedHeight(40.0f);
            cellText3.setHorizontalAlignment(1);
            cellText3.setVerticalAlignment(5);
            table.addCell(cellText3);
            PdfPCell cellText4 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getCertificateType(), ItextPDFUtil.setFont((int)16)));
            cellText4.setColspan(1);
            cellText4.setRowspan(1);
            cellText4.setFixedHeight(40.0f);
            cellText4.setHorizontalAlignment(1);
            cellText4.setVerticalAlignment(5);
            table.addCell(cellText4);
            PdfPCell cellText5 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getCertificateNumber(), ItextPDFUtil.setFont((int)16)));
            cellText5.setColspan(1);
            cellText5.setRowspan(1);
            cellText5.setFixedHeight(40.0f);
            cellText5.setHorizontalAlignment(1);
            cellText5.setVerticalAlignment(5);
            table.addCell(cellText5);
            ++count;
        }
        PdfPCell cellTime = new PdfPCell((Phrase)new Paragraph("\u7533\u8bf7\u65f6\u95f4\uff1a" + DateUtil.convertDateToString((Date)minDate, (String)"yyyy\u5e74MM\u6708dd\u65e5") + "\u2014" + DateUtil.convertDateToString((Date)maxDate, (String)"yyyy\u5e74MM\u6708dd\u65e5"), ItextPDFUtil.setFont((int)16)));
        cellTime.setColspan(6);
        cellTime.setRowspan(1);
        cellTime.setFixedHeight(40.0f);
        cellTime.setHorizontalAlignment(2);
        cellTime.setVerticalAlignment(5);
        cellTime.setBorder(0);
        table.addCell(cellTime);
        document.add((Element)table);
    }

    private void addSeniorityDetail(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, List<GradeSubsidyBatch> batchList) throws DocumentException {
        String[] titles;
        PdfPTable table = new PdfPTable(5);
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(560.0f);
        table.setTotalWidth(new float[]{70.0f, 112.0f, 154.0f, 112.0f, 112.0f});
        table.setLockedWidth(true);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        table.getDefaultCell().setBorder(0);
        PdfPCell cell1 = new PdfPCell((Phrase)new Paragraph("\u4fdd\u5b89\u5458\u5c97\u4f4d\u8d44\u683c\u57f9\u8bad\u8865\u8d34\u4eba\u5458\u82b1\u540d\u518c", ItextPDFUtil.setFont((int)22)));
        cell1.setColspan(5);
        cell1.setRowspan(1);
        cell1.setFixedHeight(90.0f);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        cell1.setBorder(0);
        table.addCell(cell1);
        String comName = batchList.get(0).getCompanyname();
        PdfPCell cell2 = new PdfPCell((Phrase)new Paragraph("\u5b66\u6821\u540d\u79f0\uff1a" + comName, ItextPDFUtil.setFont((int)16)));
        cell2.setColspan(5);
        cell2.setRowspan(1);
        cell2.setFixedHeight(40.0f);
        cell2.setHorizontalAlignment(0);
        cell2.setVerticalAlignment(5);
        cell2.setBorder(0);
        table.addCell(cell2);
        for (String title : titles = new String[]{"\u5e8f\u53f7", "\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7", "\u8865\u8d34\u91d1\u989d", "\u8bc1\u4e66\u7f16\u53f7"}) {
            PdfPCell cellTile = new PdfPCell((Phrase)new Paragraph(title, ItextPDFUtil.setFont((int)16)));
            cellTile.setColspan(1);
            cellTile.setRowspan(1);
            cellTile.setFixedHeight(40.0f);
            cellTile.setHorizontalAlignment(1);
            cellTile.setVerticalAlignment(5);
            table.addCell(cellTile);
        }
        int count = 1;
        Date minDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(BaseModel::getCreateTime).distinct().min((e1, e2) -> e1.compareTo((Date)e2)).get();
        Date maxDate = batchList.stream().filter(o -> o.getCreateTime() != null).map(BaseModel::getCreateTime).distinct().max((e1, e2) -> e1.compareTo((Date)e2)).get();
        List rosterList = this.gradeSubsidyRosterDao.findBySubsidyBatchIds(batchList);
        for (GradeSubsidyRoster gradeSubsidyRoster : rosterList) {
            PdfPCell cellIndex = new PdfPCell((Phrase)new Paragraph(count + "", ItextPDFUtil.setFont((int)16)));
            cellIndex.setColspan(1);
            cellIndex.setRowspan(1);
            cellIndex.setFixedHeight(40.0f);
            cellIndex.setHorizontalAlignment(1);
            cellIndex.setVerticalAlignment(5);
            table.addCell(cellIndex);
            PdfPCell cellText1 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getName(), ItextPDFUtil.setFont((int)16)));
            cellText1.setColspan(1);
            cellText1.setRowspan(1);
            cellText1.setFixedHeight(40.0f);
            cellText1.setHorizontalAlignment(1);
            cellText1.setVerticalAlignment(5);
            table.addCell(cellText1);
            PdfPCell cellText2 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getIdNum(), ItextPDFUtil.setFont((int)16)));
            cellText2.setColspan(1);
            cellText2.setRowspan(1);
            cellText2.setFixedHeight(40.0f);
            cellText2.setHorizontalAlignment(1);
            cellText2.setVerticalAlignment(5);
            table.addCell(cellText2);
            PdfPCell cellText3 = new PdfPCell((Phrase)new Paragraph("\uffe5" + gradeSubsidyRoster.getSubsidyMoney(), ItextPDFUtil.setFont((int)16)));
            cellText3.setColspan(1);
            cellText3.setRowspan(1);
            cellText3.setFixedHeight(40.0f);
            cellText3.setHorizontalAlignment(1);
            cellText3.setVerticalAlignment(5);
            table.addCell(cellText3);
            PdfPCell cellText4 = new PdfPCell((Phrase)new Paragraph(gradeSubsidyRoster.getCertificateNumber(), ItextPDFUtil.setFont((int)16)));
            cellText4.setColspan(1);
            cellText4.setRowspan(1);
            cellText4.setFixedHeight(40.0f);
            cellText4.setHorizontalAlignment(1);
            cellText4.setVerticalAlignment(5);
            table.addCell(cellText4);
            ++count;
        }
        PdfPCell cellTime = new PdfPCell((Phrase)new Paragraph("\u7533\u8bf7\u65f6\u95f4\uff1a" + DateUtil.convertDateToString((Date)minDate, (String)"yyyy\u5e74MM\u6708dd\u65e5") + "\u2014" + DateUtil.convertDateToString((Date)maxDate, (String)"yyyy\u5e74MM\u6708dd\u65e5"), ItextPDFUtil.setFont((int)16)));
        cellTime.setColspan(5);
        cellTime.setRowspan(1);
        cellTime.setFixedHeight(40.0f);
        cellTime.setHorizontalAlignment(2);
        cellTime.setVerticalAlignment(5);
        cellTime.setBorder(0);
        table.addCell(cellTime);
        document.add((Element)table);
    }

    private void addApprove(Document document, PdfWriter writer, SubsidyOffline subsidyOffline, Map<String, List<GradeSubsidyBatch>> typeGroupMap) throws DocumentException {
        PdfPTable table = new PdfPTable(3);
        table.setWidthPercentage(100.0f);
        table.setTotalWidth(560.0f);
        table.setTotalWidth(new float[]{80.0f, 160.0f, 320.0f});
        table.setLockedWidth(true);
        table.setSpacingBefore(10.0f);
        table.setSpacingAfter(10.0f);
        table.getDefaultCell().setBorder(0);
        PdfPCell cell1 = new PdfPCell((Phrase)new Paragraph("\u5317\u4eac\u5e02\u4fdd\u5b89\u5458\u57f9\u8bad\u8d44\u91d1\u8865\u8d34\u5ba1\u6279\u8868", ItextPDFUtil.setFont((int)22)));
        cell1.setColspan(3);
        cell1.setRowspan(1);
        cell1.setFixedHeight(120.0f);
        cell1.setHorizontalAlignment(1);
        cell1.setVerticalAlignment(5);
        cell1.setBorder(0);
        table.addCell(cell1);
        PdfPCell cell2 = new PdfPCell((Phrase)new Paragraph("\u7533\u8bf7\u4e8b\u9879\r\n\u57fa\u672c\u60c5\u51b5", ItextPDFUtil.setFont((int)16)));
        cell2.setRowspan(typeGroupMap.size() + 2);
        cell2.setBorderColor(BaseColor.BLACK);
        cell2.setFixedHeight(40.0f);
        cell2.setHorizontalAlignment(1);
        cell2.setVerticalAlignment(5);
        table.addCell(cell2);
        PdfPCell cell3 = new PdfPCell((Phrase)new Paragraph("\u8865\u8d34\u5185\u5bb9", ItextPDFUtil.setFont((int)16)));
        cell3.setRowspan(typeGroupMap.size());
        cell3.setBorderColor(BaseColor.BLACK);
        cell3.setFixedHeight(40.0f);
        cell3.setHorizontalAlignment(1);
        cell3.setVerticalAlignment(5);
        table.addCell(cell3);
        String[] subsidyCerTypes = new String[]{"", ""};
        for (String subsidyCerType : typeGroupMap.keySet()) {
            PdfPCell cell4 = new PdfPCell((Phrase)new Paragraph(SubsidyCerType.getByCode((String)subsidyCerType).getCName(), ItextPDFUtil.setFont((int)16)));
            cell4.setBorderColor(BaseColor.BLACK);
            cell4.setFixedHeight(40.0f);
            cell4.setHorizontalAlignment(1);
            cell4.setVerticalAlignment(5);
            cell4.setRowspan(1);
            table.addCell(cell4);
        }
        PdfPCell cell6 = new PdfPCell((Phrase)new Paragraph("\u7533\u8bf7\u8865\u8d34\u5468\u671f", ItextPDFUtil.setFont((int)16)));
        cell6.setBorderColor(BaseColor.BLACK);
        cell6.setFixedHeight(40.0f);
        cell6.setHorizontalAlignment(1);
        cell6.setVerticalAlignment(5);
        cell6.setRowspan(1);
        table.addCell(cell6);
        PdfPCell cell7 = new PdfPCell((Phrase)new Paragraph(subsidyOffline.getCycle(), ItextPDFUtil.setFont((int)16)));
        cell7.setBorderColor(BaseColor.BLACK);
        cell7.setFixedHeight(40.0f);
        cell7.setHorizontalAlignment(1);
        cell7.setVerticalAlignment(5);
        cell7.setRowspan(1);
        table.addCell(cell7);
        PdfPCell cell8 = new PdfPCell((Phrase)new Paragraph("\u8865\u8d34\u8d44\u91d1\u603b\u989d", ItextPDFUtil.setFont((int)16)));
        cell8.setBorderColor(BaseColor.BLACK);
        cell8.setFixedHeight(40.0f);
        cell8.setHorizontalAlignment(1);
        cell8.setVerticalAlignment(5);
        cell8.setRowspan(1);
        table.addCell(cell8);
        PdfPCell cell9 = new PdfPCell((Phrase)new Paragraph(subsidyOffline.getSubsidyMoney(), ItextPDFUtil.setFont((int)16)));
        cell9.setBorderColor(BaseColor.BLACK);
        cell9.setFixedHeight(40.0f);
        cell9.setHorizontalAlignment(1);
        cell9.setVerticalAlignment(5);
        cell9.setRowspan(1);
        table.addCell(cell9);
        PdfPCell cell10 = new PdfPCell((Phrase)new Paragraph("\u603b\u961f\u4e3b\u7ba1\r\n\u9886\u5bfc\u610f\u89c1", ItextPDFUtil.setFont((int)16)));
        cell10.setBorderColor(BaseColor.BLACK);
        cell10.setFixedHeight(120.0f);
        cell10.setHorizontalAlignment(1);
        cell10.setVerticalAlignment(5);
        cell10.setRowspan(2);
        table.addCell(cell10);
        PdfPCell cell11 = new PdfPCell((Phrase)new Paragraph("", ItextPDFUtil.setFont((int)16)));
        cell11.setBorderColor(BaseColor.BLACK);
        cell11.setFixedHeight(80.0f);
        cell11.setHorizontalAlignment(1);
        cell11.setVerticalAlignment(5);
        cell11.setRowspan(1);
        cell11.setColspan(2);
        cell11.disableBorderSide(2);
        table.addCell(cell11);
        PdfPCell cell12 = new PdfPCell((Phrase)new Paragraph("\u7b7e\u5b57:", ItextPDFUtil.setFont((int)16)));
        cell12.setBorderColor(BaseColor.BLACK);
        cell12.setPaddingLeft(10.0f);
        cell12.setBorder(0);
        cell12.setFixedHeight(40.0f);
        cell12.setHorizontalAlignment(0);
        cell12.setVerticalAlignment(5);
        cell12.setRowspan(1);
        cell12.setColspan(1);
        table.addCell(cell12);
        PdfPCell cell13 = new PdfPCell((Phrase)new Paragraph("\u5e74    \u6708    \u65e5", ItextPDFUtil.setFont((int)16)));
        cell13.setBorderColor(BaseColor.BLACK);
        cell13.disableBorderSide(7);
        cell13.setPaddingRight(20.0f);
        cell13.setFixedHeight(40.0f);
        cell13.setHorizontalAlignment(2);
        cell13.setVerticalAlignment(5);
        cell13.setRowspan(1);
        cell13.setColspan(1);
        table.addCell(cell13);
        PdfPCell cell14 = new PdfPCell((Phrase)new Paragraph("\u4fdd\u5b89\u7ba1\u7406\r\n\u652f\u961f\u9886\u5bfc\r\n\u610f\u89c1", ItextPDFUtil.setFont((int)16)));
        cell14.setBorderColor(BaseColor.BLACK);
        cell14.setFixedHeight(120.0f);
        cell14.setHorizontalAlignment(1);
        cell14.setVerticalAlignment(5);
        cell14.setRowspan(2);
        table.addCell(cell14);
        PdfPCell cell15 = new PdfPCell((Phrase)new Paragraph("\u62df\u540c\u610f\uff0c\u8bf7       \u5ba1\u6279\u3002", ItextPDFUtil.setFont((int)16)));
        cell15.setBorderColor(BaseColor.BLACK);
        cell15.setFixedHeight(80.0f);
        cell15.setHorizontalAlignment(1);
        cell15.setVerticalAlignment(5);
        cell15.setRowspan(1);
        cell15.setColspan(2);
        cell15.disableBorderSide(2);
        table.addCell(cell15);
        PdfPCell cell16 = new PdfPCell((Phrase)new Paragraph("\u7b7e\u5b57:", ItextPDFUtil.setFont((int)16)));
        cell16.setBorderColor(BaseColor.BLACK);
        cell16.setPaddingLeft(10.0f);
        cell16.setBorder(0);
        cell16.setFixedHeight(40.0f);
        cell16.setHorizontalAlignment(0);
        cell16.setVerticalAlignment(5);
        cell16.setRowspan(1);
        cell16.setColspan(1);
        table.addCell(cell16);
        PdfPCell cell17 = new PdfPCell((Phrase)new Paragraph("\u5e74    \u6708    \u65e5", ItextPDFUtil.setFont((int)16)));
        cell17.setBorderColor(BaseColor.BLACK);
        cell17.disableBorderSide(7);
        cell17.setPaddingRight(20.0f);
        cell17.setFixedHeight(40.0f);
        cell17.setHorizontalAlignment(2);
        cell17.setVerticalAlignment(5);
        cell17.setRowspan(1);
        cell17.setColspan(1);
        table.addCell(cell17);
        PdfPCell cell18 = new PdfPCell((Phrase)new Paragraph("\u627f\u529e\u4eba\r\n\u610f\u89c1", ItextPDFUtil.setFont((int)16)));
        cell18.setBorderColor(BaseColor.BLACK);
        cell18.setFixedHeight(120.0f);
        cell18.setHorizontalAlignment(1);
        cell18.setVerticalAlignment(5);
        cell18.setRowspan(2);
        table.addCell(cell18);
        PdfPCell cell19 = new PdfPCell((Phrase)new Paragraph("\u7ecf\u5ba1\u6838\uff0c\u8865\u8d34\u4eba\u5458\u5747\u7b26\u5408\u8d44\u683c\uff0c\u91d1\u989d\u6838\u5bf9\u65e0\u8bef\u3002", ItextPDFUtil.setFont((int)16)));
        cell19.setBorderColor(BaseColor.BLACK);
        cell19.setFixedHeight(80.0f);
        cell19.setHorizontalAlignment(1);
        cell19.setVerticalAlignment(5);
        cell19.setRowspan(1);
        cell19.setColspan(2);
        cell19.disableBorderSide(2);
        table.addCell(cell19);
        PdfPCell cell20 = new PdfPCell((Phrase)new Paragraph("\u7b7e\u5b57:", ItextPDFUtil.setFont((int)16)));
        cell20.setBorderColor(BaseColor.BLACK);
        cell20.setPaddingLeft(10.0f);
        cell20.disableBorderSide(9);
        cell20.setFixedHeight(40.0f);
        cell20.setHorizontalAlignment(0);
        cell20.setVerticalAlignment(5);
        cell20.setRowspan(1);
        cell20.setColspan(1);
        table.addCell(cell20);
        PdfPCell cell21 = new PdfPCell((Phrase)new Paragraph("\u5e74    \u6708    \u65e5", ItextPDFUtil.setFont((int)16)));
        cell21.setBorderColor(BaseColor.BLACK);
        cell21.disableBorderSide(5);
        cell21.setPaddingRight(20.0f);
        cell21.setFixedHeight(40.0f);
        cell21.setHorizontalAlignment(2);
        cell21.setVerticalAlignment(5);
        cell21.setRowspan(1);
        cell21.setColspan(1);
        table.addCell(cell21);
        document.add((Element)table);
    }

    public void revoke(SubsidyOffline subsidyOffline) {
        subsidyOffline.setOffApprovalState("009");
        this.updateSelective(subsidyOffline);
        this.subsidyOfflineDao.releaseBatch(subsidyOffline);
    }

    public void updateSelective(SubsidyOffline subsidyOffline) {
        User currentUser = this.arsUtil.getCurrentUser();
        subsidyOffline.setUpdateTime(new Date());
        subsidyOffline.setUpdateBy(currentUser.getUsername());
        this.subsidyOfflineDao.updateSelective(subsidyOffline);
    }

    public void approve(SubsidyOffline subsidyOffline) {
        this.updateSelective(subsidyOffline);
        this.gradeSubsidyBatchDao.updateApprovalStateBySubsidyOffline(subsidyOffline);
        List list = this.gradeSubsidyBatchDao.findbyOfflineId(subsidyOffline.getId());
        User currentUser = this.arsUtil.getCurrentUser();
        for (GradeSubsidyBatch gradeSubsidyBatch : list) {
            ApprovalLog approvalLog = new ApprovalLog();
            if (currentUser == null) {
                approvalLog.setUpdateBy("system");
                approvalLog.setApprovalorg("\u7cfb\u7edf\u81ea\u52a8");
                approvalLog.setApprovalperson("\u7cfb\u7edf\u81ea\u52a8");
            } else {
                approvalLog.setApprovalperson(currentUser.getRealname());
                approvalLog.setUpdateBy(currentUser.getUsername());
                approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
            }
            approvalLog.setActive(Boolean.valueOf(true));
            approvalLog.setType("001");
            approvalLog.setCreateTime(new Date());
            approvalLog.setUpdateTime(new Date());
            approvalLog.setApprovaldate(new Date());
            approvalLog.setApprovalstate("\u7ebf\u4e0b" + ApprovalState.convertCode((String)subsidyOffline.getOffApprovalState()));
            String businessType = "011";
            if (Constants.SUBSIDYCERTYPE_ZGZ.equals(gradeSubsidyBatch.getSubsidyCerType())) {
                businessType = "012";
            }
            Approval approval = this.approvalDAO.findBybusinessidAndType(gradeSubsidyBatch.getId(), businessType);
            approvalLog.setApprovalid(approval.getId().toString());
            this.approvalLogDao.save(approvalLog);
        }
    }
}

