/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.singleLogin.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.gx.SingleLoginResponseResult;
import com.bcxin.ars.service.impl.SingleUserLoginBaseServiceImpl;
import com.bcxin.ars.service.singleLogin.SingleLoginService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.HttpClientUtils;
import com.bcxin.ars.util.StringUtil;
import com.bjtoon.uia.sdk.exception.UiaException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="singleLoginServiceNNImpl")
@Transactional
public class SingleLoginServiceNNImpl
extends SingleUserLoginBaseServiceImpl
implements SingleLoginService {
    @Autowired
    private ConfigUtils configUtils;
    private static Logger logger = LoggerFactory.getLogger(SingleLoginServiceNNImpl.class);

    @Override
    public User getUserInfo(SingleUserDTO userInfo) {
        User user = null;
        String accessToken = "";
        try {
            accessToken = this.getAccessToken(null);
            if (StringUtil.isNotEmpty((String)accessToken)) {
                userInfo.setAccessToken(accessToken);
                SingleLoginResponseResult singleLoginResponseResult = this.getAuthentication(userInfo);
                if (singleLoginResponseResult != null && "200".equals(singleLoginResponseResult.getCode())) {
                    user = super.findByUsername(userInfo.getUser(), String.valueOf(1));
                }
            }
        }
        catch (UiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return user;
    }

    public SingleLoginResponseResult getAuthentication(SingleUserDTO userInfo) {
        SingleLoginResponseResult singleLoginResponseResult = null;
        try {
            String url = this.configUtils.getValueByKey("NNSINGLELOGINURL") + "/oauth/authentication";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("clientId", this.configUtils.getValueByKey("NNCLIENTID"));
            paramMap.put("access_token", userInfo.getAccessToken());
            paramMap.put("sign", userInfo.getSign());
            paramMap.put("key", userInfo.getKey());
            paramMap.put("loginName", userInfo.getLoginName());
            String json = HttpClientUtils.doPostByBody((String)url, paramMap);
            singleLoginResponseResult = (SingleLoginResponseResult)JSON.parseObject((String)json, SingleLoginResponseResult.class);
        }
        catch (UiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return singleLoginResponseResult;
    }

    public String getAccessToken(String code) {
        String tokenMsg = "";
        try {
            String url = this.configUtils.getValueByKey("NNSINGLELOGINURL") + "/oauth/token";
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("clientId", this.configUtils.getValueByKey("NNCLIENTID"));
            paramMap.put("clientSecret", this.configUtils.getValueByKey("NNCLIENTSECRET"));
            String json = HttpClientUtils.doPostByBody((String)url, paramMap);
            SingleLoginResponseResult singleLoginResponseResult = (SingleLoginResponseResult)JSON.parseObject((String)json, SingleLoginResponseResult.class);
            if ("200".equals(singleLoginResponseResult.getCode())) {
                tokenMsg = singleLoginResponseResult.getData();
            }
        }
        catch (UiaException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return tokenMsg;
    }

    public AjaxResult handle(SingleUserDTO dto, HttpServletRequest request) {
        return this.login(dto, request);
    }

    @Override
    public AjaxResult login(SingleUserDTO userInfo, HttpServletRequest request) {
        User u = this.getUserInfo(userInfo);
        if (u == null) {
            return new AjaxResult(false, "\u5931\u8d25");
        }
        return this.webLogin(u.getUsername(), u.getPassword(), u.getPlatform(), "GX_NW_Code", request);
    }
}

