/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.YearreportDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearreportSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Yearreport;
import com.bcxin.ars.service.sb.YearreportService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class YearreportServiceImpl
implements YearreportService {
    @Autowired
    private YearreportDao yearreportDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ApprovalUtil approvalUtil;

    public Yearreport findById(long id) {
        Yearreport result = this.yearreportDao.findById(id);
        if (result != null) {
            ApprovalDTO dto = new ApprovalDTO();
            dto.setBusinessid(Long.valueOf(id));
            dto.setBusinesstype("008");
            List list = this.approvalDAO.getBusinessidAndType(dto);
            result.setApprovallist(list);
        }
        return result;
    }

    public void saveOrUpdate(Yearreport yearreport) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (yearreport.getId() == null) {
            yearreport.setActive(Boolean.valueOf(true));
            yearreport.setCreateTime(new Date());
            yearreport.setUpdateTime(new Date());
            yearreport.setUpdateBy(currentUser.getUsername());
            yearreport.setUserid(currentUser.getId());
            this.yearreportDao.save(yearreport);
            if (yearreport.getApprovalstate().equals("002")) {
                this.approvalUtil.saveApproval("008", yearreport.getId(), "activitiyearreportapprovalProcess");
            }
        } else {
            Yearreport dbYearreport = this.yearreportDao.findById(yearreport.getId().longValue());
            dbYearreport.setUpdateTime(new Date());
            dbYearreport.setUpdateBy(currentUser.getUsername());
            dbYearreport.setAddress(yearreport.getAddress());
            dbYearreport.setApprovaldate(yearreport.getApprovaldate());
            dbYearreport.setApprovalperson(yearreport.getApprovalperson());
            dbYearreport.setApprovalreason(yearreport.getApprovalreason());
            dbYearreport.setCompanyname(yearreport.getCompanyname());
            dbYearreport.setTemplateRar(yearreport.getTemplateRar());
            dbYearreport.setCfnum(yearreport.getCfnum());
            dbYearreport.setCharge(yearreport.getCharge());
            dbYearreport.setCjnum(yearreport.getCjnum());
            dbYearreport.setCzgz(yearreport.getCzgz());
            dbYearreport.setDxnum(yearreport.getDxnum());
            dbYearreport.setFzcompany(yearreport.getFzcompany());
            dbYearreport.setFzqk(yearreport.getFzqk());
            dbYearreport.setGjmanagernum(yearreport.getGjmanagernum());
            dbYearreport.setGjnum(yearreport.getGjnum());
            dbYearreport.setGqnum(yearreport.getGqnum());
            dbYearreport.setGsnum(yearreport.getGsnum());
            dbYearreport.setHdnum(yearreport.getHdnum());
            dbYearreport.setJjss(yearreport.getJjss());
            dbYearreport.setJyqynum(yearreport.getJyqynum());
            dbYearreport.setManagernum(yearreport.getManagernum());
            dbYearreport.setPaxs(yearreport.getPaxs());
            dbYearreport.setPersonnum(yearreport.getPersonnum());
            dbYearreport.setQgbznum(yearreport.getQgbznum());
            dbYearreport.setQsbznum(yearreport.getQsbznum());
            dbYearreport.setQznum(yearreport.getQznum());
            dbYearreport.setRecordnumber(yearreport.getRecordnumber());
            dbYearreport.setServicearea(yearreport.getServicearea());
            dbYearreport.setSjbznum(yearreport.getSjbznum());
            dbYearreport.setTel(yearreport.getTel());
            dbYearreport.setXjnum(yearreport.getXjnum());
            dbYearreport.setXsnum(yearreport.getXsnum());
            dbYearreport.setXynum(yearreport.getXynum());
            dbYearreport.setZhsg(yearreport.getZhsg());
            dbYearreport.setZjnum(yearreport.getZjnum());
            dbYearreport.setZznum(yearreport.getZznum());
            dbYearreport.setSzss(yearreport.getSzss());
            dbYearreport.setProvince(yearreport.getProvince());
            dbYearreport.setCity(yearreport.getCity());
            dbYearreport.setDistrict(yearreport.getDistrict());
            if (yearreport.getApprovalstate() != null && !"".equals(yearreport.getApprovalstate()) && !yearreport.getApprovalstate().equals("002")) {
                dbYearreport.setApprovalstate(yearreport.getApprovalstate());
            } else {
                dbYearreport.setApprovalstate("002");
                this.approvalUtil.saveApproval("008", yearreport.getId(), "activitiyearreportapprovalProcess");
            }
            this.yearreportDao.update(dbYearreport);
        }
    }

    public void saveOrUpdateForDS(Yearreport yearreport) {
        Yearreport dbYearreport;
        if (yearreport.getActive() == null) {
            yearreport.setActive(Boolean.valueOf(true));
        }
        if ((dbYearreport = this.yearreportDao.findById(yearreport.getId().longValue())) != null) {
            if (yearreport.getUpdateTime().getTime() > dbYearreport.getUpdateTime().getTime()) {
                this.yearreportDao.updateForDS(yearreport);
            }
        } else {
            this.yearreportDao.saveForDS(yearreport);
        }
    }

    public Yearreport findByUser(Long userid) {
        return this.yearreportDao.findByUser(userid);
    }

    public YearreportSearchDto search(YearreportSearchDto dto) {
        YearreportSearchDto resultDto = new YearreportSearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = this.policeDao.findById(currentUser.getOrgid());
        String areacode = police.getAreacode();
        if (areacode.endsWith("0000")) {
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {
            dto.setDistrict(areacode);
        }
        List list = this.yearreportDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.yearreportDao.searchCount(dto));
        return resultDto;
    }

    public List<Yearreport> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.yearreportDao.searchForDataSynchronization(searchDto);
    }

    public List<Yearreport> findAll() {
        return this.yearreportDao.findAll();
    }
}

