/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.YearReportInsuranceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.YearReportInsuranceSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.YearReportInsurance;
import com.bcxin.ars.service.sb.YearReportInsuranceService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=YearReportInsurance.class)
public class YearReportInsuranceServiceImpl
implements YearReportInsuranceService {
    @Autowired
    private YearReportInsuranceDao yearReportInsuranceDao;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private ArsUtil arsUtil;

    public void saveOrUpdate(YearReportInsurance yearReportInsurance) {
        User user = this.arsUtil.getCurrentUser();
        YearReportInsurance dbYearReportInsurance = this.yearReportInsuranceDao.findById(yearReportInsurance.getId());
        if (dbYearReportInsurance != null) {
            dbYearReportInsurance.setUpdateTime(new Date());
            dbYearReportInsurance.setUpdateBy(user.getRealname());
            if (!StringUtils.isEmpty((Object)yearReportInsurance.getInsurance_company())) {
                dbYearReportInsurance.setInsurance_company(yearReportInsurance.getInsurance_company());
            }
            if (!StringUtils.isEmpty((Object)yearReportInsurance.getInsurance_product())) {
                dbYearReportInsurance.setInsurance_product(yearReportInsurance.getInsurance_product());
            }
            if (!StringUtils.isEmpty((Object)yearReportInsurance.getInsured_num())) {
                dbYearReportInsurance.setInsured_num(yearReportInsurance.getInsured_num());
            }
            if (!StringUtils.isEmpty((Object)yearReportInsurance.getPremium_person())) {
                dbYearReportInsurance.setPremium_person(yearReportInsurance.getPremium_person());
            }
            if (!StringUtils.isEmpty((Object)yearReportInsurance.getProtection_date())) {
                dbYearReportInsurance.setProtection_date(yearReportInsurance.getProtection_date());
            }
            this.yearReportInsuranceDao.update(dbYearReportInsurance);
        } else {
            yearReportInsurance.setCreateTime(new Date());
            yearReportInsurance.setUpdateTime(yearReportInsurance.getCreateTime());
            yearReportInsurance.setActive(Boolean.valueOf(true));
            yearReportInsurance.setUpdateBy(user.getUsername());
            this.yearReportInsuranceDao.save(yearReportInsurance);
        }
    }

    public void delete(YearReportInsurance yearReportInsurance) {
        yearReportInsurance.setUpdateTime(new Date());
        this.yearReportInsuranceDao.delete(yearReportInsurance);
    }

    public YearReportInsurance findById(long id) {
        return this.yearReportInsuranceDao.findById(Long.valueOf(id));
    }

    public YearReportInsuranceSearchDto search(YearReportInsuranceSearchDto dto) {
        YearReportInsuranceSearchDto resultDto = new YearReportInsuranceSearchDto();
        List list = this.yearReportInsuranceDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.yearReportInsuranceDao.count(dto)));
        return resultDto;
    }

    public List<YearReportInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.yearReportInsuranceDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(YearReportInsurance yearReportInsurance) {
        YearReportInsurance dbYearReportInsurance;
        if (yearReportInsurance.getActive() == null) {
            yearReportInsurance.setActive(Boolean.valueOf(true));
        }
        if ((dbYearReportInsurance = this.yearReportInsuranceDao.findById(yearReportInsurance.getId())) != null) {
            if (yearReportInsurance.getUpdateTime().getTime() > dbYearReportInsurance.getUpdateTime().getTime()) {
                this.yearReportInsuranceDao.updateForDS(yearReportInsurance);
            }
        } else {
            this.yearReportInsuranceDao.saveForDS(yearReportInsurance);
        }
    }

    public List<YearReportInsurance> findByUserId(Long userId) {
        return this.yearReportInsuranceDao.findByCompanyId(userId);
    }
}

