/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.VehicleDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.VehicleSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Vehicle;
import com.bcxin.ars.service.sb.VehicleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.Bacydwclpbxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Vehicle.class)
public class VehicleServiceImpl
implements VehicleService {
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private VehicleDao vehicleDao;
    private static Logger logger = LoggerFactory.getLogger(ClientUtil.class);
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ClientUtil clientUtil;

    public Vehicle findById(long id) {
        return this.vehicleDao.findById(id);
    }

    public void saveOrUpdate(Vehicle vehicle) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (vehicle.getId() == null) {
            vehicle.setActive(Boolean.valueOf(true));
            vehicle.setCreateTime(new Date());
            vehicle.setUpdateTime(new Date());
            vehicle.setUpdateBy(currentUser.getUsername());
            vehicle.setUserid(currentUser.getId());
            vehicle.setClstate("2");
            this.vehicleDao.save(vehicle);
        } else {
            Vehicle dbVehicle = this.vehicleDao.findById(vehicle.getId().longValue());
            if (null != vehicle.getReturndate() && !"".equals(vehicle.getReturndate())) {
                vehicle.setClstate("2");
            } else if (null != vehicle.getSenddate() && !"".equals(vehicle.getSenddate())) {
                vehicle.setClstate("1");
            }
            dbVehicle.setUpdateBy(currentUser.getUsername());
            dbVehicle.setUpdateTime(new Date());
            if (vehicle.getBuydate() != null) {
                dbVehicle.setBuydate(vehicle.getBuydate());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getChargeperson())) {
                dbVehicle.setChargeperson(vehicle.getChargeperson());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getDisplacement())) {
                dbVehicle.setDisplacement(vehicle.getDisplacement());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getEnginenum())) {
                dbVehicle.setEnginenum(vehicle.getEnginenum());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getFramenum())) {
                dbVehicle.setFramenum(vehicle.getFramenum());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getFueltype())) {
                dbVehicle.setFueltype(vehicle.getFueltype());
            }
            if (vehicle.getProductiondate() != null) {
                dbVehicle.setProductiondate(vehicle.getProductiondate());
            }
            if (vehicle.getRegdate() != null) {
                dbVehicle.setRegdate(vehicle.getRegdate());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getRegorg())) {
                dbVehicle.setRegorg(vehicle.getRegorg());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getRemarks())) {
                dbVehicle.setRemarks(vehicle.getRemarks());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getVehiclebrand())) {
                dbVehicle.setVehiclebrand(vehicle.getVehiclebrand());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getVehiclecolor())) {
                dbVehicle.setVehiclecolor(vehicle.getVehiclecolor());
            }
            if (vehicle.getBuyaccout() != null) {
                dbVehicle.setBuyaccout(vehicle.getBuyaccout());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getVehiclemodel())) {
                dbVehicle.setVehiclemodel(vehicle.getVehiclemodel());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getVehiclenum())) {
                dbVehicle.setVehiclenum(vehicle.getVehiclenum());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getVehiclesource())) {
                dbVehicle.setVehiclesource(vehicle.getVehiclesource());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getVehicletype())) {
                dbVehicle.setVehicletype(vehicle.getVehicletype());
            }
            if (vehicle.getBuyaccout() != null) {
                dbVehicle.setBuyaccout(vehicle.getBuyaccout());
            }
            if (StringUtil.isNotEmpty((String)vehicle.getClstate())) {
                dbVehicle.setClstate(vehicle.getClstate());
            }
            if (vehicle.getReturndate() != null) {
                dbVehicle.setReturndate(vehicle.getReturndate());
            }
            if (vehicle.getScrapdate() != null) {
                dbVehicle.setScrapdate(vehicle.getScrapdate());
            }
            if (vehicle.getSenddate() != null) {
                dbVehicle.setSenddate(vehicle.getSenddate());
            }
            this.vehicleDao.update(dbVehicle);
        }
    }

    public VehicleSearchDto search(VehicleSearchDto dto) {
        VehicleSearchDto resultDto = new VehicleSearchDto();
        List list = this.vehicleDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.vehicleDao.searchCount(dto));
        return resultDto;
    }

    public void delete(Vehicle vehicle) {
        User currentUser = this.arsUtil.getCurrentUser();
        vehicle.setUpdateBy(currentUser.getUsername());
        vehicle.setUpdateTime(new Date());
        this.vehicleDao.delete(vehicle);
    }

    public List<Vehicle> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.vehicleDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Vehicle vehicle) {
        if (vehicle.getActive() == null) {
            vehicle.setActive(Boolean.valueOf(true));
        }
        if (!vehicle.getActive().booleanValue()) {
            this.vehicleDao.delete(vehicle);
        } else {
            Vehicle dbVehicle = this.vehicleDao.findById(vehicle.getId().longValue());
            if (dbVehicle == null) {
                this.vehicleDao.saveForDS(vehicle);
                new Thread(() -> {
                    try {
                        Bacydwclpbxx bacydwclpbxx = new Bacydwclpbxx();
                        SecurityCompany securityCompany = this.securityCompanyDao.findByUserid(dbVehicle.getUserid());
                        bacydwclpbxx.setBagsbm(securityCompany.getCompanyCode());
                        bacydwclpbxx.setVin(dbVehicle.getFramenum());
                        bacydwclpbxx.setCph(dbVehicle.getVehiclenum());
                        bacydwclpbxx.setFdzh(dbVehicle.getEnginenum());
                        if (dbVehicle.getProductiondate() != null) {
                            bacydwclpbxx.setGmrq(DateUtil.convertDateToString((Date)dbVehicle.getProductiondate(), (String)"yyyyMMdd"));
                        }
                        if (dbVehicle.getScrapdate() != null) {
                            bacydwclpbxx.setBfrq(DateUtil.convertDateToString((Date)dbVehicle.getScrapdate(), (String)"yyyyMMdd"));
                        }
                        this.clientUtil.send("xxba_bacydwclpbxx", (Object)bacydwclpbxx);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
            } else if (vehicle.getUpdateTime().getTime() > dbVehicle.getUpdateTime().getTime()) {
                this.vehicleDao.update(vehicle);
            }
        }
    }

    public void searchForPage(VehicleSearchDto searchDto, AjaxPageResponse<Vehicle> page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.vehicleDao.searchForPage(searchDto, page);
    }
}

