/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.VehicleLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.VehicleLogSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Vehicle;
import com.bcxin.ars.model.sb.VehicleLog;
import com.bcxin.ars.service.sb.VehicleLogService;
import com.bcxin.ars.service.sb.VehicleService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=VehicleLog.class)
public class VehicleLogServiceImpl
implements VehicleLogService {
    @Autowired
    private VehicleLogDao vehicleLogDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private VehicleService vehicleService;
    @Autowired
    private SecurityPersonDao personDao;

    public VehicleLog findById(long id) {
        return this.vehicleLogDao.findById(id);
    }

    public void saveOrUpdate(VehicleLog vehicleLog) {
        User currentUser;
        User user = currentUser = this.arsUtil.getCurrentUser();
        if (vehicleLog.getId() == null) {
            vehicleLog.setActive(Boolean.valueOf(true));
            vehicleLog.setCreateTime(new Date());
            vehicleLog.setUpdateTime(new Date());
            vehicleLog.setTime(new Date());
            vehicleLog.setUpdateBy(currentUser.getUsername());
            vehicleLog.setUserid(user.getId());
            this.vehicleLogDao.save(vehicleLog);
        } else {
            VehicleLog dbVehicleLog = this.vehicleLogDao.findById(vehicleLog.getId().longValue());
            dbVehicleLog.setUpdateBy(currentUser.getRealname());
            dbVehicleLog.setUpdateTime(new Date());
            dbVehicleLog.setRemarks(vehicleLog.getRemarks());
            dbVehicleLog.setOperator(vehicleLog.getOperator());
            dbVehicleLog.setType(vehicleLog.getType());
            dbVehicleLog.setName(vehicleLog.getName());
            dbVehicleLog.setTime(vehicleLog.getTime());
            dbVehicleLog.setUserid(vehicleLog.getUserid());
            this.vehicleLogDao.update(dbVehicleLog);
        }
        Vehicle vehicle = this.vehicleService.findById(vehicleLog.getVehicleid().longValue());
        if ("1".equals(vehicleLog.getType())) {
            vehicle.setSenddate(vehicleLog.getTime());
            vehicle.setClstate("1");
            vehicle.setReturndate(null);
        } else {
            vehicle.setReturndate(vehicleLog.getTime());
            vehicle.setClstate("2");
        }
        this.vehicleService.saveOrUpdate(vehicle);
    }

    public VehicleLogSearchDto search(VehicleLogSearchDto dto) {
        VehicleLogSearchDto resultDto = new VehicleLogSearchDto();
        List list = this.vehicleLogDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.vehicleLogDao.searchCount(dto));
        return resultDto;
    }

    public void delete(VehicleLog vehicleLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        vehicleLog.setUpdateBy(currentUser.getUsername());
        vehicleLog.setUpdateTime(new Date());
        this.vehicleLogDao.delete(vehicleLog);
    }

    public List<VehicleLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.vehicleLogDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(VehicleLog vehicleLog) {
        if (vehicleLog.getActive() == null) {
            vehicleLog.setActive(Boolean.valueOf(true));
        }
        if (!vehicleLog.getActive().booleanValue()) {
            this.vehicleLogDao.delete(vehicleLog);
        } else {
            VehicleLog dbVehicleLog = this.vehicleLogDao.findById(vehicleLog.getId().longValue());
            if (dbVehicleLog == null) {
                this.vehicleLogDao.saveForDS(vehicleLog);
            } else if (vehicleLog.getUpdateTime().getTime() > dbVehicleLog.getUpdateTime().getTime()) {
                this.vehicleLogDao.update(vehicleLog);
            }
        }
    }

    public void searchForPage(VehicleLogSearchDto searchDto, AjaxPageResponse<VehicleLog> page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.vehicleLogDao.searchForPage(searchDto, page);
    }
}

