/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.SecAssociationRatingDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.SecAssociationRatingPageSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.SecAssociationRating;
import com.bcxin.ars.service.sb.SecAssociationRatingService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SecAssociationRatingServiceImpl
implements SecAssociationRatingService {
    Logger logger = LoggerFactory.getLogger(SecAssociationRatingServiceImpl.class);
    @Autowired
    private SecAssociationRatingDao secAssociationRatingDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(SecAssociationRating secAssociationRating) {
        User currentUser = this.arsUtil.getCurrentUser();
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        return this.secAssociationRatingDao.delete(secAssociationRating);
    }

    public int save(SecAssociationRating secAssociationRating) {
        SecAssociationRating dbSecAssociationRating;
        User currentUser = this.arsUtil.getCurrentUser();
        if (secAssociationRating.getId() == null) {
            secAssociationRating.setId(Long.valueOf(this.idWorker.nextId()));
            secAssociationRating.setActive(Boolean.valueOf(true));
            secAssociationRating.setCreateTime(new Date());
            secAssociationRating.setUserId(currentUser.getId());
            secAssociationRating.setApproveState("0");
        } else {
            dbSecAssociationRating = this.secAssociationRatingDao.findById(secAssociationRating.getId());
            BeanUtils.copyPropertiesIgnore((Object)secAssociationRating, (Object)dbSecAssociationRating, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbSecAssociationRating, (Object)secAssociationRating, (Boolean)false);
            secAssociationRating.setApproveUserId(currentUser.getId());
            secAssociationRating.setApproveName(currentUser.getUsername());
        }
        if ("0".equals(secAssociationRating.getApproveState())) {
            dbSecAssociationRating = this.secAssociationRatingDao.findByComName(secAssociationRating.getComName());
            if (dbSecAssociationRating != null && dbSecAssociationRating.getId() != secAssociationRating.getId()) {
                throw new ArsException(secAssociationRating.getComName() + " \u5df2\u5b58\u5728\u53d7\u7406\u8bb0\u5f55\uff01");
            }
            dbSecAssociationRating = this.secAssociationRatingDao.findByUserId(currentUser.getId());
            if (dbSecAssociationRating != null && dbSecAssociationRating.getId() != secAssociationRating.getId()) {
                throw new ArsException("\u672c\u8d26\u53f7\u5b58\u5728\u5f85\u53d7\u7406\u7684\u8bb0\u5f55\u3002\u8bf7\u7b49\u5f85\u5ba1\u6279\u5b8c\u518d\u63d0\u4ea4\uff01");
            }
        }
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateflag(Boolean.valueOf(true));
        return this.secAssociationRatingDao.save(secAssociationRating);
    }

    public void approve(SecAssociationRating secAssociationRating) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecAssociationRating dbSecAssociationRating = this.secAssociationRatingDao.findById(secAssociationRating.getId());
        BeanUtils.copyPropertiesIgnore((Object)secAssociationRating, (Object)dbSecAssociationRating, (Boolean)true);
        BeanUtils.copyPropertiesIgnore((Object)dbSecAssociationRating, (Object)secAssociationRating, (Boolean)false);
        secAssociationRating.setApproveUserId(currentUser.getId());
        secAssociationRating.setApproveName(currentUser.getRealname());
        secAssociationRating.setApproveTime(new Date());
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateflag(Boolean.valueOf(true));
        this.secAssociationRatingDao.save(secAssociationRating);
    }

    public SecAssociationRating findById(Long id) {
        return this.secAssociationRatingDao.findById(id);
    }

    public void searchForPage(SecAssociationRatingPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.secAssociationRatingDao.searchForPage(dto, page);
    }

    public void importBatch(List<SecAssociationRating> list) {
        List dbList = this.secAssociationRatingDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (SecAssociationRating secAssociationRating : list) {
                secAssociationRating.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    secAssociationRating.setUpdateTime(DateUtil.dateAdd((int)6, (Date)secAssociationRating.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.secAssociationRatingDao.saveBatch(list);
        }
    }

    public List<SecAssociationRating> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.secAssociationRatingDao.searchForDataSynchronization(dto);
    }

    public List<SecAssociationRating> findDSOutList(String startDate) {
        return this.secAssociationRatingDao.findDSOutList(startDate);
    }

    public List<SecAssociationRating> findByBatchId(List<SecAssociationRating> list) {
        return this.secAssociationRatingDao.findByBatchId(list);
    }

    public void updateSelective(SecAssociationRating secAssociationRating) {
        User currentUser = this.arsUtil.getCurrentUser();
        secAssociationRating.setUpdateTime(new Date());
        secAssociationRating.setUpdateBy(currentUser.getUsername());
        this.secAssociationRatingDao.updateSelective(secAssociationRating);
    }
}

