/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.sb.PerCerGrantDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.PerCerGrantPageSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.PerCerGrant;
import com.bcxin.ars.service.sb.PerCerGrantService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class PerCerGrantServiceImpl
implements PerCerGrantService {
    Logger logger = LoggerFactory.getLogger(PerCerGrantServiceImpl.class);
    @Autowired
    private PerCerGrantDao perCerGrantDao;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    public int delete(PerCerGrant perCerGrant) {
        User currentUser = this.arsUtil.getCurrentUser();
        perCerGrant.setUpdateTime(new Date());
        perCerGrant.setUpdateBy(currentUser.getUsername());
        return this.perCerGrantDao.delete(perCerGrant);
    }

    public int save(PerCerGrant perCerGrant) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (perCerGrant.getId() == null) {
            perCerGrant.setCreateTime(new Date());
        } else {
            PerCerGrant dbPerCerGrant = this.perCerGrantDao.findById(perCerGrant.getId());
            BeanUtils.copyPropertiesIgnore((Object)perCerGrant, (Object)dbPerCerGrant, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPerCerGrant, (Object)perCerGrant, (Boolean)false);
        }
        perCerGrant.setActive(Boolean.valueOf(true));
        perCerGrant.setUpdateBy(currentUser.getUsername());
        perCerGrant.setUpdateTime(new Date());
        perCerGrant.setUpdateflag(Boolean.valueOf(true));
        perCerGrant.setUserid(currentUser.getId());
        return this.perCerGrantDao.save(perCerGrant);
    }

    public PerCerGrant findById(Long id) {
        PerCerGrant result = this.perCerGrantDao.findById(id);
        if (result != null) {
            result.setApproval(this.approvalDAO.findBybusinessidAndType(result.getId(), "015"));
            Police police = this.policeDao.findById(result.getOrgid());
            result.setPolice(police);
        }
        return result;
    }

    public void searchForPage(PerCerGrantPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.perCerGrantDao.searchForPage(dto, page);
    }

    public void importBatch(List<PerCerGrant> list) {
        List dbList = this.perCerGrantDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PerCerGrant perCerGrant : list) {
                perCerGrant.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    perCerGrant.setUpdateTime(DateUtil.dateAdd((int)6, (Date)perCerGrant.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.perCerGrantDao.saveBatch(list);
        }
    }

    public List<PerCerGrant> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.perCerGrantDao.searchForDataSynchronization(dto);
    }

    public List<PerCerGrant> findDSOutList(String startDate) {
        return this.perCerGrantDao.findDSOutList(startDate);
    }

    public List<PerCerGrant> findByBatchId(List<PerCerGrant> list) {
        return this.perCerGrantDao.findByBatchId(list);
    }

    public void updateSelective(PerCerGrant perCerGrant) {
        User currentUser = this.arsUtil.getCurrentUser();
        perCerGrant.setUpdateTime(new Date());
        perCerGrant.setUpdateBy(currentUser.getUsername());
        this.perCerGrantDao.updateSelective(perCerGrant);
    }

    public void saveOrUpdateForIntegrate(PerCerGrant perCerGrant, User currentUser) {
        perCerGrant.setId(Long.valueOf(this.idGeneratorUtil.createID()));
        perCerGrant.setActive(Boolean.valueOf(true));
        perCerGrant.setCreateTime(new Date());
        perCerGrant.setUpdateTime(new Date());
        this.perCerGrantDao.save(perCerGrant);
        this.approvalUtil.saveApprovalForIntegrate("015", perCerGrant.getId(), "activitiPerCerGrantapprovalProcess", currentUser);
    }
}

