/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.InvestorDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.InvestorPageSearchDto;
import com.bcxin.ars.dto.sb.InvestorSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Investor;
import com.bcxin.ars.service.sb.InvestorService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdGeneratorUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.EntityForWebServiceUtil;
import com.bcxin.ars.util.KeyAndDefauleVal;
import com.bcxin.ars.webservice.Bafwgsczrxx;
import com.bcxin.ars.webservice.ClientUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Investor.class)
public class InvestorServiceImpl
implements InvestorService {
    private static Logger logger = LoggerFactory.getLogger(InvestorServiceImpl.class);
    @Autowired
    private InvestorDao investorDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityPersonDao personDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private IdGeneratorUtil idGeneratorUtil;

    public Investor findById(long id) {
        return this.investorDao.findById(id);
    }

    public void saveOrUpdate(Investor investor) {
        Investor dbInvestor;
        User currentUser = this.arsUtil.getCurrentUser();
        boolean IsNull = true;
        if (investor.getId() != null && (dbInvestor = this.investorDao.findById(investor.getId().longValue())) != null) {
            IsNull = false;
            dbInvestor.setUpdateBy(currentUser.getUsername());
            dbInvestor.setUpdateTime(new Date());
            BeanUtils.copyPropertiesIgnore((Object)investor, (Object)dbInvestor, (Boolean)true);
            this.investorDao.update(dbInvestor);
        }
        if (investor.getId() == null || IsNull) {
            investor.setActive(Boolean.valueOf(true));
            investor.setCreateTime(new Date());
            investor.setUpdateTime(new Date());
            investor.setUpdateBy(currentUser.getUsername());
            investor.setUserid(currentUser.getId());
            if (investor.getId() == null) {
                investor.setId(Long.valueOf(this.idGeneratorUtil.createID()));
            }
            this.investorDao.saveById(investor);
        }
    }

    public InvestorSearchDto search(InvestorSearchDto dto) {
        InvestorSearchDto resultDto = new InvestorSearchDto();
        List list = this.investorDao.search(dto);
        resultDto.setData(list);
        if (dto.isPaging()) {
            resultDto.setTotalCount(this.investorDao.searchCount(dto));
        }
        return resultDto;
    }

    public void delete(Investor investor) {
        User currentUser = this.arsUtil.getCurrentUser();
        investor.setUpdateBy(currentUser.getUsername());
        investor.setUpdateTime(new Date());
        this.investorDao.delete(investor);
    }

    public List<Investor> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.investorDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Investor investor) {
        if (investor.getActive() == null) {
            investor.setActive(Boolean.valueOf(true));
        }
        if (!investor.getActive().booleanValue()) {
            this.investorDao.delete(investor);
        } else {
            Investor dbInvestor = this.investorDao.findById(investor.getId().longValue());
            if (dbInvestor == null) {
                this.investorDao.saveForDS(investor);
                new Thread(() -> {
                    try {
                        this.buildWebServiceEntity(investor);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }).start();
            } else if (investor.getUpdateTime().getTime() > dbInvestor.getUpdateTime().getTime()) {
                this.investorDao.update(investor);
            }
        }
    }

    public List<Investor> findByUserId(Long userId) {
        return this.investorDao.findByUserId(userId);
    }

    private void buildWebServiceEntity(Investor investor) throws Exception {
        Bafwgsczrxx bafwgsczrxx = new Bafwgsczrxx();
        HashMap<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("gj", new KeyAndDefauleVal("national", null));
        map.put("xb", new KeyAndDefauleVal("sex", (Object)(investor.getSex() != null ? (investor.getSex().equals("\u7537") ? "1" : "2") : "2")));
        map.put("xxdz", new KeyAndDefauleVal("nowaddress", null));
        map.put("zzje", new KeyAndDefauleVal("nowaddress", null));
        map.put("szbl", new KeyAndDefauleVal("stockProportion", null));
        map.put("sffr", new KeyAndDefauleVal("investorsType", (Object)(investor.getInvestorsType().equals("2") ? "1" : "0")));
        map.put("zjlx", new KeyAndDefauleVal("investorsType", (Object)(investor.getInvestorsType().equals("2") ? "02" : "01")));
        SecurityCompany securityCompany = this.securityCompanyDao.findByUserid(investor.getUserid());
        investor.setPublicSecurityLicenseNumber(securityCompany.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("publicSecurityLicenseNumber", (Object)investor.getPublicSecurityLicenseNumber()));
        map.put("frmc", new KeyAndDefauleVal("companyCode", (Object)securityCompany.getLegalPerson()));
        map.put("gdsfzh", new KeyAndDefauleVal("idNumber", (Object)investor.getIdNumber()));
        try {
            EntityForWebServiceUtil.copy(map, (Object)investor, (Object)bafwgsczrxx);
            this.clientUtil.send("xxba_bafwgsczrxx", (Object)bafwgsczrxx);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void searchForPage(InvestorPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.investorDao.searchForPage(dto, page);
    }
}

