/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchDaoAop;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDao;
import com.bcxin.ars.dao.sb.GradeSubsidyBatchRosterDaoAop;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDao;
import com.bcxin.ars.dao.subsidy.GradeSubsidyRosterDaoAop;
import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDao;
import com.bcxin.ars.dao.subsidy.TrainSubsidyConfigDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dao.sys.SubsidyConfigDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.GradeSubsidyBatchPageSearchDto;
import com.bcxin.ars.dto.sb.GradeSubsidyBatchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.enums.SubsidyCerType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.BusinessCommon;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.GradeSubsidyBatch;
import com.bcxin.ars.model.sb.GradeSubsidyBatchRoster;
import com.bcxin.ars.model.subsidy.GradeSubsidyRoster;
import com.bcxin.ars.model.subsidy.TrainSubsidyConfig;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.GradeSubsidyBatchService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.BKTInterfaceUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradeSubsidyBatch.class, getImportType=ImportType.BATCH, getMethodName="importBatch")
@DataSyncOutAnnotation(getClazz=GradeSubsidyBatch.class, getImportType=ImportType.BATCH)
public class GradeSubsidyBatchServiceImpl
extends BaseService
implements GradeSubsidyBatchService {
    Logger logger = LoggerFactory.getLogger(GradeSubsidyBatchServiceImpl.class);
    @Autowired
    private GradeSubsidyBatchDao gradeSubsidyBatchDao;
    @Autowired
    private GradeSubsidyBatchDaoAop gradeSubsidyBatchDaoAop;
    @Autowired
    private GradeSubsidyBatchRosterDaoAop gradeSubsidyBatchRosterDaoAop;
    @Autowired
    private GradeSubsidyBatchRosterDao gradeSubsidyBatchRosterDao;
    @Autowired
    private GradeSubsidyRosterDaoAop gradeSubsidyRosterDaoAop;
    @Autowired
    private GradeSubsidyRosterDao gradeSubsidyRosterDao;
    @Autowired
    private TrainSubsidyConfigDaoAop trainSubsidyConfigDaoAop;
    @Autowired
    private TrainSubsidyConfigDao trainSubsidyConfigDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SubsidyConfigDao subsidyConfigDao;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalLogDao approvalLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private BKTInterfaceUtil bktInterfaceUtil;
    @Autowired
    private IdWorker idWorker;

    public int delete(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        gradeSubsidyBatch.setUpdateTime(new Date());
        gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        return this.gradeSubsidyBatchDaoAop.delete(gradeSubsidyBatch);
    }

    public void save(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCompany company = this.securityCompanyDao.findByUserid(currentUser.getId());
        SubsidyCerType subsidyCerType = null;
        if (gradeSubsidyBatch.getId() == null) {
            subsidyCerType = SubsidyCerType.getByCode((String)gradeSubsidyBatch.getSubsidyCerType());
            gradeSubsidyBatch.setCreateTime(new Date());
            gradeSubsidyBatch.setId(Long.valueOf(this.idWorker.nextId()));
            if ("001".equals(gradeSubsidyBatch.getApprovalstate())) {
                gradeSubsidyBatch.setOffApprovalState("001");
            } else {
                gradeSubsidyBatch.setOffApprovalState("002");
            }
            try {
                TrainSubsidyConfig trainSubsidyConfig = this.trainSubsidyConfigDao.findByTrainIdAndSubsidyCerType(Long.valueOf(Long.parseLong(company.getComId())), gradeSubsidyBatch.getSubsidyCerType());
                trainSubsidyConfig.setBatchNo(Long.valueOf(trainSubsidyConfig.getBatchNo() + 1L));
                this.trainSubsidyConfigDaoAop.save(trainSubsidyConfig);
                String batchName = Constants.BATCH_NAME_TEMP.replace("{trainName}", trainSubsidyConfig.getShortName()).replace("{subsidyCerTypeName}", subsidyCerType.getName()).replace("{batchNo}", trainSubsidyConfig.getBatchNo().toString());
                gradeSubsidyBatch.setBatchName(batchName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ArsException("\u57f9\u8bad\u5355\u4f4d\u8865\u8d34\u7b80\u79f0\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u5904\u7406");
            }
        } else {
            GradeSubsidyBatch dbGradeSubsidyBatch = this.gradeSubsidyBatchDao.findById(gradeSubsidyBatch.getId());
            BeanUtils.copyPropertiesIgnore((Object)gradeSubsidyBatch, (Object)dbGradeSubsidyBatch, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbGradeSubsidyBatch, (Object)gradeSubsidyBatch, (Boolean)false);
            if (!"001".equals(gradeSubsidyBatch.getApprovalstate()) && "001".equals(gradeSubsidyBatch.getOffApprovalState())) {
                gradeSubsidyBatch.setOffApprovalState("002");
            }
            subsidyCerType = SubsidyCerType.getByCode((String)gradeSubsidyBatch.getSubsidyCerType());
        }
        if (gradeSubsidyBatch.getRosterIds() != null) {
            ArrayList<GradeSubsidyBatchRoster> list = new ArrayList<GradeSubsidyBatchRoster>();
            GradeSubsidyBatchRoster batchRoster = null;
            for (Long rosterId : gradeSubsidyBatch.getRosterIds()) {
                batchRoster = new GradeSubsidyBatchRoster();
                batchRoster.setBatchId(gradeSubsidyBatch.getId());
                batchRoster.setRosterId(rosterId);
                batchRoster.setActive(Boolean.valueOf(true));
                batchRoster.setUpdateflag(Boolean.valueOf(true));
                batchRoster.setCreateTime(new Date());
                batchRoster.setUpdateTime(new Date());
                list.add(batchRoster);
            }
            this.gradeSubsidyBatchRosterDaoAop.saveBatch(list);
            this.gradeSubsidyRosterDaoAop.updateBatchUsed(gradeSubsidyBatch);
        }
        if (StringUtil.isEmpty((String)gradeSubsidyBatch.getDistrict())) {
            gradeSubsidyBatch.setDistrict(gradeSubsidyBatch.getCity());
            gradeSubsidyBatch.setDistrictOrgId(gradeSubsidyBatch.getCityOrgId());
        }
        if (gradeSubsidyBatch.getOrgid() == null) {
            gradeSubsidyBatch.setOrgid(Long.valueOf(Long.parseLong(gradeSubsidyBatch.getDistrictOrgId())));
        }
        gradeSubsidyBatch.setActive(Boolean.valueOf(true));
        gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        gradeSubsidyBatch.setUpdateTime(new Date());
        if ("002".equals(gradeSubsidyBatch.getApprovalstate())) {
            gradeSubsidyBatch.setApplyTime(new Date());
        }
        gradeSubsidyBatch.setUpdateflag(Boolean.valueOf(true));
        this.gradeSubsidyBatchDaoAop.save(gradeSubsidyBatch);
        if ("002".equals(gradeSubsidyBatch.getApprovalstate())) {
            switch (subsidyCerType) {
                case GRADE: {
                    gradeSubsidyBatch.setOrgName(this.approvalUtil.getApprovalOrg((BusinessCommon)gradeSubsidyBatch, "011").getOrgname());
                    this.approvalUtil.saveApproval("011", gradeSubsidyBatch.getId(), "activitiGradeSubsidyapprovalProcess");
                    this.sendApprovalStateToBKT(gradeSubsidyBatch);
                    break;
                }
                case QUALIFICATION: {
                    gradeSubsidyBatch.setOrgName(this.approvalUtil.getApprovalOrg((BusinessCommon)gradeSubsidyBatch, "012").getOrgname());
                    this.approvalUtil.saveApproval("012", gradeSubsidyBatch.getId(), "activitiQualificationSubsidyapprovalProcess");
                    break;
                }
            }
            this.gradeSubsidyBatchDaoAop.save(gradeSubsidyBatch);
        }
    }

    public GradeSubsidyBatch findById(Long id) {
        return this.gradeSubsidyBatchDao.findById(id);
    }

    public void searchForPage(GradeSubsidyBatchPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.gradeSubsidyBatchDao.searchForPage(dto, page);
    }

    public void importBatch(List<GradeSubsidyBatch> list) {
        List dbList = this.gradeSubsidyBatchDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (GradeSubsidyBatch gradeSubsidyBatch : list) {
                gradeSubsidyBatch.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    gradeSubsidyBatch.setUpdateTime(DateUtil.dateAdd((int)6, (Date)gradeSubsidyBatch.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.gradeSubsidyBatchDaoAop.saveBatch(list);
            if (!this.configUtils.isIntranet()) {
                this.sendApprovalStateToBKT(list);
            }
        }
    }

    private void sendApprovalStateToBKT(GradeSubsidyBatch gradeSubsidyBatch) {
        List rosterList = this.gradeSubsidyRosterDao.findBySubsidyBatchId(gradeSubsidyBatch.getId());
        JSONArray paramArr = new JSONArray();
        JSONObject rosterObj = null;
        for (GradeSubsidyRoster roster : rosterList) {
            rosterObj = new JSONObject();
            rosterObj.put("gradeApplyId", (Object)(roster.getGradeId() + ""));
            rosterObj.put("approvalStatus", (Object)gradeSubsidyBatch.getApprovalstate());
            paramArr.add((Object)rosterObj);
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("personList", JSON.toJSONString((Object)paramArr));
        AjaxResult result = this.bktInterfaceUtil.callInterface("train/bbd/grade/person/approvalStatus", paramMap);
        if (!result.isSuccessful()) {
            this.logger.error("\u3010\u7b49\u7ea7\u8bc1\u6279\u6b21\u5ba1\u6279\u72b6\u6001\u540c\u6b65\u3011" + result.getMsg());
        }
    }

    private void sendApprovalStateToBKT(List<GradeSubsidyBatch> list) {
        for (GradeSubsidyBatch gradeSubsidyBatch : list) {
            this.sendApprovalStateToBKT(gradeSubsidyBatch);
        }
    }

    public List<GradeSubsidyBatch> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradeSubsidyBatchDao.searchForDataSynchronization(dto);
    }

    public List<GradeSubsidyBatch> findDSOutList(String startDate) {
        return this.gradeSubsidyBatchDao.findDSOutList(startDate);
    }

    public List<GradeSubsidyBatch> findByBatchId(List<GradeSubsidyBatch> list) {
        return this.gradeSubsidyBatchDao.findByBatchId(list);
    }

    public void searchForPageInterface(GradeSubsidyBatchPageSearchDto dto, AjaxPageResponse<GradeSubsidyBatch> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.gradeSubsidyBatchDao.searchForPageInterface(dto, page);
        List maps = this.gradeSubsidyBatchDao.searchSubsidyMoney(dto);
        BigDecimal sum = new BigDecimal(0.0);
        for (Map gsb : maps) {
            String subsidyMoney = gsb.get("subsidyMoney").toString();
            if (!StringUtil.isNotEmpty((String)subsidyMoney)) continue;
            sum = sum.add(new BigDecimal(subsidyMoney));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("count", String.valueOf(maps.size()));
        map.put("money", sum.toString());
        page.setUserData(map);
    }

    public void repulse(GradeSubsidyBatch gradeSubsidyBatch) {
        gradeSubsidyBatch.setOffApprovalState("004");
        this.updateSelective(gradeSubsidyBatch);
        User currentUser = this.arsUtil.getCurrentUser();
        ApprovalLog approvalLog = new ApprovalLog();
        if (currentUser == null) {
            approvalLog.setUpdateBy("system");
            approvalLog.setApprovalorg("\u7cfb\u7edf\u81ea\u52a8");
            approvalLog.setApprovalperson("\u7cfb\u7edf\u81ea\u52a8");
        } else {
            approvalLog.setApprovalperson(currentUser.getRealname());
            approvalLog.setUpdateBy(currentUser.getUsername());
            approvalLog.setApprovalorg(currentUser.getPolice().getOrgname());
        }
        approvalLog.setActive(Boolean.valueOf(true));
        approvalLog.setType("001");
        approvalLog.setCreateTime(new Date());
        approvalLog.setUpdateTime(new Date());
        approvalLog.setApprovaldate(new Date());
        approvalLog.setApprovalreason(gradeSubsidyBatch.getReason());
        approvalLog.setApprovalstate(ApprovalState.convertCode((String)"004"));
        String businessType = "011";
        if (Constants.SUBSIDYCERTYPE_ZGZ.equals(gradeSubsidyBatch.getSubsidyCerType())) {
            businessType = "012";
        }
        Approval approval = this.approvalDAO.findBybusinessidAndType(gradeSubsidyBatch.getId(), businessType);
        approvalLog.setApprovalid(approval.getId().toString());
        this.approvalLogDao.save(approvalLog);
        this.gradeSubsidyRosterDaoAop.updateUnUsedByBatchId(gradeSubsidyBatch.getId());
    }

    public void updateSelective(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        gradeSubsidyBatch.setUpdateTime(new Date());
        if (null != currentUser) {
            gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        }
        gradeSubsidyBatch.setUpdateflag(Boolean.valueOf(true));
        this.gradeSubsidyBatchDaoAop.updateSelective(gradeSubsidyBatch);
    }

    public void uploadCommitFile(GradeSubsidyBatch gradeSubsidyBatch) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (null != currentUser) {
            gradeSubsidyBatch.setUpdateBy(currentUser.getUsername());
        }
        gradeSubsidyBatch.setUpdateflag(Boolean.valueOf(true));
        this.gradeSubsidyBatchDaoAop.updateSelective(gradeSubsidyBatch);
    }

    public void updateGrantState(String id) {
        this.gradeSubsidyBatchDao.updateGrantState(id);
    }

    public AjaxResult subsidyApplicationStatusInquiry(String batchNameSubject) {
        AjaxResult ajaxResult = new AjaxResult();
        String batchName = JwtUtil.parseJWT((String)batchNameSubject).getSubject();
        String approvalStatus = this.gradeSubsidyBatchDao.findApprovalStatusByBatchName(batchName);
        ajaxResult.setData((Object)JwtUtil.createJWT((String)approvalStatus));
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u67e5\u8be2\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult newSubsidyApplication(String gradeSubsidyBatchInfo) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)gradeSubsidyBatchInfo).getSubject();
        GradeSubsidyBatchDto gradeSubsidyBatch = (GradeSubsidyBatchDto)JSON.parseObject((String)subject, GradeSubsidyBatchDto.class);
        String batchName = gradeSubsidyBatch.getBatchName();
        if (StringUtil.isBlank((CharSequence)batchName)) {
            ajaxResult.setMsg("\u5931\u8d25, \u6279\u6b21\u540d\u4e3a\u7a7a");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        int count = this.gradeSubsidyBatchDao.findCountByBatchName(batchName);
        if (count > 0) {
            ajaxResult.setMsg("\u5931\u8d25, \u6279\u6b21\u540d\u5df2\u5b58\u5728");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        long batchId = this.idWorker.nextId();
        Date now = new Date();
        Long userId = currentUser.getId();
        gradeSubsidyBatch.setId(Long.valueOf(batchId));
        gradeSubsidyBatch.setApprovalstate("002");
        gradeSubsidyBatch.setOffApprovalState("002");
        gradeSubsidyBatch.setActive(Boolean.valueOf(true));
        gradeSubsidyBatch.setUpdateflag(Boolean.valueOf(true));
        gradeSubsidyBatch.setUpdateTime(now);
        gradeSubsidyBatch.setApplyTime(now);
        gradeSubsidyBatch.setCreateTime(now);
        gradeSubsidyBatch.setUserid(userId);
        String currentUsername = currentUser.getUsername();
        gradeSubsidyBatch.setCreateBy(currentUsername);
        gradeSubsidyBatch.setUpdateBy(currentUsername);
        gradeSubsidyBatch.setCommitPath(this.getPhotoPath(gradeSubsidyBatch.getCommitPath()));
        gradeSubsidyBatch.setTemplateRar(this.getPhotoPath(gradeSubsidyBatch.getTemplateRar()));
        gradeSubsidyBatch.setDistrict(currentUser.getAreaCode());
        List dbGradeSubsidyRosterList = this.gradeSubsidyRosterDao.findByIdNumbersAndType(gradeSubsidyBatch);
        ArrayList gradeSubsidyBatchRosters = Lists.newArrayList();
        gradeSubsidyBatch.setPerNum(String.valueOf(dbGradeSubsidyRosterList.size()));
        this.gradeSubsidyBatchDao.insertSelective((GradeSubsidyBatch)gradeSubsidyBatch);
        for (GradeSubsidyRoster gradeSubsidyRoster : dbGradeSubsidyRosterList) {
            long gradeSubsidyBatchRosterId = this.idWorker.nextId();
            GradeSubsidyBatchRoster gradeSubsidyBatchRoster = new GradeSubsidyBatchRoster();
            gradeSubsidyBatchRoster.setId(Long.valueOf(gradeSubsidyBatchRosterId));
            gradeSubsidyBatchRoster.setBatchId(Long.valueOf(batchId));
            gradeSubsidyBatchRoster.setRosterId(gradeSubsidyRoster.getId());
            gradeSubsidyBatchRoster.setActive(Boolean.valueOf(true));
            gradeSubsidyBatchRoster.setUpdateflag(Boolean.valueOf(true));
            gradeSubsidyBatchRoster.setUpdateBy(currentUsername);
            gradeSubsidyBatchRoster.setCreateTime(now);
            gradeSubsidyBatchRoster.setUpdateTime(now);
            gradeSubsidyBatchRosters.add(gradeSubsidyBatchRoster);
            gradeSubsidyRoster.setBatchId(Long.valueOf(batchId));
            gradeSubsidyRoster.setSubsidyStatus("02");
        }
        if (!gradeSubsidyBatchRosters.isEmpty()) {
            this.gradeSubsidyBatchRosterDao.saveBatch((List)gradeSubsidyBatchRosters);
        }
        ajaxResult.setData((Object)JwtUtil.createJWT((String)String.valueOf(batchId)));
        ajaxResult.setMsg("\u6210\u529f");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }
}

