/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sb.GradePersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.dto.sb.GradePersonSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.GradePerson;
import com.bcxin.ars.service.sb.GradePersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=GradePerson.class, getSeq=20000, getDataSyncType=SyncType.SYNC)
@DataSyncOutAnnotation(getClazz=GradePerson.class)
public class GradePersonServiceImpl
implements GradePersonService {
    private static final Logger loger = LoggerFactory.getLogger(GradePersonServiceImpl.class);
    @Autowired
    private GradePersonDao gradePersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private SecurityCertificateDao securityCertificateDao;
    @Autowired
    private PoliceDao policeDao;

    public GradePerson findById(Long id) {
        return this.gradePersonDao.findById(id);
    }

    public List<GradePerson> findDSOutList(String startDate) {
        return this.gradePersonDao.searchForExport(startDate);
    }

    public void insert(GradePerson gradePerson) {
        this.gradePersonDao.insert(gradePerson);
    }

    public void update(GradePerson gradePerson) {
        GradePerson dbGradPerson = this.gradePersonDao.findById(gradePerson.getId());
        BeanUtils.copyPropertiesIgnore((Object)gradePerson, (Object)dbGradPerson, (Boolean)true);
        User user = this.arsUtil.getCurrentUser();
        dbGradPerson.setUpdateBy(user.getUsername());
        dbGradPerson.setUpdateTime(new Date());
        dbGradPerson.setApprovalState(null);
        dbGradPerson.setCensorStatus(null);
        dbGradPerson.setNoPassEdit(null);
        dbGradPerson.setReson(null);
        this.gradePersonDao.update(dbGradPerson);
    }

    public void saveAppeal(GradePerson gradePerson) {
        GradePerson dbGradPerson = this.gradePersonDao.findById(gradePerson.getId());
        BeanUtils.copyPropertiesIgnore((Object)gradePerson, (Object)dbGradPerson, (Boolean)true);
        User user = this.arsUtil.getCurrentUser();
        dbGradPerson.setUpdateBy(user.getUsername());
        dbGradPerson.setUpdateTime(new Date());
        Police p = this.policeDao.findById(gradePerson.getOrgId());
        dbGradPerson.setOrgName(p.getOrgname());
        this.gradePersonDao.update(dbGradPerson);
    }

    public void saveAppealApproval(GradePerson gradePerson) {
        GradePerson dbGradPerson = this.gradePersonDao.findById(gradePerson.getId());
        BeanUtils.copyPropertiesIgnore((Object)gradePerson, (Object)dbGradPerson, (Boolean)true);
        User user = this.arsUtil.getCurrentUser();
        dbGradPerson.setUpdateBy(user.getUsername());
        dbGradPerson.setUpdateTime(new Date());
        dbGradPerson.setUpdateflag(Boolean.valueOf(true));
        if ("002".equals(dbGradPerson.getAppealState())) {
            dbGradPerson.setReson(null);
            dbGradPerson.setCensorStatus("003");
            SecurityCertificate securityCertificate = this.securityCertificateDao.findByIdnum(gradePerson.getIdnum());
            if (securityCertificate != null) {
                dbGradPerson.setNoPassEdit("0");
                dbGradPerson.setApprovalState("003");
                dbGradPerson.setSecurityCertificateNo(securityCertificate.getZsbh());
                dbGradPerson.setFzrq(securityCertificate.getFzrq());
            } else {
                dbGradPerson.setApprovalState("004");
                dbGradPerson.setReson("\u6ca1\u6709\u8d44\u683c\u8bc1\u4fe1\u606f");
                dbGradPerson.setNoPassEdit("0");
            }
        }
        this.gradePersonDao.update(dbGradPerson);
    }

    public List<Map<String, String>> insertBatchForImport(List<Map<String, String>> dataList) {
        int insertLength;
        User user = this.arsUtil.getCurrentUser();
        Random random = new Random();
        int rannum = (int)(random.nextDouble() * 90.0) + 100;
        String importBatchId = DateUtil.getCurrentDateTime((String)"yyyyMMddHHmmss") + rannum;
        int i = 0;
        for (insertLength = dataList.size(); insertLength > 2000; insertLength -= 2000) {
            this.gradePersonDao.insertTempBatchGradePersonImport(dataList.subList(i, i + 2000), importBatchId);
            i += 2000;
        }
        if (insertLength > 0) {
            this.gradePersonDao.insertTempBatchGradePersonImport(dataList.subList(i, i + insertLength), importBatchId);
        }
        this.gradePersonDao.checkIdNumNoRepeat(importBatchId);
        this.gradePersonDao.checkInOtherCom(importBatchId, user.getId());
        this.gradePersonDao.insertGradePersonInfo(importBatchId);
        List tempInputPerList = this.gradePersonDao.getTempImportGradePersonList(importBatchId);
        this.gradePersonDao.deleteTempBatchGradePersonImport(importBatchId);
        return tempInputPerList;
    }

    public void importBatch(List<GradePerson> list) {
        List dbList = this.gradePersonDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list != null && list.size() > 0) {
            for (GradePerson gradePerson : list) {
                try {
                    gradePerson.setUpdateflag(Boolean.valueOf(false));
                    gradePerson.setUpdateTime(DateUtil.dateAdd((int)6, (Date)gradePerson.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    loger.error(e.getMessage());
                }
            }
            try {
                this.gradePersonDao.updateBatch(list);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public List<GradePerson> query(GradePersonSearchDto dto, AjaxPageResponse<GradePerson> ajaxPageResponse) {
        return this.gradePersonDao.query(dto, ajaxPageResponse);
    }

    public void saveOrUpdateForDS(GradePerson gradePerson) {
        GradePerson dbGradePerson = this.gradePersonDao.findById(gradePerson.getId());
        if (dbGradePerson != null) {
            if (gradePerson.getUpdateTime().getTime() > dbGradePerson.getUpdateTime().getTime()) {
                this.gradePersonDao.update(gradePerson);
            }
        } else {
            this.gradePersonDao.insert(gradePerson);
        }
    }

    public List<GradePerson> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.gradePersonDao.searchForDataSynchronization(dto);
    }

    public List<GradePerson> findNoCensorStatus() {
        return this.gradePersonDao.findNoCensorStatus();
    }

    public List<String> queryImportBatchIdList() {
        User user = this.arsUtil.getCurrentUser();
        return this.gradePersonDao.queryImportBatchIdList(user.getId());
    }

    public void autoUpdateCensorStatus() {
    }

    public void updateCensorStatusForAuto(List<GradePerson> gradePersonList) {
        for (GradePerson gradePerson : gradePersonList) {
            try {
                Boolean pass = true;
                Date d = new Date();
                BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                backgroundApprovalDto.setBusinessid(gradePerson.getId());
                backgroundApprovalDto.setBusinesstype("21");
                backgroundApprovalDto.setIdNumber(gradePerson.getIdnum());
                backgroundApprovalDto.setRealName(gradePerson.getName());
                String approvalReason = null;
                List list = gradePerson.getBackgroundApprovals();
                if (list == null || list.size() == 0) continue;
                for (BackgroundApproval backgroundApproval : list) {
                    if (!"004".equals(backgroundApproval.getApprovalstate())) continue;
                    if ("1".equals(backgroundApproval.getLibraryType())) {
                        approvalReason = "\u80cc\u666f\u7b5b\u67e5\u4e0d\u901a\u8fc7\uff0c\u539f\u56e0\uff1a" + backgroundApproval.getApprovalreason();
                        gradePerson.setNoPassEdit("1");
                    } else {
                        approvalReason = "\u80cc\u666f\u7b5b\u67e5\u4e0d\u901a\u8fc7";
                        gradePerson.setNoPassEdit("0");
                    }
                    pass = false;
                    break;
                }
                gradePerson.setReson(approvalReason);
                if (pass.booleanValue()) {
                    gradePerson.setCensorStatus("003");
                    SecurityCertificate securityCertificate = this.securityCertificateDao.findByIdnum(gradePerson.getIdnum());
                    if (securityCertificate != null) {
                        gradePerson.setNoPassEdit("0");
                        gradePerson.setApprovalState("003");
                        gradePerson.setSecurityCertificateNo(securityCertificate.getZsbh());
                        gradePerson.setFzrq(securityCertificate.getFzrq());
                    } else {
                        gradePerson.setApprovalState("004");
                        gradePerson.setReson("\u6ca1\u6709\u8d44\u683c\u8bc1\u4fe1\u606f");
                        gradePerson.setNoPassEdit("0");
                    }
                } else {
                    gradePerson.setCensorStatus("004");
                    gradePerson.setApprovalState("004");
                }
                gradePerson.setUpdateTime(d);
                gradePerson.setUpdateflag(Boolean.valueOf(true));
            }
            catch (Exception e) {
                loger.error("\u5f02\u5e38" + gradePerson.getIdnum());
            }
        }
        this.gradePersonDao.updateBatch(gradePersonList);
    }
}

