/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.sb.FamilyDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.FamilySearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Family;
import com.bcxin.ars.service.sb.FamilyService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Family.class)
public class FamilyServiceImpl
implements FamilyService {
    @Autowired
    private FamilyDao familyDao;
    @Autowired
    private ArsUtil arsUtil;

    public Family findById(long id) {
        return this.familyDao.findById(id);
    }

    public void saveOrUpdate(Family family) {
        User currentUser = this.arsUtil.getCurrentUser();
        Family checkFamily = this.familyDao.findByFamily(family);
        if (family.getId() == null) {
            if (checkFamily != null) {
                throw new ArsException("\u6210\u5458\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
            }
            family.setActive(Boolean.valueOf(true));
            family.setCreateTime(new Date());
            family.setUpdateTime(new Date());
            family.setUpdateBy(currentUser.getUsername());
            this.familyDao.save(family);
        } else {
            if (checkFamily != null && checkFamily.getId() != family.getId()) {
                throw new ArsException("\u6210\u5458\u4fe1\u606f\u5df2\u5b58\u5728\uff01");
            }
            Family dbFamily = this.familyDao.findById(family.getId().longValue());
            dbFamily.setUpdateBy(currentUser.getUsername());
            dbFamily.setUpdateTime(new Date());
            dbFamily.setCompanyname(family.getCompanyname());
            dbFamily.setIdentifnumber(family.getIdentifnumber());
            dbFamily.setIdentifType(family.getIdentifType());
            dbFamily.setName(family.getName());
            dbFamily.setPhone(family.getPhone());
            dbFamily.setPost(family.getPost());
            dbFamily.setRelationship(family.getRelationship());
            this.familyDao.update(dbFamily);
        }
    }

    public void saveOrUpdateForDS(Family family) {
        if (family.getActive() == null) {
            family.setActive(Boolean.valueOf(true));
        }
        if (!family.getActive().booleanValue()) {
            this.familyDao.delete(family);
        } else {
            Family dbFamily = this.familyDao.findById(family.getId().longValue());
            if (dbFamily != null) {
                if (family.getUpdateTime().getTime() > dbFamily.getUpdateTime().getTime()) {
                    this.familyDao.update(family);
                }
            } else {
                this.familyDao.saveForDS(family);
            }
        }
    }

    public FamilySearchDto search(FamilySearchDto dto) {
        FamilySearchDto resultDto = new FamilySearchDto();
        List list = this.familyDao.search(dto);
        resultDto.setData(list);
        if (dto.isPaging()) {
            resultDto.setTotalCount(this.familyDao.searchCount(dto));
        }
        return resultDto;
    }

    public void delete(Family family) {
        User currentUser = this.arsUtil.getCurrentUser();
        family.setUpdateBy(currentUser.getUsername());
        family.setUpdateTime(new Date());
        this.familyDao.delete(family);
    }

    public List<Family> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.familyDao.searchForDataSynchronization(searchDto);
    }

    public void deleteByPersoncertificateId(Long personcertificateId) {
        this.familyDao.deleteByPersoncertificateId(personcertificateId);
    }

    public List<Family> searchByPid(Long pid) {
        return this.familyDao.searchByPid(pid);
    }
}

