/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import cn.hutool.core.util.ObjectUtil;
import cn.jiguang.common.utils.StringUtils;
import com.abcxin.smart.validator.annotation.ModelAnnotation;
import com.abcxin.smart.validator.annotation.ModelTableAnnotation;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.ars.dao.ExportDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sys.ExportConfigColumnDao;
import com.bcxin.ars.dao.sys.ExportConfigDao;
import com.bcxin.ars.dto.ExportModelDTO;
import com.bcxin.ars.dto.ExportTableListDTO;
import com.bcxin.ars.dto.ModelNameDTO;
import com.bcxin.ars.dto.PropertiesDTO;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sys.ExportRosterDto;
import com.bcxin.ars.enums.SignType;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ExportColumn;
import com.bcxin.ars.model.sys.ExportConfig;
import com.bcxin.ars.service.bean.factory.ExportBusinessBeanFactory;
import com.bcxin.ars.service.enums.ExportExcelType;
import com.bcxin.ars.service.sb.ExportService;
import com.bcxin.ars.service.sb.impl.ConfesscompanyundoServiceImpl;
import com.bcxin.ars.service.subsidy.ExportBusiness;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.ftp.FtpUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.beust.jcommander.internal.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
@Transactional
public class ExportServiceImpl
implements ExportService {
    private static final Logger logger = LoggerFactory.getLogger(ConfesscompanyundoServiceImpl.class);
    @Value(value="${company-download-folder}")
    private String downloadFolder;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ExportConfigDao exportConfigDao;
    @Autowired
    private ExportDao exportDao;
    @Autowired
    private ExportConfigColumnDao exportConfigColumnDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    public String exportForExcel(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName) {
        String tableListName = "";
        String tableListColumn = "";
        boolean districtFlag = false;
        String search = "";
        StringBuffer where = new StringBuffer("");
        List mapList = new ArrayList<Map>();
        try {
            String tableName = propertiesDTO.getTableName();
            String excelName = propertiesDTO.getExcelName();
            List tableList = propertiesDTO.getTableList();
            String tableAnotherName = "t1";
            Class<?> aClass = Class.forName(propertiesDTO.getModelPath());
            ExportModelDTO exportModelDTO = this.getColumn(aClass.newInstance(), josnStr, tableAnotherName);
            ModelTableAnnotation o = aClass.getAnnotation(ModelTableAnnotation.class);
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }
            searchParams.put("extra", extra);
            if (exportModelDTO != null) {
                String local;
                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;
                if (tableList != null && tableList.size() > 0) {
                    for (ExportTableListDTO exportTableListDTO : tableList) {
                        if (exportTableListDTO.getJoinType() != null && "2".equals(exportTableListDTO.getJoinType())) {
                            tableListName = tableListName + " LEFT JOIN " + exportTableListDTO.getTableName() + " AS " + exportTableListDTO.getAnotherName() + " ON " + exportTableListDTO.getSearch();
                        } else if (exportTableListDTO.getJoinType() != null && "3".equals(exportTableListDTO.getJoinType())) {
                            tableListName = tableListName + " INNER JOIN " + exportTableListDTO.getTableName() + " AS " + exportTableListDTO.getAnotherName() + " ON " + exportTableListDTO.getSearch();
                        } else {
                            tableListName = tableListName + "," + exportTableListDTO.getTableName() + " AS " + exportTableListDTO.getAnotherName();
                            search = search + exportTableListDTO.getSearch();
                        }
                        tableListColumn = tableListColumn + "," + exportTableListDTO.getTableColumn();
                    }
                }
                if (tableListColumn != "") {
                    column = column + tableListColumn;
                    table = table + tableListName;
                }
                if ("Grade_Certificate".equals(tableName) || "grade_person".equals(tableName) || "CertificatePrintLog".equals(tableName) || "sb_grade_practice".equals(tableName)) {
                    searchParams.put("needcensorStatus", "1");
                }
                try {
                    Field field2 = aClass.getDeclaredField("district");
                    if (field2 != null) {
                        districtFlag = true;
                    }
                }
                catch (NoSuchFieldException field2) {
                    // empty catch block
                }
                if ("1".equals(areaCodeFilter)) {
                    Object police;
                    String areaCode = "";
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    if ((police = user.getPolice()) != null) {
                        if (StringUtil.isEmpty((String)areaCode)) {
                            if (searchParams.get("rankAuth") != null && "1".equals(searchParams.get("rankAuth").toString())) {
                                areaCode = this.configUtils.getCurrentNative();
                                if ("4".equals(police.getOrgtype())) {
                                    searchParams.put("orgID", police.getId());
                                }
                            } else {
                                areaCode = police.getAreacode();
                            }
                        }
                    } else {
                        boolean bl;
                        boolean bl2 = false;
                        if (user.getPlatform() == 2 && !"CertificatePrintLog".equals(tableName)) {
                            try {
                                Field field3 = aClass.getDeclaredField("trainOrgID");
                                if (field3 != null) {
                                    bl = true;
                                    SecurityCompany company = this.securityCompanyDao.findByUserid(user.getId());
                                    where.append(" and ").append(" trainOrgID = ").append(company.getComId()).append(" ");
                                }
                            }
                            catch (NoSuchFieldException field3) {
                                // empty catch block
                            }
                        }
                        if (!(bl || "Grade_Certificate".equals(tableName) || "grade_person".equals(tableName) || "CertificatePrintLog".equals(tableName) || "sb_grade_practice".equals(tableName))) {
                            searchParams.put("user_id", user.getId());
                        } else {
                            searchParams.put("needcensorStatus", "1");
                        }
                    }
                    if (StringUtil.isNotEmpty((String)areaCode)) {
                        if (areaCode.endsWith("0000")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }
                Map columnMap = this.getColumn(aClass.newInstance());
                block24: for (Object e : searchParams.keySet()) {
                    ModelAnnotation resource;
                    if (searchParams.get(e) == null || !StringUtil.isNotEmpty((String)searchParams.get(e).toString()) || columnMap.get(e) == null) continue;
                    Field field = null;
                    try {
                        field = aClass.getDeclaredField(e.toString());
                    }
                    catch (NoSuchFieldException e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                    }
                    if (field == null || field.getName().equals("testState") || (resource = field.getAnnotation(ModelAnnotation.class)) == null) continue;
                    SignType signType = resource.sign();
                    switch (signType) {
                        case EQUAL_NULL_EMPTY: 
                        case EQUAL_NULL_ZERO: {
                            where.append(" and ifnull(").append((String)columnMap.get(e)).append(",'").append(signType.getDefaultValue()).append("') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("' ");
                            continue block24;
                        }
                        case NOTEMPTY: {
                            where.append(" and ifnull(").append((String)columnMap.get(e)).append(",'").append(signType.getDefaultValue()).append("') ").append(signType.getOperator()).append(" ''");
                            continue block24;
                        }
                        case IN: {
                            if ("0102".equals(searchParams.get(e))) {
                                where.append(" and ").append((String)columnMap.get(e)).append(" in ('0102','0105')");
                                continue block24;
                            }
                            where.append(" and ").append((String)columnMap.get(e)).append(signType.getOperator()).append("('").append(searchParams.get(e)).append("') ");
                            continue block24;
                        }
                        case NOTEQUAL: {
                            where.append(" and ifnull(").append((String)columnMap.get(e)).append(",'").append(signType.getDefaultValue()).append("') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("' ");
                            continue block24;
                        }
                        case LIKE: {
                            where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" '%").append(searchParams.get(e)).append("%'");
                            continue block24;
                        }
                        case OUTDAY: {
                            where.append(" and  datediff(now(),").append((String)columnMap.get(e)).append(") ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                        case IDCARDSEX: {
                            where.append(" and  IF(mod(SUBSTR(").append((String)columnMap.get(e)).append(",17,1),2),'1','2') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                        case IDCARDNATIVE: {
                            String nativePlace = (String)searchParams.get(e);
                            if (nativePlace.endsWith("0000")) {
                                nativePlace = nativePlace.substring(0, 2) + "________________";
                            } else if (nativePlace.endsWith("00")) {
                                nativePlace = nativePlace.substring(0, 4) + "______________";
                            }
                            where.append(" and  ").append((String)columnMap.get(e)).append(signType.getOperator()).append(" '").append(nativePlace).append("'");
                            continue block24;
                        }
                        case FEE_STATE: {
                            where.append(" and if(ifnull(fee_state,'0')='','0',ifnull(fee_state,'0'))=").append(searchParams.get(e));
                            continue block24;
                        }
                        case DATE_EQUAL: 
                        case DATE_GREATER_EQUAL: 
                        case DATE_LESS_EQUAL: {
                            where.append(" and  date_format(").append((String)columnMap.get(e)).append(",'%Y-%m-%d') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                        case OTHERIF: {
                            if (searchParams.get(e).equals(1)) {
                                where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" true");
                                continue block24;
                            }
                            if (searchParams.get(e).equals(0)) {
                                where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" false");
                                continue block24;
                            }
                            where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                    }
                    where.append(" and ").append((String)columnMap.get(e)).append(signType.getOperator()).append("'").append(searchParams.get(e)).append("' ");
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                if (searchParams.get("local") != null && "0".equals(local = searchParams.get("local").toString())) {
                    searchParams.remove("areacode");
                }
                mapList = this.exportDao.findExportMessager(searchParams);
            }
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(this.downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String templateName = this.downloadFolder + dirDate + "/" + now.getTime() + "_" + tableExcelName + ".xlsx";
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                return templateName;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String commonExportExcel(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName) {
        String tableListName = "";
        String tableListColumn = "";
        String search = "";
        StringBuffer where = new StringBuffer("");
        List mapList = new ArrayList<Map>();
        boolean districtFlag = false;
        try {
            String tableName = propertiesDTO.getTableName();
            String excelName = propertiesDTO.getExcelName();
            List tableList = propertiesDTO.getTableList();
            String tableAnotherName = "t1";
            Class<?> aClass = Class.forName(propertiesDTO.getModelPath());
            ModelTableAnnotation o = aClass.getAnnotation(ModelTableAnnotation.class);
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }
            searchParams.put("extra", extra);
            ExportModelDTO exportModelDTO = this.getColumn(aClass.newInstance(), josnStr, tableAnotherName);
            if (exportModelDTO != null) {
                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                }
                catch (NoSuchFieldException field) {
                    // empty catch block
                }
                if ("1".equals(areaCodeFilter)) {
                    Police police;
                    String areaCode = "";
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    if ((police = user.getPolice()) != null) {
                        if (StringUtil.isEmpty((String)areaCode)) {
                            areaCode = police.getAreacode();
                        }
                    } else {
                        boolean hasTrainOrgId = false;
                        if (user.getPlatform() == 2 && !"CertificatePrintLog".equals(tableName)) {
                            try {
                                Field field = aClass.getDeclaredField("trainOrgID");
                                if (field != null) {
                                    hasTrainOrgId = true;
                                    SecurityCompany securityCompany = this.securityCompanyDao.findByUserid(user.getId());
                                    where.append(" and ").append(" trainOrgID = ").append(securityCompany.getComId()).append(" ");
                                }
                            }
                            catch (NoSuchFieldException field) {
                                // empty catch block
                            }
                        }
                        if (!(hasTrainOrgId || "Grade_Certificate".equals(tableName) || "grade_person".equals(tableName) || "CertificatePrintLog".equals(tableName) || "sb_grade_practice".equals(tableName))) {
                            searchParams.put("user_id", user.getId());
                        } else {
                            searchParams.put("needcensorStatus", "1");
                        }
                    }
                    if (StringUtil.isNotEmpty((String)areaCode)) {
                        if (areaCode.endsWith("0000")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }
                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;
                Map columnMap = this.getColumn(aClass.newInstance());
                block24: for (Object e : searchParams.keySet()) {
                    ModelAnnotation resource;
                    if (searchParams.get(e) == null || !StringUtil.isNotEmpty((String)searchParams.get(e).toString()) || columnMap.get(e) == null) continue;
                    Field field = null;
                    try {
                        field = aClass.getDeclaredField(e.toString());
                    }
                    catch (NoSuchFieldException e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                    }
                    if (field == null || (resource = field.getAnnotation(ModelAnnotation.class)) == null) continue;
                    SignType signType = resource.sign();
                    switch (signType) {
                        case EQUAL_NULL_EMPTY: 
                        case EQUAL_NULL_ZERO: {
                            where.append(" and ifnull(").append((String)columnMap.get(e)).append(",'").append(signType.getDefaultValue()).append("') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("' ");
                            continue block24;
                        }
                        case OR: {
                            String[] columns = ((String)columnMap.get(e)).split(",");
                            StringBuilder columnStr = new StringBuilder();
                            for (int i = 0; i < columns.length; ++i) {
                                if (i > 0) {
                                    columnStr.append(" or ");
                                }
                                columnStr.append(columns[i]).append(" = '").append(searchParams.get(e)).append("'");
                            }
                            where.append(" and (" + columnStr + ")");
                            continue block24;
                        }
                        case OR_LIKE: {
                            String[] likeColumns = ((String)columnMap.get(e)).split(",");
                            StringBuilder likeColumnStr = new StringBuilder();
                            for (int i = 0; i < likeColumns.length; ++i) {
                                if (i > 0) {
                                    likeColumnStr.append(" or ");
                                }
                                likeColumnStr.append(likeColumns[i]).append(" like '%").append(searchParams.get(e)).append("%'");
                            }
                            where.append(" and (" + likeColumnStr + ")");
                            continue block24;
                        }
                        case CASE: {
                            where.append("  and (case contractStatus         when effectStartDate>date_format( now(), '%Y-%m-%d' ) then '8'         when '1' then '1'         when '2' then '2'         when '3' then '1'         else '2'       end ) = '").append(searchParams.get(e)).append("' ");
                            continue block24;
                        }
                        case NOTEMPTY: {
                            where.append(" and ifnull(").append((String)columnMap.get(e)).append(",'").append(signType.getDefaultValue()).append("') ").append(signType.getOperator()).append(" ''");
                            continue block24;
                        }
                        case IN: {
                            if ("0102".equals(searchParams.get(e))) {
                                where.append(" and ").append((String)columnMap.get(e)).append(" in ('0102','0105')");
                                continue block24;
                            }
                            where.append(" and ").append((String)columnMap.get(e)).append(signType.getOperator()).append("('").append(searchParams.get(e)).append("') ");
                            continue block24;
                        }
                        case NOTEQUAL: {
                            where.append(" and ifnull(").append((String)columnMap.get(e)).append(",'").append(signType.getDefaultValue()).append("') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("' ");
                            continue block24;
                        }
                        case LIKE: {
                            where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" '%").append(searchParams.get(e)).append("%'");
                            continue block24;
                        }
                        case OTHERIF: {
                            if (searchParams.get(e).equals(1)) {
                                where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" true");
                                continue block24;
                            }
                            if (searchParams.get(e).equals(0)) {
                                where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" false");
                                continue block24;
                            }
                            where.append(" and ").append((String)columnMap.get(e)).append(" ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                        case OUTDAY: {
                            where.append(" and  datediff(now(),").append((String)columnMap.get(e)).append(") ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                        case DATE_EQUAL: 
                        case DATE_GREATER_EQUAL: 
                        case DATE_LESS_EQUAL: {
                            where.append(" and  date_format(").append((String)columnMap.get(e)).append(",'%Y-%m-%d') ").append(signType.getOperator()).append(" '").append(searchParams.get(e)).append("'");
                            continue block24;
                        }
                        case IDCARDNATIVE: {
                            String nativePlace = (String)searchParams.get(e);
                            if (nativePlace.endsWith("0000")) {
                                nativePlace = nativePlace.substring(0, 2) + "________________";
                            } else if (nativePlace.endsWith("00")) {
                                nativePlace = nativePlace.substring(0, 4) + "______________";
                            }
                            where.append(" and  ").append((String)columnMap.get(e)).append(signType.getOperator()).append(" '").append(nativePlace).append("'");
                            continue block24;
                        }
                    }
                    where.append(" and ").append((String)columnMap.get(e)).append(signType.getOperator()).append("'").append(searchParams.get(e)).append("' ");
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                mapList = this.exportDao.commonExportExcel(searchParams);
            }
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(this.downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String templateName = this.downloadFolder + dirDate + "/" + now.getTime() + "_" + tableExcelName + ".xlsx";
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                return templateName;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String exportRoster(ExportRosterDto exportRosterDto) {
        ExportConfig exportConfig = this.exportConfigDao.selectByExportType(exportRosterDto.getExportType());
        if (exportConfig == null) {
            throw new ArsException("\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u7684\u5bfc\u51fa\u914d\u7f6e");
        }
        List columnList = this.exportConfigColumnDao.selectByConfigId(exportConfig.getId());
        if (columnList == null || columnList.size() == 0) {
            throw new ArsException("\u83b7\u53d6\u5bfc\u51fa\u5b57\u6bb5\u914d\u7f6e\u51fa\u9519");
        }
        HashMap<String, List<ExportColumn>> columnMap = new HashMap<String, List<ExportColumn>>();
        ArrayList select = new ArrayList();
        columnList.forEach(column -> {
            if ("1".equals(column.getIsNeedSelect())) {
                select.add(column);
            }
            if (columnMap.get(column.getPosition()) == null) {
                ArrayList<ExportColumn> list = new ArrayList<ExportColumn>();
                list.add((ExportColumn)column);
                columnMap.put(column.getPosition(), list);
            } else {
                ((List)columnMap.get(column.getPosition())).add(column);
            }
        });
        if (columnMap.get("center") != null && ((List)columnMap.get("center")).size() > 0) {
            this.arsUtil.setPoliceSearch((SearchDto)exportRosterDto);
            String where = "";
            try {
                where = this.toStringWhere(exportRosterDto);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            List exportRosterDtoList = this.exportDao.selectDataV1(select, exportConfig.getTableName(), where);
            if (exportRosterDtoList == null || exportRosterDtoList.size() == 0) {
                throw new ArsException("\u6570\u636e\u4e3a\u7a7a");
            }
            if (exportRosterDto.getExportType().equals("03")) {
                return this.exportCertificate(exportConfig, columnMap, exportRosterDtoList);
            }
            Date now = new Date();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(this.downloadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if ("1".equals(exportConfig.getIsJar())) {
                Map<String, List<Map<String, String>>> tables = this.splitTableByCompany(exportRosterDtoList, exportConfig.getTrainNameKey());
                if (tables.size() > 1) {
                    ArrayList<String> tableNameList = new ArrayList<String>();
                    for (String key : tables.keySet()) {
                        String templateName = this.downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate((String)key) + ".xlsx";
                        File file = new File(templateName);
                        this.exportRosterExcel(columnMap, tables.get(key), file, key, exportConfig);
                        tableNameList.add(templateName);
                    }
                    return FileUtil.zipFiles(tableNameList, (String)(this.downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate((String)"export") + ".zip"));
                }
                if (tables.size() == 1) {
                    return this.getDownPath(columnMap, exportRosterDtoList, (String)((Map)exportRosterDtoList.get(0)).get(exportConfig.getTrainNameKey()), exportConfig);
                }
            }
            return this.getDownPath(columnMap, exportRosterDtoList, exportConfig.getTitle(), exportConfig);
        }
        return null;
    }

    public String autoExportPersonInfo(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, String tableExcelName) {
        String search = "";
        StringBuffer where = new StringBuffer("");
        ArrayList<Map> mapList = new ArrayList();
        boolean districtFlag = false;
        try {
            String tableName = propertiesDTO.getTableName();
            String excelName = propertiesDTO.getExcelName();
            List tableList = propertiesDTO.getTableList();
            String tableAnotherName = "t1";
            Class<?> aClass = Class.forName(propertiesDTO.getModelPath());
            ModelTableAnnotation o = aClass.getAnnotation(ModelTableAnnotation.class);
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }
            searchParams.put("extra", extra);
            ExportModelDTO exportModelDTO = this.getColumns(aClass.newInstance(), josnStr, tableAnotherName);
            if (exportModelDTO != null) {
                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                }
                catch (NoSuchFieldException field) {
                    // empty catch block
                }
                if ("1".equals(areaCodeFilter)) {
                    String areaCode = "";
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    if (StringUtil.isNotEmpty((String)areaCode)) {
                        if (areaCode.endsWith("0000")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }
                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;
                Map columnMap = this.getColumn(aClass.newInstance());
                for (Object key : searchParams.keySet()) {
                    ModelAnnotation resource;
                    if (searchParams.get(key) == null || !StringUtil.isNotEmpty((String)searchParams.get(key).toString()) || columnMap.get(key) == null) continue;
                    Field field = null;
                    try {
                        field = aClass.getDeclaredField(key.toString());
                    }
                    catch (NoSuchFieldException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                    if (field == null || (resource = field.getAnnotation(ModelAnnotation.class)) == null) continue;
                    SignType signType = resource.sign();
                    where.append(signType.getExportWhereStrategy().spliceWhereStr(signType, columnMap, searchParams, key));
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                System.out.println(searchParams.toString());
                mapList = this.exportDao.commonExportExcel(searchParams);
            }
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                String dirDate1 = DateUtil.timestamp.format(now);
                File dir = new File(this.downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String fileName = now.getTime() + "_" + tableExcelName + ".xlsx";
                String templateName = this.downloadFolder + dirDate + "/" + fileName;
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                FileInputStream inputStream = new FileInputStream(file);
                logger.error("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230ftp\uff0cip:71.2.12.71,\u7aef\u53e3:" + Constants.GX_FTP_PORT + ",\u7528\u6237\u540d\uff1a" + "zhabxt" + ",\u5bc6\u7801\uff1a" + "Szab@789" + "\uff0cftp\u5730\u5740\uff1a" + "/lvdata/ftp/zhabxt/");
                FtpUtils.bcxUploadFile((String)"71.2.12.71", (String)"zhabxt", (String)"Szab@789", (int)Constants.GX_FTP_PORT, (String)"/lvdata/ftp/zhabxt/", (String)("zhabxt_" + dirDate1 + ".xlsx"), (InputStream)inputStream);
                return templateName;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public String toStringWhere(ExportRosterDto exportRosterDto) throws Exception {
        Class<?> aClass = Class.forName("com.bcxin.ars.dto.sys.ExportRosterDto");
        StringBuffer where = new StringBuffer("");
        ExportBusiness exportBusiness = ExportBusinessBeanFactory.getExportBusinessBean(exportRosterDto.getExportType());
        if (exportBusiness == null) {
            throw new ArsException("\u672a\u627e\u5230\u5bf9\u5e94\u4e1a\u52a1\u7c7b\u578b");
        }
        exportBusiness.getWhereByBusiness(exportRosterDto);
        Map<Object, Object> parameters = ExportServiceImpl.getFiledInfo(exportRosterDto);
        Map columnMap1 = this.getRosterExportColumn(aClass.newInstance());
        for (Object key : parameters.keySet()) {
            ModelAnnotation resource;
            if (parameters.get(key) == null || !StringUtil.isNotEmpty((String)parameters.get(key).toString()) || columnMap1.get(key) == null) continue;
            Field field = null;
            try {
                field = aClass.getDeclaredField(key.toString());
            }
            catch (NoSuchFieldException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            if (field == null || (resource = field.getAnnotation(ModelAnnotation.class)) == null) continue;
            SignType signType = resource.sign();
            where.append(signType.getExportWhereStrategy().spliceWhereStr(signType, columnMap1, parameters, key));
        }
        return where.toString();
    }

    public static Map<Object, Object> getFiledInfo(ExportRosterDto exportRosterDto) {
        Field[] fields;
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        for (Field field : fields = exportRosterDto.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            parameters.put(field.getName(), ReflectionUtils.getField((Field)field, (Object)exportRosterDto));
        }
        parameters.remove("exportType");
        return parameters;
    }

    public static Object getFieldValueByName(String fieldName, ExportRosterDto exportRosterDto) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = exportRosterDto.getClass().getMethod(getter, new Class[0]);
            Object value = method.invoke((Object)exportRosterDto, new Object[0]);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\u5b9e\u4f53\u7c7b\u8f6c\u6362\u4e3aMap\u51fa\u9519");
            return null;
        }
    }

    public String getDownPath(Map<String, List<ExportColumn>> columnMap, List<Map<String, String>> exportRosterDtoList, String tableExcelName, ExportConfig exportConfig) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        String downPath = "";
        try {
            String userAgent = request.getHeader("user-agent");
            downPath = userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0 || userAgent.indexOf("Safari") >= 0 ? new String(tableExcelName.getBytes(), "ISO8859-1") : URLEncoder.encode(tableExcelName, "UTF8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u8bbe\u7f6e\u8868\u540d\u51fa\u9519");
        }
        downPath = this.downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate((String)downPath) + ".xlsx";
        File file = new File(downPath);
        this.exportRosterExcel(columnMap, exportRosterDtoList, file, tableExcelName, exportConfig);
        return downPath;
    }

    public Map<String, List<Map<String, String>>> splitTableByCompany(List<Map<String, String>> exportRosterDtoList, String key) {
        HashMap<String, List<Map<String, String>>> map = new HashMap<String, List<Map<String, String>>>();
        exportRosterDtoList.forEach(column -> {
            String trainName = (String)column.get(key);
            if (StringUtil.isNotEmpty((String)trainName)) {
                if (map.get(trainName) == null) {
                    ArrayList<Map> list = new ArrayList<Map>();
                    list.add((Map)column);
                    map.put(trainName, list);
                } else {
                    ((List)map.get(trainName)).add(column);
                }
            }
        });
        return map;
    }

    /*
     * WARNING - void declaration
     */
    public void exportRosterExcel(Map<String, List<ExportColumn>> columnMap, List<Map<String, String>> exportRosterDtoList, File file, String tableExcelName, ExportConfig exportConfig) {
        HashMap<String, ExportExcelType> mapType = new HashMap<String, ExportExcelType>();
        mapType.put("001", ExportExcelType.FILED_NAME);
        mapType.put("002", ExportExcelType.SYS_CODE);
        mapType.put("003", ExportExcelType.DATE_FOMAT);
        mapType.put("004", ExportExcelType.SAVE_ONEPOINT);
        try {
            int i;
            XSSFWorkbook wb = new XSSFWorkbook();
            Sheet sheet1 = wb.createSheet(tableExcelName);
            CellStyle style = ExcelUtil.getExportStyle((Workbook)wb, (short)11);
            CellStyle styleColumn = ExcelUtil.getExportStyle((Workbook)wb, (short)9);
            CellStyle styleTitle = ExcelUtil.getExportHeadStyle((Workbook)wb, (short)16, (String)"1", (String)"1");
            CellStyle styleHead = ExcelUtil.getExportHeadStyle((Workbook)wb, (short)12, (String)"1", (String)"0");
            CellStyle styleBottom = ExcelUtil.getExportHeadStyle((Workbook)wb, (short)11, (String)"0", (String)"0");
            int index = 0;
            Row rowTitle = sheet1.createRow(index++);
            rowTitle.setHeightInPoints(35.0f);
            ExcelUtil.setStyleCell((Row)rowTitle, (int)0, (String)exportConfig.getTitle(), (CellStyle)styleTitle);
            ExcelUtil.region((int)0, (int)0, (int)0, (int)0, (int)(exportConfig.getColumns() - 1), (Workbook)wb);
            List<ExportColumn> top = columnMap.get("top");
            if (top != null && top.size() > 0) {
                int beginCol = 0;
                int lastCol = 0;
                Row rowTop = sheet1.createRow(index++);
                rowTop.setHeightInPoints(30.0f);
                for (i = 0; i < top.size(); ++i) {
                    ExportColumn topI = top.get(i);
                    beginCol = topI.getBeginCol();
                    lastCol = topI.getOccupy();
                    String columnValue = topI.getColumnName();
                    if (StringUtils.isNotEmpty((String)topI.getFormula())) {
                        ExportExcelType exportExcelType = (ExportExcelType)((Object)mapType.get(topI.getFormula()));
                        columnValue = columnValue + exportExcelType.getFormula().getFormulaValue(exportRosterDtoList, topI, "");
                    }
                    ExcelUtil.setStyleCell((Row)rowTop, (int)beginCol, (String)columnValue, (CellStyle)styleHead);
                    if (lastCol <= 1) continue;
                    ExcelUtil.region((int)0, (int)1, (int)1, (int)beginCol, (int)(beginCol + lastCol - 1), (Workbook)wb);
                }
            }
            List<ExportColumn> files = columnMap.get("center");
            int begin = 0;
            Row fileRow = sheet1.createRow(index++);
            if ("1".equals(exportConfig.getColumnNo())) {
                begin = 1;
                ExcelUtil.setStyleCell((Row)fileRow, (int)0, (String)"\u5e8f\u53f7", (CellStyle)style);
                sheet1.setColumnWidth(0, 1500);
            }
            i = begin;
            for (int j = 0; j < files.size(); ++j) {
                void var23_31;
                ExportColumn exportColumn = files.get(j);
                String string = exportColumn.getColumnName();
                fileRow.setHeightInPoints(30.0f);
                sheet1.setColumnWidth(i, exportColumn.getColumnWith().intValue());
                if ("1".equals(exportColumn.getRequired())) {
                    String string2 = string + "*";
                }
                ExcelUtil.setStyleCell((Row)fileRow, (int)i, (String)var23_31, (CellStyle)styleColumn);
                ++i;
            }
            Row row = null;
            int number = 1;
            for (Map map : exportRosterDtoList) {
                row = sheet1.createRow(index++);
                row.setHeightInPoints(30.0f);
                if (begin == 1) {
                    ExcelUtil.setStyleCell((Row)row, (int)0, (String)String.valueOf(number), (CellStyle)style);
                    ++number;
                }
                int i2 = begin;
                for (int j = 0; j < files.size(); ++j) {
                    String formula;
                    String key = files.get(j).getColumnValueSource();
                    String cellValue = "";
                    if (map.get(key) != null && map.get(key).toString() != "") {
                        cellValue = map.get(key).toString();
                    }
                    if (StringUtils.isNotEmpty((String)(formula = files.get(j).getFormula()))) {
                        ExportExcelType exportExcelType = (ExportExcelType)((Object)mapType.get(files.get(j).getFormula()));
                        cellValue = exportExcelType.getFormula().getFormulaValue(exportRosterDtoList, files.get(j), cellValue);
                    }
                    ExcelUtil.setStyleCell((Row)row, (int)i2, (String)cellValue, (CellStyle)style);
                    ++i2;
                }
            }
            List<ExportColumn> bottom = columnMap.get("bottom");
            if (bottom != null && bottom.size() > 0) {
                Row row2 = sheet1.createRow(index++);
                int beginCol = 0;
                int lastCol = 0;
                String value = "";
                for (int i3 = 0; i3 < bottom.size(); ++i3) {
                    Cell bottomCell = null;
                    beginCol = bottom.get(i3).getBeginCol();
                    lastCol = bottom.get(i3).getOccupy();
                    if (StringUtil.isNotEmpty((String)bottom.get(i3).getContext())) {
                        Row contentRow = sheet1.createRow(index++);
                        bottomCell = contentRow.createCell(1);
                        value = bottom.get(i3).getContext();
                        contentRow.setHeight((short)3000);
                    } else {
                        bottomCell = row2.createCell(beginCol);
                        row2.setHeight((short)800);
                        value = bottom.get(i3).getColumnName();
                    }
                    bottomCell.setCellValue(value);
                    bottomCell.setCellStyle(styleBottom);
                    if (lastCol <= 1) continue;
                    ExcelUtil.region((int)0, (int)bottomCell.getRowIndex(), (int)bottomCell.getRowIndex(), (int)beginCol, (int)(beginCol + lastCol - 1), (Workbook)wb);
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            wb.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String commonExport(PropertiesDTO propertiesDTO, String josnStr, Map<Object, Object> searchParams, User user, String tableExcelName) {
        String tableListName = "";
        String tableListColumn = "";
        String search = "";
        StringBuffer where = new StringBuffer("");
        List mapList = new ArrayList<Map>();
        boolean districtFlag = false;
        try {
            String tableName = propertiesDTO.getTableName();
            String excelName = propertiesDTO.getExcelName();
            List tableList = propertiesDTO.getTableList();
            String tableAnotherName = "t1";
            Class<?> aClass = Class.forName(propertiesDTO.getModelPath());
            ModelTableAnnotation o = aClass.getAnnotation(ModelTableAnnotation.class);
            String areaCodeFilterColumn = "areacode";
            String areaCodeFilter = "1";
            boolean extra = true;
            if (o instanceof ModelTableAnnotation) {
                ModelTableAnnotation tableAnnotation = o;
                areaCodeFilterColumn = tableAnnotation.areaCodeFilterColumn();
                areaCodeFilter = tableAnnotation.areaCodeFilter();
                extra = tableAnnotation.extra();
            }
            searchParams.put("extra", extra);
            ExportModelDTO exportModelDTO = this.getColumns(aClass.newInstance(), josnStr, tableAnotherName);
            if (exportModelDTO != null) {
                try {
                    Field field = aClass.getDeclaredField("district");
                    if (field != null) {
                        districtFlag = true;
                    }
                }
                catch (NoSuchFieldException field) {
                    // empty catch block
                }
                if ("1".equals(areaCodeFilter)) {
                    Police police;
                    String areaCode = "";
                    if (searchParams.get(areaCodeFilterColumn) != null) {
                        areaCode = searchParams.get(areaCodeFilterColumn).toString();
                    }
                    if ((police = user.getPolice()) != null) {
                        if (StringUtil.isEmpty((String)areaCode)) {
                            areaCode = police.getAreacode();
                        }
                    } else {
                        boolean hasTrainOrgId = false;
                        if (user.getPlatform() == 2 && !"CertificatePrintLog".equals(tableName)) {
                            try {
                                Field field = aClass.getDeclaredField("trainOrgID");
                                if (field != null) {
                                    hasTrainOrgId = true;
                                    SecurityCompany securityCompany = this.securityCompanyDao.findByUserid(user.getId());
                                    where.append(" and ").append(" trainOrgID = ").append(securityCompany.getComId()).append(" ");
                                }
                            }
                            catch (NoSuchFieldException field) {
                                // empty catch block
                            }
                        }
                        if (!(hasTrainOrgId || "Grade_Certificate".equals(tableName) || "grade_person".equals(tableName) || "CertificatePrintLog".equals(tableName) || "sb_grade_practice".equals(tableName))) {
                            searchParams.put("user_id", user.getId());
                        } else {
                            searchParams.put("needcensorStatus", "1");
                        }
                    }
                    if (StringUtil.isNotEmpty((String)areaCode)) {
                        if (areaCode.endsWith("0000")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 2) + "____");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 2) + "____");
                        } else if (areaCode.endsWith("00")) {
                            if (districtFlag) {
                                searchParams.put("district", areaCode.substring(0, 4) + "__");
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode.substring(0, 4) + "__");
                        } else {
                            if (districtFlag) {
                                searchParams.put("district", areaCode);
                            }
                            searchParams.put(areaCodeFilterColumn, areaCode);
                        }
                    }
                }
                String column = exportModelDTO.getColumns();
                String table = tableName + " AS " + tableAnotherName;
                Map columnMap = this.getColumn(aClass.newInstance());
                for (Object e : searchParams.keySet()) {
                    ModelAnnotation resource;
                    if (searchParams.get(e) == null || !StringUtil.isNotEmpty((String)searchParams.get(e).toString()) || columnMap.get(e) == null) continue;
                    Field field = null;
                    try {
                        field = aClass.getDeclaredField(e.toString());
                    }
                    catch (NoSuchFieldException e2) {
                        logger.error(e2.getMessage(), (Throwable)e2);
                    }
                    if (field == null || (resource = field.getAnnotation(ModelAnnotation.class)) == null) continue;
                    SignType signType = resource.sign();
                    where.append(signType.getExportWhereStrategy().spliceWhereStr(signType, columnMap, searchParams, e));
                }
                searchParams.put("tableColumn", column);
                searchParams.put("tableName", table);
                searchParams.put("search", search);
                searchParams.put("where", where.toString());
                mapList = this.exportDao.commonExportExcel(searchParams);
            }
            if (mapList != null && mapList.size() > 0) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(this.downloadFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String templateName = this.downloadFolder + dirDate + "/" + now.getTime() + "_" + tableExcelName + ".xlsx";
                File file = new File(templateName);
                this.exportCompanys(mapList, file, excelName, exportModelDTO);
                return templateName;
            }
        }
        catch (ClassNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Map getColumn(Object object) {
        Field[] fields;
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            ModelAnnotation resource;
            if (!field.isAnnotationPresent(ModelAnnotation.class) || !StringUtil.isNotEmpty((String)(resource = field.getAnnotation(ModelAnnotation.class)).column())) continue;
            columnMap.put(field.getName(), new StringBuffer().append(resource.tableName()).append(".").append(resource.column()).toString());
        }
        return columnMap;
    }

    private Map getRosterExportColumn(Object object) {
        Field[] fields;
        HashMap<String, String> columnMap = new HashMap<String, String>();
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            ModelAnnotation resource;
            if (!field.isAnnotationPresent(ModelAnnotation.class) || !StringUtil.isNotEmpty((String)(resource = field.getAnnotation(ModelAnnotation.class)).column())) continue;
            columnMap.put(field.getName(), new StringBuffer().append(resource.column()).toString());
        }
        return columnMap;
    }

    private ExportModelDTO getColumns(Object object, String josnStr, String tableName) {
        List modelNameDTOList = JSONArray.parseArray((String)josnStr, ModelNameDTO.class);
        Field[] fields = object.getClass().getDeclaredFields();
        ExportModelDTO exportModelDTO = new ExportModelDTO();
        String columnStr = "";
        String modeNames = "";
        String modekeys = "";
        String exportColumns = "";
        for (Field field : fields) {
            ModelAnnotation resource;
            if (!field.isAnnotationPresent(ModelAnnotation.class) || !(resource = field.getAnnotation(ModelAnnotation.class)).isExport()) continue;
            for (ModelNameDTO modelNameDTO1 : modelNameDTOList) {
                if (!modelNameDTO1.getModekey().equals(field.getName())) continue;
                if (StringUtil.isEmpty((String)resource.specialTranslateType())) {
                    if (resource.multipleCode()) {
                        columnStr = columnStr + this.multipleCode(resource.dictName(), resource.column(), resource.multipleCodeTableName()) + ",";
                    } else if (resource.needTranslate()) {
                        String defaultValue = resource.sign().getDefaultValue();
                        columnStr = columnStr + this.needTranslate(resource.dictName(), resource.oneToMore(), resource.column(), tableName, defaultValue) + ",";
                    } else if (StringUtil.isNotEmpty((String)resource.DATE_FORMAT())) {
                        columnStr = columnStr + "DATE_FORMAT(" + tableName + "." + resource.column() + ",'" + resource.DATE_FORMAT() + "') as " + resource.column() + ",";
                    } else if (resource.mySqlDataFormat() != null) {
                        switch (resource.mySqlDataFormat()) {
                            case MINUTE2HOUR_FLOAT_2: {
                                columnStr = columnStr + "convert(" + tableName + "." + resource.column() + "/60.0,decimal(10,2)) as " + resource.column() + ",";
                                break;
                            }
                            default: {
                                columnStr = columnStr + tableName + "." + resource.column() + ",";
                                break;
                            }
                        }
                    } else {
                        columnStr = columnStr + tableName + "." + resource.column() + ",";
                    }
                } else {
                    columnStr = columnStr + this.specialTranslate(resource.specialTranslateType(), tableName + "." + resource.column(), resource.dictName()) + ",";
                }
                exportColumns = exportColumns + resource.column() + ",";
                modekeys = modekeys + modelNameDTO1.getModekey() + ",";
                modeNames = modeNames + resource.getName() + ",";
            }
        }
        if (columnStr != "") {
            exportModelDTO.setColumns(columnStr.substring(0, columnStr.length() - 1));
            exportModelDTO.setModekeys(modekeys.substring(0, modekeys.length() - 1));
            exportModelDTO.setModeNames(modeNames.substring(0, modeNames.length() - 1));
            exportModelDTO.setExportColumns(exportColumns.substring(0, exportColumns.length() - 1));
            return exportModelDTO;
        }
        return null;
    }

    private ExportModelDTO getColumn(Object object, String josnStr, String tableName) {
        List modelNameDTOList = JSONArray.parseArray((String)josnStr, ModelNameDTO.class);
        Field[] fields = object.getClass().getDeclaredFields();
        ExportModelDTO exportModelDTO = new ExportModelDTO();
        String columnStr = "";
        String modeNames = "";
        String modekeys = "";
        String exportColumns = "";
        for (Field field : fields) {
            ModelAnnotation resource;
            if (!field.isAnnotationPresent(ModelAnnotation.class) || !(resource = field.getAnnotation(ModelAnnotation.class)).isExport()) continue;
            for (ModelNameDTO modelNameDTO1 : modelNameDTOList) {
                if (!modelNameDTO1.getModekey().equals(field.getName())) continue;
                if (!resource.anotherTable()) {
                    if (StringUtil.isEmpty((String)resource.specialTranslateType())) {
                        if (resource.multipleCode()) {
                            columnStr = columnStr + this.multipleCode(resource.dictName(), resource.column(), resource.multipleCodeTableName()) + ",";
                        } else if (resource.needTranslate()) {
                            String defaultValue = resource.sign().getDefaultValue();
                            columnStr = columnStr + this.needTranslate(resource.dictName(), resource.oneToMore(), resource.column(), tableName, defaultValue) + ",";
                        } else if (StringUtil.isNotEmpty((String)resource.DATE_FORMAT())) {
                            columnStr = columnStr + "DATE_FORMAT(" + tableName + "." + resource.column() + ",'" + resource.DATE_FORMAT() + "') as " + resource.column() + ",";
                        } else if (resource.mySqlDataFormat() != null) {
                            switch (resource.mySqlDataFormat()) {
                                case MINUTE2HOUR_FLOAT_2: {
                                    columnStr = columnStr + "convert(" + tableName + "." + resource.column() + "/60.0,decimal(10,2)) as " + resource.column() + ",";
                                    break;
                                }
                                default: {
                                    columnStr = columnStr + tableName + "." + resource.column() + ",";
                                    break;
                                }
                            }
                        } else {
                            columnStr = columnStr + tableName + "." + resource.column() + ",";
                        }
                    } else {
                        columnStr = columnStr + this.specialTranslate(resource.specialTranslateType(), tableName + "." + resource.column(), resource.dictName()) + ",";
                    }
                }
                exportColumns = exportColumns + resource.column() + ",";
                modekeys = modekeys + modelNameDTO1.getModekey() + ",";
                modeNames = modeNames + resource.getName() + ",";
            }
        }
        if (columnStr != "") {
            exportModelDTO.setColumns(columnStr.substring(0, columnStr.length() - 1));
            exportModelDTO.setModekeys(modekeys.substring(0, modekeys.length() - 1));
            exportModelDTO.setModeNames(modeNames.substring(0, modeNames.length() - 1));
            exportModelDTO.setExportColumns(exportColumns.substring(0, exportColumns.length() - 1));
            return exportModelDTO;
        }
        return null;
    }

    private String specialTranslate(String specialTranslateType, String columName, String dictName) {
        String columnStr = "";
        if ("1".equals(specialTranslateType)) {
            columnStr = "(SELECT `name` FROM nation WHERE code=" + columName + "  ) AS " + dictName;
        } else if ("2".equals(specialTranslateType)) {
            columnStr = "(SELECT GROUP_CONCAT(`name` separator  '') FROM sysarea \nWHERE `code` in (RPAD(left(" + dictName + ",2), 6, 0),RPAD(left(" + dictName + ",4), 6, 0)," + dictName + ") order by id) AS areaName ";
        } else if ("3".equals(specialTranslateType)) {
            columnStr = "  CONCAT(IF(ISNULL(t1.securityScopes),'','\u670d\u52a1\u8303\u56f4\u53d8\u66f4,'),IF(ISNULL(t1.companyname),'','\u516c\u53f8\u540d\u79f0\u53d8\u66f4,'),IF(ISNULL(t1.address),'','\u5730\u5740\u53d8\u66f4,'),IF(ISNULL(t1.legalname),'','\u6cd5\u4eba\u53d8\u66f4,'),IF(ISNULL(t1.bgregisteredMoney),'','\u6ce8\u518c\u8d44\u91d1\u53d8\u66f4,'))\n        as changeProject";
        } else if ("4".equals(specialTranslateType)) {
            columnStr = "  (select\n        case\n        when count(0) > 0\n        then count(0) -1\n        else count(0)\n        end\n        from\n        train_exam_person p,train_exam_info q\n        where  p.identitynumber = t1.Cardnumber and p.examid = q.id and q.examState != '1'\n        ) makeUpCount";
        } else if ("5".equals(specialTranslateType)) {
            columnStr = "  IFNULL(t1.companyName,(SELECT `name` from security_company WHERE id=t1.companyid )) as companyName";
        }
        return columnStr;
    }

    private String multipleCode(String dictName, String columName, String multipleCodeTableName) {
        String columnStr = "";
        columnStr = "( select GROUP_CONCAT(label) from sys_dict where codeType ='" + dictName + "' and codeValue in(\nSELECT\n\tsubstring_index(\n\t\tsubstring_index(\n\t\t\t" + multipleCodeTableName + "." + columName + ",\n\t\t\t',',\n\t\t\tb.help_topic_id + 1\n\t\t),\n\t\t',' ,- 1\n\t) shopid\nFROM\n\t" + multipleCodeTableName + "\nJOIN help_topic b ON b.help_topic_id < (\n\tlength(" + multipleCodeTableName + "." + columName + ") - length(\n\t\tREPLACE (" + multipleCodeTableName + "." + columName + ", ',', '')\n\t) + 1\n)\nWHERE\n\tid = t1.id \n)) AS " + columName;
        return columnStr;
    }

    private String needTranslate(String dictName, boolean oneToMore, String columName, String tableName, String defaultValue) {
        String columnStr = "";
        String tableColum = tableName + "." + columName;
        if (StringUtil.isNotEmpty((String)defaultValue)) {
            tableColum = "ifnull(" + tableName + "." + columName + "," + defaultValue + ")";
        }
        columnStr = !oneToMore ? "(SELECT label FROM sys_dict WHERE codeType='" + dictName + "' AND codeValue=" + tableColum + " ) AS " + columName : "(SELECT GROUP_CONCAT(label SEPARATOR  ',')  \n        FROM sys_dict\n       WHERE codeType = '" + dictName + "'\n         AND FIND_IN_SET(codeValue," + tableColum + ") >= 1)  AS  " + columName;
        return columnStr;
    }

    public List<ModelNameDTO> chooseExportColumn(PropertiesDTO propertiesDTO, List<ModelNameDTO> modelNameDTOList) {
        try {
            Class<?> aClass = Class.forName(propertiesDTO.getModelPath());
            List<ModelNameDTO> columnList = this.getModelName(aClass.newInstance(), modelNameDTOList);
            return columnList;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    private List<ModelNameDTO> getModelName(Object object, List<ModelNameDTO> modelNameDTOList) {
        Field[] fields = object.getClass().getDeclaredFields();
        ArrayList<ModelNameDTO> listModelName = new ArrayList<ModelNameDTO>();
        for (Field field : fields) {
            if (!field.isAnnotationPresent(ModelAnnotation.class)) continue;
            ModelNameDTO modelNameDTO = new ModelNameDTO();
            ModelAnnotation resource = field.getAnnotation(ModelAnnotation.class);
            if (!resource.isExport()) continue;
            modelNameDTO.setModekey(field.getName());
            modelNameDTO.setModeName(resource.getName());
            if (modelNameDTOList.size() > 0) {
                for (ModelNameDTO modelNameDTO1 : modelNameDTOList) {
                    if (!modelNameDTO1.getModekey().equals(field.getName())) continue;
                    modelNameDTO.setModelSelect("class=\"light-blue\"");
                    break;
                }
            } else if (resource.defaultColumn()) {
                modelNameDTO.setModelSelect("class=\"light-blue\"");
            }
            listModelName.add(modelNameDTO);
        }
        return listModelName;
    }

    private void exportCompanys(List<Map> list, File file, String excelName, ExportModelDTO exportModelDTO) {
        try {
            SXSSFWorkbook wb = new SXSSFWorkbook();
            SXSSFSheet sheet1 = wb.createSheet(excelName);
            String[] handers = exportModelDTO.getModeNames().split(",");
            SXSSFRow rowFirst = sheet1.createRow(0);
            CellStyle style = ExcelUtil.getExportStyle((Workbook)wb, (short)12);
            for (int i = 0; i < handers.length; ++i) {
                SXSSFCell cell = rowFirst.createCell(i);
                sheet1.setColumnWidth(i, 5000);
                cell.setCellStyle(style);
                cell.setCellValue(handers[i]);
            }
            int index = 1;
            SXSSFRow row = null;
            for (Map map : list) {
                List<String> stringList = Arrays.asList(exportModelDTO.getExportColumns().split(","));
                row = sheet1.createRow(index++);
                for (int i = 0; i < stringList.size(); ++i) {
                    SXSSFCell nameCell = row.createCell(i);
                    nameCell.setCellStyle(style);
                    String key = stringList.get(i);
                    String cellValue = "";
                    if (map.get(key) != null && map.get(key).toString() != "") {
                        cellValue = map.get(key).toString();
                    }
                    nameCell.setCellValue(cellValue);
                }
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            wb.write((OutputStream)fileOut);
            fileOut.close();
            wb.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String exportCertificate(ExportConfig exportConfig, Map<String, List<ExportColumn>> columnMap, List<Map<String, String>> exportRosterDtoList) {
        List applyTimeList = Lists.newArrayList();
        exportRosterDtoList.forEach(stringStringMap -> {
            Object applyTime = stringStringMap.get("applyTime");
            if (ObjectUtil.isNotNull(applyTime)) {
                Date date = (Date)applyTime;
                applyTimeList.add(date);
            }
        });
        applyTimeList.sort(Date::compareTo);
        Date start = null;
        Date end = null;
        if (applyTimeList.size() > 0) {
            start = (Date)applyTimeList.get(0);
            end = (Date)applyTimeList.get(applyTimeList.size() - 1);
        }
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(this.downloadFolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ("1".equals(exportConfig.getIsJar())) {
            Map<String, List<Map<String, String>>> tables = this.splitTableByCompany(exportRosterDtoList, exportConfig.getTrainNameKey());
            if (tables.size() > 1) {
                ArrayList<String> tableNameList = new ArrayList<String>();
                for (String key : tables.keySet()) {
                    String templateName = this.downloadFolder + dirDate + "/" + key + FileUtil.getFileNameByDateInterregional((Date)start, (Date)end) + ".xlsx";
                    File file = new File(templateName);
                    this.exportRosterExcel(columnMap, tables.get(key), file, key, exportConfig);
                    tableNameList.add(templateName);
                }
                return FileUtil.zipFiles(tableNameList, (String)(this.downloadFolder + dirDate + "/" + FileUtil.generatingFileNameByDate((String)"export") + ".zip"));
            }
            if (tables.size() == 1) {
                return this.getDownloadPath(columnMap, exportRosterDtoList, FileUtil.getFileNameByDateInterregional((Date)start, (Date)end), exportConfig);
            }
        }
        return this.getDownloadPath(columnMap, exportRosterDtoList, FileUtil.getFileNameByDateInterregional((Date)start, (Date)end), exportConfig);
    }

    public String getDownloadPath(Map<String, List<ExportColumn>> columnMap, List<Map<String, String>> exportRosterDtoList, String tableExcelName, ExportConfig exportConfig) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        String downPath = this.downloadFolder + dirDate + "/" + tableExcelName + ".xlsx";
        try {
            String userAgent = request.getHeader("user-agent");
            downPath = userAgent != null && (userAgent.contains("Firefox") || userAgent.contains("Chrome") || userAgent.contains("Safari")) ? new String(downPath.getBytes(), "ISO8859-1") : URLEncoder.encode(downPath, "UTF8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ArsException("\u8bbe\u7f6e\u8868\u540d\u51fa\u9519");
        }
        File file = new File(downPath);
        this.exportRosterExcel(columnMap, exportRosterDtoList, file, tableExcelName, exportConfig);
        return downPath;
    }
}

