/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sb.ConfesscompanyundoDao;
import com.bcxin.ars.dao.sb.ConfesscompanyundoDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.ConfesscompanyundoSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Confesscompanyundo;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.sb.ConfesscompanyundoService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Confesscompanyundo.class)
public class ConfesscompanyundoServiceImpl
implements ConfesscompanyundoService {
    private Logger logger = LoggerFactory.getLogger(ConfesscompanyundoServiceImpl.class);
    @Autowired
    private ConfesscompanyundoDao confesscompanyundoDao;
    @Autowired
    private ConfesscompanyundoDaoAop confesscompanyundoDaoAop;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Autowired
    private PoliceDao policeDao;

    public Confesscompanyundo findById(long id) {
        Confesscompanyundo result = this.confesscompanyundoDao.findById(Long.valueOf(id));
        if (result != null) {
            Approval approval = this.approvalDAO.findBybusinessidAndType(result.getId(), "010");
            result.setApproval(approval);
            if (result.getOrgid() != null) {
                Police police = this.policeDao.findById(result.getOrgid());
                result.setPolice(police);
            }
        }
        return result;
    }

    public List<Confesscompanyundo> findByBatchId(List<Approval> approvalList) {
        return this.confesscompanyundoDao.findByBatchId(approvalList);
    }

    public void updateBatch(List<Confesscompanyundo> list) {
        this.confesscompanyundoDaoAop.updateBatch(list);
    }

    public List<Confesscompanyundo> findAll() {
        return this.confesscompanyundoDao.findAll();
    }

    public Confesscompanyundo findUNSubmitByUser(Long userId) {
        return this.confesscompanyundoDao.findUNSubmitByUser(userId);
    }

    public void saveOrUpdate(Confesscompanyundo confesscompanyundo) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (confesscompanyundo.getOrgid() == null) {
            if (confesscompanyundo.getDistrictOrgId() != null) {
                confesscompanyundo.setOrgid(Long.valueOf(Long.parseLong(confesscompanyundo.getDistrictOrgId())));
            } else if (confesscompanyundo.getCityOrgId() != null) {
                confesscompanyundo.setOrgid(Long.valueOf(Long.parseLong(confesscompanyundo.getCityOrgId())));
            }
        }
        if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
            confesscompanyundo.setUserid(currentUser.getId());
        }
        confesscompanyundo.setCompanyname(confesscompanyundo.getCompanyname().trim());
        boolean activity = true;
        if ("002".equals(confesscompanyundo.getApprovalstate()) && this.checkDupliCompanyundo(confesscompanyundo.getCompanyname(), confesscompanyundo.getId())) {
            throw new ArsException(confesscompanyundo.getCompanyname() + "\u5df2\u91cd\u590d\uff0c\u4e0d\u80fd\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        if (confesscompanyundo.getId() == null) {
            confesscompanyundo.setActive(Boolean.valueOf(true));
            confesscompanyundo.setCreateTime(new Date());
            confesscompanyundo.setUpdateTime(new Date());
            confesscompanyundo.setUpdateBy(currentUser.getUsername());
            this.confesscompanyundoDao.save(confesscompanyundo);
        } else {
            Confesscompanyundo oldConfesscompanyundo = this.confesscompanyundoDao.findById(confesscompanyundo.getId());
            if (StringUtil.isNotEmpty((String)oldConfesscompanyundo.getApprovalstate()) && oldConfesscompanyundo.getApprovalstate().equals("002") && oldConfesscompanyundo.getOrgid().toString().equals(confesscompanyundo.getOrgid().toString())) {
                Approval approval;
                activity = false;
                if (!oldConfesscompanyundo.getCompanyname().equals(confesscompanyundo.getCompanyname()) && (approval = this.approvalDAO.findBybusinessidAndType(confesscompanyundo.getId(), "010")) != null) {
                    this.approvalUtil.updateContent(approval, confesscompanyundo.getCompanyname());
                }
            }
            if ("001".equals(confesscompanyundo.getApprovalstate())) {
                BeanUtils.copyPropertiesIgnore((Object)confesscompanyundo, (Object)oldConfesscompanyundo, (String)"active,createTime,userid", (Boolean)true);
            } else {
                BeanUtils.copyPropertiesIgnore((Object)confesscompanyundo, (Object)oldConfesscompanyundo, (Boolean)true);
            }
            oldConfesscompanyundo.setActive(Boolean.valueOf(true));
            oldConfesscompanyundo.setUpdateTime(new Date());
            oldConfesscompanyundo.setUpdateBy(currentUser.getUsername());
            this.confesscompanyundoDaoAop.update(oldConfesscompanyundo);
        }
        if ("002".equals(confesscompanyundo.getApprovalstate())) {
            confesscompanyundo.setCensorstatus("");
            if (activity) {
                this.approvalUtil.saveApproval("010", confesscompanyundo.getId(), "activiticonfesscompanyundoapprovalProcess");
            }
        }
    }

    public void updateForImport(Confesscompanyundo confesscompanyundo) {
        confesscompanyundo.setUpdateTime(new Date());
        Confesscompanyundo oldConfesscompanyundo = this.confesscompanyundoDao.findById(confesscompanyundo.getId());
        Long userId = oldConfesscompanyundo.getUserid();
        if ("001".equals(confesscompanyundo.getApprovalstate())) {
            BeanUtils.copyPropertiesIgnore((Object)confesscompanyundo, (Object)oldConfesscompanyundo, (String)"active,createTime,userid", (Boolean)true);
        } else {
            BeanUtils.copyPropertiesIgnore((Object)confesscompanyundo, (Object)oldConfesscompanyundo, (Boolean)true);
        }
        oldConfesscompanyundo.setUpdateTime(new Date());
        oldConfesscompanyundo.setUserid(userId);
        this.confesscompanyundoDaoAop.update(oldConfesscompanyundo);
    }

    public void delete(Long id) {
        Confesscompanyundo confesscompanyundo = new Confesscompanyundo();
        confesscompanyundo.setId(id);
        confesscompanyundo.setUpdateTime(new Date());
        this.confesscompanyundoDaoAop.delete(confesscompanyundo);
    }

    public void approve(Confesscompanyundo confesscompanyundo) {
        User currentUser = this.arsUtil.getCurrentUser();
        confesscompanyundo.setApprovalperson(currentUser.getId().toString());
        confesscompanyundo.setUpdateTime(new Date());
        this.confesscompanyundoDaoAop.approve(confesscompanyundo);
    }

    public ConfesscompanyundoSearchDto search(ConfesscompanyundoSearchDto dto) {
        ConfesscompanyundoSearchDto resultDto = new ConfesscompanyundoSearchDto();
        User currentUser = this.arsUtil.getCurrentUser();
        Object police = null;
        String areacode = police.getAreacode();
        if (areacode.endsWith("0000")) {
            dto.setDistrict(areacode.substring(0, 2) + "____");
        } else if (areacode.endsWith("00")) {
            dto.setDistrict(areacode.substring(0, 4) + "__");
        } else {
            dto.setDistrict(areacode);
        }
        List list = this.confesscompanyundoDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.confesscompanyundoDao.searchCount(dto));
        return resultDto;
    }

    public List<Confesscompanyundo> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.confesscompanyundoDao.searchForDataSynchronization(dto);
    }

    public void saveOrUpdateForDS(Confesscompanyundo confesscompanyundo) {
        Confesscompanyundo dbConfesscompanyundo;
        if (confesscompanyundo.getActive() == null) {
            confesscompanyundo.setActive(Boolean.valueOf(true));
        }
        if ((dbConfesscompanyundo = this.confesscompanyundoDao.findById(confesscompanyundo.getId())) != null) {
            if (confesscompanyundo.getUpdateTime().getTime() > dbConfesscompanyundo.getUpdateTime().getTime()) {
                this.confesscompanyundoDaoAop.update(confesscompanyundo);
            }
        } else {
            this.confesscompanyundoDao.save(confesscompanyundo);
        }
    }

    public boolean checkDupliCompanyundo(String companyName, Long filterId) {
        int num;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("companyname", companyName);
        ArrayList<String> notIncludeStateList = new ArrayList<String>();
        notIncludeStateList.add("001");
        notIncludeStateList.add("004");
        map.put("notincludestatelist", notIncludeStateList);
        if (filterId != null) {
            map.put("filterId", filterId);
        }
        return (num = this.confesscompanyundoDao.checkDupliCompanyundo(map)) > 0;
    }

    public PageResult searchConfesscompanyundoList_table(Map<Object, Object> p) {
        User currentUser = this.arsUtil.getCurrentUser();
        Police police = currentUser.getPolice();
        String areacode = "";
        if (p.get("areaCode") != null) {
            areacode = p.get("areaCode").toString();
        } else if (police != null) {
            areacode = police.getAreacode();
        }
        if (StringUtil.isNotEmpty((String)areacode)) {
            if (areacode.endsWith("0000")) {
                p.put("district", areacode.substring(0, 2) + "____");
            } else if (areacode.endsWith("00")) {
                p.put("district", areacode.substring(0, 4) + "__");
            } else {
                p.put("district", areacode);
            }
        }
        if (police != null && police.getOrgtype().equals("4")) {
            p.put("orgid", police.getId());
        }
        if (p.get("checkType") != null && currentUser != null) {
            if (currentUser.getPlatform() == 2 || currentUser.getPlatform() == 4) {
                p.put("userid", currentUser.getId());
            } else {
                List roles = currentUser.getRoles();
                if (roles != null && roles.size() > 0) {
                    p.put("roles", roles);
                }
            }
        }
        if (p.get("checkType") != null && currentUser != null) {
            p.put("userid", currentUser.getId());
        }
        return new PageResult(Integer.valueOf(this.confesscompanyundoDao.countConfesscompanyundoList(p)), (Object)this.confesscompanyundoDao.searchConfesscompanyundoList(p));
    }

    public void updateCensorStatus(Confesscompanyundo confesscompanyundo) {
        confesscompanyundo.setUpdateTime(new Date());
        this.confesscompanyundoDaoAop.updateCensorStatus(confesscompanyundo);
    }

    public Map<String, Object> selectApplyUserInfoWithId(Long id) {
        return this.confesscompanyundoDao.selectApplyUserInfoWithId(id);
    }

    public void searchForPage(ConfesscompanyundoSearchDto dto, AjaxPageResponse<Confesscompanyundo> page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        User currentUser = this.arsUtil.getCurrentUser();
        if (Constants.CHECKTYPE_APPROVE.equals(dto.getCheckType()) && currentUser != null) {
            dto.setUserid(currentUser.getId());
        }
        this.confesscompanyundoDao.searchForPage(dto, page);
    }

    private Confesscompanyundo copyProperties(Confesscompanyundo dest, Confesscompanyundo orig) {
        User currentUser = this.arsUtil.getCurrentUser();
        dest.setAddress(orig.getAddress());
        dest.setApprovaldate(orig.getApprovaldate());
        dest.setApprovalperson(orig.getApprovalperson());
        dest.setApprovalreason(orig.getApprovalreason());
        dest.setApprovalstate(orig.getApprovalstate());
        dest.setBadate(orig.getBadate());
        dest.setCancelapplyfj(orig.getCancelapplyfj());
        dest.setCanceldate(orig.getCanceldate());
        dest.setCancelreson(orig.getCancelreson());
        dest.setCity(orig.getCity());
        dest.setDistrict(orig.getDistrict());
        dest.setProvince(orig.getProvince());
        dest.setCompanyname(orig.getCompanyname());
        dest.setLegalcard(orig.getLegalcard());
        dest.setLegalzmcl(orig.getLegalzmcl());
        dest.setLegalcardpicf(orig.getLegalcardpicf());
        dest.setLegalcardpicz(orig.getLegalcardpicz());
        dest.setLegalname(orig.getLegalname());
        dest.setLegalphone(orig.getLegalphone());
        dest.setLoginnum(orig.getLoginnum());
        dest.setOrgid(orig.getOrgid());
        dest.setActive(orig.getActive());
        dest.setUpdateBy(currentUser.getUsername());
        dest.setUpdateTime(new Date());
        dest.setUserid(currentUser.getId());
        dest.setSzss(orig.getSzss().replaceAll("/", ""));
        dest.setServicearea(orig.getServicearea());
        dest.setCensorstatus(orig.getCensorstatus());
        return dest;
    }
}

