/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.CerLearnAuthRecordDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.page.CerLearnAuthRecordPageSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.CerLearnAuthRecord;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sb.CerLearnAuthRecordService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CerLearnAuthRecord.class, getMethodName="importBatch", getImportType=ImportType.BATCH)
public class CerLearnAuthRecordServiceImpl
extends BaseService
implements CerLearnAuthRecordService {
    Logger logger = LoggerFactory.getLogger(CerLearnAuthRecordServiceImpl.class);
    @Autowired
    private CerLearnAuthRecordDao cerLearnAuthRecordDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(CerLearnAuthRecord cerLearnAuthRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        cerLearnAuthRecord.setUpdateTime(new Date());
        cerLearnAuthRecord.setUpdateBy(currentUser.getUsername());
        return this.cerLearnAuthRecordDao.delete(cerLearnAuthRecord);
    }

    public int save(CerLearnAuthRecord cerLearnAuthRecord) {
        if (cerLearnAuthRecord.getId() == null) {
            cerLearnAuthRecord.setCreateTime(new Date());
        } else {
            CerLearnAuthRecord dbCerLearnAuthRecord = this.cerLearnAuthRecordDao.findById(cerLearnAuthRecord.getId());
            BeanUtils.copyPropertiesIgnore((Object)cerLearnAuthRecord, (Object)dbCerLearnAuthRecord, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbCerLearnAuthRecord, (Object)cerLearnAuthRecord, (Boolean)false);
        }
        cerLearnAuthRecord.setActive(Boolean.valueOf(true));
        cerLearnAuthRecord.setUpdateTime(new Date());
        cerLearnAuthRecord.setUpdateflag(Boolean.valueOf(true));
        cerLearnAuthRecord.setUpdateBy("apiSystem");
        return this.cerLearnAuthRecordDao.save(cerLearnAuthRecord);
    }

    public CerLearnAuthRecord findById(Long id) {
        return this.cerLearnAuthRecordDao.findById(id);
    }

    public void searchForPage(CerLearnAuthRecordPageSearchDto dto, AjaxPageResponse page) {
        this.cerLearnAuthRecordDao.searchForPage(dto, page);
    }

    public void importBatch(List<CerLearnAuthRecord> list) {
        List dbList = this.cerLearnAuthRecordDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (CerLearnAuthRecord cerLearnAuthRecord : list) {
                cerLearnAuthRecord.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    cerLearnAuthRecord.setUpdateTime(DateUtil.dateAdd((int)6, (Date)cerLearnAuthRecord.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.cerLearnAuthRecordDao.saveBatch(list);
        }
    }

    public List<CerLearnAuthRecord> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.cerLearnAuthRecordDao.searchForDataSynchronization(dto);
    }

    public List<CerLearnAuthRecord> findDSOutList(String startDate) {
        return this.cerLearnAuthRecordDao.findDSOutList(startDate);
    }

    public List<CerLearnAuthRecord> findByBatchId(List<CerLearnAuthRecord> list) {
        return this.cerLearnAuthRecordDao.findByBatchId(list);
    }

    public void updateSelective(CerLearnAuthRecord cerLearnAuthRecord) {
        User currentUser = this.arsUtil.getCurrentUser();
        cerLearnAuthRecord.setUpdateTime(new Date());
        cerLearnAuthRecord.setUpdateBy(currentUser.getUsername());
        this.cerLearnAuthRecordDao.updateSelective(cerLearnAuthRecord);
    }
}

