/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb.impl;

import com.bcxin.ars.dao.sb.BackgroundApprovalDao;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.webservice.BackGroupCensorService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class BackgroundApprovalServiceImpl
implements BackgroundApprovalService {
    @Autowired
    private BackgroundApprovalDao backgroundApprovalDao;
    private static BackGroupCensorService backGroupCensorService;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    public void save(BackgroundApproval backgroundApproval) {
        this.backgroundApprovalDao.save(backgroundApproval);
    }

    public List query(BackgroundApprovalDto backgroundApprovalDto) {
        return this.backgroundApprovalDao.query(backgroundApprovalDto);
    }

    public void approval(Long businessid, String businesstype, String idNumber, String realName) {
        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
        backgroundApprovalDto.setBusinessid(businessid);
        backgroundApprovalDto.setBusinesstype(businesstype);
        backgroundApprovalDto.setIdNumber(idNumber);
        backgroundApprovalDto.setRealName(realName);
        this.approval(backgroundApprovalDto);
    }

    public void approval(BackgroundApprovalDto backgroundApproval) {
        this.getBackGroupCensorService();
        backGroupCensorService.censor(backgroundApproval);
    }

    public void update(BackgroundApprovalDto backgroundApprovalDto) {
        this.backgroundApprovalDao.update(backgroundApprovalDto);
    }

    public String getCensorStatus(Long businessid, String businesstype, String idNumber, String realName) {
        this.getBackGroupCensorService();
        BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
        backgroundApprovalDto.setBusinessid(businessid);
        backgroundApprovalDto.setBusinesstype(businesstype);
        backgroundApprovalDto.setIdNumber(idNumber);
        backgroundApprovalDto.setRealName(realName);
        return backGroupCensorService.getCensorStatus(backgroundApprovalDto);
    }
}

