/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.sb;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.sb.ActivityRepairDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.ActivityRepairApprovalDto;
import com.bcxin.ars.dto.ActivityRepairApprovalSearchDto;
import com.bcxin.ars.dto.ActivityRepairDto;
import com.bcxin.ars.dto.approve.ApproveTempOrgDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.service.sb.ActivityRepairService;
import com.bcxin.ars.service.util.ApprovalUtil;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.redis.RedisUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ActivityRepairServiceImpl
implements ActivityRepairService {
    private Logger logger = LoggerFactory.getLogger(ActivityRepairServiceImpl.class);
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private PctinfoService pctinfoService;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    @Autowired
    private ActivityRepairDao activityRepairDao;
    @Resource
    private TaskService taskService;
    @Resource
    private HistoryService historyService;
    @Autowired
    private ApprovalUtil approvalUtil;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private RuntimeService runtimeService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ApproveTempDao approveTempDao;

    public void resetProcess(Long personcertificateId) {
        Personcertificate personcertificate = this.personcertificateDao.findById(personcertificateId);
        personcertificate.setApprovalstate("002");
        personcertificate.setCardState(null);
        personcertificate.setSignConfirm(null);
        personcertificate.setSumScore(null);
        personcertificate.setWrittenScore(null);
        personcertificate.setTestState(null);
        personcertificate.setPayConfirm(null);
        personcertificate.setOperateScore(null);
        personcertificate.setFingerprint(null);
        personcertificate.setFingercardState(null);
        personcertificate.setFeeState(null);
        personcertificate.setExamState(null);
        personcertificate.setExamAddress(null);
        personcertificate.setExamEnd(null);
        personcertificate.setExamStart(null);
        personcertificate.setExamSubject(null);
        personcertificate.setExamTimes(null);
        this.restartProcess(personcertificate);
    }

    public void restartProcess(Long personcertificateId) {
        Personcertificate personcertificate = this.personcertificateDao.findById(personcertificateId);
        this.restartProcess(personcertificate);
    }

    private void restartProcess(Personcertificate personcertificate) {
        try {
            personcertificate.setUpdateTime(new Date());
            personcertificate.setUpdateflag(Boolean.valueOf(true));
            this.approvalUtil.savePersonApproval("004", personcertificate.getId(), "activitipersoncertificateapprovalProcess");
            Thread.sleep(2000L);
            Approval approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
            if (StringUtil.isNotEmpty((String)personcertificate.getFeeState()) && personcertificate.getFeeState().equals("1") && (StringUtil.isEmpty((String)personcertificate.getTestState()) || !personcertificate.getTestState().equals("1"))) {
                while (!"999".equals(approval.getGroupid())) {
                    this.saveApproval_new(approval);
                    Thread.sleep(2000L);
                    approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                }
            }
            personcertificate.setApprovalstate(approval.getApprovalstate());
            personcertificate.setGroupid(approval.getGroupid());
            this.personcertificateDaoAop.update(personcertificate);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void skipProcess(ActivityRepairDto activityRepairDto) {
        this.activityRepairDao.skipProcess(activityRepairDto);
    }

    public void batchRepulse(Long[] personIds) {
        this.activityRepairDao.batchRepulse(personIds);
    }

    public void batchRepulseAndNotFeeState(Long[] personIds) {
        this.activityRepairDao.batchRepulseAndNotFeeState(personIds);
    }

    private void saveApproval_new(Approval approval) {
        String newGroupid = "";
        String taskDefinitionKey = "";
        String processName = "";
        approval.setApprovalperson("system");
        approval.setApprovaldate(new Date());
        approval.setApprovalreason("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279");
        Task task = null;
        if (StringUtil.isEmpty((String)approval.getProcessInstanceId())) {
            return;
        }
        List list1 = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
        if (list1 != null && list1.size() > 0) {
            for (HistoricActivityInstance hai : list1) {
                this.logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                if (hai.getCalledProcessInstanceId() == null || hai.getEndTime() != null) continue;
                processName = hai.getActivityName();
                task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId())).singleResult();
            }
        }
        if (task == null) {
            task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId())).singleResult();
        }
        HashMap<String, String> variables = new HashMap<String, String>();
        if ("004".equals(approval.getApprovalstate())) {
            variables.put("msg", "\u4e0d\u901a\u8fc7");
            approval.setApprovalreason("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279");
        } else {
            variables.put("msg", "\u901a\u8fc7");
            approval.setApprovalreason("\u7cfb\u7edf\u81ea\u52a8\u5ba1\u6279");
            if (approval.getGroupid().equals("999")) {
                variables.put("testState", "1");
            }
        }
        processName = processName + "--" + task.getName();
        this.logger.info(processName);
        this.taskService.complete(task.getId(), variables);
        Task newTask = null;
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(approval.getProcessInstanceId()).list();
        if (list != null && list.size() > 0) {
            for (HistoricActivityInstance hai : list) {
                this.logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                if (hai.getCalledProcessInstanceId() == null || hai.getEndTime() != null) continue;
                newTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId())).singleResult();
            }
        }
        if (newTask == null) {
            newTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId())).singleResult();
        }
        if (newTask != null && !"004".equals(approval.getApprovalstate())) {
            List newTaskEntitys = this.taskService.getIdentityLinksForTask(newTask.getId());
            if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                IdentityLink identityLink = (IdentityLink)newTaskEntitys.get(0);
                newGroupid = identityLink.getGroupId();
            }
            taskDefinitionKey = newTask.getTaskDefinitionKey();
            if (StringUtil.isNotEmpty((String)newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty((String)newTask.getName()))) {
                approval.setNextPerson(newTask.getName());
                approval.setApprovalstate("005");
            } else {
                approval.setNextPerson("");
            }
        } else {
            approval.setNextPerson("");
        }
        if (!approval.getApprovalstate().equals("004") && StringUtil.isEmpty((String)approval.getNextPerson())) {
            approval.setApprovalstate("003");
        }
        approval.setTaskDefinitionKey(taskDefinitionKey);
        approval.setGroupid(newGroupid);
        approval.setUpdateTime(new Date());
        approval.setUpdateflag(Boolean.valueOf(true));
        approval.setOldRev(Boolean.valueOf(false));
        this.approvalDAO.update(approval);
    }

    public void approvalOldToNew(Approval approval) {
        try {
            if ("004".equals(approval.getBusinesstype())) {
                Personcertificate personcertificate = this.personcertificateDao.findById(approval.getBusinessid());
                if (StringUtil.isEmpty((String)personcertificate.getFeeState()) || personcertificate.getFeeState().equals("0")) {
                    if (StringUtil.isNotEmpty((String)personcertificate.getFingerprint())) {
                        this.approvalUtil.savePersonApproval("004", personcertificate.getId(), "activitipersoncertificateapprovalProcess");
                        Thread.sleep(2000L);
                        approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                        personcertificate.setGroupid(approval.getGroupid());
                        personcertificate.setUpdateflag(Boolean.valueOf(true));
                        personcertificate.setUpdateTime(new Date());
                        this.personcertificateDaoAop.update(personcertificate);
                    }
                } else if (personcertificate.getFeeState().equals("1")) {
                    if (personcertificate.getSumScore() == null || StringUtil.isEmpty((String)personcertificate.getSumScore().toString())) {
                        this.approvalUtil.savePersonApproval("004", personcertificate.getId(), "activitipersoncertificateapprovalProcess");
                        Thread.sleep(2000L);
                        approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                        while (!"999".equals(approval.getGroupid())) {
                            this.saveApproval_new(approval);
                            Thread.sleep(2000L);
                            approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                            personcertificate.setGroupid(approval.getGroupid());
                            personcertificate.setUpdateflag(Boolean.valueOf(true));
                            personcertificate.setUpdateTime(new Date());
                            this.personcertificateDaoAop.update(personcertificate);
                        }
                    } else {
                        this.approvalUtil.savePersonApproval("004", personcertificate.getId(), "activitipersoncertificateapprovalProcess");
                        Thread.sleep(2000L);
                        approval = this.approvalDAO.findBybusinessidAndType(personcertificate.getId(), "004");
                        personcertificate.setGroupid(approval.getGroupid());
                        personcertificate.setUpdateTime(new Date());
                        personcertificate.setUpdateflag(Boolean.valueOf(true));
                        this.personcertificateDaoAop.update(personcertificate);
                    }
                }
            } else {
                this.restartApproval(approval);
                Thread.sleep(2000L);
                for (int seq = this.getApproveSeq(approval); seq > 0; --seq) {
                    this.saveApproval_new(approval);
                    Thread.sleep(2000L);
                }
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
    }

    public void approvalOldToNew(Long approvalId) {
        Approval approval = this.approvalDAO.getById(approvalId);
        this.approvalOldToNew(approval);
    }

    private void restartApproval(Approval approval) {
        Config configVersion = this.configUtils.getConfigByKey("APPROVAL_VERSION_SWITCH");
        if (approval != null && configVersion != null && "1".equals(configVersion.getValue())) {
            this.restartApproval_new(approval);
        } else {
            this.restartApproval_old(approval);
        }
    }

    private void restartApproval_old(Approval approval) {
        String newGroupid = "";
        Config config = this.configUtils.getConfigByKey("police");
        this.logger.info("begin startApply process!!!");
        String processKey = this.approvalUtil.getBusinessTypeForActKey(approval);
        String testState = "";
        Long policeId = 0L;
        if (approval.getPoliceid() != null) {
            policeId = approval.getPoliceid();
        }
        if (StringUtil.isNotEmpty((String)processKey)) {
            HashMap<String, Object> variables = new HashMap<String, Object>();
            variables.put("businessid", approval.getBusinessid());
            variables.put("testState", testState);
            variables.put("policeid", policeId);
            variables.put("areaCode", approval.getAreaCode().substring(0, 4) + "00");
            String processInstanceId = "";
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(processKey + approval.getAreaCode().substring(0, 4) + "00", variables);
            processInstanceId = pi.getProcessInstanceId();
            approval.setProcessInstanceId(processInstanceId);
            approval.setInProcessInstanceId(processInstanceId);
            if (config.getValue().equals("1")) {
                approval.setUpdateflag(Boolean.valueOf(true));
            }
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).singleResult();
            this.taskService.complete(task.getId(), variables);
            Task newTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(approval.getProcessInstanceId())).singleResult();
            if (newTask != null) {
                List newTaskEntitys = this.taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = (IdentityLink)newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
                if (StringUtil.isNotEmpty((String)newGroupid) && (!newGroupid.equals("apply") || StringUtil.isNotEmpty((String)newTask.getName()))) {
                    approval.setNextPerson(newTask.getName());
                } else {
                    approval.setNextPerson("");
                }
            }
            approval.setGroupid(newGroupid);
            this.approvalDAO.update(approval);
        }
    }

    private void restartApproval_new(Approval approval) {
        String processKey = this.approvalUtil.getBusinessTypeForActKey(approval);
        String areaCode = approval.getAreaCode();
        ApproveTemp approveTemp = this.approveTempDao.findByTempCode(processKey + "-" + areaCode);
        if (approveTemp == null) {
            areaCode = areaCode.substring(0, 4) + "00";
            approveTemp = this.approveTempDao.findByTempCode(processKey + "-" + areaCode);
            if (approveTemp == null) {
                approveTemp = this.approveTempDao.findByTempCode(processKey);
            }
        }
        Long policeId = 0L;
        HashMap<String, Object> variables = new HashMap<String, Object>();
        String newGroupid = "";
        String testState = "";
        Long orgId = approval.getOrgid();
        variables.put("businessid", approval.getBusinessid());
        String processInstanceId = "";
        approval.setApprovaldate(null);
        approval.setApprovalreason(null);
        approval.setReplyreason("");
        approval.setReplyRar("");
        approval.setReplystate("");
        approval.setInfoRar("");
        if (approval.getPoliceid() != null) {
            policeId = approval.getPoliceid();
        }
        if (orgId == null) {
            throw new ArsException(approval.getContext() + " \u6ca1\u6709\u9009\u62e9\u529e\u4e8b\u673a\u6784\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
        processKey = approveTemp.getTempCode();
        ApproveTempOrgDto approveTempOrgDto = new ApproveTempOrgDto();
        approveTempOrgDto.setPoliceId(orgId.toString());
        if (processKey != null) {
            approveTempOrgDto.setTempCode(processKey);
        }
        try {
            ProcessInstance pi = this.runtimeService.startProcessInstanceByKey(processKey + "-" + orgId, variables);
            processInstanceId = pi.getProcessInstanceId();
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).singleResult();
            variables.put("areaCode", areaCode);
            variables.put("policeid", policeId);
            variables.put("testState", testState);
            this.taskService.complete(task.getId(), variables);
            Task newTask = null;
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).list();
            if (list != null && list.size() > 0) {
                for (HistoricActivityInstance hai : list) {
                    this.logger.info(hai.getId() + "  " + hai.getActivityName() + "  " + hai.getCalledProcessInstanceId());
                    if (hai.getCalledProcessInstanceId() == null || hai.getEndTime() != null) continue;
                    newTask = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(hai.getCalledProcessInstanceId())).singleResult();
                }
            }
            if (newTask != null) {
                approval.setNextPerson(newTask.getName());
                approval.setProcessInstanceId(processInstanceId);
                approval.setInProcessInstanceId(processInstanceId);
                approval.setOutProcessInstanceId(processInstanceId);
                List newTaskEntitys = this.taskService.getIdentityLinksForTask(newTask.getId());
                if (newTaskEntitys != null && newTaskEntitys.size() > 0) {
                    IdentityLink identityLink = (IdentityLink)newTaskEntitys.get(0);
                    newGroupid = identityLink.getGroupId();
                }
            }
            approval.setGroupid(newGroupid);
            approval.setUpdateBy("system");
            approval.setUpdateTime(new Date());
            approval.setApprovalstate("002");
            approval.setOldRev(Boolean.valueOf(false));
            this.approvalDAO.update(approval);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ArsException("\u672a\u914d\u7f6e\u5ba1\u6279\u6d41\u7a0b\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6279\uff01");
        }
    }

    public synchronized int getApproveSeq(Approval approval) {
        int seq = 0;
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(approval.getInProcessInstanceId())).singleResult();
        if (task != null) {
            Object flowMap;
            String targetId = task.getTaskDefinitionKey();
            String proKey = task.getProcessDefinitionId();
            String value = "";
            try {
                value = this.redisUtil.get("activiti_process:" + proKey);
            }
            catch (RuntimeException ex) {
                this.logger.error("cache\u7f13\u5b58\u83b7\u53d6\u5f02\u5e38[{}]", (Object)"config");
            }
            if (StringUtil.isNotEmpty((String)value)) {
                JSONObject jsonObject = JSONObject.parseObject((String)value);
                flowMap = jsonObject;
            } else {
                FlowElement flowElement;
                this.logger.info("\u4ece\u6570\u636e\u5e93\u4e2d\u91cd\u65b0\u83b7\u53d6\u5ba1\u6279\u6d41\u7a0b[{}]", (Object)targetId);
                BpmnModel bpmnModel = this.repositoryService.getBpmnModel(proKey);
                Process mainProcess = bpmnModel.getMainProcess();
                List startEvents = mainProcess.findFlowElementsOfType(StartEvent.class);
                String startId = "";
                for (Object startEvent : startEvents) {
                    startId = startEvent.getId();
                }
                flowMap = Collections.synchronizedMap(new HashMap());
                List sequenceFlows = mainProcess.findFlowElementsOfType(SequenceFlow.class);
                do {
                    for (SequenceFlow sequenceFlow : sequenceFlows) {
                        if (!startId.equals(sequenceFlow.getSourceRef()) || "${msg=='\u672a\u901a\u8fc7'}".equals(sequenceFlow.getConditionExpression()) || "\u672a\u901a\u8fc7".equals(sequenceFlow.getName()) || "${testState=='1'}".equals(sequenceFlow.getConditionExpression()) || "${replystate=='003' }".equals(sequenceFlow.getConditionExpression()) || "${policeid >0 }".equals(sequenceFlow.getConditionExpression())) continue;
                        startId = sequenceFlow.getTargetRef();
                        break;
                    }
                    flowElement = mainProcess.getFlowElement(startId);
                    this.logger.info(flowElement.getName() + "--" + flowElement.getId());
                    if (!(flowElement instanceof UserTask)) continue;
                    flowMap.put(startId, seq);
                    if ("\u79d1\u957f\u6307\u6d3e\u6c11\u8b66".equals(flowElement.getName())) continue;
                    ++seq;
                } while (!(flowElement instanceof EndEvent));
                if (!flowMap.isEmpty()) {
                    this.redisUtil.set("activiti_process:" + proKey, JSON.toJSONString((Object)flowMap));
                }
            }
            seq = flowMap.get(targetId) != null ? Integer.parseInt(flowMap.get(targetId).toString()) : 0;
        }
        return seq > 0 ? seq - 1 : seq;
    }

    public PageResult searchApprovalList(Map<Object, Object> p) {
        return new PageResult(this.activityRepairDao.searchApprovalListCount(p), (Object)this.activityRepairDao.searchApprovalList(p));
    }

    public List<Personcertificate> checkReturn(Long[] perIds) {
        return this.activityRepairDao.checkReturn(perIds);
    }

    public List<Long> checkCanReturnPerson(Long[] perIds) {
        return this.activityRepairDao.checkCanReturnPerson(perIds);
    }

    public void jumpNextProcess(Long approvalId) throws Exception {
        try {
            Approval approval = this.approvalDAO.getById(approvalId);
            this.saveApproval_new(approval);
            Thread.sleep(2000L);
            this.activityRepairDao.updateApprovalState(approval);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void repulseProcess(Long approvalId) throws Exception {
        try {
            Approval approval = this.approvalDAO.getById(approvalId);
            this.activityRepairDao.repulseProcess(approval);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void reStartProcess(Long approvalId) throws Exception {
        try {
            Approval approval = this.approvalDAO.getById(approvalId);
            approval.setApprovalstate("002");
            this.restartApproval(approval);
            Thread.sleep(2000L);
            this.activityRepairDao.updateApprovalState(approval);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    public void getFinger(Long personId) {
        Personcertificate personcertificate = this.personcertificateDao.findById(personId);
        Pctinfo pctinfo = this.pctinfoService.findByIdnumber(personcertificate.getCardnumber());
        if (pctinfo != null) {
            personcertificate.setFingerprint(pctinfo.getBarcode());
            personcertificate.setFingercardState("1");
            this.personcertificateDaoAop.updateSelective(personcertificate);
        }
    }

    public void search(ActivityRepairApprovalSearchDto dto, AjaxPageResponse<ActivityRepairApprovalDto> ajaxPageResponse) {
        this.activityRepairDao.search(dto, ajaxPageResponse);
    }
}

