/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.SecurityCompanyInsuranceDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.SecurityCompanyInsuranceSearchDto;
import com.bcxin.ars.model.SecurityCompanyInsurance;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.SecurityCompanyInsuranceService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityCompanyInsurance.class)
public class SecurityCompanyInsuranceServiceImpl
implements SecurityCompanyInsuranceService {
    @Autowired
    private SecurityCompanyInsuranceDao securityCompanyInsuranceDao;
    @Autowired
    private SecurityCompanyDao companyDao;
    @Autowired
    private ArsUtil arsUtil;

    public void saveOrUpdate(SecurityCompanyInsurance securityCompanyInsurance) {
        User user = this.arsUtil.getCurrentUser();
        SecurityCompanyInsurance dbSecurityCompanyInsurance = this.securityCompanyInsuranceDao.findById(securityCompanyInsurance.getId());
        if (dbSecurityCompanyInsurance != null) {
            dbSecurityCompanyInsurance.setUpdateTime(new Date());
            dbSecurityCompanyInsurance.setUpdateBy(user.getRealname());
            if (!StringUtils.isEmpty((Object)securityCompanyInsurance.getInsurance_company())) {
                dbSecurityCompanyInsurance.setInsurance_company(securityCompanyInsurance.getInsurance_company());
            }
            if (!StringUtils.isEmpty((Object)securityCompanyInsurance.getInsurance_product())) {
                dbSecurityCompanyInsurance.setInsurance_product(securityCompanyInsurance.getInsurance_product());
            }
            if (!StringUtils.isEmpty((Object)securityCompanyInsurance.getInsured_num())) {
                dbSecurityCompanyInsurance.setInsured_num(securityCompanyInsurance.getInsured_num());
            }
            if (!StringUtils.isEmpty((Object)securityCompanyInsurance.getPremium_person())) {
                dbSecurityCompanyInsurance.setPremium_person(securityCompanyInsurance.getPremium_person());
            }
            if (!StringUtils.isEmpty((Object)securityCompanyInsurance.getProtection_date())) {
                dbSecurityCompanyInsurance.setProtection_date(securityCompanyInsurance.getProtection_date());
            }
            this.securityCompanyInsuranceDao.update(dbSecurityCompanyInsurance);
        } else {
            securityCompanyInsurance.setCreateTime(new Date());
            securityCompanyInsurance.setUpdateTime(securityCompanyInsurance.getCreateTime());
            securityCompanyInsurance.setActive(Boolean.valueOf(true));
            securityCompanyInsurance.setUpdateBy(user.getUsername());
            this.securityCompanyInsuranceDao.save(securityCompanyInsurance);
        }
    }

    public void delete(SecurityCompanyInsurance securityCompanyInsurance) {
        securityCompanyInsurance.setUpdateTime(new Date());
        this.securityCompanyInsuranceDao.delete(securityCompanyInsurance);
    }

    public SecurityCompanyInsurance findById(long id) {
        return this.securityCompanyInsuranceDao.findById(Long.valueOf(id));
    }

    public SecurityCompanyInsuranceSearchDto search(SecurityCompanyInsuranceSearchDto dto) {
        SecurityCompanyInsuranceSearchDto resultDto = new SecurityCompanyInsuranceSearchDto();
        List list = this.securityCompanyInsuranceDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.securityCompanyInsuranceDao.count(dto)));
        return resultDto;
    }

    public List<SecurityCompanyInsurance> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.securityCompanyInsuranceDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(SecurityCompanyInsurance securityCompanyInsurance) {
        SecurityCompanyInsurance dbSecurityCompanyInsurance;
        if (securityCompanyInsurance.getActive() == null) {
            securityCompanyInsurance.setActive(Boolean.valueOf(true));
        }
        if ((dbSecurityCompanyInsurance = this.securityCompanyInsuranceDao.findById(securityCompanyInsurance.getId())) != null) {
            if (securityCompanyInsurance.getUpdateTime().getTime() > dbSecurityCompanyInsurance.getUpdateTime().getTime()) {
                this.securityCompanyInsuranceDao.updateForDS(securityCompanyInsurance);
            }
        } else {
            this.securityCompanyInsuranceDao.saveForDS(securityCompanyInsurance);
        }
    }

    public List<SecurityCompanyInsurance> findByUserId(Long userId) {
        return this.securityCompanyInsuranceDao.findByCompanyId(userId);
    }
}

