/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.OperationDao;
import com.bcxin.ars.dao.PermissionDao;
import com.bcxin.ars.dao.PoliceRoleDao;
import com.bcxin.ars.model.Operation;
import com.bcxin.ars.model.Permission;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.service.PermissionService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionServiceImpl
implements PermissionService {
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private OperationDao operationDao;
    @Autowired
    private PoliceRoleDao policeRoleDao;
    @Autowired
    private ArsUtil arsUtil;

    public List<Permission> findByRole(Long roleid, String roletype, String moduletype) {
        return this.permissionDao.findByRole(roleid, roletype, moduletype);
    }

    public void save(Permission permission) {
        this.permissionDao.save(permission);
    }

    public void saveOrUpdate(Long roleid, Long[] operationIds, String roletype) {
        this.permissionDao.deleteByRole(roleid, roletype);
        for (Long operationId : operationIds) {
            Permission permission = new Permission();
            permission.setNativeCode(this.arsUtil.getCurrentNatvie());
            permission.setRoleid(roleid);
            Operation operation = this.operationDao.findById(operationId);
            permission.setOperation(operation);
            permission.setModule(operation.getModule());
            permission.setRoletype(roletype);
            this.permissionDao.save(permission);
        }
        if (roletype.equals("2")) {
            PoliceRole policeRole = this.policeRoleDao.findById(roleid.longValue());
            policeRole.setOprole("1");
            policeRole.setUpdateTime(new Date());
            this.policeRoleDao.update(policeRole);
        }
    }

    public void delete(Permission permission) {
        this.permissionDao.delete(permission);
    }

    public void deleteByRole(Long roleid, String roletype) {
        this.permissionDao.deleteByRole(roleid, roletype);
    }

    public List<Permission> findByUserId(Long userid) {
        return this.permissionDao.findByUserId(userid);
    }

    public List<Permission> findByGAUserId(Long userid) {
        return this.permissionDao.findByGAUserId(userid);
    }

    public List<Permission> findAllForPlatform(Integer platform) {
        return this.permissionDao.findAllForPlatform(platform);
    }

    public void saveOrUpdateForDS(Permission permission) {
        Permission dbPermission = this.permissionDao.findByOperationIdAndRoleId(permission.getOperationid(), permission.getRoleid());
        if (dbPermission == null) {
            this.permissionDao.save(permission);
        }
    }
}

