/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.OrderPersonDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.OrderPersonSearchDto;
import com.bcxin.ars.model.OrderPerson;
import com.bcxin.ars.service.OrderPersonService;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class OrderPersonServiceImpl
implements OrderPersonService {
    @Autowired
    private OrderPersonDao orderPersonDao;

    public void save(OrderPerson orderPerson) {
        this.orderPersonDao.save(orderPerson);
    }

    public OrderPerson findById(Long id) {
        return this.orderPersonDao.findById(id);
    }

    public List<OrderPerson> findListByOrderId(Long orderId) {
        OrderPersonSearchDto dto = new OrderPersonSearchDto();
        dto.setOrderid(orderId);
        return this.orderPersonDao.findListByOrderId(dto);
    }

    public OrderPersonSearchDto findByOrderid(OrderPersonSearchDto dto) {
        OrderPersonSearchDto resultDto = new OrderPersonSearchDto();
        List list = this.orderPersonDao.findListByOrderId(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.orderPersonDao.countByOrderId(dto)));
        return resultDto;
    }

    public List<OrderPerson> findAll() {
        return this.orderPersonDao.findAll();
    }

    public void updateTrainInfo(OrderPerson orderPerson) {
        orderPerson.setUpdateTime(new Date());
        this.orderPersonDao.updateTrainInfo(orderPerson);
    }

    public List<OrderPerson> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.orderPersonDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(OrderPerson orderPerson) {
        if (orderPerson.getActive() == null) {
            orderPerson.setActive(Boolean.valueOf(true));
        }
        if (!orderPerson.getActive().booleanValue()) {
            this.orderPersonDao.delete(orderPerson);
        } else {
            OrderPerson dbOrderPerson = this.orderPersonDao.findById(orderPerson.getId());
            if (dbOrderPerson == null) {
                this.orderPersonDao.saveForDS(orderPerson);
            } else if (orderPerson.getUpdateTime().getTime() > dbOrderPerson.getUpdateTime().getTime()) {
                this.orderPersonDao.update(orderPerson);
            }
        }
    }
}

