/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.LoginLogDao;
import com.bcxin.ars.dto.LoginLogSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.LoginLogPageSearchDto;
import com.bcxin.ars.model.LoginLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LoginLogServiceImpl
implements LoginLogService {
    private static final Logger logger = LoggerFactory.getLogger(LoginLogServiceImpl.class);
    @Autowired
    private LoginLogDao loginLogDao;
    @Autowired
    private ArsUtil arsUtil;

    public void save(LoginLog loginLog) {
        loginLog.setUpdateTime(new Date());
        this.loginLogDao.save(loginLog);
    }

    public void save(User user, String type) {
        LoginLog loginLog = new LoginLog();
        loginLog.setType(type);
        loginLog.setUsername(user.getUsername());
        loginLog.setUpdateTime(new Date());
        this.loginLogDao.save(loginLog);
    }

    public void logIn(HttpServletRequest request) {
        try {
            String userAgent = request.getHeader("User-Agent");
            User user = this.arsUtil.getCurrentUser();
            if (user == null) {
                throw new Exception("==========> LoginLogService.logIn\uff0c\u5f02\u5e38\uff1a\u7528\u6237\u72b6\u6001\u4e0d\u5b58\u5728\uff01");
            }
            LoginLog loginLog = new LoginLog();
            loginLog.setType("1");
            loginLog.setIpAddress(this.getRemoteAddrIp(request));
            loginLog.setUsername(user.getUsername());
            loginLog.setUpdateTime(new Date());
            loginLog.setUserAgent(userAgent);
            this.loginLogDao.save(loginLog);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void logOut(HttpServletRequest request) {
        try {
            User user = this.arsUtil.getCurrentUser();
            if (user == null) {
                throw new Exception("==========> LoginLogService.logOut\uff0c\u5f02\u5e38\uff1a\u7528\u6237\u72b6\u6001\u4e0d\u5b58\u5728\uff01");
            }
            LoginLog loginLog = new LoginLog();
            loginLog.setType("2");
            loginLog.setIpAddress(this.getRemoteAddrIp(request));
            loginLog.setUsername(user.getUsername());
            loginLog.setUpdateTime(new Date());
            this.loginLogDao.save(loginLog);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public LoginLogSearchDto search(LoginLogSearchDto dto) {
        User user = this.arsUtil.getCurrentUser();
        if (user == null) {
            return null;
        }
        List data = this.loginLogDao.search(dto);
        Long count = this.loginLogDao.searchCount(dto);
        dto.setData(data);
        dto.setTotalCount(count);
        return dto;
    }

    public void searchForPage(LoginLogPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.loginLogDao.searchForPage(dto, page);
    }

    public String getRemoteAddrIp(HttpServletRequest request) {
        String ipFromNginx = this.getHeader(request, "X-Real-IP");
        System.out.println("ipFromNginx:" + ipFromNginx);
        System.out.println("getRemoteAddr:" + request.getRemoteAddr());
        return StringUtil.isEmpty((String)ipFromNginx) ? request.getRemoteAddr() : ipFromNginx;
    }

    private String getHeader(HttpServletRequest request, String headName) {
        String value = request.getHeader(headName);
        return !StringUtil.isBlank((CharSequence)value) && !"unknown".equalsIgnoreCase(value) ? value : "";
    }
}

