/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.FilerecordDao;
import com.bcxin.ars.dao.datasync.FileRecordDetailDao;
import com.bcxin.ars.dto.page.FilerecordPageSearchDto;
import com.bcxin.ars.dto.sb.FilerecordSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Filerecord;
import com.bcxin.ars.service.FilerecordService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.EmailUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class FilerecordServiceImpl
implements FilerecordService {
    Logger logger = LoggerFactory.getLogger(FilerecordServiceImpl.class);
    @Autowired
    private FilerecordDao filerecordDao;
    @Autowired
    private FileRecordDetailDao fileRecordDetailDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private EmailUtil emailUtil;

    public void saveOrUpdate(Filerecord filerecord) {
        this.filerecordDao.save(filerecord);
    }

    public Filerecord findById(long id) {
        return this.filerecordDao.findById(Long.valueOf(id));
    }

    public Filerecord findByFilepath(String filepath) {
        return this.filerecordDao.findByFilepath(filepath);
    }

    public void save(Filerecord filerecord) {
        this.filerecordDao.save(filerecord);
    }

    public List<Filerecord> findFilerecordByTime(String startDate, String endDate) {
        return this.filerecordDao.findFilerecordByTime(startDate);
    }

    public List<Filerecord> findByBatchId(List<Filerecord> filerecordList) {
        return this.filerecordDao.findByBatchId(filerecordList);
    }

    public void importBatchFilerecord(List<Filerecord> filerecordList) {
        List<Filerecord> dbExistIDList = this.findByBatchId(filerecordList);
        filerecordList.removeAll(dbExistIDList);
        if (filerecordList.size() > 0) {
            filerecordList.forEach(detail -> {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (detail.getErrorDetailList() != null && detail.getErrorDetailList().size() > 0) {
                        this.fileRecordDetailDao.saveBatch(detail.getErrorDetailList());
                        detail.getErrorDetailList().forEach(errorDetail -> this.sendFailEmail(errorDetail.getData(), errorDetail.getError(), detail.getFilepath()));
                    }
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
            this.filerecordDao.saveBatch(filerecordList);
        }
    }

    public FilerecordSearchDto search(FilerecordSearchDto dto) {
        FilerecordSearchDto resultDto = new FilerecordSearchDto();
        List list = this.filerecordDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(this.filerecordDao.count(dto));
        return resultDto;
    }

    public List<Filerecord> findDSOutList(String startDate) {
        List list = this.filerecordDao.findFilerecordByTime(startDate);
        if (this.configUtils.isIntranet()) {
            list.forEach(record -> record.setErrorDetailList(this.fileRecordDetailDao.findByRecordId(record.getId())));
        }
        this.filerecordDao.updateFlagBatch(list);
        return list;
    }

    public void delete(Long id) {
        this.filerecordDao.delete(id);
    }

    private void sendFailEmail(String data, String errorMsg, String fileName) {
        Config receiveUserConfig = this.configUtils.getConfigByKey("DATASYNC_RECEIVEUSER");
        Config currentNativeName = this.configUtils.getConfigByKey("current_native_name");
        if (receiveUserConfig != null && currentNativeName != null) {
            new Thread(() -> {
                String sendHtml = "{currentNativeName}\u73af\u5883\u5916\u5230\u5185\u540c\u6b65\u5f02\u5e38\uff0c\u6765\u6e90\uff1a{url}<br>\u540c\u6b65\u6587\u4ef6\u5168\u8def\u5f84\u540d\uff1a<br>{fileName}<br>\u540c\u6b65\u6570\u636e\u4e3a\uff1a<br><p style='color: green'>{data}</p><br>\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a<br><p style='color: red'>{errorMsg}</p>".replace("{fileName}", fileName).replace("{data}", data).replace("{errorMsg}", errorMsg).replace("{currentNativeName}", currentNativeName.getValue()).replace("url", this.configUtils.getWebHost());
                String receiveUser = receiveUserConfig.getValue();
                this.emailUtil.sendEmail("\u767e\u4fdd\u76fe\u6570\u636e\u540c\u6b65\u5f02\u5e38\u63d0\u9192", sendHtml, receiveUser);
            }).start();
        }
    }

    public void searchForPage(FilerecordPageSearchDto dto, AjaxPageResponse page) {
        this.filerecordDao.searchForPage(dto, page);
    }
}

