/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.CyFirearmsLogDao;
import com.bcxin.ars.dao.sb.FirearmsDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.sb.CyFirearmsLogSearchDto;
import com.bcxin.ars.model.CyFirearmsLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.service.CyFirearmsLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncAnnotation(getClazz=CyFirearmsLog.class)
public class CyFirearmsLogServiceImpl
implements CyFirearmsLogService {
    @Autowired
    private CyFirearmsLogDao cyFirearmsLogDao;
    @Autowired
    private FirearmsDao firearmsDao;
    @Autowired
    private ArsUtil arsUtil;

    public void saveOrUpdate(CyFirearmsLog cyFirearmsLog) {
        User user = this.arsUtil.getCurrentUser();
        CyFirearmsLog dbCyFirearmsLog = this.cyFirearmsLogDao.findById(cyFirearmsLog.getId());
        if (dbCyFirearmsLog != null) {
            dbCyFirearmsLog.setUpdateTime(new Date());
            dbCyFirearmsLog.setUpdateBy(user.getRealname());
            this.cyFirearmsLogDao.update(dbCyFirearmsLog);
        } else {
            cyFirearmsLog.setUserid(user.getId());
            cyFirearmsLog.setCreateTime(new Date());
            cyFirearmsLog.setUpdateTime(cyFirearmsLog.getCreateTime());
            cyFirearmsLog.setActive(Boolean.valueOf(true));
            cyFirearmsLog.setUpdateBy(user.getUsername());
            this.cyFirearmsLogDao.save(cyFirearmsLog);
        }
        Firearms firearms = this.firearmsDao.findById(new Long(cyFirearmsLog.getFirearmsid()).longValue());
        firearms.setFirearmsstate(cyFirearmsLog.getType());
        if ("1".equals(cyFirearmsLog.getType())) {
            firearms.setUsename(cyFirearmsLog.getName());
            firearms.setUsedate(cyFirearmsLog.getTime());
            firearms.setUseexplain(cyFirearmsLog.getRemarks());
        } else {
            firearms.setUsename("");
            firearms.setUsedate(null);
            firearms.setUseexplain("");
        }
        firearms.setUpdateTime(new Date());
        this.firearmsDao.update(firearms);
    }

    public CyFirearmsLog findById(long id) {
        return this.cyFirearmsLogDao.findById(Long.valueOf(id));
    }

    public CyFirearmsLogSearchDto search(CyFirearmsLogSearchDto dto) {
        CyFirearmsLogSearchDto resultDto = new CyFirearmsLogSearchDto();
        List list = this.cyFirearmsLogDao.search(dto);
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(this.cyFirearmsLogDao.count(dto)));
        return resultDto;
    }

    public List<CyFirearmsLog> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.cyFirearmsLogDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(CyFirearmsLog cyFirearmsLog) {
        if (cyFirearmsLog.getActive() == null) {
            cyFirearmsLog.setActive(Boolean.valueOf(true));
        }
        if (!cyFirearmsLog.getActive().booleanValue()) {
            this.cyFirearmsLogDao.delete(cyFirearmsLog);
        } else {
            CyFirearmsLog dbCyFirearmsLogLog = this.cyFirearmsLogDao.findById(cyFirearmsLog.getId());
            if (dbCyFirearmsLogLog == null) {
                this.cyFirearmsLogDao.saveForDS(cyFirearmsLog);
            } else if (cyFirearmsLog.getUpdateTime().getTime() > dbCyFirearmsLogLog.getUpdateTime().getTime()) {
                this.cyFirearmsLogDao.update(cyFirearmsLog);
            }
        }
    }

    public void searchForPage(CyFirearmsLogSearchDto searchDto, AjaxPageResponse<CyFirearmsLog> page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        this.cyFirearmsLogDao.searchForPage(searchDto, page);
    }
}

