/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.impl;

import com.bcxin.ars.dao.ComStateChangeLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.ComStateChangeLogPageSearchDto;
import com.bcxin.ars.model.ComStateChangeLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.ComStateChangeLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ComStateChangeLogServiceImpl
implements ComStateChangeLogService {
    Logger logger = LoggerFactory.getLogger(ComStateChangeLogServiceImpl.class);
    @Autowired
    private ComStateChangeLogDao comStateChangeLogDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int delete(ComStateChangeLog comStateChangeLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        comStateChangeLog.setUpdateTime(new Date());
        comStateChangeLog.setUpdateBy(currentUser.getUsername());
        return this.comStateChangeLogDao.delete(comStateChangeLog);
    }

    public int save(ComStateChangeLog comStateChangeLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (comStateChangeLog.getId() == null) {
            comStateChangeLog.setCreateTime(new Date());
        } else {
            ComStateChangeLog dbComStateChangeLog = this.comStateChangeLogDao.findById(comStateChangeLog.getId());
            BeanUtils.copyPropertiesIgnore((Object)comStateChangeLog, (Object)dbComStateChangeLog, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbComStateChangeLog, (Object)comStateChangeLog, (Boolean)false);
        }
        comStateChangeLog.setActive(Boolean.valueOf(true));
        comStateChangeLog.setUpdateBy(currentUser.getUsername());
        comStateChangeLog.setUpdateTime(new Date());
        comStateChangeLog.setUpdateflag(Boolean.valueOf(true));
        comStateChangeLog.setUserId(currentUser.getId());
        comStateChangeLog.setAreaCode(currentUser.getPolice().getAreacode());
        return this.comStateChangeLogDao.save(comStateChangeLog);
    }

    public ComStateChangeLog findById(Long id) {
        return this.comStateChangeLogDao.findById(id);
    }

    public void searchForPage(ComStateChangeLogPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.comStateChangeLogDao.searchForPage(dto, page);
    }

    public void importBatch(List<ComStateChangeLog> list) {
        List dbList = this.comStateChangeLogDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComStateChangeLog comStateChangeLog : list) {
                comStateChangeLog.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comStateChangeLog.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comStateChangeLog.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comStateChangeLogDao.saveBatch(list);
        }
    }

    public List<ComStateChangeLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comStateChangeLogDao.searchForDataSynchronization(dto);
    }

    public List<ComStateChangeLog> findDSOutList(String startDate) {
        return this.comStateChangeLogDao.findDSOutList(startDate);
    }

    public List<ComStateChangeLog> findByBatchId(List<ComStateChangeLog> list) {
        return this.comStateChangeLogDao.findByBatchId(list);
    }

    public void updateSelective(ComStateChangeLog comStateChangeLog) {
        User currentUser = this.arsUtil.getCurrentUser();
        comStateChangeLog.setUpdateTime(new Date());
        comStateChangeLog.setUpdateBy(currentUser.getUsername());
        this.comStateChangeLogDao.updateSelective(comStateChangeLog);
    }
}

