/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.gx;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.gx.InternetPlusBusinessDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.model.gx.InternetPlusBusiness;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.gx.InterfaceNoticeService;
import com.bcxin.ars.util.gx.HttpClientUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InterfaceNoticeServiceImpl
implements InterfaceNoticeService {
    private static String url = "http://71.4.152.20/gzmhgxhlwService/gzmh/ars-rest/callback";
    private static final Logger logger = LoggerFactory.getLogger(InterfaceNoticeServiceImpl.class);
    @Autowired
    ApprovalDAO approvalDAO;
    @Autowired
    PoliceDao policeDao;
    @Autowired
    InternetPlusBusinessDao internetPlusBusinessDao;

    public void approvalNotice(Approval approval) {
        try {
            InternetPlusBusiness internetPlusBusiness = this.internetPlusBusinessDao.findByBusinessId(approval.getBusinessid());
            if (internetPlusBusiness == null) {
                return;
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("sdono", (Object)internetPlusBusiness.getSdono());
            if (approval != null) {
                if (approval.getApprovalstate().equals("003")) {
                    jsonObject.put("status", (Object)"0");
                } else if (approval.getApprovalstate().equals("004")) {
                    jsonObject.put("status", (Object)"1");
                }
                jsonObject.put("msg", (Object)approval.getApprovalreason());
                JSONObject sdata = JSON.parseObject((String)internetPlusBusiness.getSData());
                jsonObject.put("sjly", sdata.get((Object)"dataSource"));
                jsonObject.put("name", (Object)approval.getApprovalperson());
                jsonObject.put("userno", (Object)approval.getUpdateBy());
                ArrayList<JSONObject> imageList = new ArrayList<JSONObject>();
                JSONObject fileName = new JSONObject();
                fileName.put("fileName", (Object)"");
                imageList.add(fileName);
            }
            logger.info("\u5ba1\u6279\u901a\u77e5\u8bf7\u6c42\u53c2\u6570\uff1a" + jsonObject);
            String result = HttpClientUtil.doPost((String)url, (JSONObject)jsonObject, (String)"UTF-8");
            logger.info("\u5ba1\u6279\u901a\u77e5\u54cd\u5e94\u53c2\u6570\uff1a" + result);
        }
        catch (Exception e) {
            logger.error("\u5ba1\u6279\u901a\u77e5httpclient error:" + e.getMessage());
        }
    }
}

