/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.conference.impl;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.UserDto;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.conference.CloudConferenceRoom;
import com.bcxin.ars.dto.conference.CloudConferenceRoomDevice;
import com.bcxin.ars.dto.conference.CloudConferenceRoomDto;
import com.bcxin.ars.dto.conference.CloudConferenceRoomMember;
import com.bcxin.ars.dto.conference.CloudConferenceRoomSearchDto;
import com.bcxin.ars.service.conference.CloudConferenceRoomService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.http.HttpRequest;
import com.xiaoleilu.hutool.http.HttpResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import com.xiaoleilu.hutool.http.Method;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class CloudConferenceRoomServiceImpl
implements CloudConferenceRoomService {
    private static final Logger log = LoggerFactory.getLogger(CloudConferenceRoomServiceImpl.class);
    @Resource
    private UserDao userDao;
    @Resource
    private ConfigUtils configUtils;
    @Resource
    private ArsUtil arsUtil;

    public AjaxPageResponse<CloudConferenceRoomSearchDto> listCloudConferenceRoom(CloudConferenceRoomSearchDto cloudConferenceRoomSearchDto) {
        AjaxPageResponse ajaxPageResponse = new AjaxPageResponse();
        String accessToken = this.arsUtil.getHuaweiMeetAccessToken(this.configUtils.getValueByKey("HeiweiconferenceAccount"), this.configUtils.getValueByKey("HeiweiconferencePassword"), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
        String url = "https://api.meeting.huaweicloud.com/v1/usg/dcs/corp/vmr";
        HashMap params = Maps.newHashMapWithExpectedSize((int)10);
        params.put("offset", cloudConferenceRoomSearchDto.getPageNum());
        params.put("limit", cloudConferenceRoomSearchDto.getNumPerPage());
        params.put("searchKey", cloudConferenceRoomSearchDto.getSearchKey());
        params.put("status", cloudConferenceRoomSearchDto.getStatus());
        HttpResponse response = ((HttpRequest)HttpUtil.createGet((String)url).form((Map)params).header("Authorization", "Basic " + authorization)).execute();
        String responseBody = response.body();
        JSONObject responseJson = JSONUtil.parseObj((String)responseBody);
        if (response.getStatus() != 200) {
            String errorCode = responseJson.getStr((Object)"error_code");
            String errorMsg = responseJson.getStr((Object)"error_msg");
            log.error("\u8bf7\u6c42\u83b7\u53d6\u534e\u4e3a\u4e91\u4f1a\u8bae\u5ba4\u63a5\u53e3\u9519\u8bef,error_code:{},error_msg:{}", (Object)errorCode, (Object)errorMsg);
            ajaxPageResponse.setCode(errorCode);
            ajaxPageResponse.setMessage("\u8bf7\u6c42\u534e\u4e3a\u4e91\u4f1a\u8bae\u63a5\u53e3\u9519\u8bef" + errorMsg);
            return ajaxPageResponse;
        }
        List data = (List)responseJson.get((Object)"data", List.class);
        ArrayList cloudConferenceRooms = Lists.newArrayList();
        for (Object item : data) {
            CloudConferenceRoomMember member;
            CloudConferenceRoom roomInstance = (CloudConferenceRoom)JSONUtil.toBean((JSONObject)((JSONObject)item), CloudConferenceRoom.class);
            CloudConferenceRoomDto roomDto = new CloudConferenceRoomDto();
            BeanUtils.copyProperties((Object)roomInstance, (Object)roomDto);
            CloudConferenceRoomDevice device = roomInstance.getDevice();
            if (device != null) {
                roomDto.setDeviceId(roomInstance.getDevice().getId());
                roomDto.setDeviceMark(roomInstance.getDevice().getMark());
            }
            if ((member = roomInstance.getMember()) != null) {
                roomDto.setMemberId(roomInstance.getMember().getId());
                roomDto.setMemberMark(roomInstance.getMember().getMark());
            }
            cloudConferenceRooms.add(roomDto);
        }
        log.info("\u534e\u4e3a\u4e91\u4f1a\u8bae\u8fd4\u56de\u4e91\u4f1a\u8bae\u5ba4\u5217\u8868:{}", (Object)data);
        ajaxPageResponse.setData((List)cloudConferenceRooms);
        ajaxPageResponse.setTotal((long)responseJson.getInt((Object)"count").intValue());
        ajaxPageResponse.setPageNumber(responseJson.getInt((Object)"offset").intValue());
        ajaxPageResponse.setPageSize(responseJson.getInt((Object)"limit").intValue());
        return ajaxPageResponse;
    }

    public AjaxResult recycleVmr(String[] ids, String memberId) {
        AjaxResult ajaxResult = new AjaxResult();
        ajaxResult.setSuccessful(true);
        if (ids == null || memberId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode("500");
            ajaxResult.setMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxResult;
        }
        String accessToken = this.arsUtil.getHuaweiMeetAccessToken(this.configUtils.getValueByKey("HeiweiconferenceAccount"), this.configUtils.getValueByKey("HeiweiconferencePassword"), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
        String url = "https://api.meeting.huaweicloud.com" + "/v1/usg/dcs/corp/vmr/recycle-from-member/{account}".replace("{account}", memberId);
        HttpResponse response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("Authorization", "Basic " + authorization)).body(JSONUtil.toJsonStr((Object)ids)).execute();
        String body = response.body();
        if (response.getStatus() != 200) {
            JSONObject jsonObject = JSONUtil.parseObj((String)body);
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode(jsonObject.getStr((Object)"error_code"));
            ajaxResult.setMsg(jsonObject.getStr((Object)"error_msg"));
            return ajaxResult;
        }
        ajaxResult.setMsg("\u56de\u6536\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult assignVmr(String[] ids, String memberId) {
        AjaxResult ajaxResult = new AjaxResult();
        ajaxResult.setSuccessful(true);
        if (ids == null || memberId == null) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode("500");
            ajaxResult.setMsg("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return ajaxResult;
        }
        String accessToken = this.arsUtil.getHuaweiMeetAccessToken(this.configUtils.getValueByKey("HeiweiconferenceAccount"), this.configUtils.getValueByKey("HeiweiconferencePassword"), Constants.HeiweiconferenceUserId);
        String authorization = Base64.getEncoder().encodeToString(accessToken.getBytes());
        String url = "https://api.meeting.huaweicloud.com" + "/v1/usg/dcs/corp/vmr/assign-to-member/{account}".replace("{account}", memberId);
        HttpResponse response = ((HttpRequest)HttpUtil.createRequest((Method)Method.POST, (String)url).header("Authorization", "Basic " + authorization)).body(JSONUtil.toJsonStr((Object)ids)).execute();
        String body = response.body();
        if (response.getStatus() != 200) {
            JSONObject jsonObject = JSONUtil.parseObj((String)body);
            ajaxResult.setSuccessful(false);
            ajaxResult.setCode(jsonObject.getStr((Object)"error_code"));
            ajaxResult.setMsg(jsonObject.getStr((Object)"error_msg"));
            return ajaxResult;
        }
        ajaxResult.setMsg("\u5206\u914d\u6210\u529f");
        return ajaxResult;
    }

    public AjaxPageResponse<UserDto> getAssignList(UserSearchDto userSearchDto, AjaxPageResponse<UserDto> userDtoAjaxPageResponse) {
        List users = this.userDao.searchForAssign(userSearchDto, userDtoAjaxPageResponse);
        return userDtoAjaxPageResponse;
    }
}

