/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.bcxin.ars.dao.certificate.TrainCertificateSnapshotDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.TrainCertificateSnapshot;
import com.bcxin.ars.service.certificate.TrainCertificateSnapshotService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class TrainCertificateSnapshotServiceImpl
implements TrainCertificateSnapshotService {
    Logger logger = LoggerFactory.getLogger(TrainCertificateSnapshotServiceImpl.class);
    @Autowired
    private TrainCertificateSnapshotDao trainCertificateSnapshotDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int save(TrainCertificateSnapshot trainCertificateSnapshot) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (trainCertificateSnapshot.getId() == null) {
            trainCertificateSnapshot.setCreateTime(new Date());
        } else {
            TrainCertificateSnapshot dbQrcodeInfo = this.trainCertificateSnapshotDao.findByQrCodeId(trainCertificateSnapshot.getQrCodeId());
            BeanUtils.copyPropertiesIgnore((Object)trainCertificateSnapshot, (Object)dbQrcodeInfo, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbQrcodeInfo, (Object)trainCertificateSnapshot, (Boolean)false);
        }
        trainCertificateSnapshot.setActive(Boolean.valueOf(true));
        trainCertificateSnapshot.setUpdateBy(currentUser.getUsername());
        trainCertificateSnapshot.setUpdateTime(new Date());
        trainCertificateSnapshot.setUpdateflag(Boolean.valueOf(true));
        trainCertificateSnapshot.setAreaCode(currentUser.getPolice().getAreacode());
        return this.trainCertificateSnapshotDao.save(trainCertificateSnapshot);
    }

    public TrainCertificateSnapshot findByQrCodeId(Long qrCodeId) {
        return this.trainCertificateSnapshotDao.findByQrCodeId(qrCodeId);
    }

    public void importBatch(List<TrainCertificateSnapshot> list) {
        List dbList = this.trainCertificateSnapshotDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (TrainCertificateSnapshot trainCertificateSnapshot : list) {
                trainCertificateSnapshot.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    trainCertificateSnapshot.setUpdateTime(DateUtil.dateAdd((int)6, (Date)trainCertificateSnapshot.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.trainCertificateSnapshotDao.saveBatch(list);
        }
    }

    public List<TrainCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.trainCertificateSnapshotDao.searchForDataSynchronization(dto);
    }

    public List<TrainCertificateSnapshot> findDSOutList(String startDate) {
        return this.trainCertificateSnapshotDao.findDSOutList(startDate);
    }

    public List<TrainCertificateSnapshot> findByBatchId(List<TrainCertificateSnapshot> list) {
        return this.trainCertificateSnapshotDao.findByBatchId(list);
    }
}

