/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.enums.SyncType;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.OrgnoDao;
import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dao.PersonImgDao;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.dao.certificate.CertificatePrintLogDao;
import com.bcxin.ars.dao.certificate.PerCerSnapshotDao;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.BatchImportTxtDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.PersonInfoDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.certificate.SecurityCerDto;
import com.bcxin.ars.dto.certificate.SecurityCertificateSearchDto;
import com.bcxin.ars.dto.page.SecurityCertificateDto;
import com.bcxin.ars.dto.page.SecurityCertificatePageSearchDto;
import com.bcxin.ars.dto.v5.SecurityCertificateV5Dto;
import com.bcxin.ars.dto.v5.V5ResultDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.Orgno;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.CertificatePrintLog;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.service.util.PhotoUtil;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import com.bcxin.ars.service.util.SysDictUtils;
import com.bcxin.ars.util.Base64Img;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DES3;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.GetPersonImgUtil;
import com.bcxin.ars.util.IdNumUtil;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.QRCodeUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=SecurityCertificate.class, getSeq=20000, getDataSyncType=SyncType.SYNC)
@DataSyncOutAnnotation(getClazz=SecurityCertificate.class, getSeq=20000, getDataSyncType=SyncType.SYNC)
public class SecurityCertificateServiceImpl
extends BaseService
implements SecurityCertificateService {
    public static final Logger logger = LoggerFactory.getLogger(SecurityCertificateServiceImpl.class);
    @Autowired
    private SecurityCertificateDao securityCertificateDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private CertificatePrintLogDao certificatePrintLogDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    @Autowired
    private GetPersonImgUtil getPersonImgUtil;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Autowired
    private SecurityPersonDao securityPersonDao;
    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;
    @Autowired
    private PersonImgDao personImgDao;
    @Autowired
    private PersonBaseInfoDao personBaseInfoDao;
    @Autowired
    private PerCerSnapshotDao perCerSnapshotDao;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private SysDictUtils sysDictUtils;
    @Autowired
    private PersonBaseInfoService personBaseInfoService;
    @Autowired
    private PhotoUtil photoUtil;
    @Autowired
    private SysareaService sysareaService;
    @Autowired
    private OrgnoDao orgnodao;
    @Value(value="${temp-folder}")
    private String tempFolder;
    @Value(value="${BBD_H5_URL}")
    private String bbdH5Url;

    public SecurityCertificate findById(Long id) {
        return this.securityCertificateDao.findById(id);
    }

    public void saveOrUpdate(SecurityCertificate securityCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (securityCertificate.getId() == null) {
            SecurityCertificate dbPersonCertificate = this.securityCertificateDao.findBySecuritypersonid(securityCertificate.getSecuritypersonid().longValue());
            if (dbPersonCertificate != null) {
                BeanUtils.copyPropertiesIgnore((Object)securityCertificate, (Object)dbPersonCertificate, (Boolean)true);
                dbPersonCertificate.setUpdateBy(currentUser.getUsername());
                dbPersonCertificate.setUpdateTime(new Date());
                this.securityCertificateDao.update(dbPersonCertificate);
            } else {
                securityCertificate.setActive(Boolean.valueOf(true));
                securityCertificate.setCreateTime(new Date());
                securityCertificate.setUpdateTime(new Date());
                securityCertificate.setUpdateBy(currentUser.getUsername());
                securityCertificate.setIsprint(false);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
                Date date = new Date();
                String native_short = this.configUtils.getValueByKey("current_native_short");
                String year = "";
                if (StringUtil.isNotEmpty((String)native_short)) {
                    year = native_short + securityCertificate.getFzjgbh().substring(0, 2) + simpleDateFormat.format(date);
                }
                SecurityCertificateSearchDto searchdto = new SecurityCertificateSearchDto();
                searchdto.setZsbh(year);
                String maxZsbh_year = this.securityCertificateDao.searchMaxZsbhCount(searchdto);
                maxZsbh_year = StringUtils.isEmpty((Object)maxZsbh_year) ? year + "000001" : maxZsbh_year.substring(0, 3) + String.valueOf(Long.valueOf(maxZsbh_year.substring(3)) + 1L);
                securityCertificate.setZsbh(maxZsbh_year);
                securityCertificate.setId(Long.valueOf(this.idWorker.nextId()));
                String photo = this.getPhotoUrl(securityCertificate);
                this.savePerCerSnapshot(securityCertificate, photo);
                this.securityCertificateDao.save(securityCertificate);
            }
            ApprovalDTO policeapp = new ApprovalDTO();
            policeapp.setBusinessid(securityCertificate.getSecuritypersonid());
            policeapp.setBusinesstype("004");
            policeapp.setOrgid(Long.valueOf(567L));
            List list = this.approvalDAO.getBusinessidAndType(policeapp);
            if (list != null && list.size() > 0) {
                Approval temp = (Approval)list.get(0);
                temp.setApprovalstate("003");
                temp.setUpdateTime(new Date());
                this.approvalDAO.update(temp);
            }
            Personcertificate personcertificate = this.personcertificateDao.findById(securityCertificate.getSecuritypersonid());
            personcertificate.setCardState("2");
            personcertificate.setApplyforstate("003");
            this.personcertificateDaoAop.update(personcertificate);
            SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(dbPersonCertificate.getIdnum());
            if (null != securityPerson) {
                securityPerson.setZgcredential(dbPersonCertificate.getZsbh());
                securityPerson.setZgcertificatejgno(dbPersonCertificate.getFzjgbh());
                securityPerson.setZgcertificatejgname(dbPersonCertificate.getFzjgmc());
                securityPerson.setZgcertificatejgtime(dbPersonCertificate.getFzrq() == null ? "" : DateUtil.convertDateToString((Date)dbPersonCertificate.getFzrq(), (String)"yyyy-MM-dd"));
                securityPerson.setZgtraincompanyname(personcertificate.getCompanyname());
                securityPerson.setUpdateTime(new Date());
                this.securityPersonDaoAop.update(securityPerson);
            }
        } else {
            SecurityCertificate dbPersonCertificate = this.securityCertificateDao.findById(securityCertificate.getId());
            dbPersonCertificate.setUpdateBy(currentUser.getUsername());
            dbPersonCertificate.setUpdateTime(new Date());
            dbPersonCertificate.setAddress(securityCertificate.getAddress());
            dbPersonCertificate.setCsrq(securityCertificate.getCsrq());
            dbPersonCertificate.setFzrq(securityCertificate.getFzrq());
            dbPersonCertificate.setIdnum(securityCertificate.getIdnum());
            dbPersonCertificate.setXm(securityCertificate.getXm());
            dbPersonCertificate.setZsbh(securityCertificate.getZsbh());
            dbPersonCertificate.setZzrq(securityCertificate.getZzrq());
            dbPersonCertificate.setZzzt(securityCertificate.getZzzt());
            dbPersonCertificate.setFzjgbh(securityCertificate.getFzjgbh());
            dbPersonCertificate.setFzjgmc(securityCertificate.getFzjgmc());
            this.securityCertificateDao.update(dbPersonCertificate);
            SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(securityCertificate.getIdnum());
            if (null != securityPerson) {
                securityPerson.setZgcredential(securityCertificate.getZsbh());
                securityPerson.setZgcertificatejgno(securityCertificate.getFzjgbh());
                securityPerson.setZgcertificatejgname(securityCertificate.getFzjgmc());
                securityPerson.setZgcertificatejgtime(securityCertificate.getFzrq() == null ? "" : DateUtil.convertDateToString((Date)securityCertificate.getFzrq(), (String)"yyyy-MM-dd"));
                securityPerson.setUpdateTime(new Date());
                this.securityPersonDaoAop.update(securityPerson);
            }
        }
    }

    public SecurityCertificateSearchDto search(SecurityCertificateSearchDto dto) {
        SecurityCertificateSearchDto resultDto = new SecurityCertificateSearchDto();
        String v5Url = this.configUtils.getValueByKey("V5_TENANT_URL");
        if (StringUtils.isEmpty((Object)v5Url)) {
            v5Url = "https://v5qy.baibaodun.cn/";
        }
        HttpResponse response = HttpUtil.createPost((String)(v5Url + "v3/public/qualification-credentials")).contentType("application/json").body(String.format("{'idnum':'%s','areaCode':'%s'}", dto.getKeyword(), this.configUtils.getValueByKey("current_native"))).execute();
        V5ResultDto v5resultDto = (V5ResultDto)JSON.parseObject((String)response.body(), V5ResultDto.class);
        ArrayList<SecurityCertificate> list = new ArrayList<SecurityCertificate>();
        if (v5resultDto.isSuccess() && v5resultDto.getData() != null) {
            List v5List = JSON.parseArray((String)JSON.toJSONString((Object)v5resultDto.getData()), SecurityCertificateV5Dto.class);
            for (SecurityCertificateV5Dto securityCertificateV5Dto : v5List) {
                SecurityCertificate securityCertificate = new SecurityCertificate();
                securityCertificate.setFzjgmc(securityCertificateV5Dto.getOrgName());
                securityCertificate.setFzrq(securityCertificateV5Dto.getCerDate());
                securityCertificate.setXm(securityCertificateV5Dto.getXm());
                securityCertificate.setIdnum(securityCertificateV5Dto.getIdnum());
                securityCertificate.setZsbh(securityCertificateV5Dto.getZsbh());
                securityCertificate.setHeadImg(securityCertificateV5Dto.getHeadImg());
                list.add(securityCertificate);
            }
        }
        resultDto.setData(list);
        resultDto.setTotalCount(Long.valueOf(list.size()));
        return resultDto;
    }

    public void delete(SecurityCertificate securityCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        securityCertificate.setUpdateBy(currentUser.getUsername());
        securityCertificate.setUpdateTime(new Date());
        this.securityCertificateDao.delete(securityCertificate);
    }

    public SecurityCertificate findBySecuritypersonid(long securitypersonid, String type) {
        SecurityCertificate result = this.securityCertificateDao.findBySecuritypersonid(securitypersonid);
        Config config = this.configUtils.getConfigByKey("current_province");
        Config H5UrlConfig = this.configDao.findByKey("H5URL" + config.getValue());
        Personcertificate personcertificate = this.personcertificateDao.findById(result.getSecuritypersonid());
        String data = "";
        String pathName = "";
        this.setPhotoData(result);
        try {
            data = DES3.encode((String)JSON.toJSONString((Object)result.getSecuritypersonid(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
            result.setNation(this.sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty((String)personcertificate.getNation()) ? "01" : personcertificate.getNation()));
            if ("1".equals(type)) {
                result.setAddress(personcertificate.getPopulationAddress());
            } else {
                result.setAddress(personcertificate.getAddress());
            }
            if (null != config && null != H5UrlConfig) {
                pathName = QRCodeUtil.generateQRCode((String)(this.bbdH5Url + "certificate?certificateId=" + URLEncoder.encode(data, "UTF-8") + H5UrlConfig.getValue()), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                result.setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    public String getQRCode(String snapshotId) throws Exception {
        System.out.println(this.getElectronCerUrl(snapshotId));
        return QRCodeUtil.generateBase64QRCode((String)this.getElectronCerUrl(snapshotId), (int)100, (int)100, (String)"jpg");
    }

    public String getQRCodeForThirdParty(String snapshotId) throws Exception {
        return QRCodeUtil.generateBase64QRCodeForThirdParty((String)this.getElectronCerUrl(snapshotId), (int)100, (int)100, (String)"jpg");
    }

    public String getElectronCerUrl(String snapshotId) throws Exception {
        String cerUrl = this.configUtils.getValueByKey("PERCERURL" + this.configUtils.getCurrentProvince());
        snapshotId = URLEncoder.encode(snapshotId, "UTF-8");
        return cerUrl + "/securityCertificate/viewCer.do?snapshotId=" + snapshotId;
    }

    public SecurityCertificate previewById(Long id, String type) {
        SecurityCertificate securityCertificate;
        securityCertificate.setNation(this.sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty((String)(securityCertificate = this.securityCertificateDao.findById(id)).getNation()) ? "01" : securityCertificate.getNation()));
        if ("1".equals(type)) {
            securityCertificate.setAddress(securityCertificate.getPopulationAddress());
        }
        String photo = this.setPhotoData(securityCertificate);
        Long snapshotId = this.savePerCerSnapshot(securityCertificate, photo);
        try {
            Base64Utils.encodeToString((byte[])snapshotId.toString().getBytes("UTF-8"));
            securityCertificate.setQrcode(this.getQRCode(DES3.encode((String)snapshotId.toString())));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        securityCertificate.setSnapshotId(snapshotId);
        return securityCertificate;
    }

    public Long savePerCerSnapshot(SecurityCertificate securityCertificate, String photo) {
        User currentUser = this.arsUtil.getCurrentUser();
        PerCerSnapshot perCerSnapshot = new PerCerSnapshot();
        perCerSnapshot.setPersonId(securityCertificate.getPersonId());
        perCerSnapshot.setCerId(securityCertificate.getId());
        perCerSnapshot.setName(securityCertificate.getXm());
        perCerSnapshot.setBirthDate(securityCertificate.getCsrq());
        perCerSnapshot.setPhone(securityCertificate.getPhone());
        perCerSnapshot.setIdNum(securityCertificate.getIdnum());
        perCerSnapshot.setComName(securityCertificate.getCompanyName());
        perCerSnapshot.setPhoto(photo);
        perCerSnapshot.setAddress(securityCertificate.getAddress());
        perCerSnapshot.setCerNo(securityCertificate.getZsbh());
        perCerSnapshot.setIssueDate(DateUtil.convertDateToString((Date)securityCertificate.getFzrq(), (String)"yyyy-MM-dd"));
        perCerSnapshot.setOrgName(securityCertificate.getFzjgmc());
        perCerSnapshot.setUpdateflag(Boolean.valueOf(true));
        perCerSnapshot.setId(Long.valueOf(this.idWorker.nextId()));
        perCerSnapshot.setActive(Boolean.valueOf(true));
        perCerSnapshot.setCreateTime(new Date());
        perCerSnapshot.setUpdateTime(new Date());
        if (currentUser != null) {
            perCerSnapshot.setUpdateBy(currentUser.getUsername());
            perCerSnapshot.setUserid(currentUser.getId());
        } else {
            perCerSnapshot.setUpdateBy("system");
        }
        this.perCerSnapshotDao.save(perCerSnapshot);
        securityCertificate.setSnapshotId(perCerSnapshot.getId());
        return perCerSnapshot.getId();
    }

    public List<SecurityCertificate> previewByIdArr(SecurityCertificateSearchDto dto) {
        HashMap<Long, String> typeMap = new HashMap<Long, String>();
        for (int i = 0; i < dto.getIdArray().length; ++i) {
            typeMap.put(dto.getIdArray()[i], dto.getTypes()[i]);
        }
        List securityCertificateList = this.securityCertificateDao.findByIdArr(dto.getIdArray());
        Iterator iterator = securityCertificateList.iterator();
        while (iterator.hasNext()) {
            SecurityCertificate securityCertificate;
            securityCertificate.setNation(this.sysDictUtils.getDictTypeValue("nation", StringUtil.isEmpty((String)(securityCertificate = (SecurityCertificate)iterator.next()).getNation()) ? "01" : securityCertificate.getNation()));
            if ("1".equals(typeMap.get(securityCertificate.getId()))) {
                securityCertificate.setAddress(securityCertificate.getPopulationAddress());
            } else {
                securityCertificate.setAddress(securityCertificate.getAddress());
            }
            String photo = this.setPhotoData(securityCertificate);
            Long snapshotId = this.savePerCerSnapshot(securityCertificate, photo);
            try {
                Base64Utils.encodeToString((byte[])snapshotId.toString().getBytes("UTF-8"));
                securityCertificate.setQrcode(this.getQRCode(DES3.encode((String)snapshotId.toString())));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            securityCertificate.setSnapshotId(snapshotId);
        }
        return securityCertificateList;
    }

    public Boolean checkCerStatus(String idNum) {
        SecurityCertificate certificate = this.securityCertificateDao.findByIdnum(idNum);
        if (certificate != null) {
            return true;
        }
        return false;
    }

    public AjaxResult checkStatusForApply(String idNum) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        Boolean flag = false;
        SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(idNum);
        if (securityPerson == null) {
            result.setMsg("\u8be5\u5b66\u5458\u4e0d\u5b58\u5728\u5165\u804c\u8bb0\u5f55\uff01");
        } else if ("1".equals(securityPerson.getIdentityAuthState())) {
            flag = true;
        } else {
            result.setMsg("\u8be5\u5b66\u5458\u672a\u5b9e\u540d\u8ba4\u8bc1\u901a\u8fc7\uff01");
        }
        if (flag.booleanValue()) {
            SecurityCompany company = securityPerson.getRelation().getCompany();
            if (company != null && StringUtil.isNotEmpty((String)company.getAreaCode()) && ("6106".equals(company.getAreaCode().substring(0, 4)) || "6110".equals(company.getAreaCode().substring(0, 4)))) {
                SecurityCertificate certificate = this.securityCertificateDao.findByIdnum(idNum);
                if (certificate != null && certificate.getFzrq() != null && certificate.getFzrq().getTime() > DateUtil.convertStringToDate((String)"2020-11-16").getTime()) {
                    flag = false;
                    result.setMsg("\u8be5\u5b66\u5458\u5df2\u6301\u6709\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01");
                } else {
                    Personcertificate personcertificate = this.personcertificateDao.findApprovalingByIdNumForYanAn(idNum);
                    if (personcertificate != null) {
                        flag = false;
                        result.setMsg("\u8be5\u5b66\u5458\u5df2\u62a5\u540d\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01");
                    }
                }
            } else if (Constants.ZGZBT_SWITCH_1.equals(this.configUtils.getValueByKey(Constants.ZGZBT_SWITCH))) {
                Personcertificate personcertificate;
                SecurityCertificate certificate = this.securityCertificateDao.findByIdnum(idNum);
                if (certificate != null) {
                    flag = false;
                    result.setMsg("\u8be5\u5b66\u5458\u5df2\u6301\u6709\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01");
                }
                if (flag.booleanValue() && (personcertificate = this.personcertificateDao.findApprovalingByIdNum(idNum)) != null) {
                    flag = false;
                    result.setMsg("\u8be5\u5b66\u5458\u5df2\u62a5\u540d\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01");
                }
            } else {
                Personcertificate personcertificate = this.personcertificateDao.findApprovaling(securityPerson.getId());
                if (personcertificate != null) {
                    flag = false;
                    result.setMsg("\u8be5\u5b66\u5458\u5df2\u62a5\u540d\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01");
                }
            }
        }
        result.setData((Object)flag);
        return result;
    }

    public void updateSnapshotId(SecurityCertificate securityCertificate) {
        this.securityCertificateDao.updateSnapshotId(securityCertificate);
    }

    public void updateBatchSnapshotId(List<SecurityCertificate> list) {
        this.securityCertificateDao.updateBatchSnapshotId(list);
    }

    public List<String> updateIsDraw(List<String> idNums) {
        List existIdNum = this.securityCertificateDao.selectIdNums(idNums);
        if (existIdNum.size() > 0) {
            this.securityCertificateDao.updateIsDraw(existIdNum);
        }
        if (existIdNum.size() < idNums.size()) {
            idNums.removeAll(existIdNum);
            return idNums;
        }
        return null;
    }

    public List<SecurityCertificate> findAddressByIdArr(Long[] idArr) {
        return this.securityCertificateDao.findByIdArr(idArr);
    }

    public void reCer(Long cerId) {
        SecurityCertificate securityCertificate = this.securityCertificateDao.findById(cerId);
        securityCertificate.setActive(Boolean.valueOf(true));
        securityCertificate.setUpdateTime(new Date());
        securityCertificate.setIsprint(false);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy");
        Date date = new Date();
        String current_native_short = this.configUtils.getValueByKey("current_native_short");
        String year = "";
        if (StringUtil.isNotEmpty((String)current_native_short) && StringUtil.isNotEmpty((String)securityCertificate.getAreaCode())) {
            Orgno orgno = this.orgnodao.findByAreaCode(securityCertificate.getAreaCode().substring(0, 4));
            if (orgno != null && StringUtil.isNotEmpty((String)orgno.getOrgName())) {
                securityCertificate.setFzjgmc(orgno.getOrgName());
            }
            if (orgno != null && StringUtil.isNotEmpty((String)orgno.getOrgnum())) {
                year = current_native_short + orgno.getOrgnum().substring(2, 4) + simpleDateFormat.format(date);
                securityCertificate.setFzjgbh(orgno.getOrgnum());
            }
        }
        if (StringUtil.isEmpty((String)year)) {
            return;
        }
        SecurityCertificateSearchDto searchdto = new SecurityCertificateSearchDto();
        searchdto.setZsbh(year);
        String maxZsbh_year = this.securityCertificateDao.searchMaxZsbhCount(searchdto);
        maxZsbh_year = StringUtils.isEmpty((Object)maxZsbh_year) ? year + "000001" : maxZsbh_year.substring(0, 7) + StringUtil.addZeroForNum((String)String.valueOf(Long.valueOf(maxZsbh_year.substring(7)) + 1L), (int)6);
        securityCertificate.setZsbh(maxZsbh_year);
        securityCertificate.setUpdateflag(Boolean.valueOf(true));
        this.securityCertificateDao.update(securityCertificate);
        this.perCerSnapshotDao.updateByCer(securityCertificate);
        if (securityCertificate.getPersonId() != null) {
            this.updateSecurityPersonCertificateInfo(securityCertificate);
        }
    }

    public SecurityCertificate findBySecuritypersonid(long securitypersonid) {
        return this.findBySecuritypersonid(securitypersonid, "1");
    }

    public List<SecurityCertificate> findBySecuritypersonidArr(SecurityCertificateSearchDto dto) {
        Config config = this.configDao.findByKey("current_province");
        List securityCertificateList = this.securityCertificateDao.findBySecuritypersonidArr(dto);
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
        for (int i = 0; i < securityCertificateList.size(); ++i) {
            if (null == securityCertificateList.get(i)) continue;
            ((SecurityCertificate)securityCertificateList.get(i)).setPhoto(this.getPersonImgUtil.getPersonImg(((SecurityCertificate)securityCertificateList.get(i)).getIdnum()));
            try {
                if (null == ((SecurityCertificate)securityCertificateList.get(i)).getSecuritypersonid()) continue;
                String data = DES3.encode((String)JSON.toJSONString((Object)((SecurityCertificate)securityCertificateList.get(i)).getSecuritypersonid(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                String pathName = "";
                if (null == config) continue;
                Config H5UrlConfig = this.configDao.findByKey("H5URL" + config.getValue());
                if (null != H5UrlConfig) {
                    pathName = QRCodeUtil.generateQRCode((String)(this.bbdH5Url + "certificate?certificateId=" + URLEncoder.encode(data, "utf-8") + H5UrlConfig.getValue()), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                }
                ((SecurityCertificate)securityCertificateList.get(i)).setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return securityCertificateList;
    }

    public void updatePrintedByLog(Long securitypersonid, String printType) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCertificate securityCertificate = this.securityCertificateDao.findBySecuritypersonid(securitypersonid.longValue());
        if (securityCertificate.getPrintcount() == null || securityCertificate.getPrintcount().equals("")) {
            securityCertificate.setPrintcount("1");
        } else {
            int printcount = Integer.parseInt(securityCertificate.getPrintcount()) + 1;
            securityCertificate.setPrintcount(printcount + "");
        }
        this.setSecurityCertificate(securityCertificate, currentUser.getUsername());
        this.securityCertificateDao.updatePrinteStateForBj(securityCertificate);
        CertificatePrintLog log = this.setCertificatePrintLog(currentUser.getUsername(), securityCertificate.getXm(), securityCertificate.getIdnum(), securityCertificate.getZsbh(), currentUser.getRealname(), currentUser.getId());
        log.setPrintType(printType);
        this.certificatePrintLogDao.save(log);
    }

    public void updatePrintedByidArr(Long[] idArray) {
        User user = this.arsUtil.getCurrentUser();
        SecurityCertificateSearchDto dto = new SecurityCertificateSearchDto();
        dto.setIdArray(idArray);
        dto.setPrintsort(null);
        dto.setPrintorder(null);
        List securityCertificateList = this.securityCertificateDao.findBySecuritypersonidArr(dto);
        for (SecurityCertificate securityCertificate : securityCertificateList) {
            CertificatePrintLog log = this.setCertificatePrintLog(user.getUsername(), securityCertificate.getXm(), securityCertificate.getIdnum(), securityCertificate.getZsbh(), user.getRealname(), user.getId());
            if (securityCertificate.getPrintcount() == null || securityCertificate.getPrintcount().equals("")) {
                securityCertificate.setPrintcount("1");
                log.setPrintType("1");
            } else {
                int printcount = Integer.parseInt(securityCertificate.getPrintcount()) + 1;
                securityCertificate.setPrintcount(printcount + "");
                log.setPrintType("2");
            }
            this.setSecurityCertificate(securityCertificate, user.getUsername());
            securityCertificate.setUpdateflag(Boolean.valueOf(true));
            this.securityCertificateDao.updatePrinteCount(securityCertificate);
            this.certificatePrintLogDao.save(log);
        }
    }

    public void updatePrinted(Long[] idArray, Long[] snapshotIdArr, String printType) {
        User user = this.arsUtil.getCurrentUser();
        SecurityCertificateSearchDto dto = new SecurityCertificateSearchDto();
        dto.setIdArray(idArray);
        dto.setPrintsort(null);
        dto.setPrintorder(null);
        List securityCertificateList = this.securityCertificateDao.findBySecuritypersonidArr(dto);
        HashMap<Long, Long> logMap = new HashMap<Long, Long>();
        for (int i = 0; i < idArray.length; ++i) {
            logMap.put(idArray[i], snapshotIdArr[i]);
        }
        for (SecurityCertificate securityCertificate : securityCertificateList) {
            CertificatePrintLog log = this.setCertificatePrintLog(user.getUsername(), securityCertificate.getXm(), securityCertificate.getIdnum(), securityCertificate.getZsbh(), user.getRealname(), user.getId());
            if (securityCertificate.getPrintcount() == null || securityCertificate.getPrintcount().equals("")) {
                securityCertificate.setPrintcount("1");
                log.setPrintType("1");
            } else {
                int printcount = Integer.parseInt(securityCertificate.getPrintcount()) + 1;
                securityCertificate.setPrintcount(printcount + "");
                log.setPrintType("2");
            }
            if (StringUtil.isNotEmpty((String)printType)) {
                log.setPrintType(printType);
            }
            this.setSecurityCertificate(securityCertificate, user.getUsername());
            securityCertificate.setUpdateflag(Boolean.valueOf(true));
            securityCertificate.setSnapshotId((Long)logMap.get(securityCertificate.getSecuritypersonid()));
            this.securityCertificateDao.updatePrinteCount(securityCertificate);
            this.certificatePrintLogDao.save(log);
        }
    }

    public SecurityCertificate setSecurityCertificate(SecurityCertificate securityCertificate, String userName) {
        securityCertificate.setPrintTime(new Date());
        securityCertificate.setUpdateTime(new Date());
        securityCertificate.setUpdateBy(userName);
        securityCertificate.setIsprint(true);
        return securityCertificate;
    }

    public CertificatePrintLog setCertificatePrintLog(String userName, String scXm, String idNum, String scZsbh, String realName, Long userId) {
        CertificatePrintLog log = new CertificatePrintLog();
        log.setActive(Boolean.valueOf(true));
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        log.setActive(Boolean.valueOf(true));
        log.setCreateTime(new Date());
        log.setUpdateTime(new Date());
        log.setUpdateBy(userName);
        log.setName(scXm);
        log.setIdnum(idNum);
        log.setSecurityCertificateNo(scZsbh);
        log.setPrintName(realName);
        log.setTrainOrgId(userId);
        return log;
    }

    public void updatePrinteCount(SecurityCertificate securityCertificate) {
        this.securityCertificateDao.updatePrinteCount(securityCertificate);
    }

    public List<SecurityCertificate> findDetail(SecurityCertificateSearchDto dto) {
        return this.securityCertificateDao.findDetail(dto);
    }

    public List<SecurityCertificate> searchUpdateflagForExport() {
        return this.securityCertificateDao.searchUpdateflagForExport(DateUtil.getYesterday());
    }

    @Deprecated
    public void outerSaveOrUpdateForDS(SecurityCertificate cert) {
        logger.info("saveOrupdate... " + cert);
        try {
            if (cert.getId() == null) {
                throw new ArsException("id\u7f3a\u5931");
            }
            Boolean isEdit = false;
            SecurityCertificate dbCert = this.securityCertificateDao.findById(cert.getId());
            if (dbCert == null) {
                cert.setUpdateflag(Boolean.valueOf(false));
                this.securityCertificateDao.save(cert);
            } else if (cert.getUpdateTime().getTime() > dbCert.getUpdateTime().getTime()) {
                cert.setUpdateflag(Boolean.valueOf(false));
                this.securityCertificateDao.update(cert);
            }
            if (isEdit.booleanValue()) {
                this.updateSecurityPersonCertificateInfo(cert);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void importBatch(List<SecurityCertificate> list) {
        List dbList = this.securityCertificateDao.findByBatchId(list);
        list.removeAll(dbList);
        final Vector<SecurityCertificate> errorList = new Vector<SecurityCertificate>();
        if (list.size() > 0) {
            for (SecurityCertificate detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    errorList.add(detail);
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if ("11".equals(this.configUtils.getCurrentNative())) {
                this.securityCertificateDao.saveBatchForImportOutBj(list);
            } else {
                this.securityCertificateDao.saveBatch(list);
            }
            new Thread(() -> {
                final CountDownLatch workCount = ThreadUtil.newCountDownLatch((int)list.size());
                ThreadPoolExecutor threadPoolExecutor = ThreadUtil.newExecutor((int)15, (int)15);
                for (final SecurityCertificate detail : list) {
                    threadPoolExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SecurityCertificateServiceImpl.this.updateSecurityPersonCertificateInfo(detail);
                            }
                            catch (Exception e) {
                                errorList.add(detail);
                                logger.error(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                workCount.countDown();
                            }
                        }
                    });
                }
                try {
                    workCount.await();
                }
                catch (InterruptedException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
                finally {
                    threadPoolExecutor.shutdown();
                }
            }).start();
        }
    }

    public AjaxResult updateSecurityPersonCertificateInfo(SecurityCertificate detail) {
        SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(detail.getIdnum());
        if (null != securityPerson) {
            securityPerson.setZgcredential(detail.getZsbh());
            securityPerson.setZgcertificatejgno(detail.getFzjgbh());
            securityPerson.setZgcertificatejgname(detail.getFzjgmc());
            securityPerson.setZgcertificatejgtime(detail.getFzrq() == null ? "" : DateUtil.convertDateToString((Date)detail.getFzrq(), (String)"yyyy-MM-dd"));
            securityPerson.setUpdateTime(new Date());
            this.securityPersonDaoAop.update(securityPerson);
            if (!this.configUtils.isIntranet()) {
                detail.setPersonId(securityPerson.getId());
                return this.pushPersonCertificateToSAAS(detail);
            }
        }
        return null;
    }

    public AjaxResult pushPersonCertificateToSAAS(SecurityCertificate SecurityCertificate2) {
        PersonInfoDto personDto = new PersonInfoDto();
        if (StringUtil.isNotEmpty((String)SecurityCertificate2.getTrainName())) {
            personDto.setTrainOrganName(SecurityCertificate2.getTrainName());
        }
        personDto.setIsOldData(StringUtil.isEmpty((String)SecurityCertificate2.getIsOldData()) ? "0" : SecurityCertificate2.getIsOldData());
        personDto.setPerId(SecurityCertificate2.getPersonId());
        personDto.setCerNo(SecurityCertificate2.getZsbh());
        personDto.setLicenceOrgNo(SecurityCertificate2.getFzjgbh());
        personDto.setLicenceOrg(SecurityCertificate2.getFzjgmc());
        personDto.setLicenceDate(SecurityCertificate2.getFzrq() == null ? "" : DateUtil.convertDateToString((Date)SecurityCertificate2.getFzrq(), (String)"yyyy-MM-dd"));
        try {
            if (SecurityCertificate2.getSnapshotId() == null) {
                Config H5UrlConfig;
                String data = DES3.encode((String)JSON.toJSONString((Object)SecurityCertificate2.getSecuritypersonid(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                Config config = this.configUtils.getConfigByKey("current_province");
                if (null != config && null != (H5UrlConfig = this.configUtils.getConfigByKey("H5URL" + config.getValue()))) {
                    personDto.setElectronCerUrl(this.bbdH5Url.replace("/#/", "/$$/") + "certificate?certificateId=" + URLEncoder.encode(data, "utf-8") + H5UrlConfig.getValue());
                }
            } else {
                personDto.setElectronCerUrl(this.getElectronCerUrl(DES3.encode((String)SecurityCertificate2.getSnapshotId().toString())));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        AjaxResult result = this.saasInterfaceUtil.callInterface("/thirdPlat/bbd-callBack/complete-bayzgz-approve", personDto);
        if (!result.isSuccessful()) {
            logger.error(SecurityCertificate2.getXm() + result.getMsg());
        }
        return result;
    }

    public void edit(SecurityCertificate securityCertificate) {
        User currentUser = this.arsUtil.getCurrentUser();
        SecurityCertificate dbSecurityCertificate = this.securityCertificateDao.findById(securityCertificate.getId());
        BeanUtils.copyPropertiesIgnore((Object)securityCertificate, (Object)dbSecurityCertificate, (Boolean)true);
        BeanUtils.copyPropertiesIgnore((Object)dbSecurityCertificate, (Object)securityCertificate, (Boolean)false);
        securityCertificate.setCsrq(IdNumUtil.getBirthdayByIdCard((String)securityCertificate.getIdnum()));
        securityCertificate.setUpdateflag(Boolean.valueOf(true));
        securityCertificate.setUpdateTime(new Date());
        securityCertificate.setUpdateBy(currentUser.getUsername());
        this.securityCertificateDao.update(securityCertificate);
        Personcertificate personcertificate = this.personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if (personcertificate != null) {
            boolean personEdit = false;
            if (StringUtil.isNotEmpty((String)securityCertificate.getPopulationAddress()) && !securityCertificate.getPopulationAddress().equals(personcertificate.getPopulationAddress())) {
                personcertificate.setPopulationAddress(securityCertificate.getPopulationAddress());
                personEdit = true;
            }
            if (StringUtil.isNotEmpty((String)securityCertificate.getNation()) && !securityCertificate.getNation().equals(personcertificate.getNation())) {
                personcertificate.setNation(securityCertificate.getNation());
                personEdit = true;
            }
            if (StringUtil.isNotEmpty((String)securityCertificate.getXm()) && !securityCertificate.getXm().equals(personcertificate.getName())) {
                personcertificate.setName(securityCertificate.getXm());
                personEdit = true;
            }
            if (StringUtil.isNotEmpty((String)securityCertificate.getIdnum()) && !securityCertificate.getIdnum().equals(personcertificate.getCardnumber())) {
                personcertificate.setCardnumber(securityCertificate.getIdnum());
                personEdit = true;
            }
            if (personEdit) {
                personcertificate.setUpdateflag(Boolean.valueOf(true));
                personcertificate.setUpdateTime(new Date());
                personcertificate.setUpdateBy(currentUser.getUsername());
                this.personcertificateDaoAop.update(personcertificate);
            }
        }
    }

    public void searchForPage(SecurityCertificatePageSearchDto dto, AjaxPageResponse<SecurityCertificateDto> page) {
        dto.setPoliceBusiness(false);
        User user = this.arsUtil.getCurrentUser();
        Police police = user.getPolice();
        dto.setUserAreaCode(Boolean.valueOf(false));
        if (!"11".equals(this.configUtils.getCurrentNative())) {
            if (user.getAreasList() != null && user.getAreasList().size() > 0) {
                dto.setAreasList(user.getAreasList());
                dto.setUserAreaCode(Boolean.valueOf(true));
            }
            if (StringUtil.isNotEmpty((String)dto.getAreaCode())) {
                dto.setUserAreaCode(Boolean.valueOf(true));
            } else {
                dto.setAreaCode(police.getAreacode());
            }
        }
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        if (StringUtil.isNotEmpty((String)dto.getOldData()) && Constants.PRINT_TYPE_OLD_YES.equals(dto.getOldData()) && "640000".equals(this.configUtils.getCurrentProvince())) {
            dto.setAreaCode(null);
        }
        if ("4".equals(police.getOrgtype())) {
            dto.setOrgId(police.getId());
        }
        this.securityCertificateDao.searchForPage(dto, page);
    }

    public SecurityCertificate getDetail(Long id) {
        return this.securityCertificateDao.getDetail(id);
    }

    public void relationOldCert(SecurityPerson person) {
        SecurityCertificate securityCertificate = this.securityCertificateDao.findByIdnum(person.getIdNumber());
        if (securityCertificate != null && "1".equals(securityCertificate.getIsOldData())) {
            securityCertificate.setUpdateflag(Boolean.valueOf(true));
            securityCertificate.setUpdateTime(new Date());
            this.securityCertificateDao.update(securityCertificate);
            Personcertificate personcertificate = this.personcertificateDao.findById(securityCertificate.getSecuritypersonid());
            personcertificate.setUpdateflag(Boolean.valueOf(true));
            personcertificate.setUpdateTime(new Date());
            personcertificate.setPersonid(person.getId());
            this.personcertificateDaoAop.update(personcertificate);
        }
    }

    public List<SecurityCertificate> findBySecuritypersonidArrBatch(SecurityCertificateSearchDto dto) {
        List securityCertificateList = this.securityCertificateDao.findBySecuritypersonidArr(dto);
        return securityCertificateList;
    }

    public void saveOrUpdateForDS(SecurityCertificate cert) {
        SecurityCertificate dbCert = this.securityCertificateDao.findById(cert.getId());
        if (dbCert != null) {
            if ("11".equals(this.configUtils.getCurrentNative())) {
                this.securityCertificateDao.updateForBJDS(cert);
            } else {
                this.securityCertificateDao.updateFlagForDS(cert.getId());
            }
        } else {
            this.securityCertificateDao.save(cert);
        }
    }

    public List<SecurityCertificate> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.securityCertificateDao.searchForDataSynchronization(dto);
    }

    public String setPhotoData(SecurityCertificate securityCertificate) {
        String photo;
        block15: {
            photo = null;
            Personcertificate personcertificate = this.personcertificateDao.findById(securityCertificate.getSecuritypersonid());
            if ("11".equals(this.configUtils.getCurrentNative())) {
                try {
                    PersonBaseInfo personBaseInfo;
                    SecurityPerson person = this.securityPersonDao.findById(personcertificate.getPersonid());
                    if (person == null) {
                        person = this.securityPersonDao.findByIdCard(securityCertificate.getIdnum());
                    }
                    if ((personBaseInfo = this.personBaseInfoDao.findByIdNum(personcertificate.getCardnumber())) != null && StringUtil.isNotEmpty((String)personBaseInfo.getImgPath())) {
                        photo = personBaseInfo.getImgPath();
                        securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(personBaseInfo.getImgPath())));
                        break block15;
                    }
                    if (personcertificate.getImglogo() != null && personcertificate.getImglogo().indexOf("getResource") >= 0) {
                        photo = personcertificate.getImglogo();
                        securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(personcertificate.getImglogo())));
                        break block15;
                    }
                    if (person != null && StringUtil.isNotEmpty((String)person.getIdPhoto())) {
                        photo = person.getIdPhoto();
                        securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(person.getIdPhoto())));
                        break block15;
                    }
                    if (person == null) break block15;
                    if (person.getPhoto().indexOf("getResource") >= 0) {
                        photo = person.getPhoto();
                        securityCertificate.setPhoto("data:image/jpg;base64," + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(person.getPhoto())));
                        break block15;
                    }
                    securityCertificate.setPhoto("data:image/jpg;base64," + this.getPersonImgUtil.getPersonImg(securityCertificate.getIdnum()));
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                try {
                    String basePhoto = "data:image/{type};base64,";
                    if (StringUtil.isEmpty((String)securityCertificate.getHeadImg())) {
                        PersonBaseInfo personBaseInfo = this.personBaseInfoDao.findByIdNum(securityCertificate.getIdnum());
                        if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getImgPath())) {
                            photo = personBaseInfo.getImgPath();
                            basePhoto = basePhoto.replace("{type}", photo.substring(photo.lastIndexOf(".") + 1)).toLowerCase();
                            securityCertificate.setPhoto(basePhoto + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(personBaseInfo.getImgPath())));
                        } else {
                            securityCertificate.setPhoto("data:image/jpg;base64," + this.getPersonImgUtil.getPersonImg(securityCertificate.getIdnum()));
                        }
                    } else {
                        photo = securityCertificate.getHeadImg();
                        basePhoto = basePhoto.replace("{type}", photo.substring(photo.lastIndexOf(".") + 1)).toLowerCase();
                        securityCertificate.setPhoto(basePhoto + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(securityCertificate.getHeadImg())));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return photo;
    }

    public static void main(String[] args) {
        HttpResponse response = HttpUtil.createPost((String)"https://v5qy.baibaodun.cn/v3/public/qualification-credentials").contentType("application/json").body(String.format("{'idnum':'%s','areaCode':'%s'}", "610104196712050615", "61")).execute();
        ArrayList<SecurityCertificateDto> lists = new ArrayList<SecurityCertificateDto>();
        V5ResultDto resultDto = (V5ResultDto)JSON.parseObject((String)response.body(), V5ResultDto.class);
        if (resultDto.isSuccess() && resultDto.getData() != null) {
            List v5List = JSON.parseArray((String)JSON.toJSONString((Object)resultDto.getData()), SecurityCertificateV5Dto.class);
            for (SecurityCertificateV5Dto securityCertificateV5Dto : v5List) {
                SecurityCertificateDto securityCertificateDto = new SecurityCertificateDto();
                securityCertificateDto.setFzjgmc(securityCertificateV5Dto.getOrgName());
                securityCertificateDto.setFzrq(DateUtil.convertDateToString((Date)securityCertificateV5Dto.getCerDate(), (String)"yyyy-MM-dd"));
                securityCertificateDto.setFromV5(true);
                lists.add(securityCertificateDto);
            }
        }
        System.out.println(JSON.toJSONString(lists));
    }

    public String getPhotoUrl(SecurityCertificate securityCertificate) {
        String photo = null;
        Personcertificate personcertificate = this.personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if ("11".equals(this.configUtils.getCurrentNative())) {
            try {
                PersonBaseInfo personBaseInfo;
                SecurityPerson person = this.securityPersonDao.findById(personcertificate.getPersonid());
                if (person == null) {
                    person = this.securityPersonDao.findByIdCard(securityCertificate.getIdnum());
                }
                if ((personBaseInfo = this.personBaseInfoDao.findByIdNum(personcertificate.getCardnumber())) != null && StringUtil.isNotEmpty((String)personBaseInfo.getImgPath())) {
                    photo = personBaseInfo.getImgPath();
                } else if (personcertificate.getImglogo() != null && personcertificate.getImglogo().indexOf("getResource") >= 0) {
                    photo = personcertificate.getImglogo();
                } else if (person != null && StringUtil.isNotEmpty((String)person.getIdPhoto())) {
                    photo = person.getIdPhoto();
                } else if (person != null && person.getPhoto().indexOf("getResource") >= 0) {
                    photo = person.getPhoto();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            try {
                if (StringUtil.isEmpty((String)securityCertificate.getHeadImg())) {
                    PersonBaseInfo personBaseInfo = this.personBaseInfoDao.findByIdNum(securityCertificate.getIdnum());
                    if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getImgPath())) {
                        photo = personBaseInfo.getImgPath();
                    }
                } else {
                    photo = securityCertificate.getHeadImg();
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return photo;
    }

    public String setPhotoDataV1(SecurityCertificate securityCertificate, String headStr) {
        String photo = null;
        Personcertificate personcertificate = this.personcertificateDao.findById(securityCertificate.getSecuritypersonid());
        if ("11".equals(this.configUtils.getCurrentNative())) {
            try {
                if (StringUtil.isNotEmpty((String)personcertificate.getImglogo())) {
                    photo = personcertificate.getImglogo();
                } else {
                    SecurityPerson person = this.securityPersonDao.findUsedByIdNum(securityCertificate.getIdnum());
                    if (person != null && StringUtil.isNotEmpty((String)person.getIdPhoto())) {
                        photo = person.getIdPhoto();
                    } else {
                        PersonBaseInfo personBaseInfo = this.personBaseInfoDao.findByIdNum(personcertificate.getCardnumber());
                        if (personBaseInfo != null && StringUtil.isNotEmpty((String)personBaseInfo.getImgPath())) {
                            photo = personBaseInfo.getImgPath();
                        }
                    }
                }
                if (StringUtil.isNotEmpty((String)photo)) {
                    securityCertificate.setPhoto(headStr + GetPersonImgUtil.GetImageStr((String)this.getResourcePath(photo)));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        } else {
            securityCertificate.setPhoto(headStr + this.getPersonImgUtil.getPersonImg(securityCertificate.getIdnum()));
        }
        return photo;
    }

    public SecurityCertificate findBySecuritypersonidWithPhotoAndQR(long decodeCertificateId, String certificateId, String path) {
        SecurityCertificate securityCertificate = this.securityCertificateDao.findBySecuritypersonid(decodeCertificateId);
        if (null != securityCertificate) {
            this.setPhotoData(securityCertificate);
            try {
                if (null != path && !"".equals(path)) {
                    Config config = this.configDao.findByKey("current_province");
                    Config H5UrlConfig = this.configDao.findByKey("H5URL" + config.getValue());
                    String pathName = "";
                    if (null != H5UrlConfig) {
                        pathName = QRCodeUtil.generateQRCode((String)(this.bbdH5Url + "certificate?certificateId=" + URLEncoder.encode(certificateId, "utf-8") + H5UrlConfig.getValue()), (int)100, (int)100, (String)"jpg", (String)(this.tempFolder + "qrcode.jpg"));
                    }
                    securityCertificate.setQrcode(Base64Img.GetImageStr((String)pathName, (String)"jpg"));
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return securityCertificate;
    }

    public SecurityCertificate findBySecuritypersonidForApp(long personId) {
        Personcertificate dbPersoncertificate = new Personcertificate();
        dbPersoncertificate.setPersonid(Long.valueOf(personId));
        Personcertificate personcertificate = this.personcertificateDao.findByPersonid(dbPersoncertificate);
        SecurityCertificate securityCertificate = null;
        if (null != personcertificate) {
            securityCertificate = this.securityCertificateDao.findBySecuritypersonid(personcertificate.getId().longValue());
        }
        return securityCertificate;
    }

    public void getPersonImg(Long[] idArrays) throws IOException {
        for (Long id : idArrays) {
            this.getPersonImg(id);
        }
    }

    public String getPersonImg(Long id) {
        try {
            BackGroupCensorService backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
            SecurityCertificate securityCertificate = this.findById(id);
            if (securityCertificate == null || securityCertificate.isHavephoto()) {
                return "\u6570\u636e\u9519\u8bef";
            }
            String resultMsg = "\u6ca1\u6709\u83b7\u53d6\u5230\u4eba\u53e3\u5e93\u5934\u50cf";
            logger.info("\u6b63\u5728\u83b7\u53d6\u7684\u8eab\u4efd\u8bc1\u53f7\u7801\uff1a" + securityCertificate.getIdnum());
            securityCertificate.setHavephoto(false);
            PersonBaseInfo personBaseInfo = backGroupCensorService.getPopulationInfo(securityCertificate.getIdnum(), true);
            if (!"45".equals(this.configUtils.getCurrentNative()) && personBaseInfo != null) {
                personBaseInfo.setCreateTime(new Date());
                personBaseInfo.setActive(Boolean.valueOf(true));
                if (StringUtil.isNotEmpty((String)personBaseInfo.getPhoto())) {
                    this.photoUtil.savePhoto(personBaseInfo);
                    securityCertificate.setHavephoto(true);
                    securityCertificate.setHeadImg(personBaseInfo.getImgPath());
                    this.personBaseInfoService.save(personBaseInfo);
                    resultMsg = "\u64cd\u4f5c\u6210\u529f";
                }
            }
            this.securityCertificateDao.updateHavePhotodByIdnum(securityCertificate);
            return resultMsg;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public void updateReceiveState(Long[] idArr) {
        this.securityCertificateDao.updateReceiveState(idArr);
    }

    public void searchForTrain(SecurityCertificateSearchDto dto, AjaxPageResponse<Personcertificate> ajaxPageResponse) {
        this.securityCertificateDao.searchForTrain(dto, ajaxPageResponse);
    }

    public List<SecurityCertificate> findDSOutList(String startDate) {
        return this.securityCertificateDao.searchUpdateflagForExport(startDate);
    }

    public void batchSaveElectronCerUrlForOldData() {
        if ("11".equals(this.configUtils.getCurrentNative())) {
            List certificateList = this.securityCertificateDao.findOldDataForPerson();
            ArrayList list = new ArrayList();
            if (certificateList.size() > 0) {
                certificateList.forEach(detail -> {
                    try {
                        String data = DES3.encode((String)JSON.toJSONString((Object)detail.getSecuritypersonid(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat}));
                        detail.setElectronCerUrl("http://www.bktang.cn/pxxtfront/bbdapp/#/certificate?certificateId=" + URLEncoder.encode(data, "utf-8") + "$http://bjapi.baibaodun.cn:8803/");
                        list.add(detail);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                });
                int limit = this.configUtils.limitSize;
                int count = new Double(Math.ceil((double)list.size() * 1.0 / (double)limit)).intValue();
                List subList = null;
                for (int i = 0; i < count; ++i) {
                    subList = list.stream().skip(i * limit).limit(limit).collect(Collectors.toList());
                    this.securityCertificateDao.batchSaveElectronCerUrl(subList);
                }
            }
        }
    }

    public List<String> batchUpdateState(String idNums, String isState, String makeCard) throws IOException {
        String currentDate = DateUtil.getCurrentDate((String)"yyyy-MM-dd");
        ArrayList<String> downloadUrl = new ArrayList<String>();
        boolean index = false;
        int count = 0;
        if (StringUtil.isNotEmpty((String)idNums)) {
            idNums = idNums.replaceAll("([^a-zA-Z0-9])", ",");
            String[] idNumArr = idNums.split(",");
            count = idNumArr.length;
            ArrayList existCertificateList = new ArrayList();
            ArrayList<String> existHavePhotoList = new ArrayList<String>();
            ArrayList<String> noExistCertificateList = new ArrayList<String>();
            ArrayList<String> noExistHavePhotoList = new ArrayList<String>();
            List list = this.securityCertificateDao.findByIdNums(idNumArr);
            if (idNumArr != null && idNumArr.length > 0) {
                list.forEach(securityCertificate -> {
                    existCertificateList.add(securityCertificate.getIdnum().toUpperCase());
                    if (StringUtil.isNotEmpty((String)securityCertificate.getHeadImg())) {
                        existHavePhotoList.add(securityCertificate.getIdnum().toUpperCase());
                    } else {
                        String idnum = securityCertificate.getIdnum();
                        PersonBaseInfo baseInfo = this.personBaseInfoDao.findByIdNum(idnum);
                        if (null != baseInfo && StringUtil.isNotEmpty((String)baseInfo.getImgPath())) {
                            this.securityCertificateDao.updateHeadImg(idnum, baseInfo.getImgPath());
                            existHavePhotoList.add(idnum.toUpperCase());
                        } else {
                            SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(idnum);
                            if (null != securityPerson && StringUtil.isNotEmpty((String)securityPerson.getIdPhoto())) {
                                this.securityCertificateDao.updateHeadImg(idnum, securityPerson.getIdPhoto());
                                existHavePhotoList.add(idnum.toUpperCase());
                            }
                        }
                    }
                });
                if (existHavePhotoList.size() > 0) {
                    this.securityCertificateDao.updateBatchByidNum(existHavePhotoList, Constants.ISDRAW_WAITPASH);
                }
                ArrayList<String> asList = new ArrayList<String>();
                for (int i = 0; i < idNumArr.length; ++i) {
                    if (!StringUtil.isNotEmpty((String)idNumArr[i])) continue;
                    asList.add(idNumArr[i].toUpperCase());
                }
                noExistCertificateList.addAll(asList);
                noExistCertificateList.removeAll(existCertificateList);
                noExistHavePhotoList.addAll(existCertificateList);
                noExistHavePhotoList.removeAll(existHavePhotoList);
                if (Constants.MAKE_CARD.equals(makeCard)) {
                    String txtfileName = this.configUtils.tempfolder + "/" + currentDate + "/securityCertificate.txt";
                    this.batchImportTxt(txtfileName, existHavePhotoList);
                    downloadUrl.add(txtfileName);
                }
                if (noExistCertificateList.size() > 0 || noExistHavePhotoList.size() > 0) {
                    String fileName = this.configUtils.tempfolder + "/" + currentDate + "/noPass.xls";
                    SecurityCertificateServiceImpl.batchUpdateStateExcel(fileName, noExistCertificateList, noExistHavePhotoList);
                    downloadUrl.add(fileName);
                }
                ArrayList<String> url = new ArrayList<String>();
                if (downloadUrl.size() > 0) {
                    String zipFileName = FileUtil.generatingFileNameByDate((String)"authorization") + ".zip";
                    FileUtil.zipFiles(downloadUrl, (String)(this.configUtils.tempfolder + currentDate + "/" + zipFileName));
                    String zipurl = "getResource.do?path=temp/" + currentDate + "/" + zipFileName;
                    url.add(zipurl);
                }
                return url;
            }
        }
        return null;
    }

    public List<String> batchexportAppPhoto(List<Map<String, String>> idList) throws IOException {
        String currentDate = DateUtil.getCurrentDate((String)"yyyy-MM-dd");
        if (idList.size() > 0) {
            ArrayList<String> idNumArr = new ArrayList<String>();
            for (Map<String, String> map : idList) {
                idNumArr.add(map.get("idNum"));
            }
            ArrayList<HashMap<String, HashMap<String, String>>> excelList = new ArrayList<HashMap<String, HashMap<String, String>>>();
            ArrayList<String> pathList = new ArrayList<String>();
            if (idList != null && idList.size() > 0) {
                idList.forEach(strMap -> {
                    HashMap pmap = new HashMap();
                    HashMap<String, String> map = new HashMap<String, String>();
                    String name = (String)strMap.get("name");
                    String idNum = (String)strMap.get("idNum");
                    if (StringUtil.isNotEmpty((String)idNum)) {
                        map.put("idNum", idNum);
                        map.put("isCertification", "\u5426");
                        map.put("isIdPhoto", "\u5426");
                        map.put("isAppPhoto", "\u5426");
                        map.put("isPerson", "\u5426");
                        map.put("expName", name);
                        map.put("remark", "");
                        pmap.put(idNum.toUpperCase(), map);
                        excelList.add(pmap);
                    }
                });
                String[] idNumArrs = idNumArr.toArray(new String[idNumArr.size()]);
                List list = this.securityCertificateDao.findByIdNums(idNumArrs);
                for (SecurityCertificate securityCertificate : list) {
                    for (HashMap hashMap : excelList) {
                        String idPhotoUrl;
                        PersonBaseInfo byIdNum;
                        String idNum;
                        SecurityPerson securityperson;
                        HashMap exportMap;
                        if (!StringUtil.isNotEmpty((String)securityCertificate.getIdnum()) || null == (exportMap = (HashMap)hashMap.get(securityCertificate.getIdnum().toUpperCase()))) continue;
                        exportMap.put("isCertification", "\u662f");
                        exportMap.put("name", securityCertificate.getXm());
                        if (null == securityCertificate.getXm() || !((String)exportMap.get("expName")).equals(securityCertificate.getXm())) {
                            exportMap.put("remark", "\u5bfc\u5165\u59d3\u540d\u4e0d\u4e00\u81f4\uff0c\u5bfc\u5165\u59d3\u540d\u4e3a\uff1a" + (String)exportMap.get("expName") + ",\u7cfb\u7edf\u4e2d\u59d3\u540d\u4e3a:" + securityCertificate.getXm());
                        }
                        if (null != (securityperson = this.securityPersonDao.findByIdCardAndActive(idNum = securityCertificate.getIdnum()))) {
                            if (StringUtil.isNotEmpty((String)securityperson.getPhone())) {
                                exportMap.put("phone", securityperson.getPhone());
                            } else {
                                exportMap.put("phone", "\u6682\u65e0\u624b\u673a\u53f7");
                            }
                            exportMap.put("isPerson", "\u662f");
                            if (null != securityperson.getRelation() && null != securityperson.getRelation().getCompany()) {
                                exportMap.put("company", securityperson.getRelation().getCompany().getName());
                            } else {
                                exportMap.put("company", "\u6682\u65e0\u516c\u53f8");
                            }
                        }
                        if (null != (byIdNum = this.personBaseInfoDao.findByIdNum(securityCertificate.getIdnum())) && StringUtil.isNotEmpty((String)byIdNum.getImgPath())) {
                            exportMap.put("isIdPhoto", "\u662f");
                            continue;
                        }
                        if (null == securityperson || !StringUtil.isNotEmpty((String)(idPhotoUrl = securityperson.getIdPhoto()))) continue;
                        exportMap.put("isAppPhoto", "\u662f");
                        String[] pathsArr = idPhotoUrl.split("/");
                        if (pathsArr.length != 3) continue;
                        String path = pathsArr[1] + "/" + pathsArr[2];
                        File file = new File(this.configUtils.uploadFolder + path);
                        byte[] bytes = FileUtil.File2byte((File)file);
                        String appPhotoPath = this.configUtils.tempfolder + currentDate + "/";
                        String appPotoName = idNum + ".jpg";
                        FileUtil.byte2File((byte[])bytes, (String)appPhotoPath, (String)appPotoName);
                        pathList.add(appPhotoPath + appPotoName);
                    }
                }
                String fileName = this.configUtils.tempfolder + "/" + currentDate + "/exportAppPhoto.xls";
                pathList.add(fileName);
                SecurityCertificateServiceImpl.batchexportAppPhotoExcel(fileName, excelList);
                ArrayList<String> downloadUrl = new ArrayList<String>();
                String zipFileName = FileUtil.generatingFileNameByDate((String)"appPhoto") + ".zip";
                FileUtil.zipFiles(pathList, (String)(this.configUtils.tempfolder + currentDate + "/" + zipFileName));
                pathList.forEach(tempPath -> {
                    if (tempPath.indexOf("temp") > 0) {
                        FileUtil.deleteFile((String)tempPath);
                    }
                });
                String string = "getResource.do?path=temp/" + currentDate + "/" + zipFileName;
                downloadUrl.add(string);
                return downloadUrl;
            }
        }
        return null;
    }

    public static void batchexportAppPhotoExcel(String fileName, List<HashMap<String, HashMap<String, String>>> list) throws IOException {
        int i;
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        SXSSFSheet sh = wb.createSheet();
        sh.setColumnWidth(0, 3840);
        sh.setColumnWidth(1, 5120);
        sh.setColumnWidth(2, 5120);
        sh.setColumnWidth(3, 8960);
        sh.setColumnWidth(4, 3840);
        sh.setColumnWidth(5, 5120);
        sh.setColumnWidth(6, 3840);
        sh.setColumnWidth(7, 17920);
        sh.setColumnWidth(8, 15360);
        String[] info = new String[]{"\u7cfb\u7edf\u59d3\u540d", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u624b\u673a\u53f7\u7801", "\u5728\u804c\u516c\u53f8", "\u662f\u5426\u6709\u8d44\u683c\u8bc1", "\u662f\u5426\u6709\u4eba\u53e3\u5e93\u7167\u7247", "\u662f\u5426\u6709app\u7167\u7247", "\u5907\u6ce8", "\u5bfc\u5165\u59d3\u540d\u5bf9\u6bd4\u7ed3\u679c"};
        boolean rowIndex = false;
        int columnIndex = 0;
        Row header = sh.createRow(0);
        for (i = 0; i < info.length; ++i) {
            header.createCell(columnIndex++).setCellValue(info[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            HashMap<String, String> hashMap;
            HashMap<String, HashMap<String, String>> map = list.get(i);
            if (map.size() <= 0 || null == (hashMap = map.get(map.keySet().iterator().next()))) continue;
            Row row = sh.createRow(i + 1);
            row.createCell(0).setCellValue(hashMap.get("name"));
            row.createCell(1).setCellValue(hashMap.get("idNum"));
            row.createCell(2).setCellValue(hashMap.get("phone"));
            row.createCell(3).setCellValue(hashMap.get("company"));
            row.createCell(4).setCellValue(hashMap.get("isCertification"));
            row.createCell(5).setCellValue(hashMap.get("isIdPhoto"));
            row.createCell(6).setCellValue(hashMap.get("isAppPhoto"));
            if ("\u662f".equals(hashMap.get("isCertification"))) {
                if ("\u662f".equals(hashMap.get("isIdPhoto"))) {
                    if ("\u662f".equals(hashMap.get("isPerson"))) {
                        row.createCell(7).setCellValue("\u53ef\u5236\u8bc1\uff0c\u65e0\u9700\u5ba1\u6838\u3002");
                    } else {
                        row.createCell(7).setCellValue("\u53ef\u5236\u8bc1\u3002\u8be5\u4eba\u5458\u672a\u5f55\u5165\u7cfb\u7edf\u3002");
                    }
                } else if ("\u662f".equals(hashMap.get("isAppPhoto"))) {
                    row.createCell(7).setCellValue("\u53ef\u5236\u8bc1\u9700\u5ba1\u6838\u3002\u9700\u5ba1\u6838App\u7167\u7247\u662f\u5426\u7b26\u5408\u8981\u6c42\u3002");
                } else {
                    row.createCell(7).setCellValue("\u4e0d\u53ef\u5236\u8bc1\uff0c\u8be5\u4eba\u5458\u65e0\u4eba\u53e3\u7167\u7247\u3001\u65e0App\u7167\u7247\uff0c\u9700App\u8865\u62cd");
                }
            } else {
                row.createCell(7).setCellValue("\u4e0d\u53ef\u5236\u8bc1\u3002\u8be5\u4eba\u5458\u65e0\u8d44\u683c\u8bc1\u4fe1\u606f\u3002");
            }
            row.createCell(8).setCellValue(hashMap.get("remark"));
        }
        FileOutputStream out = null;
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            out = new FileOutputStream(file);
            wb.write((OutputStream)out);
            out.close();
            wb.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void batchUpdateStateExcel(String fileName, List<String> noExistCertificateList, List<String> noExistHavePhotoList) throws IOException {
        int rownum;
        SXSSFWorkbook wb = new SXSSFWorkbook(1000);
        SXSSFSheet sh = wb.createSheet();
        sh.setColumnWidth(0, 1280);
        sh.setColumnWidth(1, 5120);
        sh.setColumnWidth(2, 5120);
        String[] info = new String[]{"", "\u8eab\u4efd\u8bc1\u53f7\u7801", "\u6279\u91cf\u4fee\u6539\u51fa\u73b0\u95ee\u9898"};
        boolean rowIndex = false;
        int columnIndex = 0;
        Row header = sh.createRow(0);
        for (int i = 0; i < info.length; ++i) {
            header.createCell(columnIndex++).setCellValue(info[i]);
        }
        for (rownum = 0; rownum < noExistCertificateList.size(); ++rownum) {
            Row row = sh.createRow(rownum + 1);
            row.createCell(0).setCellValue("");
            row.createCell(1).setCellValue(noExistCertificateList.get(rownum));
            row.createCell(2).setCellValue("\u6ca1\u6709\u8bc1\u4e66");
        }
        for (rownum = 0; rownum < noExistHavePhotoList.size(); ++rownum) {
            int index = noExistCertificateList.size();
            index = index > 0 ? (index += 2) : 1;
            Row row = sh.createRow(rownum + index);
            row.createCell(0).setCellValue("");
            row.createCell(1).setCellValue(noExistHavePhotoList.get(rownum));
            row.createCell(2).setCellValue("\u6ca1\u6709\u7167\u7247");
        }
        FileOutputStream out = null;
        File file = new File(fileName);
        if (file.getParentFile().exists() || !file.getParentFile().mkdirs()) {
            // empty if block
        }
        if (!file.exists()) {
            file.createNewFile();
        }
        try {
            out = new FileOutputStream(file);
            wb.write((OutputStream)out);
            out.close();
            wb.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void batchImportTxt(String fileName, List<String> list) throws IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("successful", true);
        map.put("code", "");
        map.put("msg", "");
        map.put("obj", "");
        map.put("token", "");
        map.put("state", "");
        ArrayList ImportList = new ArrayList();
        if (list.size() > 0) {
            String[] idNum = list.toArray(new String[list.size()]);
            List securityCertificateList = this.securityCertificateDao.findByIdNums(idNum);
            securityCertificateList.forEach(securityCertificate -> {
                BatchImportTxtDTO batchImportTxtDTO = new BatchImportTxtDTO();
                batchImportTxtDTO.setTitle("\u5317\u4eac\u5e02\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1");
                batchImportTxtDTO.setXm(securityCertificate.getXm());
                batchImportTxtDTO.setIdNumber(securityCertificate.getIdnum());
                batchImportTxtDTO.setZsbh(securityCertificate.getZsbh());
                if (null != securityCertificate.getFzrq()) {
                    batchImportTxtDTO.setFzrq(DateUtil.convertDateToString((Date)securityCertificate.getFzrq(), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                if (StringUtil.isNotEmpty((String)securityCertificate.getHeadImg())) {
                    try {
                        String resourcePath = this.getResourcePath(securityCertificate.getHeadImg());
                        String jpg = Base64Img.GetImageStr((String)resourcePath);
                        batchImportTxtDTO.setImglogo(jpg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (securityCertificate.getSnapshotId() == null) {
                    this.savePerCerSnapshot((SecurityCertificate)securityCertificate, securityCertificate.getHeadImg());
                }
                try {
                    Base64Utils.encodeToString((byte[])securityCertificate.getSnapshotId().toString().getBytes("UTF-8"));
                    String qrCodeForThirdParty = this.getQRCodeForThirdParty(DES3.encode((String)securityCertificate.getSnapshotId().toString()));
                    batchImportTxtDTO.setSnapshotPhoto(qrCodeForThirdParty);
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ImportList.add(batchImportTxtDTO);
            });
            map.put("data", ImportList);
            String json = JSON.toJSONString(map);
            FileOutputStream out = null;
            File file = new File(fileName);
            if (!file.exists()) {
                file.createNewFile();
            }
            try {
                out = new FileOutputStream(file);
                out.write(json.getBytes());
                out.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public AjaxResult checkyearAndday(String idNum) {
        AjaxResult result = new AjaxResult();
        SecurityCertificate securityCertificate = this.securityCertificateDao.findByIdnum(idNum);
        if (null != securityCertificate && null != securityCertificate.getFzrq()) {
            int day = DateUtil.dateDiff((Date)securityCertificate.getFzrq(), (Date)new Date());
            if (day >= 365) {
                result.setSuccessful(true);
                result.setCode("200");
                result.setMsg("\u8d44\u683c\u8bc1\u6ee1\u4e00\u5e74");
                return result;
            }
            result.setSuccessful(true);
            result.setCode("201");
            result.setMsg("\u8d44\u683c\u8bc1\u672a\u6ee1\u4e00\u5e74");
            return result;
        }
        result.setSuccessful(true);
        result.setCode("202");
        result.setMsg("\u4e0d\u5b58\u5728");
        return result;
    }

    public AjaxResult searchForPublicQuery(String idnum) {
        ArrayList<SecurityCertificateDto> lists = new ArrayList<SecurityCertificateDto>();
        logger.error("=========> \u67e5\u8be2\u5f00\u59cb\uff1a" + this.configUtils.getValueByKey("BJ_PUBLIC_QUERY_FORM_V5"));
        String v5Url = this.configUtils.getValueByKey("V5_TENANT_URL");
        if (StringUtils.isEmpty((Object)v5Url)) {
            v5Url = "https://v5qy.baibaodun.cn/";
        }
        String url = v5Url + "v3/public/qualification-credentials";
        String body = String.format("{'idnum':'%s','areaCode':'%s'}", idnum, this.configUtils.getValueByKey("current_native"));
        logger.error("=========> \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        logger.error("=========> \u8bf7\u6c42\u62a5\u6587\uff1a" + body);
        System.out.println("=========> \u8bf7\u6c42\u5730\u5740\uff1a" + url);
        System.out.println("=========> \u8bf7\u6c42\u62a5\u6587\uff1a" + body);
        HttpResponse response = HttpUtil.createPost((String)url).contentType("application/json").body(body).execute();
        logger.error("=========> \u8fd4\u56de\u62a5\u6587\uff1a" + response.body());
        System.out.println("=========> \u8fd4\u56de\u62a5\u6587\uff1a" + response.body());
        V5ResultDto resultDto = (V5ResultDto)JSON.parseObject((String)response.body(), V5ResultDto.class);
        logger.error("=========> \u8fd4\u56de\u62a5\u6587\u8f6c\u6362\uff1a" + JSON.toJSONString((Object)resultDto));
        if (resultDto.isSuccess() && resultDto.getData() != null) {
            logger.error("=========> \u62a5\u6587\u5904\u7406\uff1a1");
            List v5List = JSON.parseArray((String)JSON.toJSONString((Object)resultDto.getData()), SecurityCertificateV5Dto.class);
            logger.error("=========> \u62a5\u6587\u5904\u7406.v5List\uff1a" + v5List.size());
            for (SecurityCertificateV5Dto securityCertificateV5Dto : v5List) {
                SecurityCertificateDto securityCertificateDto = new SecurityCertificateDto();
                securityCertificateDto.setFzjgmc(securityCertificateV5Dto.getOrgName());
                securityCertificateDto.setFzrq(DateUtil.convertDateToString((Date)securityCertificateV5Dto.getCerDate(), (String)"yyyy-MM-dd"));
                securityCertificateDto.setFromV5(true);
                logger.error("=========> \u8fd4\u56de\u62a5\u6587\u5904\u74061\uff1a" + JSON.toJSONString((Object)securityCertificateDto));
                lists.add(securityCertificateDto);
            }
            logger.error("=========> \u8fd4\u56de\u62a5\u6587\u5904\u74062\uff1a" + JSON.toJSONString(lists));
        }
        return AjaxResult.success(lists);
    }

    public AjaxResult canSignUpSecurityCertificate(String idNumbers) {
        String subject = JwtUtil.parseJWT((String)idNumbers).getSubject();
        List idNumbersList = JSON.parseArray((String)subject, String.class);
        HashSet idNumbersSet = Sets.newHashSet((Iterable)idNumbersList);
        AjaxResult ajaxResult = new AjaxResult();
        if (CollectionUtil.isEmpty((Collection)idNumbersSet)) {
            ajaxResult.setSuccessful(false);
            ajaxResult.setMsg("\u8bf7\u8f93\u5165\u6b63\u786e\u53c2\u6570");
            return ajaxResult;
        }
        HashMap resultData = Maps.newHashMap();
        for (String idNumber : idNumbersSet) {
            boolean canApply = this.checkCanApplySecurityCertificate(idNumber);
            resultData.put(idNumber, canApply);
        }
        ajaxResult.setData((Object)JwtUtil.createJWT((String)JSON.toJSONString((Object)resultData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue})));
        ajaxResult.setMsg("\u67e5\u8be2\u6210\u529f");
        ajaxResult.setSuccessful(true);
        return ajaxResult;
    }

    public boolean checkCanApplySecurityCertificate(String idNumber) {
        if (StringUtil.isBlank((CharSequence)idNumber)) {
            return false;
        }
        boolean flag = false;
        SecurityPerson securityPerson = this.securityPersonDao.findByIdCard(idNumber);
        if (securityPerson == null) {
            logger.error("\u5b66\u5458{}\u4e0d\u5b58\u5728\u5165\u804c\u8bb0\u5f55\uff01", (Object)idNumber);
        } else if ("1".equals(securityPerson.getIdentityAuthState())) {
            flag = true;
        } else {
            logger.error("\u5b66\u5458{}\u672a\u5b9e\u540d\u8ba4\u8bc1\u901a\u8fc7\uff01", (Object)idNumber);
        }
        if (flag) {
            if (Constants.ZGZBT_SWITCH_1.equals(this.configUtils.getValueByKey(Constants.ZGZBT_SWITCH))) {
                Personcertificate personcertificate;
                SecurityCertificate certificate = this.securityCertificateDao.findByIdnum(idNumber);
                if (certificate != null) {
                    flag = false;
                    logger.error("\u5b66\u5458{}\u5df2\u6301\u6709\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01", (Object)idNumber);
                }
                if (flag && (personcertificate = this.personcertificateDao.findApprovalingByIdNum(idNumber)) != null) {
                    flag = false;
                    logger.error("\u5b66\u5458{}\u5df2\u62a5\u540d\u4fdd\u5b89\u5458\u8d44\u683c\u8bc1\uff01", (Object)idNumber);
                }
            } else {
                Personcertificate personcertificate = this.personcertificateDao.findApprovaling(securityPerson.getId());
                if (personcertificate != null) {
                    flag = false;
                }
            }
        }
        return flag;
    }

    public SecurityCerDto findByIdNum(String idNum) {
        SecurityCerDto result = null;
        SecurityCertificate cer = this.securityCertificateDao.findByIdnum(idNum);
        if (cer != null) {
            result = new SecurityCerDto();
            cer.setPhoto(this.getPersonImgUtil.getPersonImg(cer.getIdnum()));
            BeanUtils.copyPropertiesIgnore((Object)cer, (Object)result);
            result.setName(cer.getXm());
            result.setIdNum(cer.getIdnum());
            result.setOrgName(cer.getFzjgmc());
            result.setCerNo(cer.getZsbh());
            result.setCerDate(DateFormatUtils.format((Date)cer.getFzrq(), (String)"yyyy-MM-dd"));
        }
        return result;
    }
}

