/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dao.certificate.PerCerSnapshotDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.page.PerCerSnapshotPageSearchDto;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.certificate.PerCerSnapshotService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@DataSyncOutAnnotation(getClazz=PerCerSnapshot.class)
public class PerCerSnapshotServiceImpl
implements PerCerSnapshotService {
    Logger logger = LoggerFactory.getLogger(PerCerSnapshotServiceImpl.class);
    @Autowired
    private PerCerSnapshotDao perCerSnapshotDao;
    @Autowired
    private IdWorker idWorker;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private PersonBaseInfoService personBaseInfoService;

    public int delete(PerCerSnapshot perCerSnapshot) {
        User currentUser = this.arsUtil.getCurrentUser();
        perCerSnapshot.setUpdateTime(new Date());
        perCerSnapshot.setUpdateBy(currentUser.getUsername());
        return this.perCerSnapshotDao.delete(perCerSnapshot);
    }

    public int save(PerCerSnapshot perCerSnapshot) {
        String idNum;
        PersonBaseInfo baseInfo;
        User currentUser = this.arsUtil.getCurrentUser();
        if (perCerSnapshot.getId() == null) {
            perCerSnapshot.setId(Long.valueOf(this.idWorker.nextId()));
            perCerSnapshot.setCreateTime(new Date());
        } else {
            PerCerSnapshot dbPerCerSnapshot = this.perCerSnapshotDao.findById(perCerSnapshot.getId());
            BeanUtils.copyPropertiesIgnore((Object)perCerSnapshot, (Object)dbPerCerSnapshot, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbPerCerSnapshot, (Object)perCerSnapshot, (Boolean)false);
        }
        perCerSnapshot.setActive(Boolean.valueOf(true));
        perCerSnapshot.setUpdateBy(currentUser.getUsername());
        perCerSnapshot.setUpdateTime(new Date());
        perCerSnapshot.setUpdateflag(Boolean.valueOf(true));
        perCerSnapshot.setAreaCode(currentUser.getPolice().getAreacode());
        if (StringUtil.isEmpty((String)perCerSnapshot.getPhoto()) && null != (baseInfo = this.personBaseInfoService.findByIdNum(idNum = perCerSnapshot.getIdNum()))) {
            perCerSnapshot.setPhoto(baseInfo.getPhoto());
        }
        return this.perCerSnapshotDao.save(perCerSnapshot);
    }

    public PerCerSnapshot findById(Long id) {
        return this.perCerSnapshotDao.findById(id);
    }

    public void searchForPage(PerCerSnapshotPageSearchDto dto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)dto);
        this.perCerSnapshotDao.searchForPage(dto, page);
    }

    public void importBatch(List<PerCerSnapshot> list) {
        List dbList = this.perCerSnapshotDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (PerCerSnapshot perCerSnapshot : list) {
                String idNum;
                PersonBaseInfo baseInfo;
                perCerSnapshot.setUpdateflag(Boolean.valueOf(false));
                if (StringUtil.isEmpty((String)perCerSnapshot.getPhoto()) && null != (baseInfo = this.personBaseInfoService.findByIdNum(idNum = perCerSnapshot.getIdNum()))) {
                    perCerSnapshot.setPhoto(baseInfo.getPhoto());
                }
                try {
                    if (this.configUtils.isIntranet()) continue;
                    perCerSnapshot.setUpdateTime(DateUtil.dateAdd((int)6, (Date)perCerSnapshot.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.perCerSnapshotDao.saveBatch(list);
        }
    }

    public List<PerCerSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.perCerSnapshotDao.searchForDataSynchronization(dto);
    }

    public List<PerCerSnapshot> findDSOutList(String startDate) {
        return this.perCerSnapshotDao.findDSOutList(startDate);
    }

    public List<PerCerSnapshot> findByBatchId(List<PerCerSnapshot> list) {
        return this.perCerSnapshotDao.findByBatchId(list);
    }

    public void updateSelective(PerCerSnapshot perCerSnapshot) {
        User currentUser = this.arsUtil.getCurrentUser();
        perCerSnapshot.setUpdateTime(new Date());
        perCerSnapshot.setUpdateBy(currentUser.getUsername());
        this.perCerSnapshotDao.updateSelective(perCerSnapshot);
    }
}

