/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.certificate.impl;

import com.bcxin.ars.dao.certificate.ComCertificateSnapshotDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.ComCertificateSnapshot;
import com.bcxin.ars.service.certificate.ComCertificateSnapshotService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ComCertificateSnapshotServiceImpl
implements ComCertificateSnapshotService {
    Logger logger = LoggerFactory.getLogger(ComCertificateSnapshotServiceImpl.class);
    @Autowired
    private ComCertificateSnapshotDao comCertificateSnapshotDao;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;

    public int save(ComCertificateSnapshot comCertificateSnapshot) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (comCertificateSnapshot.getId() == null) {
            comCertificateSnapshot.setCreateTime(new Date());
        } else {
            ComCertificateSnapshot dbQrcodeInfo = this.comCertificateSnapshotDao.findByQrCodeId(comCertificateSnapshot.getQrCodeId());
            BeanUtils.copyPropertiesIgnore((Object)comCertificateSnapshot, (Object)dbQrcodeInfo, (Boolean)true);
            BeanUtils.copyPropertiesIgnore((Object)dbQrcodeInfo, (Object)comCertificateSnapshot, (Boolean)false);
        }
        comCertificateSnapshot.setActive(Boolean.valueOf(true));
        comCertificateSnapshot.setUpdateBy(currentUser.getUsername());
        comCertificateSnapshot.setUpdateTime(new Date());
        comCertificateSnapshot.setUpdateflag(Boolean.valueOf(true));
        comCertificateSnapshot.setAreaCode(currentUser.getPolice().getAreacode());
        return this.comCertificateSnapshotDao.save(comCertificateSnapshot);
    }

    public ComCertificateSnapshot findByQrCodeId(Long qrCodeId) {
        return this.comCertificateSnapshotDao.findByQrCodeId(qrCodeId);
    }

    public void importBatch(List<ComCertificateSnapshot> list) {
        List dbList = this.comCertificateSnapshotDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            for (ComCertificateSnapshot comCertificateSnapshot : list) {
                comCertificateSnapshot.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (this.configUtils.isIntranet()) continue;
                    comCertificateSnapshot.setUpdateTime(DateUtil.dateAdd((int)6, (Date)comCertificateSnapshot.getUpdateTime(), (int)1));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.comCertificateSnapshotDao.saveBatch(list);
        }
    }

    public List<ComCertificateSnapshot> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return this.comCertificateSnapshotDao.searchForDataSynchronization(dto);
    }

    public List<ComCertificateSnapshot> findDSOutList(String startDate) {
        return this.comCertificateSnapshotDao.findDSOutList(startDate);
    }

    public List<ComCertificateSnapshot> findByBatchId(List<ComCertificateSnapshot> list) {
        return this.comCertificateSnapshotDao.findByBatchId(list);
    }
}

