/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.approve.impl;

import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.approve.ApproveTempLinkRelaDao;
import com.bcxin.ars.dto.approve.ApproveTempDto;
import com.bcxin.ars.dto.approve.CheckTempConfigDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.service.approve.ApproveTempService;
import com.bcxin.ars.service.util.ArsUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
public class ApproveTempServiceImpl
implements ApproveTempService {
    @Autowired
    private ApproveTempDao approveTempDao;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private ApproveTempLinkRelaDao approveTempLinkRelaDao;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ApproveTempDto> findDto() {
        List tempDtoList;
        Police qxPolice;
        User currentUser = this.arsUtil.getCurrentUser();
        Police currentPolice = currentUser.getPolice();
        List resultApproveTempDtoList = new ArrayList();
        ArrayList<ApproveTempDto> resultTempList = new ArrayList<ApproveTempDto>();
        if (currentPolice == null) throw new ArsException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u673a\u6784\u4fe1\u606f\u5931\u8d25\uff01");
        String orgtype = currentPolice.getOrgtype();
        String areacode = currentPolice.getAreacode();
        Long orgId = null;
        if (StringUtils.isEmpty((Object)areacode)) {
            throw new ArsException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5730\u533a\u7f16\u7801\u5931\u8d25\uff01");
        }
        if (!"1".equals(orgtype)) {
            List polices = null;
            Police policeQuery = new Police();
            policeQuery.setOrgtype("2");
            policeQuery.setAreacode(areacode.substring(0, 4) + "00");
            polices = this.policeDao.findPoliceByOrgTypeAndLikeAreacode("2", areacode.substring(0, 4) + "00");
            if (polices == null || polices.size() != 1) throw new ArsException("\u83b7\u53d6\u5f53\u524d\u7528\u6237\u5e02\u7ea7\u673a\u6784\u5931\u8d25:\u5e02\u7ea7\u673a\u6784\u4e0d\u5b58\u5728\u6216\u8005\u5e02\u7ea7\u673a\u6784\u5b58\u5728\u591a\u6761\u91cd\u590d\uff01");
            orgId = ((Police)polices.get(0)).getId();
        } else {
            orgId = currentPolice.getId();
        }
        resultApproveTempDtoList = this.approveTempDao.findDto(orgId);
        Long qxOrgId = null;
        if ("3".equals(orgtype)) {
            qxOrgId = currentPolice.getId();
        } else if ("4".equals(orgtype) && (qxPolice = this.policeDao.findByOrgIdsAndOrgType(currentPolice.getPath().split("/"), "3")) != null) {
            qxOrgId = qxPolice.getId();
        }
        Map<Object, Object> tempMap = new HashMap();
        if (qxOrgId != null && (tempDtoList = this.approveTempDao.findDto(qxOrgId)) != null && tempDtoList.size() > 0) {
            tempMap = tempDtoList.stream().collect(Collectors.toMap(ApproveTempDto::getApproveType, Function.identity()));
        }
        if (resultApproveTempDtoList == null || resultApproveTempDtoList.size() <= 0) return resultTempList;
        for (ApproveTempDto item : resultApproveTempDtoList) {
            if (tempMap.get(item.getApproveType()) != null) {
                item = (ApproveTempDto)tempMap.get(item.getApproveType());
            }
            ApproveTemp checkCityTemp = new ApproveTemp();
            checkCityTemp.setId(Long.valueOf(item.getTempId()));
            if (this.checkCurrentTempConfigComplete(checkCityTemp)) {
                item.setApproveSetStatus("1");
            } else {
                item.setApproveSetStatus("0");
            }
            resultTempList.add(item);
        }
        return resultTempList;
    }

    public ApproveTemp findById(Long id) {
        return this.approveTempDao.findById(id);
    }

    public void update(ApproveTemp approveTemp) {
        User currentUser = this.arsUtil.getCurrentUser();
        if (approveTemp.getId() != null) {
            ApproveTemp dbApproveTemp = this.approveTempDao.findById(approveTemp.getId());
            dbApproveTemp.setUpdateBy(currentUser.getUsername());
            dbApproveTemp.setUpdateTime(new Date());
            if (!StringUtils.isEmpty((Object)approveTemp.getTempName())) {
                dbApproveTemp.setTempName(approveTemp.getTempName());
            }
            if (!StringUtils.isEmpty((Object)approveTemp.getApproveSetStatus())) {
                dbApproveTemp.setApproveSetStatus(approveTemp.getApproveSetStatus());
            }
            if (!StringUtils.isEmpty((Object)approveTemp.getNoticeTemp())) {
                dbApproveTemp.setNoticeTemp(approveTemp.getNoticeTemp());
            }
            if (!StringUtils.isEmpty((Object)approveTemp.getRepulseExplain())) {
                dbApproveTemp.setRepulseExplain(approveTemp.getRepulseExplain());
            }
            this.approveTempDao.update(dbApproveTemp);
        }
    }

    public String getConfigState() {
        User currentUser = this.arsUtil.getCurrentUser();
        String configState = "";
        return configState;
    }

    public List<ApproveTemp> findByParentTempId(ApproveTemp approveTemp) {
        return this.approveTempDao.findByParentTempId(approveTemp.getParentTempId());
    }

    public List<ApproveTemp> findApproveOrgListSj(ApproveTemp approveTemp) {
        return this.approveTempDao.findApproveOrgListSj(approveTemp.getParentTempId());
    }

    public boolean checkTempConfigComplete(ApproveTemp approveTemp) {
        User user = this.arsUtil.getCurrentUser();
        String orgtype = user.getPolice().getOrgtype();
        String superAreaCode = "";
        String superOrgtype = "";
        String areaCode = user.getPolice().getAreacode();
        boolean configStatus = true;
        if (orgtype.equals("1")) {
            return true;
        }
        if (orgtype.equals("2")) {
            areaCode = areaCode.substring(0, 4);
            superAreaCode = areaCode.substring(0, 2) + "0000";
            superOrgtype = "1";
        } else if (orgtype.equals("3")) {
            superAreaCode = areaCode.substring(0, 4) + "00";
            superOrgtype = "2";
        } else {
            superAreaCode = areaCode;
            superOrgtype = "3";
        }
        CheckTempConfigDto checkDto = new CheckTempConfigDto();
        checkDto.setTempId(approveTemp.getId());
        checkDto.setAreaCode(superAreaCode);
        checkDto.setOrgtype(superOrgtype);
        Long check = this.approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
        if (check != null && check > 0L) {
            configStatus = false;
        }
        return configStatus;
    }

    public ApproveTemp findByTempCode(String tempCode) {
        return this.approveTempDao.findByTempCode(tempCode);
    }

    public String getMaxApproveLevel(String tempCode) {
        ApproveTemp approveTemp = this.approveTempDao.findByTempCode(tempCode);
        if (approveTemp != null) {
            return this.approveTempDao.getMaxApproveLevelByApproveTempId(approveTemp.getId());
        }
        throw new ArsException("\u5ba1\u6279\u6a21\u677f\u672a\u914d\u7f6e\uff01");
    }

    private boolean checkCurrentTempConfigComplete(ApproveTemp approveTemp) {
        Long count;
        User user = this.arsUtil.getCurrentUser();
        Long orgid = user.getPolice().getId();
        boolean configStatus = true;
        CheckTempConfigDto checkDto = new CheckTempConfigDto();
        checkDto.setTempId(approveTemp.getId());
        checkDto.setOrgid(orgid);
        Long check = this.approveTempLinkRelaDao.checkTempConfigCompleteByOrgId(checkDto);
        configStatus = check != null && check > 0L ? false : (count = this.approveTempLinkRelaDao.getTempLinkByPoliceCount(checkDto)) != null && count > 0L;
        return configStatus;
    }
}

