/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.approve.impl;

import com.bcxin.ars.dao.approve.ApproveLinkDao;
import com.bcxin.ars.dto.approve.ApproveLinkSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveLink;
import com.bcxin.ars.service.approve.ApproveLinkService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ApproveLinkServiceImpl
implements ApproveLinkService {
    @Autowired
    private ApproveLinkDao approveLinkDao;
    @Autowired
    private ArsUtil arsUtil;

    public void delete(ApproveLink approveLink) {
        User currentUser = this.arsUtil.getCurrentUser();
        approveLink.setActive(Boolean.valueOf(false));
        approveLink.setUpdateBy(currentUser.getUsername());
        approveLink.setUpdateTime(new Date());
        this.approveLinkDao.delete(approveLink);
    }

    public void saveOrUpdate(ApproveLink approveLink) {
        User currentUser = this.arsUtil.getCurrentUser();
        ApproveLink checkApproveLink = this.approveLinkDao.findByLinkName(approveLink.getLinkName());
        if (checkApproveLink != null && approveLink.getId() == null && approveLink.getId() != null && checkApproveLink.getId() != approveLink.getId()) {
            throw new ArsException("\u5ba1\u6279\u73af\u8282\u540d\u79f0\u5df2\u5b58\u5728!");
        }
        if (StringUtil.isNotEmpty((String)approveLink.getLinkType())) {
            checkApproveLink = this.approveLinkDao.findByLinkType(approveLink.getLinkType());
            String typeName = "";
            switch (approveLink.getLinkType()) {
                case "1": {
                    typeName = "\u62a5\u540d\u786e\u8ba4";
                    break;
                }
                case "2": {
                    typeName = "\u7f34\u8d39\u786e\u8ba4";
                    break;
                }
                case "3": {
                    typeName = "\u6307\u7eb9\u83b7\u53d6";
                    break;
                }
                case "4": {
                    typeName = "\u8003\u8bd5\u5b89\u6392";
                }
            }
            if (checkApproveLink != null && (approveLink.getId() == null || approveLink.getId() != null && checkApproveLink.getId() != approveLink.getId())) {
                throw new ArsException(approveLink.getLinkName() + "\u5df2\u8bbe\u7f6e" + typeName + "\uff0c\u8bf7\u52ff\u91cd\u590d\u9009\u62e9!");
            }
        }
        if (approveLink.getId() == null) {
            approveLink.setActive(Boolean.valueOf(true));
            approveLink.setCreateTime(new Date());
            approveLink.setUpdateBy(currentUser.getUsername());
            approveLink.setUpdateTime(new Date());
            this.approveLinkDao.save(approveLink);
        } else {
            ApproveLink dbApproveLink = this.approveLinkDao.findById(approveLink.getId());
            dbApproveLink.setLinkName(approveLink.getLinkName());
            dbApproveLink.setLinkType(approveLink.getLinkType());
            dbApproveLink.setSeq(approveLink.getSeq());
            dbApproveLink.setUpdateBy(currentUser.getUsername());
            dbApproveLink.setUpdateTime(new Date());
            this.approveLinkDao.update(dbApproveLink);
        }
    }

    public ApproveLink findById(Long id) {
        return this.approveLinkDao.findById(id);
    }

    public ApproveLinkSearchDto search(ApproveLinkSearchDto searchDto) {
        List linkList = this.approveLinkDao.search(searchDto);
        Long count = this.approveLinkDao.searchCount(searchDto);
        searchDto.setData(linkList);
        searchDto.setTotalCount(count);
        return searchDto;
    }

    public List<ApproveLink> findByApproveTempId(Long approveTempId) {
        return this.approveLinkDao.findByApproveTempId(approveTempId);
    }
}

