/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.appeal.impl;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.SecurityPersonDaoAop;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.service.appeal.AppealHandle;
import com.bcxin.ars.service.util.SAASInterfaceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthAppealHandle
implements AppealHandle {
    @Autowired
    private SAASInterfaceUtil saasInterfaceUtil;
    @Autowired
    private SecurityPersonDaoAop securityPersonDaoAop;
    private static Map<String, String> saasMap = new HashMap<String, String>();

    public void handle(Appeal appeal) {
        if (saasMap.get(appeal.getAppealState()) != null) {
            ArrayList paramList = new ArrayList();
            HashMap<String, String> detailMap = new HashMap<String, String>();
            detailMap.put("perId", appeal.getBusinessid() + "");
            detailMap.put("appealState", saasMap.get(appeal.getAppealState()));
            detailMap.put("appealContext", appeal.getAppealContext());
            paramList.add(detailMap);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("appeals", JSON.toJSONString(paramList));
            this.saasInterfaceUtil.callInterface("/thirdPlat/bbd-callBack/batch-per-appeal-result", paramMap);
        }
    }

    public void handle(List<Appeal> list) {
        if (list != null && list.size() > 0) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            ArrayList paramList = new ArrayList();
            ArrayList<Appeal> passList = new ArrayList<Appeal>();
            for (Appeal appeal : list) {
                if (saasMap.get(appeal.getAppealState()) == null) continue;
                HashMap<String, String> detailMap = new HashMap<String, String>();
                detailMap.put("perId", appeal.getBusinessid() + "");
                detailMap.put("approveStatus", saasMap.get(appeal.getAppealState()));
                detailMap.put("approveContent", appeal.getAppealReson());
                paramList.add(detailMap);
                if (!"003".equals(appeal.getAppealState())) continue;
                passList.add(appeal);
            }
            if (passList.size() > 0) {
                this.securityPersonDaoAop.updateBatchAuthState(passList);
            }
            if (paramList != null && paramList.size() > 0) {
                paramMap.put("appeals", JSON.toJSONString(paramList));
                this.saasInterfaceUtil.callInterface("/thirdPlat/bbd-callBack/batch-per-appeal-result", paramMap);
            }
        }
    }

    static {
        saasMap.put("003", "1");
        saasMap.put("004", "2");
    }
}

