/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.ars.service.appeal.impl;

import cn.hutool.extra.validation.BeanValidationResult;
import cn.hutool.extra.validation.ValidationUtil;
import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.abcxin.smart.validator.group.ThirdPartyTrain;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.appeal.AppealDao;
import com.bcxin.ars.dao.sb.PersonGradeDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.PersoncertificateDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.SearchDto;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.exception.ValidateException;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.model.sb.PersonGrade;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.service.appeal.AppealService;
import com.bcxin.ars.service.bean.factory.AppealHandleBeanFactory;
import com.bcxin.ars.service.bean.factory.BackGroupCensorServiceBeanFactory;
import com.bcxin.ars.service.impl.BaseService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.ImgUtils;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.webservice.BackGroupCensorService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@Transactional
@DataSyncAnnotation(getClazz=Appeal.class)
@DataSyncOutAnnotation(getClazz=Appeal.class)
public class AppealServiceImpl
extends BaseService
implements AppealService {
    public static Logger logger = LoggerFactory.getLogger(AppealServiceImpl.class);
    private static BackGroupCensorService backGroupCensorService;
    @Autowired
    private AppealDao appealDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private PersoncertificateDaoAop personcertificateDaoAop;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    @Value(value="${base-folder}")
    private String baseFolder;
    @Value(value="${upload-folder}")
    private String uploadFolder;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Resource
    private IdWorker idWorker;
    @Resource
    private PersonGradeDao personGradeDao;

    private void getBackGroupCensorService() {
        if (backGroupCensorService == null) {
            backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
        }
    }

    public void searchForPage(AppealSearchDto searchDto, AjaxPageResponse page) {
        this.arsUtil.setPoliceSearch((SearchDto)searchDto);
        String areaCodeQuery = searchDto.getAreaCodeQuery();
        if (!StringUtils.isEmpty((Object)areaCodeQuery)) {
            searchDto.setAreaCode(areaCodeQuery);
        }
        this.appealDao.searchForPage(searchDto, page);
    }

    public List<Appeal> searchForDataSynchronization(DataSynchronizationSearchDto searchDto) {
        return this.appealDao.searchForDataSynchronization(searchDto);
    }

    public void saveOrUpdateForDS(Appeal appeal) {
        this.getBackGroupCensorService();
        Appeal dbAppeal = this.findById(appeal.getId());
        if (dbAppeal != null) {
            if (appeal.getUpdateTime().getTime() >= dbAppeal.getUpdateTime().getTime()) {
                this.appealDao.update(appeal);
            }
        } else {
            try {
                String photo = backGroupCensorService.getPhoto(appeal.getIdnum(), appeal.getName());
                appeal.setPhoto(photo);
                this.savePhoto(appeal);
            }
            catch (Exception e) {
                logger.error("\u5185\u7f51\u8bfb\u53d6\u540c\u6b65\u7533\u8bc9\u4fe1\u606f\u5f02\u5e38\uff0c\u83b7\u53d6\u4eba\u53e3\u5e93\u7167\u7247\u5f02\u5e38:" + e.getMessage());
            }
            this.appealDao.insert(appeal);
        }
    }

    private void savePhoto(Appeal appeal) {
        if (StringUtil.isNotEmpty((String)appeal.getPhoto())) {
            Date now = new Date();
            String fileName = now.getTime() + ".jpg";
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(this.uploadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String key = "upload/" + dirDate + "/" + fileName;
            String url = "getResource.do?path=" + key;
            String targetPath = this.baseFolder + key;
            if (ImgUtils.generateImage((String)appeal.getPhoto(), (String)targetPath)) {
                appeal.setDataImg(url);
            }
            appeal.setPhoto(null);
        }
    }

    public List<Appeal> findDSOutList(String startDate) {
        return this.appealDao.findDSOutList(startDate);
    }

    public void importBatch(List<Appeal> list) {
        List dbList = this.appealDao.findByBatchId(list);
        list.removeAll(dbList);
        if (list.size() > 0) {
            HashMap<String, ArrayList<Appeal>> map = new HashMap<String, ArrayList<Appeal>>();
            for (Appeal detail : list) {
                detail.setUpdateflag(Boolean.valueOf(false));
                try {
                    if (!this.configUtils.isIntranet()) {
                        detail.setUpdateTime(DateUtil.dateAdd((int)6, (Date)detail.getUpdateTime(), (int)1));
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                ArrayList<Appeal> businessList = (ArrayList<Appeal>)map.get(detail.getBusinesstype());
                if (businessList == null) {
                    businessList = new ArrayList<Appeal>();
                }
                businessList.add(detail);
                map.put(detail.getBusinesstype(), businessList);
            }
            map.keySet().forEach(businessType -> AppealHandleBeanFactory.getAppealHandleBean(businessType).handle((List)map.get(businessType)));
            this.appealDao.saveBatch(list);
        }
    }

    public Appeal findById(Long id) {
        return this.appealDao.findById(id);
    }

    public void save(Appeal appeal) {
        User currentUser = this.arsUtil.getCurrentUser();
        appeal.setActive(Boolean.valueOf(true));
        appeal.setCreateTime(new Date());
        appeal.setUpdateTime(new Date());
        appeal.setUpdateBy(currentUser == null ? "system" : currentUser.getUsername());
        appeal.setAppealState("002");
        if (StringUtil.isNotEmpty((String)appeal.getCardImgPositive())) {
            appeal.setCardImgPositive(this.getPhotoPath(appeal.getCardImgPositive()));
        }
        if (StringUtil.isNotEmpty((String)appeal.getCardImgBack())) {
            appeal.setCardImgBack(this.getPhotoPath(appeal.getCardImgBack()));
        }
        if (StringUtil.isNotEmpty((String)appeal.getCardHold())) {
            appeal.setCardHold(this.getPhotoPath(appeal.getCardHold()));
        }
        if (StringUtil.isNotEmpty((String)appeal.getAuthImg())) {
            appeal.setAuthImg(this.getPhotoPath(appeal.getAuthImg()));
        }
        if (StringUtil.isNotEmpty((String)appeal.getAttFile())) {
            appeal.setAttFile(this.getPhotoPath(appeal.getAttFile()));
        }
        if ("11".equals(this.configUtils.getCurrentNative())) {
            SecurityCompany company = this.securityCompanyDao.findByComId(appeal.getCompanyId());
            String districtOrgId = company.getDistrictOrgId();
            boolean districtOrgIdIsNull = StringUtils.isEmpty((Object)districtOrgId);
            appeal.setOrgId(districtOrgIdIsNull ? Long.valueOf(company.getOrgId()) : Long.valueOf(districtOrgId));
            appeal.setOrgName(districtOrgIdIsNull ? company.getOrgName() : company.getDistrictOrgName());
            appeal.setAreaCode(company.getAreaCode());
        }
        this.appealDao.insert(appeal);
        this.saveBusiness(appeal);
    }

    private void saveBusiness(Appeal appeal) {
        if ("11".equals(this.configUtils.getCurrentNative()) && "002".equals(appeal.getBusinesstype())) {
            Personcertificate personcertificate = this.personcertificateDao.findById(appeal.getBusinessid());
            personcertificate.setCensorStatus("005");
            personcertificate.setUpdateTime(new Date());
            personcertificate.setApprovalstate("005");
            this.personcertificateDaoAop.updateSelective(personcertificate);
        }
    }

    public void saveAppealApproval(Appeal appeal) {
        Appeal dbAppeal = this.findById(appeal.getId());
        BeanUtils.copyPropertiesIgnore((Object)appeal, (Object)dbAppeal, (Boolean)true);
        User user = this.arsUtil.getCurrentUser();
        dbAppeal.setUpdateBy(user.getUsername());
        dbAppeal.setUpdateTime(new Date());
        dbAppeal.setUpdateflag(Boolean.valueOf(true));
        this.appealDao.update(dbAppeal);
    }

    public AjaxResult submitBackgroundAppeal(String appeal) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)appeal).getSubject();
        User currentUser = this.arsUtil.getCurrentUser();
        Appeal appealInfo = (Appeal)JSON.parseObject((String)subject, Appeal.class);
        BeanValidationResult beanValidationResult = ValidationUtil.warpValidate((Object)appealInfo, (Class[])new Class[]{ThirdPartyTrain.class});
        if (!beanValidationResult.isSuccess()) {
            Set errorMessages = beanValidationResult.getErrorMessages().stream().map(BeanValidationResult.ErrorMessage::getMessage).collect(Collectors.toSet());
            throw new ValidateException(errorMessages);
        }
        int count = this.appealDao.selectCountByBusinessId(appealInfo);
        if (count > 0) {
            ajaxResult.setMsg("\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        long appealId = this.idWorker.nextId();
        Date now = new Date();
        appealInfo.setActive(Boolean.valueOf(true));
        appealInfo.setCreateTime(now);
        appealInfo.setUpdateTime(now);
        appealInfo.setUpdateBy(currentUser.getUsername());
        appealInfo.setAppealState("002");
        appealInfo.setId(Long.valueOf(appealId));
        String businessType = appealInfo.getBusinesstype();
        Long businessId = appealInfo.getBusinessid();
        if ("003".equals(businessType)) {
            PersonGrade personGrade = this.personGradeDao.findById(businessId);
            if (personGrade == null) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u62a5\u540d\u4fe1\u606f\u4e0d\u5b58\u5728");
                return ajaxResult;
            }
            appealInfo.setName(personGrade.getName());
            appealInfo.setIdnum(personGrade.getIdNum());
            appealInfo.setCompanyName(personGrade.getComName());
            appealInfo.setCompanyId(personGrade.getComId());
            Police police = this.policeDao.findByAreaCode(personGrade.getAreaCode());
            appealInfo.setAreaCode(personGrade.getAreaCode());
            appealInfo.setOrgId(police.getId());
            appealInfo.setOrgName(police.getOrgname());
        } else if ("002".equals(businessType)) {
            Personcertificate personCertificate = this.personcertificateDao.findById(businessId);
            if (personCertificate == null) {
                ajaxResult.setSuccessful(false);
                ajaxResult.setMsg("\u62a5\u540d\u4fe1\u606f\u4e0d\u5b58\u5728");
                return ajaxResult;
            }
            appealInfo.setName(personCertificate.getName());
            appealInfo.setIdnum(personCertificate.getCardnumber());
            appealInfo.setCompanyName(personCertificate.getCompanyname());
            appealInfo.setCompanyId(personCertificate.getCompanyid());
            Police police = this.policeDao.findByAreaCode(personCertificate.getDistrict());
            appealInfo.setAreaCode(personCertificate.getDistrict());
            appealInfo.setOrgId(police.getId());
            appealInfo.setOrgName(police.getOrgname());
        }
        this.appealDao.insert(appealInfo);
        ajaxResult.setData((Object)JwtUtil.createJWT((String)String.valueOf(appealId)));
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult queryBackgroundAppealResult(String appealId) {
        AjaxResult ajaxResult = new AjaxResult();
        String subject = JwtUtil.parseJWT((String)appealId).getSubject();
        String appealStatus = this.appealDao.findAppealStatusById(Long.valueOf(subject));
        ajaxResult.setData((Object)JwtUtil.createJWT((String)appealStatus));
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u6210\u529f");
        return ajaxResult;
    }

    public AjaxResult applyAppeal(Appeal appeal) {
        int count;
        AjaxResult ajaxResult = new AjaxResult();
        Personcertificate personcertificate = this.personcertificateDao.findById(appeal.getBusinessid());
        boolean b = this.checkCarNumRepeat(personcertificate);
        if (b) {
            ajaxResult.setMsg("\u8be5\u4eba\u5458\u5df2\u7ecf\u62a5\u540d\u8003\u8bd5\uff0c\u4e0d\u5f97\u8fdb\u884c\u7533\u8bc9!");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        appeal.setBusinesstype("002");
        if (!StringUtils.isEmpty((Object)personcertificate.getCardnumber())) {
            appeal.setIdnum(personcertificate.getCardnumber());
        }
        if ((count = this.appealDao.selectCountByBusIdAndNum(appeal)) > 0) {
            ajaxResult.setMsg("\u8be5\u4eba\u5458\u5b58\u5728\u7533\u8bc9\u4e2d\u8bb0\u5f55\uff0c\u4e0d\u53ef\u91cd\u590d\u63d0\u4ea4");
            ajaxResult.setSuccessful(false);
            return ajaxResult;
        }
        User currentUser = this.arsUtil.getCurrentUser();
        appeal.setActive(Boolean.valueOf(true));
        Date now = new Date();
        appeal.setCreateTime(now);
        appeal.setUpdateTime(now);
        appeal.setUpdateflag(Boolean.valueOf(true));
        appeal.setUpdateBy(currentUser == null ? "system" : currentUser.getUsername());
        appeal.setAppealState("002");
        long appealId = this.idWorker.nextId();
        appeal.setId(Long.valueOf(appealId));
        if (StringUtil.isNotEmpty((String)appeal.getAppealContext())) {
            appeal.setAppealContext(appeal.getAppealContext());
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getOrgid())) {
            appeal.setOrgId(personcertificate.getOrgid());
            Police police = this.policeDao.findById(personcertificate.getOrgid());
            if (!StringUtils.isEmpty((Object)police.getOrgname())) {
                appeal.setOrgName(police.getOrgname());
            }
            if (!StringUtils.isEmpty((Object)police.getAreacode())) {
                appeal.setAreaCode(police.getAreacode());
            }
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getCompanyid())) {
            appeal.setCompanyId(personcertificate.getCompanyid());
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getCompanyname())) {
            appeal.setCompanyName(personcertificate.getCompanyname());
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getCardnumber())) {
            appeal.setIdnum(personcertificate.getCardnumber());
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getName())) {
            appeal.setName(personcertificate.getName());
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getIdCardFront())) {
            appeal.setCardImgPositive(personcertificate.getIdCardFront());
        }
        if (!StringUtils.isEmpty((Object)personcertificate.getIdCardReverse())) {
            appeal.setCardImgBack(personcertificate.getIdCardReverse());
        }
        this.appealDao.insert(appeal);
        this.saveBusinesstype(personcertificate);
        ajaxResult.setSuccessful(true);
        ajaxResult.setMsg("\u63d0\u4ea4\u6210\u529f");
        return ajaxResult;
    }

    private void saveBusinesstype(Personcertificate personcertificate) {
        if ("61".equals(this.configUtils.getCurrentNative())) {
            personcertificate.setCensorStatus("005");
            personcertificate.setUpdateTime(new Date());
            personcertificate.setUpdateflag(Boolean.valueOf(true));
            this.personcertificateDaoAop.updateSelective(personcertificate);
        }
    }

    public boolean checkCarNumRepeat(Personcertificate personcertificate) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cardNum", personcertificate.getCardnumber());
        ArrayList<String> notIncludeStateList = new ArrayList<String>();
        notIncludeStateList.add("001");
        notIncludeStateList.add("004");
        notIncludeStateList.add("009");
        map.put("notincludestatelist", notIncludeStateList);
        map.put("filterId", personcertificate.getId());
        Personcertificate dbcheckpersoncertificate = this.personcertificateDao.checkCarNumRepeat(map);
        return null != dbcheckpersoncertificate;
    }

    public Appeal findOneByBusinessIdAndType(String businessid, String businesstype) {
        return this.appealDao.findOneByBusinessIdAndType(businessid, businesstype);
    }
}

