package com.bcxin.ars.service;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.TaskScheduleListDto;
import com.bcxin.ars.dto.task.TaskFeedBackDto;
import com.bcxin.ars.dto.task.TaskListDto;
import com.bcxin.ars.dto.task.TaskListSearchDto;
import com.bcxin.ars.model.task.TaskFeedback;
import com.bcxin.ars.service.task.TaskFeedbackService;
import com.bcxin.ars.service.task.TaskPersonService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;

import com.bcxin.ars.context.SecurityContext;
import com.bcxin.ars.dto.TaskSearchDto;
import com.bcxin.ars.model.SecurityCompanySchedule;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.model.task.TaskPerson;
import com.bcxin.ars.model.task.TaskPersonSchedule;
import com.bcxin.ars.service.task.TaskService;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(locations = { "classpath:/ars-service.xml" })
public class TaskServiceTest {

	@Autowired
	private TaskService taskService;

	@Autowired
	private TaskPersonService taskPersonService;
	@Autowired
	private TaskFeedbackService feedbackService;
	@Before
	public void begin() {
		User user = new User();
		user.setId(3l);
		user.setUsername("test");
		user.setRealname("test");
		user.setPlatform(1);
		SecurityContext.currentUser.set(user);
	}

	@Test
	public void testFindAll() {
		TaskSearchDto dto= new TaskSearchDto();
		dto.setPaging(false);
		dto.setPersonId(235l);
		TaskSearchDto data = taskService.searchForFeedback(dto);
		data.getPersonId();
		/*Task task = taskService.findById(1l);
		List<TaskPerson> taskPerson = new ArrayList<TaskPerson>();
		TaskPerson tp1 = new TaskPerson();
		SecurityPerson p1 = new SecurityPerson();
		p1.setId(6l);
		tp1.setPerson(p1);
		tp1.setTaskId(1l);
		List<TaskPersonSchedule> scheduleList = new ArrayList<TaskPersonSchedule>();
		List<SecurityCompanySchedule> detailList = new ArrayList<SecurityCompanySchedule>();
		SecurityCompanySchedule s1 = new SecurityCompanySchedule();
		s1.setId(2l);
		detailList.add(s1);
		SecurityCompanySchedule s2 = new SecurityCompanySchedule();
		s2.setId(3l);
		detailList.add(s2);
		TaskPersonSchedule tps1 = new TaskPersonSchedule();
		tps1.setTaskDate("2017-05-12");
		tps1.setScheduleDetail(detailList);
		scheduleList.add(tps1);
		TaskPersonSchedule tps2 = new TaskPersonSchedule();
		tps2.setTaskDate("2017-06-12");
		tps2.setScheduleDetail(detailList);
		scheduleList.add(tps2);
		tp1.setScheduleList(scheduleList);
		taskPerson.add(tp1);
		TaskPerson tp2 = new TaskPerson();
		SecurityPerson p2 = new SecurityPerson();
		p2.setId(7l);
		tp2.setPerson(p2);
		tp2.setTaskId(1l);
		List<TaskPersonSchedule> scheduleList2 = new ArrayList<TaskPersonSchedule>();
		List<SecurityCompanySchedule> detailList2 = new ArrayList<SecurityCompanySchedule>();
		detailList2.add(s1);
		detailList2.add(s2);
		TaskPersonSchedule tps3 = new TaskPersonSchedule();
		tps3.setTaskDate("2017-07-12");
		tps3.setScheduleDetail(detailList2);
		scheduleList2.add(tps1);
		TaskPersonSchedule tps4 = new TaskPersonSchedule();
		tps4.setTaskDate("2017-08-12");
		tps4.setScheduleDetail(detailList2);
		scheduleList2.add(tps4);
		tp2.setScheduleList(scheduleList2);
		taskPerson.add(tp2);
		task.setPersonList(taskPerson);
		task.setScheduleList(detailList);
		taskService.saveOrUpdate(task);*/
	}
	
	@Test
	public void testFindByPerson() {
		SecurityPerson person = new SecurityPerson();
		person.setId(6l);
		List<Task> list = taskService.findByPerson(person);
		System.out.println(list);
	}
	
	@Test
	public void testSearch() {
		TaskSearchDto dto = new TaskSearchDto();
		dto.setPageNum(0);
		dto.setNumPerPage(5);
		TaskSearchDto list = taskService.search(dto);
		List<Task> data = list.getData();
		Assert.assertTrue(data.size() > 0);
	}

	public void setCommonValue(Task t,TaskListDto dto){
		//任务类型
		dto.setTaskType(t.getTaskType());
		//任务ID
		dto.setTaskId(t.getId());
		//任务名称
		dto.setTaskName(t.getName());
		//任务详情
		dto.setTaskDetail(t.getDetail());
		//任务地址
		dto.setAddress(t.getAddress());

		//周期还是临时
		if(t.getTaskType()!=null&&t.getTaskType().getId()==1){
			if(t.isRepeat()==true){
				dto.setPeat(true);
			}else{
				dto.setPeat(false);
			}
		}
	}
	public double calcuCounttime(List<TaskFeedback> taskFeedbackList){
		double counttime=0;
		//计算总时长
		for(TaskFeedback taskFeedback:taskFeedbackList){
			if(taskFeedback!=null&&taskFeedback.getStartTime()!=null&&taskFeedback.getEndTime()!=null){
				counttime +=DateUtil.hourDiff1(taskFeedback.getStartTime(),taskFeedback.getEndTime(),"yyyy-MM-dd HH:mm:ss");
			}
		}
		return counttime;
	}
	@Test
	public void testTask(){
		long startTime=System.currentTimeMillis();   //获取开始时间
		TaskSearchDto taskSearchDto =new TaskSearchDto();
		taskSearchDto.setPersonId(138l);
		taskSearchDto.setAcceptStatus("2");
		taskSearchDto.setPaging(false);
		//获取用户的任务列表
		TaskSearchDto resultdto =taskService.findTaskListByPersonid(taskSearchDto);
		List<Task> taskList = resultdto.getData();


		List<TaskListDto> list = new ArrayList<>();

		for(Task t:taskList){
			TaskPerson taskPerson =taskPersonService.findStatusByTaskIdPersonId(t.getId(),taskSearchDto.getPersonId());

			//0-未接受（即新任务）
			if(taskPerson!=null&&taskPerson.getAcceptStatus()==0&&taskSearchDto.getAcceptStatus().equals(Constants.ACCEPTASKSTATUS_NEW)){
				TaskListDto dto =new TaskListDto();
				//任务状态
				dto.setTaskStatus(Constants.TASKSTATUS_NEW);
				dto.setStartDate(DateUtil.convertDateToString(t.getCreateTime(),"yyyy年MM月dd日 hh:mm"));
				setCommonValue(t,dto);
				//任务日期
				dto.setStartdateEnddate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getEndDate()),"yyyy年MM月dd日"));
				list.add(dto);

			}//2-已拒绝
			else if(taskPerson!=null&&taskPerson.getAcceptStatus()==2&&taskSearchDto.getAcceptStatus().equals(Constants.ACCEPTASKSTATUS_DENY)){
				TaskListDto dto =new TaskListDto();
				//任务状态
				dto.setTaskStatus(Constants.TASKSTATUS_DENY);
				dto.setStartDate(DateUtil.convertDateToString(t.getCreateTime(),"yyyy年MM月dd日 hh:mm"));
				setCommonValue(t,dto);
				//任务日期
				dto.setStartdateEnddate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getEndDate()),"yyyy年MM月dd日"));
				list.add(dto);

			}//3已完成
			else if(taskPerson!=null&&taskPerson.getAcceptStatus()==3&&taskSearchDto.getAcceptStatus().equals(Constants.ACCEPTASKSTATUS_FINISHALL)){
				TaskListDto dto =new TaskListDto();
				//计算执行时间
				List<TaskFeedback> taskFeedbackList =feedbackService.findAllFeedbackByTaskid(t.getId(),taskSearchDto.getPersonId());
				double counttime= calcuCounttime(taskFeedbackList);
				int fInt = (int) counttime;
				BigDecimal b1 = new BigDecimal(Double.toString(counttime));
				BigDecimal b2 = new BigDecimal(Integer.toString(fInt));
				float fPoint = b1.subtract(b2).floatValue();
				dto.setCountTime(fInt+"小时"+(int)(fPoint*60)+"分钟");
				//任务状态
				dto.setTaskStatus(Constants.TASKSTATUS_FINISHALL);
				//结束日期
				dto.setFinishDate(DateUtil.convertDateToString(t.getUpdateTime(),"yyyy年MM月dd日"));
				setCommonValue(t,dto);
				//任务日期
				dto.setStartdateEnddate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getEndDate()),"yyyy年MM月dd日"));
				list.add(dto);
			}//4超时
			else if(taskPerson!=null&&taskPerson.getAcceptStatus()==4&&taskSearchDto.getAcceptStatus().equals(Constants.ACCEPTASKSTATUS_DENY)){
				TaskListDto dto =new TaskListDto();
				//任务状态
				dto.setTaskStatus(Constants.TASKSTATUS_OVERTIME);
				dto.setStartDate(DateUtil.convertDateToString(t.getCreateTime(),"yyyy年MM月dd日 hh:mm"));
				setCommonValue(t,dto);
				//任务日期
				dto.setStartdateEnddate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getEndDate()),"yyyy年MM月dd日"));
				list.add(dto);
			}else if(taskPerson!=null&&taskPerson.getAcceptStatus()==1&&taskSearchDto.getAcceptStatus().equals(Constants.ACCEPTASKSTATUS_OTHER)){//1-已接受
				if(t.getTaskType()!=null&&t.getTaskType().getId()==4){//紧急任务
					List<TaskFeedback> taskFeedbackList =feedbackService.findUrgentFeedbackByTaskid(t.getId(),taskSearchDto.getPersonId());
					for(TaskFeedback taskFeedback:taskFeedbackList){
						TaskListDto dto =new TaskListDto();

						//紧急任务的接受日期
						dto.setAccepDate(DateUtil.convertDateToString(taskFeedback.getCreateTime(),"yyyy年MM月dd日 hh:mm"));
						//紧急任务的发布日期
						dto.setStartDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日 hh:mm"));


						if(taskFeedback.getTaskStatus()!=null&&taskFeedback.getTaskStatus().getId()==2){
							//正在执行，已执行时长为当前时间减去开始时间
							dto.setTaskStatus(Constants.TASKSTATUS_DOING);
							dto.setCountdownTime("已执行时长："+String.valueOf(DateUtil.hourDiff(taskFeedback.getStartTime(),new Date())));
						}else {
							//完成，已执行时长为结束时间减去开始时间
							dto.setTaskStatus(Constants.TASKSTATUS_FINISH);
							dto.setCountdownTime("已执行时长："+String.valueOf(DateUtil.hourDiff(taskFeedback.getStartTime(),taskFeedback.getEndTime())));

							//紧急任务结束日期
							dto.setFinishDate(DateUtil.convertDateToString(taskFeedback.getEndTime(),"yyyy年MM月dd日"));

						}
						setCommonValue(t,dto);
						list.add(dto);
						break;

					}

				}else if(t.getTaskType()!=null&&t.getTaskType().getId()==2){//临时任务
					//计算执行时间
					List<TaskFeedback> taskFeedbackList =feedbackService.findAllFeedbackByTaskid(t.getId(),taskSearchDto.getPersonId());
					List<TaskFeedback> taskFeedbackListOne =feedbackService.findFeedbackByTaskid(t.getId(),taskSearchDto.getPersonId());

					//计算执行时间
					double counttime= calcuCounttime(taskFeedbackList);
					int fInt = (int) counttime;
					BigDecimal b1 = new BigDecimal(Double.toString(counttime));
					BigDecimal b2 = new BigDecimal(Integer.toString(fInt));
					float fPoint = b1.subtract(b2).floatValue();
					//下一班次子任务信息
					TaskListDto dto =new TaskListDto();
					dto.setPersonId(taskSearchDto.getPersonId());
					dto.setTaskId(t.getId());
					TaskFeedBackDto taskFeedBackDto = feedbackService.findNextFeedBack_back(dto);
					//任务日期
					dto.setStartdateEnddate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getEndDate()),"yyyy年MM月dd日"));

					//循环子任务列表，返回正在执行的任务，有且只有一条
					for(TaskFeedback taskFeedback:taskFeedbackListOne){

						/*TaskFeedBackDto taskFeedBackDto1 = null;
						if(taskFeedback.getEndTime()!=null){
							dto.setFinishDate(DateUtil.convertDateToString(taskFeedback.getEndTime(),"yyyy-MM-dd hh:mm:ss"));
							taskFeedBackDto1 = feedbackService.findNextFeedBack_back(dto);
						}*/
						//执行状态
						if(taskFeedback.getTaskStatus()!=null&&taskFeedback.getTaskStatus().getId()==2){
							//正在执行
							dto.setTaskStatus(Constants.TASKSTATUS_DOING);
							//		dto.setCountdownTime("还有"+String.valueOf(DateUtil.dateDiff(new Date(),taskFeedback.getEndTime())*24)+"小时下班");
							//下一班次
							if(taskFeedBackDto!=null){
								dto.setNextScheduleDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+taskFeedBackDto.getDetails().get(0).getTaskStart()),"yyyy年MM月dd日 HH:mm")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate()+" "+taskFeedBackDto.getDetails().get(0).getTaskEnd()),"HH:mm"));
							}
							dto.setCountdownTime("已执行时长："+String.valueOf(DateUtil.hourDiff(taskFeedback.getStartTime(),new Date())));


						}//已结束
						else if((taskFeedBackDto==null&&taskFeedback.getStartTime()!=null&&taskFeedback.getEndTime()!=null&&taskFeedback.getTaskStatus().getId()==3)){
							dto.setTaskStatus(Constants.TASKSTATUS_FINISH);
							dto.setFinishDate(DateUtil.convertDateToString(t.getUpdateTime(),"yyyy年MM月dd日 hh:mm"));

							dto.setCountTime(fInt+"小时"+(int)(fPoint*60)+"分钟");

						}//即将开始
						else {
							dto.setTaskStatus(Constants.TASKSTATUS_TODO);
							String beginTime=String.valueOf(DateUtil.hourDiff(new Date(),DateUtil.convertStringToDate(taskFeedback.getTaskDate()+" "+taskFeedback.getTaskStart())));
							if(taskFeedback.getStartTime()!=null){
								if (taskFeedBackDto != null) {
									dto.setNextScheduleDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskStart()), "yyyy年MM月dd日 HH:mm") + "-" + DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskEnd()), "HH:mm"));
								}
								beginTime=String.valueOf(DateUtil.hourDiff(new Date(),DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskStart())));
								dto.setBeginTime("还有"+beginTime+"开始");
							}else{
								dto.setNextScheduleDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedback.getTaskDate()+" "+taskFeedback.getTaskStart()),"yyyy年MM月dd日 HH:mm")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedback.getTaskDate()+" "+taskFeedback.getTaskEnd()),"HH:mm"));
								if(!beginTime.equals("")){
									dto.setBeginTime("还有"+beginTime+"开始");
								}else{
									dto.setBeginTime("已迟到");
								}
							}


						}
						setCommonValue(t,dto);
						list.add(dto);
						break;
					}


				}else if(t.getTaskType()!=null&&t.getTaskType().getId()==1){//周期任务
					//周期子任务列表
					List<TaskFeedback> taskFeedbackList =feedbackService.findAllFeedbackByTaskid(t.getId(),taskSearchDto.getPersonId());
					List<TaskFeedback> taskFeedbackListOne =feedbackService.findFeedbackByTaskid(t.getId(),taskSearchDto.getPersonId());

					//计算执行时间
					double counttime= calcuCounttime(taskFeedbackList);
					int fInt = (int) counttime;
					BigDecimal b1 = new BigDecimal(Double.toString(counttime));
					BigDecimal b2 = new BigDecimal(Integer.toString(fInt));
					float fPoint = b1.subtract(b2).floatValue();
					//下一班次的子任务信息
					TaskListDto dto =new TaskListDto();
					dto.setPersonId(taskSearchDto.getPersonId());
					dto.setTaskId(t.getId());
					TaskFeedBackDto taskFeedBackDto = feedbackService.findNextFeedBack_back(dto);

					//任务日期
					if(t.isRepeat()==true){
						dto.setStartdateEnddate(DateUtil.convertDateToString(t.getCreateTime(),"yyyy年MM月dd日"));
					}else{
						// 获取Calendar
						Calendar calendar = Calendar.getInstance();
						// 设置时间,当前时间不用设置
						calendar.setTime(DateUtil.convertStringToDate(t.getEndDate()));
						// 设置日期为本月最大日期
						calendar.set(Calendar.DATE, calendar.getActualMaximum(Calendar.DATE));

						dto.setStartdateEnddate(DateUtil.convertDateToString(DateUtil.convertStringToDate(t.getStartDate()),"yyyy年MM月dd日")+"-"+DateUtil.convertDateToString(calendar.getTime(),"yyyy年MM月dd日"));
					}
					for(TaskFeedback taskFeedback:taskFeedbackListOne){
					/*	TaskFeedBackDto taskFeedBackDto1 = null;
						if(taskFeedback.getEndTime()!=null){
							dto.setFinishDate(DateUtil.convertDateToString(taskFeedback.getEndTime(),"yyyy-MM-dd hh:mm:ss"));
							taskFeedBackDto1 = feedbackService.findNextFeedBack_back(dto);
						}*/
						//正在执行,循环子任务列表，返回正在执行的任务，有且只有一条
						if(taskFeedback.getTaskStatus()!=null&&taskFeedback.getTaskStatus().getId()==2) {
							if (taskFeedBackDto != null) {
								dto.setNextScheduleDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskStart()), "yyyy年MM月dd日 HH:mm") + "-" + DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskEnd()), "HH:mm"));
							}

							dto.setTaskStatus(Constants.TASKSTATUS_DOING);
							//		dto.setCountdownTime("还有"+String.valueOf(DateUtil.dateDiff(new Date(),taskFeedback.getEndTime())*24)+"小时下班");
							dto.setCountdownTime("已执行时长：" + String.valueOf(DateUtil.hourDiff(taskFeedback.getStartTime(), new Date())));
						}
						else if((taskFeedBackDto==null&&taskFeedback.getStartTime()!=null&&taskFeedback.getEndTime()!=null&&taskFeedback.getTaskStatus().getId()==3)){
							dto.setTaskStatus(Constants.TASKSTATUS_FINISH);
							dto.setFinishDate(DateUtil.convertDateToString(t.getUpdateTime(),"yyyy年MM月dd日 hh:mm"));

							dto.setCountTime(fInt+"小时"+(int)(fPoint*60)+"分钟");

						}//即将开始，判断是否有下一班次，如果有，则返回相应信息
						else if(taskFeedback.getTaskStatus().getId()==1){
							dto.setTaskStatus(Constants.TASKSTATUS_TODO);
							String beginTime=String.valueOf(DateUtil.hourDiff(new Date(),DateUtil.convertStringToDate(taskFeedback.getTaskDate()+" "+taskFeedback.getTaskStart())));
							if(taskFeedback.getStartTime()!=null){
								if (taskFeedBackDto != null) {
									dto.setNextScheduleDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskStart()), "yyyy年MM月dd日 HH:mm") + "-" + DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskEnd()), "HH:mm"));
								}
								beginTime=String.valueOf(DateUtil.hourDiff(new Date(),DateUtil.convertStringToDate(taskFeedBackDto.getTaskDate() + " " + taskFeedBackDto.getDetails().get(0).getTaskStart())));
								dto.setBeginTime("还有"+beginTime+"开始");
							}else{
								dto.setNextScheduleDate(DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedback.getTaskDate()+" "+taskFeedback.getTaskStart()),"yyyy年MM月dd日 HH:mm")+"-"+DateUtil.convertDateToString(DateUtil.convertStringToDate(taskFeedback.getTaskDate()+" "+taskFeedback.getTaskEnd()),"HH:mm"));
								if(!beginTime.equals("")){
									dto.setBeginTime("还有"+beginTime+"开始");
								}else{
									dto.setBeginTime("已迟到");
								}
							}

						}
						setCommonValue(t,dto);
						list.add(dto);
						break;
					}
				}
			}
		}

		TaskListSearchDto searchDto = new TaskListSearchDto();
		searchDto.setData(list);
		searchDto.setTotalCount(resultdto.getTotalCount());
		searchDto.setPageNum(resultdto.getPageNum());
		searchDto.setNumPerPage(resultdto.getNumPerPage());



	 Collections.sort(list, new Comparator<TaskListDto>() {
			@Override
			public int compare(TaskListDto o1, TaskListDto o2) {
				int i = Integer.valueOf(o1.getTaskStatus()) - Integer.valueOf(o2.getTaskStatus());
				if (i == 0) {
					long t1 = 0,t2=0;
					if(o1.getNextScheduleDate()!=null){
						 t1 = DateUtil.parseDate(o1.getNextScheduleDate().substring(0, 17));
					}
				    if(o2.getNextScheduleDate()!=null){
						 t2 = DateUtil.parseDate(o2.getNextScheduleDate().substring(0, 17));
					}

					if (t1 > t2) {
						return 1;
					} else if (t1 < t2) {
						return -1;
					} else {
						return 0;
					}
				}

				return i;
		}
		});
		System.out.println(JSON.toJSONString(list));
		long endTime=System.currentTimeMillis(); //获取结束时间

		System.out.println("程序运行时间： "+(endTime-startTime)+"ms");

		//      System.out.print(list);
	}

	@Test
	public void testsort(){
		List<TaskListDto> list = new ArrayList<>();
		TaskListDto dto =new TaskListDto();
		dto.setTaskStatus("7");
		list.add(dto);
		TaskListDto dto1 =new TaskListDto();
		dto1.setTaskStatus("6");
		list.add(dto1);
		TaskListDto dto2 =new TaskListDto();
		dto2.setTaskStatus("8");
		list.add(dto2);

		System.out.println(JSON.toJSONString(list));
		Collections.sort(list, new Comparator<TaskListDto>() {
			@Override
			public int compare(TaskListDto o1, TaskListDto o2) {
				int i = Integer.valueOf(o1.getTaskStatus()) - Integer.valueOf(o2.getTaskStatus());
				return i;
			}
		});
		System.out.println(JSON.toJSONString(list));

		//      System.out.print(list);

	}

}
