package com.bcxin.ars.service.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.nx.NXIntegratedBaseDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dao.sb.ShareholderDao;
import com.bcxin.ars.dao.sys.ApprovalDAO;
import com.bcxin.ars.dao.sys.ApprovalLogDao;
import com.bcxin.ars.dto.nx.*;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.*;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.util.MD5Util;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.nx.NXIntegratedConstants;
import com.bcxin.ars.util.text.StringUtils;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.*;

@Component
public class NXIntegratedInterfaceUtil {
    /**
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(NXIntegratedInterfaceUtil.class);

    @Value("${nx_integrated_clientId}")
    private String clientId;

    @Value("${nx_integrated_password}")
    private String password;

    @Value("${nx_integrated_url}")
    private String url;
    @Autowired
    private UserDao userDao;
    @Autowired
    private PoliceDao policeDao;
    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Autowired
    private ShareholderDao shareholderDao;
    @Autowired
    private ApprovalDAO approvalDAO;
    @Autowired
    private ApprovalLogDao approvalLogDao;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;


    @Autowired
    private NXIntegratedBaseDao nxIntegratedBaseDao;







    /*public void save(NXIntegratedParameter nxIntegratedParameter) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId",clientId);
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("hhmmss");
        SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dFormat=new SimpleDateFormat("yyyyMMdd");
        String date=simpleDateFormat.format(new Date());
        params.put("timespan",date);
        params.put("sign", MD5Util.encode(clientId+"|"+password+"|"+date));
        UpProAccept upProAccept=new UpProAccept();
        UpProResult upProResult=new UpProResult();
        List<UpProMaterial> upProMaterials=new ArrayList<>();
        List<UpProProcess> upProProcesses=new ArrayList<>();
        List<UpProsPecialProcedure> upProsPecialProcedures=new ArrayList<>();
        String businessType=nxIntegratedParameter.getBusinessType();
        if (businessType.equals("001")) {//保安服务公司许可证
            List<Sponsorlicense> sponsorlicenses=nxIntegratedParameter.getSponsorlicenses();
            for (Sponsorlicense sponsorlicense:sponsorlicenses) {
                String createDate=dateFormat.format(sponsorlicense.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyerType(NXIntegratedConstants.ApplyerType);//申请类型
                User user=userDao.findById(sponsorlicense.getUserid());
                upProAccept.setApplyerName(user.getUsername());
                upProAccept.setApplyerPageCode(user.getIdNumber());
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(sponsorlicense.getAreaCode());
                upProAccept.setCatalogCode(NXIntegratedConstants.SponsorlicenseCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(sponsorlicense.getPhone());
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(sponsorlicense.getCompanyname());
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.SponsorlicenseCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.SponsorlicenseLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.SponsorlicenseLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.SponsorlicenseLocalCode);
                upProAccept.setOrgCode(NXIntegratedConstants.SponsorlicenseOrgCode);
                upProAccept.setOrgName(getPoliceName(sponsorlicense.getOrgid()));
                String da=dFormat.format(sponsorlicense.getCreateTime());
                upProAccept.setProjectNo(NXIntegratedConstants.SponsorlicenseTaskCode+da+getProjectNo(NXIntegratedConstants.SponsorlicenseBH));
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(dateFormat.format(getPromiseDate(sponsorlicense.getCreateTime(),businessType)));
                upProAccept.setPromiseTime(NXIntegratedConstants.SponsorlicensePromiseTime);
                upProAccept.setRowGuid(sponsorlicense.getId()+"");
                upProAccept.setTaskCode(NXIntegratedConstants.SponsorlicenseTaskCode);
                upProAccept.setTaskName(NXIntegratedConstants.SponsorlicenseTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(NXIntegratedConstants.SponsorlicenseTaskHandleItem);
                upProAccept.setCompanyCode(getCompanyCode(sponsorlicense.getId().toString()));
                upProAccept.setHandleUserId(sponsorlicense.getUserid().toString());
                upProAccept.setFileId(NXIntegratedConstants.SponsorlicenseFileId);
                //办件过程信息
                List<ApprovalLog> logList=getApprovalLog(sponsorlicense.getId().toString());
                for (ApprovalLog approvalLog:logList) {
                    UpProProcess upProProcess=new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(dateFormat.format(approvalLog.getCreateTime()));
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(dateFormat.format(approvalLog.getApprovaldate()));
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(dateFormat.format(approvalLog.getCreateTime()));
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason());
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson());
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId());
                    upProProcess.setProcessName(getProcessName(""+approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo(approvalLog.getApprovalid());
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid());
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                Approval approval = approvalDAO.findBybusinessidAndType(sponsorlicense.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(dateFormat.format(approval.getCreateTime()));
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(approval.getApprovalperson());
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo(approval.getId().toString());
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(dateFormat.format(approval.getApprovaldate()));
                upProResult.setResultExplain(approval.getApprovalreason());
                upProResult.setResultType(getResultType(approval.getApprovalstate()));
                upProResult.setRowGuid(approval.getId().toString());

                //材料信息
                UpProMaterial upProMaterial=new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(dateFormat.format(sponsorlicense.getCreateTime()));
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyerType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(sponsorlicense.getTemplateRar()));
                upProMaterial.setProjectNo(sponsorlicense.getId().toString());
                upProMaterial.setRowGuid(sponsorlicense.getId().toString());
                upProMaterial.setUrl(sponsorlicense.getTemplateRar());
                upProMaterials.add(upProMaterial);

                params.put("upProAccept",upProAccept);
                params.put("upProResult",upProResult);
                params.put("upProMaterial",upProMaterials);
                params.put("upProProcess",upProProcesses);
                params.put("upProsPecialProcedure",upProsPecialProcedures);
                String strXML= HttpUtil.post(url + NXIntegratedConstants.APPLYINFO, params);
            }


        } else if (businessType.equals("002")) {//保安培训单位许可证

        } else if (businessType.equals("003")) {//保安服务公司设立分公司备案

        }else if (businessType.equals("004")) {//资格证报名

        } else if (businessType.equals("005")) {//保安跨区域服务备案

        } else if (businessType.equals("006")) {//自行招用保安员单位备案

        } else if (businessType.equals("007")) {//保安服务（培训）许可证项目变更

        }




    }*/

    private String getMaterialName(String templateRar) {
        if (StringUtil.isEmpty(templateRar)){
            return "";
        }else {
            String[] split = templateRar.split("\\/");
            String lastName = split[split.length - 1];
            return lastName;
        }


    }

    private String formatDate(Date date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        if (date == null) {
            return "";
        } else {
            return dateFormat.format(date);
        }
    }


    private String getResultType(String approvalstate) {
        String str = "";
        if (approvalstate.equals("003")) {
            str = "1";
        } else if (approvalstate.equals("004")) {
            str = "0";
        } else if (approvalstate.equals("005")) {
            str = "2";
        } else if (approvalstate.equals("005")) {
            str = "3";
        } else {
            str = "2";
        }
        return str;
    }

    private String getProcessName(String approvalstate) {
        if (approvalstate.equals("")) {
            return "受理";
        } else {
            return "办结";
        }
    }

    private String getEventName(String approvalstate) {
        String str = "";
        if (approvalstate.equals("003")) {
            str = "1";
        } else if (approvalstate.equals("004")) {
            str = "2";
        } else {
            str = "9";
        }
        return str;
    }

    private List<ApprovalLog> getApprovalLog(String id) {
        return approvalLogDao.findByApprovalId(id);
    }

    private Date getPromiseDate(Date createTime, String s) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(createTime);
        if (s.equals("001")) {
            calendar.add(calendar.DATE, 10);
        } else if (s.equals("002")) {
            calendar.add(calendar.DATE, 10);
        } else if (s.equals("003")) {
            calendar.add(calendar.DATE, 5);
        } else if (s.equals("004")) {
            calendar.add(calendar.DATE, 10);
        } else if (s.equals("005")) {
            calendar.add(calendar.DATE, 7);
        } else if (s.equals("006")) {
            calendar.add(calendar.DATE, 5);
        } else if (s.equals("007")) {
            calendar.add(calendar.DATE, 10);
        }

        return calendar.getTime();

    }

    private String getCompanyCode(String sid) {
        List<Shareholder> shareholders = shareholderDao.findBySId(sid);
        if (shareholders.size() > 0) {
            return shareholders.get(0).getSocialCode();
        }
        return "";
    }

    private String ApplyerPageType(Integer i) {
        String str = "";
        if (i == 4) {
            str = NXIntegratedConstants.ApplyerPageType111;
        } else if (i == 2) {
            str = NXIntegratedConstants.ApplyerPageType003;
        }
        return str;
    }

    public String getApplyerType(Integer i) {
        String str = "";
        if (i == 4) {
            str = "1";
        } else if (i == 2) {
            str = "2";
        }
        return str;
    }

    public String getPoliceName(Long i) {
        return policeDao.findById(i).getOrgname();
    }

    public String getProjectNo(String bh) {
        int num = personcertificateDao.getNextVal(bh);
        return String.format("%04d", num);
    }

    /*public void pushBase(List<Sponsorlicense> sponsorlicenses, String businessType) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId",clientId);
        SimpleDateFormat simpleDateFormat=new SimpleDateFormat("hhmmss");
        SimpleDateFormat dateFormat=new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat dFormat=new SimpleDateFormat("yyyyMMdd");
        String date=simpleDateFormat.format(new Date());
        params.put("timespan",date);
        params.put("sign", MD5Util.encode(clientId+"|"+password+"|"+date));
        UpProAccept upProAccept=new UpProAccept();
        UpProResult upProResult=new UpProResult();
        List<UpProMaterial> upProMaterials=new ArrayList<>();
        List<UpProProcess> upProProcesses=new ArrayList<>();
        List<UpProsPecialProcedure> upProsPecialProcedures=new ArrayList<>();
        for (Sponsorlicense sponsorlicense:sponsorlicenses) {
            String createDate=dateFormat.format(sponsorlicense.getCreateTime());
            //办件受理信息
            upProAccept.setAcceptDate(createDate);
            upProAccept.setApplyDate(createDate);
            upProAccept.setApplyerType(NXIntegratedConstants.ApplyerType);//申请类型
            User user=userDao.findById(sponsorlicense.getUserid());
            upProAccept.setApplyerName(user.getUsername());
            upProAccept.setApplyerPageCode(user.getIdNumber());
            upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
            upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
            upProAccept.setAreaId(sponsorlicense.getAreaCode());
            upProAccept.setCatalogCode(NXIntegratedConstants.SponsorlicenseCatalogCode);
            upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
            upProAccept.setCdTime(createDate);
            upProAccept.setContractMobile(sponsorlicense.getPhone());
            upProAccept.setDataSource(NXIntegratedConstants.DataSource);
            upProAccept.setEnterpriseName(sponsorlicense.getCompanyname());
            upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
            upProAccept.setLocalCatalogCode(NXIntegratedConstants.SponsorlicenseCatalogCode);
            upProAccept.setLocalItemCode(NXIntegratedConstants.SponsorlicenseLocalCode);
            upProAccept.setLocalProjectNo(NXIntegratedConstants.SponsorlicenseLocalCode);
            upProAccept.setLocalTaskCode(NXIntegratedConstants.SponsorlicenseLocalCode);
            upProAccept.setOrgCode(NXIntegratedConstants.SponsorlicenseOrgCode);
            upProAccept.setOrgName(getPoliceName(sponsorlicense.getOrgid()));
            String da=dFormat.format(sponsorlicense.getCreateTime());
            upProAccept.setProjectNo(NXIntegratedConstants.SponsorlicenseTaskCode+da+getProjectNo(NXIntegratedConstants.SponsorlicenseBH));
            upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
            upProAccept.setPromiseDate(dateFormat.format(getPromiseDate(sponsorlicense.getCreateTime(),businessType)));
            upProAccept.setPromiseTime(NXIntegratedConstants.SponsorlicensePromiseTime);
            upProAccept.setRowGuid(sponsorlicense.getId()+"");
            upProAccept.setTaskCode(NXIntegratedConstants.SponsorlicenseTaskCode);
            upProAccept.setTaskName(NXIntegratedConstants.SponsorlicenseTaskName);
            upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
            upProAccept.setTaskHandleItem(NXIntegratedConstants.SponsorlicenseTaskHandleItem);
            upProAccept.setCompanyCode(getCompanyCode(sponsorlicense.getId().toString()));
            upProAccept.setHandleUserId(sponsorlicense.getUserid().toString());
            upProAccept.setFileId(NXIntegratedConstants.SponsorlicenseFileId);
            //材料信息
            UpProMaterial upProMaterial=new UpProMaterial();
            upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
            upProMaterial.setCdTime(dateFormat.format(sponsorlicense.getCreateTime()));
            upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
            upProMaterial.setGetType(NXIntegratedConstants.ApplyerType);
            upProMaterial.setMaterialAttachName("无");
            upProMaterial.setMaterialName(getMaterialName(sponsorlicense.getTemplateRar()));
            upProMaterial.setProjectNo(sponsorlicense.getId().toString());
            upProMaterial.setRowGuid(sponsorlicense.getId().toString());
            upProMaterial.setUrl(sponsorlicense.getTemplateRar());
            upProMaterials.add(upProMaterial);

            params.put("upProAccept",upProAccept);
            params.put("upProResult",upProResult);
            params.put("upProMaterial",upProMaterials);
            params.put("upProProcess",upProProcesses);
            params.put("upProsPecialProcedure",upProsPecialProcedures);
            String strXML= HttpUtil.post(url + NXIntegratedConstants.APPLYINFO, params);
        }

    }
*/
    public void pushAllSponsorlicense(List<Sponsorlicense> sponsorlicenses, String businessType) {
        logger.error("宁夏一体化开始传数据，用户名" + clientId + "，密码：" + password + "，地址：" + url);
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");
        for (Sponsorlicense sponsorlicense : sponsorlicenses) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();

                String createDate = formatDate(sponsorlicense.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型
                User user = userDao.findById(sponsorlicense.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(sponsorlicense.getLegalPersonNo() + "");
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(sponsorlicense.getDistrict() +"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.SponsorlicenseCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(sponsorlicense.getPhone() + "");
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(sponsorlicense.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.SponsorlicenseCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.SponsorlicenseLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.SponsorlicenseLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.SponsorlicenseLocalCode);
                upProAccept.setOrgCode(getSponsorlicenseOrgCode(sponsorlicense.getCity()));
                upProAccept.setOrgName(getPoliceName(sponsorlicense.getOrgid()));
                String da = dFormat.format(sponsorlicense.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.SponsorlicenseBH);
                upProAccept.setProjectNo("64"+getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(sponsorlicense.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime(NXIntegratedConstants.SponsorlicensePromiseTime);
                upProAccept.setRowGuid(sponsorlicense.getId() + "");
                upProAccept.setTaskCode(getSponsorlicenseTaskCode(sponsorlicense.getCity()));
                upProAccept.setTaskName(NXIntegratedConstants.SponsorlicenseTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(getSponsorlicenseTaskCode(sponsorlicense.getCity())+"01");
                upProAccept.setCompanyCode(getCompanyCode(sponsorlicense.getId().toString()));
                upProAccept.setHandleUserId(sponsorlicense.getUserid().toString());
                upProAccept.setFileId(getSponsorlicenseFileId(sponsorlicense.getCity()));
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(sponsorlicense.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()));
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()));
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()));
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64"+getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da +
                            ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                Approval approval = approvalDAO.findBybusinessidAndType(sponsorlicense.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da +
                        ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(getResultType(approval.getApprovalstate()) + "");
                upProResult.setRowGuid(approval.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(sponsorlicense.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(sponsorlicense.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64"+getSponsorlicenseTaskCode(sponsorlicense.getCity()) + da +
                        ta);
                upProMaterial.setRowGuid(sponsorlicense.getId().toString() + "");
                upProMaterial.setUrl(sponsorlicense.getTemplateRar() + "");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("" + sponsorlicense.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(sponsorlicense.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("sponsorlicense" + sponsorlicense.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }

        }

    }

    private String getSponsorlicenseFileId(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SponsorlicenseFileIdYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SponsorlicenseFileIdSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SponsorlicenseFileIdWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SponsorlicenseFileIdGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SponsorlicenseFileIdZW;
        }else {
            str=NXIntegratedConstants.SponsorlicenseFileIdZZQ;
        }
        return str;
    }

    private String getSponsorlicenseTaskCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SponsorlicenseTaskCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SponsorlicenseTaskCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SponsorlicenseTaskCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SponsorlicenseTaskCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SponsorlicenseTaskCodeZW;
        }else {
            str=NXIntegratedConstants.SponsorlicenseTaskCodeZZQ;
        }
        return str;
    }

    private String getSponsorlicenseOrgCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SponsorlicenseOrgCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SponsorlicenseOrgCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SponsorlicenseOrgCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SponsorlicenseOrgCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SponsorlicenseOrgCodeZW;
        }else {
            str=NXIntegratedConstants.SponsorlicenseOrgCodeZZQ;
        }
        return str;
    }

    public void pushAllTraincompanyapply(List<Traincompanyapply> traincompanyapplies, String businessType) {

        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");

        for (Traincompanyapply traincompanyapply : traincompanyapplies) {
            try {

                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();

                String createDate = formatDate(traincompanyapply.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型
                User user = userDao.findById(traincompanyapply.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(traincompanyapply.getLegalcode()+ "");
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(traincompanyapply.getDistrict() +"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.TraincompanyapplyCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(traincompanyapply.getLegalphone() + "");
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(traincompanyapply.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.TraincompanyapplyCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.TraincompanyapplyLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.TraincompanyapplyLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.TraincompanyapplyLocalCode);
                upProAccept.setOrgCode(NXIntegratedConstants.TraincompanyapplyOrgCode);
                upProAccept.setOrgName(getPoliceName(traincompanyapply.getOrgid()) + "");
                String da = dFormat.format(traincompanyapply.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.TraincompanyapplyBH);
                upProAccept.setProjectNo("64"+NXIntegratedConstants.TraincompanyapplyTaskCode + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(traincompanyapply.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime(NXIntegratedConstants.TraincompanyapplyPromiseTime);
                upProAccept.setRowGuid(traincompanyapply.getId() + "");
                upProAccept.setTaskCode(NXIntegratedConstants.TraincompanyapplyTaskCode);
                upProAccept.setTaskName(NXIntegratedConstants.TraincompanyapplyTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(NXIntegratedConstants.TraincompanyapplyTaskHandleItem);
                upProAccept.setCompanyCode(traincompanyapply.getBusinessnumber()+ "");
                upProAccept.setHandleUserId(traincompanyapply.getUserid().toString() + "");
                upProAccept.setFileId(NXIntegratedConstants.TraincompanyapplyFileId);
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(traincompanyapply.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()) + "");
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()) + "");
                    upProProcess.setProjectNo("64"+NXIntegratedConstants.TraincompanyapplyTaskCode + da +
                            ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                Approval approval = approvalDAO.findBybusinessidAndType(traincompanyapply.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+NXIntegratedConstants.TraincompanyapplyTaskCode + da +
                        ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(getResultType(approval.getApprovalstate()) + "");
                upProResult.setRowGuid(approval.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(traincompanyapply.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(traincompanyapply.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64"+NXIntegratedConstants.TraincompanyapplyTaskCode + da +
                        ta);
                upProMaterial.setRowGuid(traincompanyapply.getId().toString() + "");
                upProMaterial.setUrl(traincompanyapply.getTemplateRar() + "");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("traincompanyapply" + traincompanyapply.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(traincompanyapply.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("traincompanyapply" + traincompanyapply.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }

    }

    public void pushAllSubsidiary(List<Subsidiary> subsidiaries, String businessType) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");

        for (Subsidiary subsidiary : subsidiaries) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();

                String createDate = formatDate(subsidiary.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型
                User user = userDao.findById(subsidiary.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(subsidiary.getLegalcardnumber()+ "");
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(subsidiary.getDistrict() +"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.SubsidiaryCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(subsidiary.getLegalphone() + "");
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(subsidiary.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.SubsidiaryCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.SubsidiaryLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.SubsidiaryLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.SubsidiaryLocalCode);
                upProAccept.setOrgCode(getSubsidiaryOrgCode(subsidiary.getCity()));
                upProAccept.setOrgName(getPoliceName(subsidiary.getOrgid()) + "");
                String da = dFormat.format(subsidiary.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.SubsidiaryBH);
                upProAccept.setProjectNo("64"+getSubsidiaryTaskCode(subsidiary.getCity()) + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(subsidiary.getCreateTime(), businessType)));
                upProAccept.setPromiseTime(NXIntegratedConstants.SubsidiaryPromiseTime);
                upProAccept.setRowGuid(subsidiary.getId() + "");
                upProAccept.setTaskCode(getSubsidiaryTaskCode(subsidiary.getCity()));
                upProAccept.setTaskName(NXIntegratedConstants.SubsidiaryTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(getSubsidiaryTaskHandleItem(subsidiary.getCity()));
                upProAccept.setCompanyCode(subsidiary.getCreditcode() + "");
                upProAccept.setHandleUserId(subsidiary.getUserid().toString());
                upProAccept.setFileId(getSubsidiaryFileId(subsidiary.getCity()));
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(subsidiary.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()) + "");
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()) + "");
                    upProProcess.setProjectNo("64"+getSubsidiaryTaskCode(subsidiary.getCity()) + da +ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                Approval approval = approvalDAO.findBybusinessidAndType(subsidiary.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+getSubsidiaryTaskCode(subsidiary.getCity()) + da +ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(getResultType(approval.getApprovalstate()) + "");
                upProResult.setRowGuid(approval.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(subsidiary.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(subsidiary.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64"+getSubsidiaryTaskCode(subsidiary.getCity()) + da +ta);
                upProMaterial.setRowGuid(subsidiary.getId().toString() + "");
                upProMaterial.setUrl(subsidiary.getTemplateRar() + "");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("subsidiary" + subsidiary.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(subsidiary.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("subsidiary" + subsidiary.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private String getSubsidiaryFileId(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SubsidiaryFileIdYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SubsidiaryFileIdSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SubsidiaryFileIdWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SubsidiaryFileIdGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SubsidiaryFileIdZW;
        }else {

        }
        return str;
    }

    private String getSubsidiaryTaskHandleItem(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SubsidiaryTaskCodeYC+"01";
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SubsidiaryTaskCodeSZS+"01";
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SubsidiaryTaskCodeWZ+"01";
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SubsidiaryTaskCodeGY+"01";
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SubsidiaryTaskCodeZW+"01";
        }else {

        }
        return str;
    }

    private String getSubsidiaryTaskCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SubsidiaryTaskCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SubsidiaryTaskCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SubsidiaryTaskCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SubsidiaryTaskCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SubsidiaryTaskCodeZW;
        }else {

        }
        return str;
    }

    private String getSubsidiaryOrgCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.SubsidiaryOrgCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.SubsidiaryOrgCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.SubsidiaryOrgCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.SubsidiaryOrgCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.SubsidiaryOrgCodeZW;
        }else {

        }
        return str;
    }

    public void pushAllPersoncertificate(List<Personcertificate> personcertificates, String businessType) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");

        for (Personcertificate personcertificate : personcertificates) {
            try {
                String time = System.currentTimeMillis() + "";
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();


                String createDate = formatDate(personcertificate.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型

                upProAccept.setApplyerName(personcertificate.getName());
                upProAccept.setApplyerPageCode(personcertificate.getCardnumber());
                upProAccept.setApplyerPageType("111");//申请人证件类型
                upProAccept.setApplyerType("1");
                upProAccept.setAreaId(personcertificate.getDistrict() +"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.PersoncertificateCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(personcertificate.getPhone() + "");
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(personcertificate.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.PersoncertificateCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.PersoncertificateLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.PersoncertificateLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.PersoncertificateLocalCode);
                upProAccept.setOrgCode(getPersoncertificateOrgCode(personcertificate.getCity()));
                upProAccept.setOrgName(personcertificate.getSzss() + "");
                String da = dFormat.format(personcertificate.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.PersoncertificateBH);
                upProAccept.setProjectNo("64"+getPersoncertificateTaskCode(personcertificate.getCity()) + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(personcertificate.getCreateTime(), businessType)));
                upProAccept.setPromiseTime(NXIntegratedConstants.PersoncertificatePromiseTime);
                upProAccept.setRowGuid(personcertificate.getId() + "");
                upProAccept.setTaskCode(getPersoncertificateTaskCode(personcertificate.getCity()));
                upProAccept.setTaskName(NXIntegratedConstants.PersoncertificateTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(getPersoncertificateTaskHandleItem(personcertificate.getCity()));
                upProAccept.setCompanyCode(getCCode(personcertificate.getCompanyid()) + "");
                upProAccept.setHandleUserId(personcertificate.getUpdateBy());
                upProAccept.setFileId(getPersoncertificateFileId(personcertificate.getCity()));
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(personcertificate.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()) + "");
                    upProProcess.setProjectNo("64"+getPersoncertificateTaskCode(personcertificate.getCity()) + da +ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(personcertificate.getUpdateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+getPersoncertificateTaskCode(personcertificate.getCity()) + da +ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(personcertificate.getUpdateTime()) + "");
                upProResult.setResultExplain("无");
                upProResult.setResultType(getResultType(personcertificate.getApprovalstate()));
                upProResult.setRowGuid(personcertificate.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(personcertificate.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName("无");
                upProMaterial.setProjectNo("64"+getPersoncertificateTaskCode(personcertificate.getCity()) + da +ta);
                upProMaterial.setRowGuid(personcertificate.getId().toString() + "");
                upProMaterial.setUrl("无");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("personcertificate" + personcertificate.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(personcertificate.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(personcertificate.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("personcertificate" + personcertificate.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private String getPersoncertificateFileId(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.PersoncertificateFileIdYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.PersoncertificateFileIdSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.PersoncertificateFileIdWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.PersoncertificateFileIdGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.PersoncertificateFileIdZW;
        }else {
        }
        return str;
    }

    private String getPersoncertificateTaskHandleItem(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.PersoncertificateTaskCodeYC+"01";
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.PersoncertificateTaskCodeSZS+"01";
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.PersoncertificateTaskCodeWZ+"01";
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.PersoncertificateTaskCodeGY+"01";
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.PersoncertificateTaskCodeZW+"01";
        }else {
        }
        return str;
    }

    private String getPersoncertificateTaskCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.PersoncertificateTaskCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.PersoncertificateTaskCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.PersoncertificateTaskCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.PersoncertificateTaskCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.PersoncertificateTaskCodeZW;
        }else {
        }
        return str;
    }

    private String getPersoncertificateOrgCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.PersoncertificateOrgCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.PersoncertificateOrgCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.PersoncertificateOrgCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.PersoncertificateOrgCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.PersoncertificateOrgCodeZW;
        }else {
        }
        return str;
    }

    public void pushAllCrosscompany(List<Crosscompany> crosscompanies, String businessType) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");

        for (Crosscompany crosscompany : crosscompanies) {
            try {
                String time = System.currentTimeMillis() + "";
                logger.error("时间戳" + time);
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();

                String createDate = formatDate(crosscompany.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型
                User user = userDao.findById(crosscompany.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(crosscompany.getLegalcardnumber());
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(crosscompany.getDistrict() +"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.CrosscompanyCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(crosscompany.getLegalphone() + "");
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(crosscompany.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.CrosscompanyCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.CrosscompanyLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.CrosscompanyLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.CrosscompanyLocalCode);
                upProAccept.setOrgCode(getCrosscompanyOrgCode(crosscompany.getCity()));
                upProAccept.setOrgName(getPoliceName(crosscompany.getOrgid()) + "");
                String da = dFormat.format(crosscompany.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.CrosscompanyBH);
                upProAccept.setProjectNo("64"+getCrosscompanyTaskCode(crosscompany.getCity()) + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(crosscompany.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime(NXIntegratedConstants.CrosscompanyPromiseTime);
                upProAccept.setRowGuid(crosscompany.getId() + "");
                upProAccept.setTaskCode(getCrosscompanyTaskCode(crosscompany.getCity()));
                upProAccept.setTaskName(NXIntegratedConstants.CrosscompanyTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(getCrosscompanyTaskHandleItem(crosscompany.getCity()));
                upProAccept.setCompanyCode(crosscompany.getCreditcode());
                upProAccept.setHandleUserId(crosscompany.getUserid().toString() + "");
                upProAccept.setFileId(getCrosscompanyFileId(crosscompany.getCity()));
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(crosscompany.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64"+getCrosscompanyTaskCode(crosscompany.getCity()) + da +ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                // Approval approval = approvalDAO.findBybusinessidAndType(crosscompany.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(crosscompany.getCreateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+getCrosscompanyTaskCode(crosscompany.getCity()) + da +ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(crosscompany.getUpdateTime()));
                upProResult.setResultExplain("无");
                upProResult.setResultType(getResultType(crosscompany.getApprovalstate()));
                upProResult.setRowGuid(crosscompany.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(crosscompany.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(crosscompany.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64"+getCrosscompanyTaskCode(crosscompany.getCity()) + da +ta);
                upProMaterial.setRowGuid(crosscompany.getId().toString() + "");
                upProMaterial.setUrl(crosscompany.getTemplateRar() + "");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("crosscompany" + crosscompany.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(crosscompany.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(crosscompany.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("crosscompany" + crosscompany.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private String getCrosscompanyFileId(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.CrosscompanyFileIdYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.CrosscompanyFileIdSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.CrosscompanyFileIdWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.CrosscompanyFileIdGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.CrosscompanyFileIdZW;
        }else {
        }
        return str;
    }

    private String getCrosscompanyTaskHandleItem(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.CrosscompanyTaskCodeYC+"01";
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.CrosscompanyTaskCodeSZS+"01";
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.CrosscompanyTaskCodeWZ+"01";
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.CrosscompanyTaskCodeGY+"01";
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.CrosscompanyTaskCodeZW+"01";
        }else {
        }
        return str;
    }

    private String getCrosscompanyTaskCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.CrosscompanyTaskCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.CrosscompanyTaskCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.CrosscompanyTaskCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.CrosscompanyTaskCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.CrosscompanyTaskCodeZW;
        }else {
        }
        return str;
    }

    private String getCrosscompanyOrgCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.CrosscompanyOrgCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.CrosscompanyOrgCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.CrosscompanyOrgCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.CrosscompanyOrgCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.CrosscompanyOrgCodeZW;
        }else {
        }
        return str;
    }

    public void pushAllConfesscompany(List<Confesscompany> confesscompanies, String businessType) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");

        for (Confesscompany confesscompany : confesscompanies) {
            try {
                String time = System.currentTimeMillis() + "";
                logger.error("时间戳" + time);
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();

                String createDate = formatDate(confesscompany.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型
                User user = userDao.findById(confesscompany.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(confesscompany.getLegalcardnumber()+ "");
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(confesscompany.getDistrict() +"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.SubsidiaryCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(confesscompany.getLegalphone() + "");
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(confesscompany.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.SubsidiaryCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.SubsidiaryLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.SubsidiaryLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.SubsidiaryLocalCode);
                upProAccept.setOrgCode(getSubsidiaryOrgCode(confesscompany.getCity()));
                upProAccept.setOrgName(getPoliceName(confesscompany.getOrgid()) + "");
                String da = dFormat.format(confesscompany.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.ConfesscompanyBH);
                upProAccept.setProjectNo("64"+getSubsidiaryTaskCode(confesscompany.getCity()) + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(confesscompany.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime(NXIntegratedConstants.SubsidiaryPromiseTime);
                upProAccept.setRowGuid(confesscompany.getId() + "");
                upProAccept.setTaskCode(getSubsidiaryTaskCode(confesscompany.getCity()));
                upProAccept.setTaskName(NXIntegratedConstants.SubsidiaryTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(getSubsidiaryTaskHandleItem(confesscompany.getCity()));
                upProAccept.setCompanyCode(confesscompany.getCreditcode() + "");
                upProAccept.setHandleUserId(confesscompany.getUserid().toString() + "");
                upProAccept.setFileId(getSubsidiaryFileId(confesscompany.getCity()));
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(confesscompany.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64"+getSubsidiaryTaskCode(confesscompany.getCity()) + da +ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                Approval approval = approvalDAO.findBybusinessidAndType(confesscompany.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+getSubsidiaryTaskCode(confesscompany.getCity()) + da +ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(getResultType(approval.getApprovalstate()));
                upProResult.setRowGuid(approval.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(confesscompany.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(confesscompany.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64"+getSubsidiaryTaskCode(confesscompany.getCity()) + da +ta);
                upProMaterial.setRowGuid(confesscompany.getId().toString() + "");
                upProMaterial.setUrl(confesscompany.getTemplateRar() + "");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("confesscompany" + confesscompany.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(confesscompany.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("confesscompany" + confesscompany.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    public void pushAllLegalchange(List<Legalchange> legalchanges, String businessType) {
        //获取申报信息
        Map<String, Object> params = new HashMap<>();
        params.put("clientId", clientId);
        SimpleDateFormat dFormat = new SimpleDateFormat("yyyyMMdd");

        for (Legalchange legalchange : legalchanges) {
            try {
                String time = System.currentTimeMillis() + "";
                logger.error("时间戳" + time);
                params.put("timespan", time);
                params.put("sign", MD5Util.encode(clientId + "|" + password + "|" + time));
                UpProAccept upProAccept = new UpProAccept();
                UpProResult upProResult = new UpProResult();
                List<UpProMaterial> upProMaterials = new ArrayList<>();
                List<UpProProcess> upProProcesses = new ArrayList<>();
                List<UpProsPecialProcedure> upProsPecialProcedures = new ArrayList<>();

                String createDate = formatDate(legalchange.getCreateTime());
                //办件受理信息
                upProAccept.setAcceptDate(createDate);
                upProAccept.setApplyDate(createDate);
                upProAccept.setApplyType(NXIntegratedConstants.ApplyType);//申请类型
                User user = userDao.findById(legalchange.getUserid());
                upProAccept.setApplyerName(user.getUsername() + "");
                upProAccept.setApplyerPageCode(getApplyerPageCode(legalchange.getCompanyid()));
                upProAccept.setApplyerPageType(ApplyerPageType(user.getPlatform()));//申请人证件类型
                upProAccept.setApplyerType(getApplyerType(user.getPlatform()));
                upProAccept.setAreaId(getAreaId(legalchange.getCompanyid())+"000000");
                upProAccept.setCatalogCode(NXIntegratedConstants.LegalchangeCatalogCode);
                upProAccept.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProAccept.setCdTime(createDate);
                upProAccept.setContractMobile(getContractMobile(legalchange.getCompanyid()));
                upProAccept.setDataSource(NXIntegratedConstants.DataSource);
                upProAccept.setEnterpriseName(legalchange.getCompanyname() + "");
                upProAccept.setIsItemBase(NXIntegratedConstants.IsItemBase);
                upProAccept.setLocalCatalogCode(NXIntegratedConstants.LegalchangeCatalogCode);
                upProAccept.setLocalItemCode(NXIntegratedConstants.LegalchangeLocalCode);
                upProAccept.setLocalProjectNo(NXIntegratedConstants.LegalchangeLocalCode);
                upProAccept.setLocalTaskCode(NXIntegratedConstants.LegalchangeLocalCode);
                upProAccept.setOrgCode(getLegalchangeOrgCode(legalchange.getCity()));
                upProAccept.setOrgName(getPoliceName(legalchange.getOrgid()));
                String da = dFormat.format(legalchange.getCreateTime());
                String ta=getProjectNo(NXIntegratedConstants.LegalchangeBH);
                upProAccept.setProjectNo("64"+getLegalchangeTaskCode(legalchange.getCity()) + da +ta);
                upProAccept.setProjectType(NXIntegratedConstants.ProjectType);
                upProAccept.setPromiseDate(formatDate(getPromiseDate(legalchange.getCreateTime(), businessType)) + "");
                upProAccept.setPromiseTime(NXIntegratedConstants.LegalchangePromiseTime);
                upProAccept.setRowGuid(legalchange.getId() + "");
                upProAccept.setTaskCode(getLegalchangeTaskCode(legalchange.getCity()));
                upProAccept.setTaskName(NXIntegratedConstants.LegalchangeTaskName);
                upProAccept.setTaskVersion(NXIntegratedConstants.TaskVersion);
                upProAccept.setTaskHandleItem(getLegalchangeTaskCode(legalchange.getCity())+"01");
                upProAccept.setCompanyCode(getCCode(legalchange.getCompanyid()));
                upProAccept.setHandleUserId(legalchange.getUserid().toString() + "");
                upProAccept.setFileId(getLegalchangeFileId(legalchange.getCity()));
                String handleUserName="暂无审批人";
                //办件过程信息
                List<ApprovalLog> logList = getApprovalLog(legalchange.getId().toString());
                for (ApprovalLog approvalLog : logList) {
                    UpProProcess upProProcess = new UpProProcess();
                    upProProcess.setCdOperation(NXIntegratedConstants.CdOperationI);
                    upProProcess.setCdTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setDataSource(NXIntegratedConstants.DataSource);
                    upProProcess.setEventEndTime(formatDate(approvalLog.getApprovaldate()) + "");
                    upProProcess.setEventName(getEventName(approvalLog.getApprovalstate()));
                    upProProcess.setEventStartTime(formatDate(approvalLog.getCreateTime()) + "");
                    upProProcess.setHandleExplain(approvalLog.getApprovalreason() + "");
                    upProProcess.setHandleUserName(approvalLog.getApprovalperson() + "");
                    handleUserName=approvalLog.getApprovalperson() + "";
                    upProProcess.setProcessId(approvalLog.getProcessInstanceId() + "");
                    upProProcess.setProcessName(getProcessName("" + approvalLog.getApprovalstate()));
                    upProProcess.setProjectNo("64"+getLegalchangeTaskCode(legalchange.getCity()) + da +ta);
                    upProProcess.setIsNeedService(NXIntegratedConstants.IsNeedService);
                    upProProcess.setRowGuid(approvalLog.getApprovalid() + "");
                    upProProcesses.add(upProProcess);
                }

                //办件结果信息
                Approval approval = approvalDAO.findBybusinessidAndType(legalchange.getId(), businessType);
                upProResult.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProResult.setCdTime(formatDate(approval.getCreateTime()) + "");
                upProResult.setDataSource(NXIntegratedConstants.DataSource);
                upProResult.setHandleUserName(handleUserName);
                upProResult.setIsDeliveryResults(NXIntegratedConstants.IsDeliveryResults);
                upProResult.setProjectNo("64"+getLegalchangeTaskCode(legalchange.getCity()) + da +ta);
                upProResult.setRemark(NXIntegratedConstants.Remark);
                upProResult.setResultDate(formatDate(approval.getApprovaldate()) + "");
                upProResult.setResultExplain(approval.getApprovalreason() + "");
                upProResult.setResultType(getResultType(approval.getApprovalstate()));
                upProResult.setRowGuid(approval.getId().toString() + "");

                //材料信息
                UpProMaterial upProMaterial = new UpProMaterial();
                upProMaterial.setCdOperation(NXIntegratedConstants.CdOperationI);
                upProMaterial.setCdTime(formatDate(legalchange.getCreateTime()) + "");
                upProMaterial.setDataSource(NXIntegratedConstants.DataSource);
                upProMaterial.setGetType(NXIntegratedConstants.ApplyType);
                upProMaterial.setMaterialAttachName("无");
                upProMaterial.setMaterialName(getMaterialName(legalchange.getTemplateRar()) + "");
                upProMaterial.setProjectNo("64"+getLegalchangeTaskCode(legalchange.getCity()) + da +ta);
                upProMaterial.setRowGuid(legalchange.getId().toString() + "");
                upProMaterial.setUrl(legalchange.getTemplateRar() + "");
                upProMaterial.setRemark(NXIntegratedConstants.Remark);
                upProMaterials.add(upProMaterial);

                params.put("upProAccept", upProAccept);
                params.put("upProResult", upProResult);
                params.put("upProMaterial", upProMaterials);
                params.put("upProProcess", upProProcesses);
                params.put("upProsPecialProcedure", upProsPecialProcedures);
                String result = StringUtils.EMPTY;
                CloseableHttpClient httpClient = HttpClients.createDefault();
                ResponseHandler<String> responseHandler = new BasicResponseHandler();
                try {
                    StringEntity requestEntity = new StringEntity(JSON.toJSONString(params), "utf-8");
                    requestEntity.setContentEncoding("UTF-8");
                    //第一步：创建HttpClient对象
                    httpClient = HttpClients.createDefault();
                    //第二步：创建httpPost对象
                    HttpPost httpPost = new HttpPost(url + NXIntegratedConstants.APPLYINFO);
                    httpPost.setHeader("Content-type", "application/json");
                    httpPost.setEntity(requestEntity);
                    result = httpClient.execute(httpPost, responseHandler);//调接口获取返回值时，必须用此方法
                } catch (IOException e) {
                    e.printStackTrace();
                }
                logger.error("legalchange" + legalchange.getId() + ":" + result);
                JSONObject resultJSON = JSON.parseObject(result);
                String code = resultJSON.getString("code");
                String succ = resultJSON.getString("succ");
                if (succ.equals("true")) {
                    NXIntegratedBaseDto nxIntegratedBaseDto = new NXIntegratedBaseDto();
                    nxIntegratedBaseDto.setBusinessId(legalchange.getId().toString());
                    nxIntegratedBaseDto.setBusinessType(businessType);
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    for (ApprovalLog approvalLog : logList) {
                        nxIntegratedBaseDto.setBusinessId(approvalLog.getId().toString());
                        nxIntegratedBaseDto.setBusinessType("02");
                        nxIntegratedBaseDto.setResult(result);
                        nxIntegratedBaseDto.setCode(code);
                        nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                    }
                    nxIntegratedBaseDto.setBusinessId(approval.getId().toString());
                    nxIntegratedBaseDto.setBusinessType("01");
                    nxIntegratedBaseDto.setResult(result);
                    nxIntegratedBaseDto.setCode(code);
                    nxIntegratedBaseDao.save(nxIntegratedBaseDto);
                }else {
                    logger.error("legalchange" + legalchange.getId() + "params:" + params);
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
            }
        }
    }

    private String getLegalchangeFileId(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.LegalchangeFileIdYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.LegalchangeFileIdSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.LegalchangeFileIdWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.LegalchangeFileIdGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.LegalchangeFileIdZW;
        }else {
            str=NXIntegratedConstants.LegalchangeFileIdZZQ;
        }
        return str;
    }

    private String getLegalchangeTaskCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.LegalchangeTaskCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.LegalchangeTaskCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.LegalchangeTaskCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.LegalchangeTaskCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.LegalchangeTaskCodeZW;
        }else {
            str=NXIntegratedConstants.LegalchangeTaskCodeZZQ;
        }
        return str;
    }

    private String getLegalchangeOrgCode(String city) {
        String str="";
        if (city.equals("640100")){//银川市
            str=NXIntegratedConstants.LegalchangeOrgCodeYC;
        }else if (city.equals("640200")){//石嘴山市
            str=NXIntegratedConstants.LegalchangeOrgCodeSZS;
        } else if (city.equals("640300")){//吴忠市
            str=NXIntegratedConstants.LegalchangeOrgCodeWZ;
        }else if (city.equals("640400")){//固原市
            str=NXIntegratedConstants.LegalchangeOrgCodeGY;
        }else if (city.equals("640500")){//中卫市
            str=NXIntegratedConstants.LegalchangeOrgCodeZW;
        }else {
            str=NXIntegratedConstants.LegalchangeOrgCodeZZQ;
        }
        return str;
    }

    private String getApplyerPageCode(Long companyid) {
        SecurityCompany securityCompany = securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty(securityCompany.getLegalPersonNo())) {
            return "";
        } else {
            return securityCompany.getLegalPersonNo();
        }
    }

    private String getCCode(Long companyid) {
        SecurityCompany securityCompany = securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty(securityCompany.getSocialCode())) {
            return "";
        } else {
            return securityCompany.getSocialCode();
        }
    }

    private String getContractMobile(Long companyid) {
        SecurityCompany securityCompany = securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty(securityCompany.getTel())) {
            return "";
        } else {
            return securityCompany.getTel();
        }
    }

    private String getAreaId(Long companyid) {
        SecurityCompany securityCompany = securityCompanyDao.findById(companyid);
        if (StringUtil.isEmpty(securityCompany.getAreaCode())) {
            return "";
        } else {
            return securityCompany.getAreaCode();
        }

    }

    public static void main(String[] args) {
        System.out.println(System.currentTimeMillis());
    }
}
