package com.bcxin.ars.service.util;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.XmlUtil;
import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dao.log.BjRestLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.log.BjRestLog;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.webservice.MinisterialResponse;
import com.bcxin.ars.webservice.MinisterialResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.soap.*;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import java.io.ByteArrayOutputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * @author zhangyutong
 */
@Service
public class MinisterialUtil{

    private static Logger logger = LoggerFactory.getLogger(MinisterialUtil.class);

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private BjRestLogDao bjRestLogDao;

    @Value("${SIGNATURE}")
    private String SIGNATURE;
    @Value("${ACCOUNT_ID}")
    private String ACCOUNT_ID;
    @Value("${ORG_CODE}")
    private  String ORG_CODE;
    @Value("${ORG_NAME}")
    private String ORG_NAME;
    @Value("${PASSWORD}")
    private String PASSWORD;
    @Value("${serviceAddress}")
    private String SERVICEADDRESS;

    /**
     * 数据上报部级接口公用方法
     * @param dataType
     * @param list
     * @return
     */
    public String send(MinisterialDataType dataType, List list){
        String current_native = configUtils.getValueByKey(Constants.CURRENT_NATIVE);
        /**
         * 调用日志信息
         */
        BjRestLog bjRestLog= new BjRestLog();
        bjRestLog.setResttype(dataType.getCode());

        String className = dataType.getDataClazz().getSimpleName();
        try {
            // 创建连接
            // ==================================================
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();

            //  创建消息对象
            // ===========================================
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty(SOAPMessage.CHARACTER_SET_ENCODING, "utf-8");

            // 创建soap消息主体==========================================
            SOAPPart soapPart = message.getSOAPPart();// 创建soap部分
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("dat","http://datarecord.webservice.ssis.com");
            envelope.addNamespaceDeclaration("web","http://webservice.entity.ssis.com");
            envelope.addNamespaceDeclaration(className.toLowerCase().substring(0, 3),"http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com");

            SOAPBody body = envelope.getBody();

            SOAPElement entityElement = null;
            if(className.equals("Babzjl")) {
                entityElement = body.addChildElement(envelope.createQName("xxba_"+className+"xx","dat"));
            }else{
                entityElement = body.addChildElement(envelope.createQName("xxba_"+className,"dat"));
            }

            SOAPElement licenseElement = entityElement.addChildElement(envelope.createQName("LICENSE","dat"));
            licenseElement.addChildElement("SIGNATURE","web").addTextNode(SIGNATURE);
            SOAPElement userElement = licenseElement.addChildElement("USERINFO","web");
            userElement.addChildElement("ACCOUNT_ID","web").addTextNode(ACCOUNT_ID);
            userElement.addChildElement("ORG_CODE","web").addTextNode(ORG_CODE);
            userElement.addChildElement("ORG_NAME","web").addTextNode(ORG_NAME);
            userElement.addChildElement("PASSWORD","web").addTextNode(PASSWORD);

            String lowerClassName = className.toLowerCase().substring(0, 3);

            SOAPElement packageElement = entityElement.addChildElement(envelope.createQName("PACKAGE","dat"));
            SOAPElement dataElement = packageElement.addChildElement(envelope.createQName("DATA",lowerClassName));

            String fieldValue = "";
            for (Object o : list) {
                SOAPElement recordElement = dataElement.addChildElement(envelope.createQName("RECORD",lowerClassName));
                for (Field field : o.getClass().getDeclaredFields()) {
                    fieldValue = "";
                    Object obj = ReflectUtil.getFieldValue(o,field.getName());
                    MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                    if(resource != null){
                        fieldValue = resource.defaultValue();
                        if (obj != null) {
                            fieldValue = resource.DATA_FORMAT().getMinDataFormatStrategy().format(field, obj);
                        }
                    }
                    recordElement.addChildElement(field.getName().toUpperCase(), lowerClassName).addTextNode(fieldValue);
                }
            }

            String FSSJ = DateUtil.getCurrentDateTime(DateUtil.FORMAT12);
            String JYLCH ="00"+current_native+FSSJ+getRadom(11);

            SOAPElement packageheadElement = packageElement.addChildElement(envelope.createQName("PACKAGEHEAD",lowerClassName));
            packageheadElement.addChildElement("DQY","web");
            packageheadElement.addChildElement("FSSJ","web").addTextNode(FSSJ);
            packageheadElement.addChildElement("JLS","web");
            packageheadElement.addChildElement("JYLCH","web").addTextNode(JYLCH);
            packageheadElement.addChildElement("MYJLS","web");
            packageheadElement.addChildElement("SBH","web").addTextNode(current_native);
            packageheadElement.addChildElement("SID","web");

            // Save the message
            message.saveChanges();
            ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
            message.writeTo(requestStream);
            //请求报文，照片不需要存在请求报文格式
            if(!dataType.getCode().equals(Constants.XXBA_ZPXXB)) {
                bjRestLog.setRequestContext(requestStream.toString("utf-8"));
            }
            /*
             * 实际的消息是使用 call()方法发送的，该方法接收消息本身和目的地作为参数，并返回第二个 SOAPMessage 作为响应。
             * call方法的message对象为发送的soap报文，url为mule配置的inbound端口地址。
             */
            URL url = new URL(SERVICEADDRESS);
            logger.error("上报部级请求地址：",url.toString());
            // 响应消息
            // ===========================================================================
            SOAPMessage reply = connection.call(message, url);
            //reply.setProperty(SOAPMessage.CHARACTER_SET_ENCODING, "utf-8");
            // ==================创建soap消息转换对象
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            // Extract the content of the reply======================提取消息内容
            Source sourceContent = reply.getSOAPPart().getContent();
            // Set the output for the transformation

            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(responseStream);
            transformer.transform(sourceContent, result);
            String responseStreamString = responseStream.toString("utf-8");
            //响应报文
            bjRestLog.setResponseContext(responseStreamString);
            // Close the connection 关闭连接 ==============
            connection.close();

            Document document = XmlUtil.readXML(responseStreamString);
            Element rootElement = XmlUtil.getRootElement(document);
            Element soapBody = XmlUtil.getElement(rootElement, "soap:Body");
            Element response = XmlUtil.getElement(soapBody, "ns1:xxba_BayxxbResponse");
            Element responsePackage = XmlUtil.getElement(response, "ns1:PACKAGE");
            Element packageHead = XmlUtil.getElement(responsePackage, "PACKAGEHEAD");
            MinisterialResponse ministerialResponse = XmlUtil.xmlToBean(packageHead, MinisterialResponse.class);
            List<MinisterialResponseData> responseDataList = new ArrayList<>();

            Element packageData = XmlUtil.getElement(responsePackage, "DATA");
            // 据文档说, 成功的不会返回data信息
            if (packageData != null) {
                List<Element> record = XmlUtil.getElements(packageData, "RECORD");
                for (Element element : record) {
                    MinisterialResponseData ministerialResponseData = XmlUtil.xmlToBean(element, MinisterialResponseData.class);
                    responseDataList.add(ministerialResponseData);
                }
            }

            ministerialResponse.setMinisterialResponseData(responseDataList);
            logger.error("上报部级返回结果:{}", ministerialResponse);

            // 处理成功设置日志记录
            if (Constants.MINISTRY_CODE_SUCCESS.equals(ministerialResponse.getCODE())) {
                bjRestLog.setCode(Constants.MINISTRY_CODE_SUCCESS);
                bjRestLog.setMsg(ministerialResponse.getMSG());
            }
            return JYLCH;

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            //执行结果编码
            bjRestLog.setCode(Constants.MINISTRY_CODE_ERROR);
            //执行结果信息
            bjRestLog.setMsg(e.getMessage());
        }finally {
            //创建时间
            bjRestLog.setCreateTime(new Date());
            //有效标记
            bjRestLog.setActive(true);
            //更新时间
            bjRestLog.setUpdateTime(new Date());
            //更新者
            bjRestLog.setUpdateBy(Constants.APPROVAL_SYSTEM);
            //bjRestLogDao.save(bjRestLog);
            logger.error("上报部级执行结果:{}", JSON.toJSONString(bjRestLog));

        }
        return null;
    }

    public AjaxResult sendList(MinisterialDataType dataType, List list){
        String current_native = configUtils.getValueByKey(Constants.CURRENT_NATIVE);
        /**
         * 调用日志信息
         */
        BjRestLog bjRestLog= new BjRestLog();
        bjRestLog.setResttype(dataType.getCode());

        String className = dataType.getDataClazz().getSimpleName();
        try {
            // 创建连接
            // ==================================================
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();

            //  创建消息对象
            // ===========================================
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty(SOAPMessage.CHARACTER_SET_ENCODING, "utf-8");

            // 创建soap消息主体==========================================
            SOAPPart soapPart = message.getSOAPPart();// 创建soap部分
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("dat","http://datarecord.webservice.ssis.com");
            envelope.addNamespaceDeclaration("web","http://webservice.entity.ssis.com");
            envelope.addNamespaceDeclaration(className.toLowerCase().substring(0, 3),"http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com");

            SOAPBody body = envelope.getBody();

            SOAPElement entityElement = body.addChildElement(envelope.createQName("xxba_"+className,"dat"));

            SOAPElement licenseElement = entityElement.addChildElement(envelope.createQName("LICENSE","dat"));
            licenseElement.addChildElement("SIGNATURE","web").addTextNode(SIGNATURE);
            SOAPElement userElement = licenseElement.addChildElement("USERINFO","web");
            userElement.addChildElement("ACCOUNT_ID","web").addTextNode(ACCOUNT_ID);
            userElement.addChildElement("ORG_CODE","web").addTextNode(ORG_CODE);
            userElement.addChildElement("ORG_NAME","web").addTextNode(ORG_NAME);
            userElement.addChildElement("PASSWORD","web").addTextNode(PASSWORD);

            String lowerClassName = className.toLowerCase().substring(0, 3);

            SOAPElement packageElement = entityElement.addChildElement(envelope.createQName("PACKAGE","dat"));
            SOAPElement dataElement = packageElement.addChildElement(envelope.createQName("DATA",lowerClassName));

            String fieldValue = "";
            for (Object o : list) {
                SOAPElement recordElement = dataElement.addChildElement(envelope.createQName("RECORD",lowerClassName));
                for (Field field : o.getClass().getDeclaredFields()) {
                    fieldValue = "";
                    Object obj = ReflectUtil.getFieldValue(o,field.getName());
                    MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                    if(resource != null){
                        fieldValue = resource.defaultValue();
                        if (obj != null) {
                            fieldValue = resource.DATA_FORMAT().getMinDataFormatStrategy().format(field, obj);
                        }
                    }
                    recordElement.addChildElement(field.getName().toUpperCase(), lowerClassName).addTextNode(fieldValue);
                }
            }

            String FSSJ = DateUtil.getCurrentDateTime(DateUtil.FORMAT12);
            String JYLCH ="00"+current_native+FSSJ+getRadom(11);

            SOAPElement packageheadElement = packageElement.addChildElement(envelope.createQName("PACKAGEHEAD",lowerClassName));
            packageheadElement.addChildElement("DQY","web");
            packageheadElement.addChildElement("FSSJ","web").addTextNode(FSSJ);
            packageheadElement.addChildElement("JLS","web");
            packageheadElement.addChildElement("JYLCH","web").addTextNode(JYLCH);
            packageheadElement.addChildElement("MYJLS","web");
            packageheadElement.addChildElement("SBH","web").addTextNode(current_native);
            packageheadElement.addChildElement("SID","web");

            // Save the message
            message.saveChanges();
            ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
            message.writeTo(requestStream);
            //请求报文，照片不需要存在请求报文格式
            if(!dataType.getCode().equals(Constants.XXBA_ZPXXB)) {
                bjRestLog.setRequestContext(requestStream.toString("utf-8"));
            }
            /*
             * 实际的消息是使用 call()方法发送的，该方法接收消息本身和目的地作为参数，并返回第二个 SOAPMessage 作为响应。
             * call方法的message对象为发送的soap报文，url为mule配置的inbound端口地址。
             */
            URL url = new URL(SERVICEADDRESS);
            // 响应消息
            // ===========================================================================
            SOAPMessage reply = connection.call(message, url);
            //reply.setProperty(SOAPMessage.CHARACTER_SET_ENCODING, "utf-8");
            // ==================创建soap消息转换对象
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            // Extract the content of the reply======================提取消息内容
            Source sourceContent = reply.getSOAPPart().getContent();
            // Set the output for the transformation

            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(responseStream);
            transformer.transform(sourceContent, result);
            String responseStreamString = responseStream.toString("utf-8");
            //响应报文
            bjRestLog.setResponseContext(responseStreamString);
            // Close the connection 关闭连接 ==============
            connection.close();

            Document document = XmlUtil.readXML(responseStreamString);
            Element rootElement = XmlUtil.getRootElement(document);
            Element soapBody = XmlUtil.getElement(rootElement, "soap:Body");
            Element soapFault = XmlUtil.getElement(soapBody, "soap:Fault");
            if(soapFault == null){
                return AjaxResult.error("同步失败");
            }

            Element response = XmlUtil.getElement(soapBody, "ns1:xxba_"+className+"Response");
            Element responsePackage = XmlUtil.getElement(response, "ns1:PACKAGE");
            Element packageData = XmlUtil.getElement(responsePackage, "DATA");
            // 据文档说, 成功的不会返回data信息
            if (packageData != null) {
                List<Element> record = XmlUtil.getElements(packageData, "RESRECORD");
                int successCount = 0;
                for (Element element : record) {
                    MinisterialResponseData ministerialResponseData = XmlUtil.xmlToBean(element, MinisterialResponseData.class);
                    if (Constants.MINISTRY_CODE_SUCCESS.equals(ministerialResponseData.getCODE())){
                        successCount++;
                    }else{
                        break;
                    }
                }
                if(successCount >= record.size() ){
                    return AjaxResult.success(null,JYLCH);
                }
            }

            return AjaxResult.success(null,null);

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            //执行结果编码
            bjRestLog.setCode(Constants.MINISTRY_CODE_ERROR);
            //执行结果信息
            bjRestLog.setMsg(e.getMessage());
        }finally {
            //创建时间
            bjRestLog.setCreateTime(new Date());
            //有效标记
            bjRestLog.setActive(true);
            //更新时间
            bjRestLog.setUpdateTime(new Date());
            //更新者
            bjRestLog.setUpdateBy(Constants.APPROVAL_SYSTEM);
            //bjRestLogDao.save(bjRestLog);
            logger.error("上报部级执行结果:{}", JSON.toJSONString(bjRestLog));

        }
        return AjaxResult.error("同步失败");
    }

    public AjaxResult send(MinisterialDataType dataType, Object object){
        String current_native = configUtils.getValueByKey(Constants.CURRENT_NATIVE);
        /**
         * 调用日志信息
         */
        BjRestLog bjRestLog= new BjRestLog();
        bjRestLog.setResttype(dataType.getCode());

        String className = dataType.getDataClazz().getSimpleName();
        try {
            // 创建连接
            // ==================================================
            SOAPConnectionFactory soapConnFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection connection = soapConnFactory.createConnection();

            //  创建消息对象
            // ===========================================
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty(SOAPMessage.CHARACTER_SET_ENCODING, "utf-8");

            // 创建soap消息主体==========================================
            SOAPPart soapPart = message.getSOAPPart();// 创建soap部分
            SOAPEnvelope envelope = soapPart.getEnvelope();
            envelope.addNamespaceDeclaration("dat","http://datarecord.webservice.ssis.com");
            envelope.addNamespaceDeclaration("web","http://webservice.entity.ssis.com");
            envelope.addNamespaceDeclaration(className.toLowerCase().substring(0, 3),"http://" + className.toLowerCase() + ".request.datarecord.webservice.entity.ssis.com");

            SOAPBody body = envelope.getBody();

            SOAPElement entityElement = body.addChildElement(envelope.createQName("xxba_"+className,"dat"));

            SOAPElement licenseElement = entityElement.addChildElement(envelope.createQName("LICENSE","dat"));
            licenseElement.addChildElement("SIGNATURE","web").addTextNode(SIGNATURE);
            SOAPElement userElement = licenseElement.addChildElement("USERINFO","web");
            userElement.addChildElement("ACCOUNT_ID","web").addTextNode(ACCOUNT_ID);
            userElement.addChildElement("ORG_CODE","web").addTextNode(ORG_CODE);
            userElement.addChildElement("ORG_NAME","web").addTextNode(ORG_NAME);
            userElement.addChildElement("PASSWORD","web").addTextNode(PASSWORD);

            String lowerClassName = className.toLowerCase().substring(0, 3);

            SOAPElement packageElement = entityElement.addChildElement(envelope.createQName("PACKAGE","dat"));
            SOAPElement dataElement = packageElement.addChildElement(envelope.createQName("DATA",lowerClassName));

            String fieldValue = "";
            SOAPElement recordElement = dataElement.addChildElement(envelope.createQName("RECORD",lowerClassName));
            for (Field field : object.getClass().getDeclaredFields()) {
                fieldValue = "";
                Object obj = ReflectUtil.getFieldValue(object,field.getName());
                MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                if(resource != null){
                    fieldValue = resource.defaultValue();
                    if (obj != null) {
                        fieldValue = resource.DATA_FORMAT().getMinDataFormatStrategy().format(field, obj);
                    }
                }
                recordElement.addChildElement(field.getName().toUpperCase(), lowerClassName).addTextNode(fieldValue);
            }

            String FSSJ = DateUtil.getCurrentDateTime(DateUtil.FORMAT12);
            String JYLCH ="00"+current_native+FSSJ+getRadom(11);

            SOAPElement packageheadElement = packageElement.addChildElement(envelope.createQName("PACKAGEHEAD",lowerClassName));
            packageheadElement.addChildElement("DQY","web");
            packageheadElement.addChildElement("FSSJ","web").addTextNode(FSSJ);
            packageheadElement.addChildElement("JLS","web");
            packageheadElement.addChildElement("JYLCH","web").addTextNode(JYLCH);
            packageheadElement.addChildElement("MYJLS","web");
            packageheadElement.addChildElement("SBH","web").addTextNode(current_native);
            packageheadElement.addChildElement("SID","web");

            // Save the message
            message.saveChanges();
            ByteArrayOutputStream requestStream = new ByteArrayOutputStream();
            message.writeTo(requestStream);
            //请求报文，照片不需要存在请求报文格式
            if(!dataType.getCode().equals(Constants.XXBA_ZPXXB)) {
                bjRestLog.setRequestContext(requestStream.toString("utf-8"));
            }
            /*
             * 实际的消息是使用 call()方法发送的，该方法接收消息本身和目的地作为参数，并返回第二个 SOAPMessage 作为响应。
             * call方法的message对象为发送的soap报文，url为mule配置的inbound端口地址。
             */
            URL url = new URL(SERVICEADDRESS);
            // 响应消息
            // ===========================================================================
            SOAPMessage reply = connection.call(message, url);
            //reply.setProperty(SOAPMessage.CHARACTER_SET_ENCODING, "utf-8");
            // ==================创建soap消息转换对象
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            // Extract the content of the reply======================提取消息内容
            Source sourceContent = reply.getSOAPPart().getContent();
            // Set the output for the transformation

            ByteArrayOutputStream responseStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(responseStream);
            transformer.transform(sourceContent, result);
            String responseStreamString = responseStream.toString("utf-8");
            //响应报文
            bjRestLog.setResponseContext(responseStreamString);
            // Close the connection 关闭连接 ==============
            connection.close();

            Document document = XmlUtil.readXML(responseStreamString);
            Element rootElement = XmlUtil.getRootElement(document);
            Element soapBody = XmlUtil.getElement(rootElement, "soap:Body");
            Element soapFault = XmlUtil.getElement(soapBody, "soap:Fault");

            if(soapFault == null){
                return AjaxResult.error("同步失败");
            }

            Element response = XmlUtil.getElement(soapBody, "ns1:xxba_"+className+"Response");
            Element responsePackage = XmlUtil.getElement(response, "ns1:PACKAGE");
            Element packageData = XmlUtil.getElement(responsePackage, "DATA");
            // 据文档说, 成功的不会返回data信息
            if (packageData != null) {
                List<Element> record = XmlUtil.getElements(packageData, "RESRECORD");
                Element element = record.get(0);
                MinisterialResponseData ministerialResponseData = XmlUtil.xmlToBean(element, MinisterialResponseData.class);
                if (Constants.MINISTRY_CODE_SUCCESS.equals(ministerialResponseData.getCODE())){
                    bjRestLog.setCode(Constants.MINISTRY_CODE_SUCCESS);
                    bjRestLog.setMsg(ministerialResponseData.getMSG());
                    return AjaxResult.success(null,JYLCH);
                }
            }

            return AjaxResult.success(null,null);

        } catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            //执行结果编码
            bjRestLog.setCode(Constants.MINISTRY_CODE_ERROR);
            //执行结果信息
            bjRestLog.setMsg(e.getMessage());
        }finally {
            //创建时间
            bjRestLog.setCreateTime(new Date());
            //有效标记
            bjRestLog.setActive(true);
            //更新时间
            bjRestLog.setUpdateTime(new Date());
            //更新者
            bjRestLog.setUpdateBy(Constants.APPROVAL_SYSTEM);
            //bjRestLogDao.save(bjRestLog);
            logger.error("上报部级执行结果:{}", JSON.toJSONString(bjRestLog));

        }
        return AjaxResult.error("同步失败");
    }

    /***
     * 生成随机数
     * @param length 长度
     * @return
     */
    public static String getRadom(int length){
        //获取一个随机数
        double rand = Math.random();
        //将随机数转换为字符串
        String str = String.valueOf(rand).replace("0.", "");
        //截取字符串
        String newStr = str.substring(0, length);
        return newStr;
    }


    public static void main(String[] args) {

        //String responseStreamString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><soap:Fault><faultcode>soap:Server</faultcode><faultstring>操作数据库发生错误，可能原因是:1.网络问题，2.数据库服务器忙，3.连接参数有误，4.读取的数据量超负荷。</faultstring></soap:Fault></soap:Body></soap:Envelope>";
        //Document document = XmlUtil.readXML(responseStreamString);
        //Element rootElement = XmlUtil.getRootElement(document);
        //Element soapBody = XmlUtil.getElement(rootElement, "soap:Body");
        //Element soapFault = XmlUtil.getElement(soapBody, "soap:Fault");
        //if(soapFault != null){
        //    System.out.println(soapFault);
        //}

        String responseStreamString = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soap:Body><ns1:xxba_BafwgsglryResponse xmlns:ns1=\"http://datarecord.webservice.ssis.com\"><ns1:PACKAGE><DATA xmlns=\"http://webservice.entity.ssis.com\"><RESRECORD><CODE>10</CODE><ERRORMSG xsi:nil=\"true\"/><KEY1>BAG6100000411</KEY1><KEY2>61210119771017761x</KEY2><MSG>处理成功!</MSG><NO>0</NO></RESRECORD><RESRECORD><CODE>10</CODE><ERRORMSG xsi:nil=\"true\"/><KEY1>BAG6100000233</KEY1><KEY2>610121197705170011</KEY2><MSG>处理成功!</MSG><NO>1</NO></RESRECORD><RESRECORD><CODE>10</CODE><ERRORMSG xsi:nil=\"true\"/><KEY1>BAG6100000699</KEY1><KEY2>445281197910111234</KEY2><MSG>处理成功!</MSG><NO>2</NO></RESRECORD></DATA><PACKAGEHEAD xmlns=\"http://webservice.entity.ssis.com\"><CGJLS>3</CGJLS><CODE>10</CODE><DQY xsi:nil=\"true\"/><FSSJ>20211026000141855</FSSJ><JLS/><JYLCH xsi:nil=\"true\"/><MSG>处理成功!</MSG><MYJLS xsi:nil=\"true\"/><SBH>61</SBH><SBJLS>0</SBJLS><SID xsi:nil=\"true\"/></PACKAGEHEAD></ns1:PACKAGE></ns1:xxba_BafwgsglryResponse></soap:Body></soap:Envelope>";
        Document document = XmlUtil.readXML(responseStreamString);
        Element rootElement = XmlUtil.getRootElement(document);
        Element soapBody = XmlUtil.getElement(rootElement, "soap:Body");
        Element response = XmlUtil.getElement(soapBody, "ns1:xxba_BafwgsglryResponse");
        Element responsePackage = XmlUtil.getElement(response, "ns1:PACKAGE");
        Element packageData = XmlUtil.getElement(responsePackage, "DATA");
        // 据文档说, 成功的不会返回data信息
        if (packageData != null) {
            List<Element> record = XmlUtil.getElements(packageData, "RESRECORD");
            Element element = record.get(0);
            MinisterialResponseData ministerialResponseData = XmlUtil.xmlToBean(element, MinisterialResponseData.class);
            if (Constants.MINISTRY_CODE_SUCCESS.equals(ministerialResponseData.getCODE())){
                System.out.println(ministerialResponseData.getMSG());
            }
        }

    }
}
