package com.bcxin.ars.service.util;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Random;

/**
 * 主键生成工具类
 * Created by Dareen on 2018/3/28.
 */
@Slf4j
@Service
public class IdGeneratorUtil {
    //日志
//    private Logger logger = Logger.getLogger(IdGeneratorUtil.class);
    @Autowired
    private ConfigDao configDao;
    private String onlineFlag = "";
    /****
     * 生成主键
     * @return  时间戳+随机5位数+内外网标识位
     */
    public  long createID() {
        StringBuffer reulst = new StringBuffer();
        //获取系统是否联网部署online
        Config onlineConfig = configDao.findByKey(Constants.ONLINE);
        if(StringUtil.isEmpty(onlineFlag) && onlineConfig != null && onlineConfig.getValue() != null){
            onlineFlag =  onlineConfig.getValue();
        }
        //随机产生5位数
        //modify zjh time :2018年8月3日 14:23:39 位数太长导致app获取任务详情出错
        Random random = new Random();
        int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
        //获得的是自1970-1-01 00:00:00.000 到当前时刻的时间距离
        long ct = System.currentTimeMillis();
        return Long.valueOf(reulst.append(ct).append(rannum).append(onlineFlag).toString().substring(2));
    }

    public static void main(String[] args) {
        StringBuffer reulst = new StringBuffer();
        //随机产生5位数
        //modify zjh time :2018年8月3日 14:23:39 位数太长导致app获取任务详情出错
        Random random = new Random();
        int rannum = (int) (random.nextDouble() * (99 - 10 + 1)) + 100;// 获取5位随机数
        //获得的是自1970-1-01 00:00:00.000 到当前时刻的时间距离
        long ct = System.currentTimeMillis();
        System.out.println(Long.valueOf(reulst.append(ct).append(rannum).append('1').toString().substring(2)));
    }
}





