package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.AppraiseResultDto;
import com.bcxin.ars.dto.appraise.AppraisePageResultDto;
import com.bcxin.ars.dto.appraise.AppraisePageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.Map;

/**
 * 调好差评接口工具类
 * @author linqinglin
 * @date 2019/04/23 0023 15:14
 */
@Component
public class AppraiseInterfaceUtil {

    private static Logger logger = LoggerFactory.getLogger(AppraiseInterfaceUtil.class);

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Value("${AppraiseURL}")
    private String AppraiseURL;

    /**
     * 调saas接口
     * @param url 接口地址
     * @param paramObj 传参
     */
    public AjaxResult callInterface(String url , Object paramObj){
        //对象转map
        Map<String,Object> paramMap = BeanUtil.beanToMap(paramObj);
        return callInterface(url,paramMap);
    }

    /**
     * 调saas接口
     * @param url 接口地址
     * @param paramMap 传参
     */
    public AjaxResult callInterface(String url , Map<String,Object> paramMap){
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();

        url = AppraiseURL + url;
        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //获取结果
            String resultStr = HttpRequest.post(url).header("User-Agent","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36")
                    .form(paramMap)
                    .execute()
                    .body();
            //String resultStr = HttpUtil.post(url, paramMap);
            interfaceLog.setResult(resultStr);

            AppraiseResultDto resultDto = JSONObject.parseObject(resultStr, AppraiseResultDto.class);
            data = resultDto;
            if(resultDto != null && StringUtil.isNotEmpty(resultDto.getCode())) {
                if (resultDto.isSuccess()) {
                    logger.info("接口对接成功");
                } else {
                    result = false;
                    //错误信息
                    msg =  resultDto.getErrorMessage();
                    logger.error(resultStr);
                    logger.info("接口对接失败");
                }
            }else{
                result = false;
                msg =  "没有返回结果";
                logger.info("接口对接失败,没有返回结果");
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result);
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "接口对接失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }

    public AjaxPageResponse searchForPage(String url, AppraisePageSearchDto dto, AppraisePageResultDto page) {
        try {
            //获取结果
            //String resultStr = HttpRequest.post(AppraiseURL+url).header("User-Agent","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.86 Safari/537.36")
            //        .form(BeanUtil.beanToMap(dto))
            //        .execute()
            //        .body();

            String resultStr = HttpUtil.post(AppraiseURL+url,BeanUtil.beanToMap(dto));
            logger.error("好差评接口地址:"+AppraiseURL+url);
            logger.error("好差评接口参数:"+ JSON.toJSONString(dto));
            logger.error("好差评接口返回结果:"+resultStr);

            AppraiseResultDto resultDto = JSONObject.parseObject(resultStr, AppraiseResultDto.class);
            if(resultDto.getData() != null) {
                JSONObject pageJson = JSONObject.parseObject(resultDto.getData().toString());
                page = JSONObject.parseObject(pageJson.get("page").toString(), page.getClass());
                System.out.println(JSON.toJSONString(page));
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
            e.printStackTrace();
            logger.error("好差评接口调用失败。");
        }finally {
            return page.toAjaxPage();
        }

    }

    public static void main(String[] args) {
      String url ="http://outbjbbd.test.baibaodun.cn/ars-rest/comTask/contract/save.json";
      String contracts = "[{\"comContractId\":638318060121358336,\"comTaskId\":636983286630973440,\"createBy\":634333489453334528,\"createTime\":1572229567521,\"isDelete\":\"0\",\"updateTime\":1572229567524}]";
      //对象转map
      Map<String,Object> paramMap = new HashedMap();
      paramMap.put("sid","0E44373E153D7C59341D77809D11C17E07FD91598F759F3E79BFA3D9BDB2CCCF7DD089A41E48CD4CADB1F18A76187437EC609C2215764BBA1AF3EF5CE85BAAC2");
      paramMap.put("comTaskId",636983286630973440L);
      paramMap.put("contracts",contracts);
      //获取结果
      String resultStr = HttpUtil.post(url, paramMap);
      System.out.println(resultStr);
    }
}
