package com.bcxin.ars.service.task.impl;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.task.TaskTrackDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.ImportType;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.task.TaskTrack;
import com.bcxin.ars.service.task.TaskTrackService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.DateUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

@Service
@Transactional
@DataSyncAnnotation(getClazz = TaskTrack.class,getImportType = ImportType.BATCH,getMethodName = "importBatch")
public class TaskTrackServiceImpl implements TaskTrackService {

	@Autowired
	private TaskTrackDao taskTrackDao;

	@Autowired
	private SecurityPersonDao personDao;
	
	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigUtils configUtils;
	@Override
	public Long save(TaskTrack track) {

		SecurityPerson person = personDao.findById(track.getPersonId());
		if(person!=null) {
			person.setLatitude(track.getLatitude());
			person.setLongitude(track.getLongitude());
			person.setUpdateTime(new Date());
			personDao.updateSelective(person);//更新人员的当前位置
		}
		track.setNativeCode(arsUtil.getCurrentNatvie());
		track.setUpdateTime(new Date());
		return taskTrackDao.save(track);
	}

	@Override
	public Long saveForSaaS(TaskTrack track) {
		track.setNativeCode(arsUtil.getCurrentNatvie());
		track.setUpdateTime(new Date());
		return taskTrackDao.save(track);
	}
	@Override
	public List<TaskTrack> findByFeedbackId(Long feedbackId) {
		return taskTrackDao.findByFeedbackId(feedbackId);
	}

	/**
	 * 外导内数据查询
	 * @param searchDto
	 * @return
	 */
	@Override
	public List<TaskTrack> searchForDataSynchronization( DataSynchronizationSearchDto searchDto) {
		return taskTrackDao.searchForDataSynchronization(searchDto);
	}

	/**
	 * 内外网数据同步
	 * @param list
	 */
	public void importBatch(List<TaskTrack> list) {
		List<TaskTrack> dbList = taskTrackDao.findByBatchId(list);
		//去掉重复的
		//通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
		list.removeAll(dbList);
		if (list.size()>0){
			for (TaskTrack taskTrack : list) {
				taskTrack.setUpdateflag(false);
				try {
					if(!configUtils.isIntranet()){
						taskTrack.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, taskTrack.getUpdateTime(), 1));
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
			taskTrackDao.saveBatch(list);
		}
	}

	
}
