package com.bcxin.ars.service.task.impl;

import cn.jiguang.common.utils.StringUtils;
import com.bcxin.ars.dao.SecurityPersonDao;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dao.task.*;
import com.bcxin.ars.dto.UrgentPerson;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.*;
import com.bcxin.ars.service.task.TaskFeedbackLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.MessageUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class TaskFeedbackLogServiceImpl implements TaskFeedbackLogService {

	@Autowired
	private TaskFeedbackLogDao taskFeedbackLogDao;

	@Autowired
	private TaskFeedbackDao taskFeedbackDao;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private TaskPersonDao taskPersonDao;

	@Autowired
	private SecurityPersonDao personDao;

	@Autowired
	private TaskDao taskDao;

	@Autowired
	private UrgentTeamPersonDAO urgentTeamPersonDAO;

	@Autowired
	private TaskPersonScheduleDao taskPersonScheduleDao;

	@Autowired
	private TaskFeedbackDao feedbackDao;
	@Autowired
	private MessageLogDao messageLogDao;

	@Override
	public TaskFeedbackLog saveOrUpdate(TaskFeedbackLog taskFeedbackLog) {
		TaskFeedback taskFeedback = taskFeedbackLog.getTaskFeedback();
		taskFeedback = taskFeedbackDao.findById(taskFeedback.getId());
		if (taskFeedback == null) {
			throw new ArsException("数据异常:查找不到子任务信息");
		}
		User currentUser = arsUtil.getCurrentUser();
		if (!StringUtils.isEmpty(taskFeedbackLog.getDutyState())) {
			if (!taskFeedbackLog.getDutyState().equals(Constants.DUTYSTATE_NORMAL)) {
				Date taskEnd = DateUtil
						.convertStringToDate(taskFeedback.getTaskDate() + " " + taskFeedback.getTaskEnd());
				Date nowDate = new Date();
				// 当前时间如果早于子任务(班次)截至时间，则提前离岗，否则为正常下班
				if (nowDate.getTime() < taskEnd.getTime()) {
					// 提前离岗
					taskFeedback.setFeedbackStatus("2");
				} else {
					// 正常下班
					taskFeedback.setFeedbackStatus("1");
				}
				taskFeedback.setEndTime(new Date());
				taskFeedback.setComment(taskFeedbackLog.getComment());
				taskFeedback.setUpdateTime(new Date());
				taskFeedback.setUpdateBy(currentUser.getUsername());
				taskFeedback.setPhotos(taskFeedbackLog.getImage());
				TaskStatus taskStatus = new TaskStatus();
				taskStatus.setId(3L);
				taskFeedback.setTaskStatus(taskStatus);
				taskFeedbackDao.update(taskFeedback);
			}
		}
		taskFeedbackLog.setCreateTime(new Date());
		taskFeedbackLog.setUpdateBy(currentUser.getUsername());
		taskFeedbackLogDao.save(taskFeedbackLog);
		// 如果有紧急任务，则需要签到上班
		Long taskId = taskFeedbackLog.getTaskId(); // 紧急任务ID
		if (taskId != null) {
			TaskPerson taskPerson = new TaskPerson();
			taskPerson.setTaskId(taskId);
			taskPerson.setPerson(taskFeedbackLog.getPerson());
			taskPerson.setAcceptStatus(1);
			List<TaskFeedback> taskFeedbackList = taskFeedbackDao.findAllFeedbackByTaskid(taskPerson.getTaskId(),
					taskPerson.getPerson().getId());
			if (taskFeedbackList != null && taskFeedbackList.size() > 0) {
				throw new ArsException("紧急任务已接收过，不能重复接收！");
			}
			TaskPerson dbTaskPerson = taskPersonDao.findByTaskIdPersonId(taskPerson.getTaskId(),
					taskPerson.getPerson().getId());
			if (dbTaskPerson.getAcceptStatus().equals(4)) {
				throw new ArsException("紧急任务已过期！");
			}
			dbTaskPerson.setAcceptStatus(taskPerson.getAcceptStatus());
			dbTaskPerson.setUpdateTime(new Date());
			taskPersonDao.update(dbTaskPerson);
			Task task = taskDao.findById(taskPerson.getTaskId());
			if (task == null) {
				task = taskDao.findUrgentById(taskPerson.getTaskId());
			}
			// 如果是紧急任务
			if (task.getTaskType().getId() == 4l) {
				// 紧急任务接受后，删除其他未接受的紧急任务
				// 判断人员当前是否有紧急任务，如果有则不推送
				List<TaskPerson> list = taskPersonDao.findUnAcceptByPersonId(taskPerson.getPerson().getId());
				for (TaskPerson tPerson : list) {
					List<TaskPersonSchedule> tpsList = taskPersonScheduleDao.findByTaskPersonIdStatus(tPerson.getId(),
							null);
					for (TaskPersonSchedule tps : tpsList) {
						taskPersonScheduleDao.deleteDetailByPersonSchedule(tps);
					}
					taskPersonScheduleDao.deleteByTaskPersonId(tPerson.getId());
					taskPersonDao.delete(tPerson);
				}
				// 通知本人
				String urgentTaskMsg = Constants.URGENTTASK_MSG;
				urgentTaskMsg = urgentTaskMsg.replace("%TASKNAME%", task.getName());
				urgentTaskMsg = urgentTaskMsg.replace("%ADDRESS%", task.getAddress());
				SecurityPerson person = personDao.findById(taskPerson.getPerson().getId());
				// 短信通知
				MessageUtil.sendMessage(person.getPhone(),
						urgentTaskMsg.replace("%PERSONNAME%", person.getRealName()),messageLogDao);
				// 获取单位信息
				SecurityCompany company = person.getRelation().getCompany();
				// 通知应急小队负责人
				List<UrgentPerson> personList = urgentTeamPersonDAO.queryUrgentPersonByCompnyId(company.getId());
				if (personList != null) {
					for (UrgentPerson urgentPerson : personList) {
						if (urgentPerson.isInCharge()) {
							String urgentChargeTaskMsg = Constants.URGENTTASK_MSG;
							urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%TASKNAME%", task.getName());
							urgentChargeTaskMsg = urgentChargeTaskMsg.replace("%ADDRESS%", task.getAddress());
							MessageUtil.sendMessage(urgentPerson.getPhone(),
									urgentChargeTaskMsg.replace("%PERSONNAME%", person.getRealName()),messageLogDao);
						}
					}
				}
			}
			// 任务被接受后，创建具体的任务
			try {
				createTaskFeedbackByTask(task, taskPerson.getPerson().getId());
			} catch (Exception e) {

			}
		}
		return taskFeedbackLog;
	}

	private void createTaskFeedbackByTask(Task task, long personId) {
		Long nativeCode = arsUtil.getCurrentNatvie();
		if (nativeCode == null) {
			nativeCode = task.getNativeCode();
		}
		TaskPerson taskPerson = taskPersonDao.findByTaskIdPersonId(task.getId(), personId);
		if (taskPerson != null && taskPerson.getAcceptStatus() != null && taskPerson.getAcceptStatus().equals(1)) {
			if (task.getTaskType().getId().equals(4l)) {
				// 紧急任务
				TaskFeedback feedback = new TaskFeedback();
				feedback.setNativeCode(nativeCode);
				feedback.setPerson(taskPerson.getPerson());
				feedback.setTask(task);
				feedback.setTaskStart(DateUtil.convertDateToString(DateUtil.convertStringToDate(task.getStartDate()),
						DateUtil.FORMAT5));
				TaskStatus taskStatus = new TaskStatus();
				taskStatus.setId(2l);
				feedback.setTaskStatus(taskStatus);
				feedback.setScheduleId(1l);
				feedback.setTaskDate(DateUtil.getCurrentDate());
				feedback.setScheduleName("紧急任务");
				feedback.setStartTime(new Date());
				feedback.setCreateTime(new Date());
				feedback.setUpdateTime(new Date());
				feedbackDao.save(feedback);
			}
		}
	}

	@Override
	public List<TaskFeedbackLog> findFeedbackLogList(Long personId, Long feedbackId) {
		return taskFeedbackLogDao.findFeedbackLogList(personId, feedbackId);
	}

}
