package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.ThirdPartyDao;
import com.bcxin.ars.dto.page.ThirdPartyPageSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ThirdParty;
import com.bcxin.ars.service.sys.ThirdPartyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
/**
 * 第三方对接信息Service实现类
 *
 * @author linqinglin
 * @Date 2020-05-15 10:14:15
 */
@Service
@Transactional
public class ThirdPartyServiceImpl implements ThirdPartyService {

    Logger logger = LoggerFactory.getLogger(ThirdPartyServiceImpl.class);

    @Autowired
    private ThirdPartyDao thirdPartyDao;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(ThirdParty thirdParty) {
        User currentUser = arsUtil.getCurrentUser();
        thirdParty.setUpdateTime(new Date());
        thirdParty.setUpdateBy(currentUser.getUsername());
        return thirdPartyDao.delete(thirdParty);
    }

    @Override
    public int save(ThirdParty thirdParty) throws Exception {
        User currentUser = arsUtil.getCurrentUser();
        if(thirdParty.getId() == null){
            thirdParty.setCreateTime(new Date());
            thirdParty.setId(idWorker.nextId());
            thirdParty.setClientSecret(StringUtil.createRandomCharData(10));
        }else{
            ThirdParty dbThirdParty = thirdPartyDao.findById(thirdParty.getId());
            BeanUtils.copyPropertiesIgnore(thirdParty,dbThirdParty,true);
            BeanUtils.copyPropertiesIgnore(dbThirdParty,thirdParty,false);
        }
        thirdParty.setActive(true);
        thirdParty.setUpdateBy(currentUser.getUsername());
        thirdParty.setUpdateTime(new Date());
        thirdParty.setUpdateflag(true);
        return thirdPartyDao.save(thirdParty);
    }

    @Override
    public ThirdParty findById(Long id) {
        return thirdPartyDao.findById(id);
    }

    @Override
    public void searchForPage(ThirdPartyPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
       thirdPartyDao.searchForPage(dto,page);
    }

}
