/*
 * Copyright (c) 2015 xuerdongcom@126.com All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 */
package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.sys.SysareaDAO;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.dto.TreeView;
import com.bcxin.ars.dto.sys.SysareaSearchDTO;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xuerdong
 * @since 1.1
 */
@Service(value = "areaService")
public class SysareaServiceImpl implements SysareaService {
	@Autowired
	private SysareaDAO sysareaDAO;

	@Autowired
	private ArsUtil arsUtil;
	
	@Autowired
	private ConfigDao configDao;
	
	@Override
	public List<TreeView>  searchForTreeView(SysareaSearchDTO sysareaSearchDTO) {
		User user = arsUtil.getCurrentUser();
		sysareaSearchDTO.setPath(user.getPolice().getPath());
		sysareaSearchDTO.setUserid(user.getId());

		return sysareaDAO.searchForTreeView(sysareaSearchDTO);
	}

	@Override
	public List<TreeView> searchForCompany(SysareaSearchDTO sysareaSearchDTO) {
		User user = arsUtil.getCurrentUser();
		sysareaSearchDTO.setPath(user.getPolice().getPath());
		sysareaSearchDTO.setUserid(user.getId());
		return sysareaDAO.searchForCompany(sysareaSearchDTO);
	}
	/**
	 * 查询
	 * @param dto
	 * @return
	 */
	@Override
	public SysareaSearchDTO search(SysareaSearchDTO dto) {
		SysareaSearchDTO resultDto = new SysareaSearchDTO();
		List<Sysarea> list =  sysareaDAO.search(dto);
		resultDto.setData(list);
		resultDto.setTotalCount(sysareaDAO.count(dto));
		return resultDto;
	}

	@Override
	public SysareaSearchDTO searchAll(SysareaSearchDTO dto){
		SysareaSearchDTO resultDto = new SysareaSearchDTO();
		List<Sysarea> list = sysareaDAO.searchAll(dto);
		resultDto.setData(list);
		return resultDto;
	}
	
	@Override
	public List<Sysarea> findByParentId(Long parentid) {
		return sysareaDAO.findByParentId(parentid);
	}

	@Override
	public Sysarea findByCode(String code) {
		return sysareaDAO.findByCode(code);
	}
	
	@Override
	public List<TreeView> findTreeViewByCode(String areacode) {
		return sysareaDAO.findTreeViewByCode(areacode);
	}

	@Override
	public List<Sysarea> findCurrentAreaList(SysareaSearchDTO sysareaSearchDTO) {
		User user = arsUtil.getCurrentUser();
		sysareaSearchDTO.setPath(user.getPolice().getPath());
		sysareaSearchDTO.setUserid(user.getId());
		sysareaSearchDTO.setCode(user.getPolice().getAreacode());
		return sysareaDAO.findAreaListByParentCode(sysareaSearchDTO);
	}


	@Override
	public String findByCodeForFullName(String code) {
		StringBuffer result = new StringBuffer();

		if(StringUtil.isNotEmpty(code)) {
			//省份
			Sysarea province = sysareaDAO.findByCode(code.substring(0, 2) + "0000");
			//市级
			Sysarea city = sysareaDAO.findByCode(code.substring(0, 4) + "00");
			//区
			Sysarea district = sysareaDAO.findByCode(code);
			//拼凑省、市、区名称
			if (province != null) {
				result.append(province.getName());
			}
			if (city != null) {
				result.append(city.getName());
			}
			if (district != null) {
				result.append(district.getName());
			}
		}
		return  result.toString();
	}

	@Override
	public List<TreeView> searchSimpleTreeView(SysareaSearchDTO sysareaSearchDTO) {
		User user = arsUtil.getCurrentUser();
		sysareaSearchDTO.setPath(user.getPolice().getPath());
		sysareaSearchDTO.setUserid(user.getId());
		return sysareaDAO.searchSimpleTreeView(sysareaSearchDTO);
	}

	@Override
	public List<Sysarea> findCurrentSystemAreaList() {
		SysareaSearchDTO sysareaSearchDTO  = new SysareaSearchDTO();
		/**
		 * 当前省份信息
		 */
		Config provinceConfig = configDao.findByKey(Constants.CURRENT_PROVINCE);
		sysareaSearchDTO.setCode(provinceConfig.getValue());
		return sysareaDAO.findAreaListByParentCode(sysareaSearchDTO);
	}

	@Override
	public List<Tree> searchForTree(SysareaSearchDTO dto) {
		User currentUser = arsUtil.getCurrentUser();
		dto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(dto);
		List<Tree> list = sysareaDAO.searchForTree(dto);
		List<Tree> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {
			Map<String, List<Tree>> treeMap = list.stream().collect(Collectors.groupingBy(Tree::getId));
			Map<String, List<Tree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(Tree::getParentId));

			for (Tree tree : list) {
				if (groupMap.get(tree.getId()) != null) {
					tree.setChildren(groupMap.get(tree.getId()));
				}else{
					tree.setExpanded(true);
					tree.setState("open");
				}

				if (tree.getParentId() == null || treeMap.get(tree.getParentId()) == null) {
					resultList.add(tree);
				}
			}
		}

		return resultList;
	}

	@Override
	public List<LayTree> searchForLayTree(SysareaSearchDTO searchDto) {
		User currentUser = arsUtil.getCurrentUser();
		searchDto.setPoliceBusiness(true);
		arsUtil.setPoliceSearch(searchDto);
		List<LayTree> list = sysareaDAO.searchForLayTree(searchDto);

		List<LayTree> resultList = new ArrayList<>();
		if(list != null && list.size() > 0) {

			Map<String, List<LayTree>> treeMap = list.stream().collect(Collectors.groupingBy(LayTree::getId));
			Map<String, List<LayTree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(LayTree::getParentId));

			for (LayTree tree : list) {
				if (groupMap.get(tree.getId()) != null) {
					tree.setChildren(groupMap.get(tree.getId()));
				}else{
					tree.setOpen(true);
				}

				if (tree.getParentId() == null || treeMap.get(tree.getParentId()) == null) {
					resultList.add(tree);
				}
			}
		}

		return resultList;
	}


}