package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.ModuleMenuDao;
import com.bcxin.ars.dao.sys.ModulePermissionDao;
import com.bcxin.ars.dto.LayTree;
import com.bcxin.ars.dto.MenuTree;
import com.bcxin.ars.dto.page.ModuleMenuPageSearchDto;
import com.bcxin.ars.dto.sys.MenuDto;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.ModuleMenu;
import com.bcxin.ars.model.sys.ModulePermission;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 功能权限表Service实现类
 *
 * @author linqinglin
 * @Date 2020-03-27 14:35:21
 */
@Service
@Transactional
public class ModuleMenuServiceImpl implements ModuleMenuService {

    Logger logger = LoggerFactory.getLogger(ModuleMenuServiceImpl.class);

    @Autowired
    private ModuleMenuDao moduleMenuDao;

    @Autowired
    private ModulePermissionDao modulePermissionDao;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;


    @Override
    public int save(ModuleMenu moduleMenu) {
        User currentUser = arsUtil.getCurrentUser();

        if(moduleMenu.getId() == null){
            moduleMenu.setId(idWorker.nextId());
            moduleMenu.setActive(true);
            moduleMenu.setCreateTime(new Date());
        }else{
            ModuleMenu dbModuleMenu = moduleMenuDao.findById(moduleMenu.getId());
            BeanUtils.copyPropertiesIgnore(moduleMenu,dbModuleMenu,true);
            BeanUtils.copyPropertiesIgnore(dbModuleMenu,moduleMenu,false);
        }

        if(moduleMenu.getParentId() != null){
            ModuleMenu parentMenu = moduleMenuDao.findById(moduleMenu.getParentId());
            moduleMenu.setParentIds((StringUtil.isEmpty(parentMenu.getParentIds())? moduleMenu.getId()+"/":parentMenu.getParentIds()) + moduleMenu.getId()+"/");
        }else{
            moduleMenu.setParentIds(moduleMenu.getId()+"/");
        }

        moduleMenu.setUpdateBy(currentUser.getUsername());
        moduleMenu.setUpdateTime(new Date());
        return moduleMenuDao.save(moduleMenu);
    }

    @Override
    public ModuleMenu findById(Long id) {
        return moduleMenuDao.findById(id);
    }

    @Override
    public void delete(ModuleMenu moduleMenu) {
        User currentUser = arsUtil.getCurrentUser();
        moduleMenu.setActive(false);
        moduleMenu.setUpdateTime(new Date());
        moduleMenu.setUpdateBy(currentUser.getUsername());
        moduleMenuDao.updateSelective(moduleMenu);
    }

    @Override
    public void updateSeq(ModuleMenu moduleMenu) {

        if(moduleMenu.getParentId() != null){
            ModuleMenu parentMenu = moduleMenuDao.findById(moduleMenu.getParentId());
            moduleMenu.setParentIds((StringUtil.isEmpty(parentMenu.getParentIds())?"":parentMenu.getParentIds()) + parentMenu.getId()+"/");
        }else{
            moduleMenu.setParentIds(null);
        }

        if(moduleMenu.getSeq() == null){
            Integer seq = moduleMenuDao.getMaxSeq(moduleMenu.getParentId());
            moduleMenu.setSeq(seq);
        }

        User currentUser = arsUtil.getCurrentUser();
        moduleMenu.setUpdateTime(new Date());
        moduleMenu.setUpdateBy(currentUser.getUsername());
        moduleMenuDao.save(moduleMenu);
        moduleMenuDao.updateSeq(moduleMenu);
    }

    @Override
    public void enable(ModuleMenu moduleMenu) {
        User currentUser = arsUtil.getCurrentUser();
        moduleMenu.setActive(true);
        moduleMenu.setUpdateTime(new Date());
        moduleMenu.setUpdateBy(currentUser.getUsername());
        moduleMenuDao.updateSelective(moduleMenu);
    }

    @Override
    public List<ModuleMenu> searchForTree(ModuleMenuPageSearchDto dto, AjaxPageResponse page) {
        page.setPagination(false);
        List<ModuleMenu> list = moduleMenuDao.searchForPage(dto,page);

        List<ModuleMenu> treeList = new ArrayList<>();
        Map<Long,List<ModuleMenu>> groupMap = list.stream().filter(((menu)-> menu.getParentId() != null)).collect(Collectors.groupingBy(ModuleMenu::getParentId));

        for (ModuleMenu moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }

        for (ModuleMenu moduleMenu : list) {
            if(moduleMenu.getChildren() != null && moduleMenu.getChildren().size() > 0){

            }else{
                moduleMenu.setState("open");
            }
            if(moduleMenu.getParentId() == null){
                treeList.add(moduleMenu);
            }
        }

        return treeList;
    }

    @Override
    public List<MenuDto> searchForGXTree() {
        List<MenuDto> list = moduleMenuDao.searchForGX();

        List<MenuDto> treeList = new ArrayList<>();
        Map<Long,List<MenuDto>> groupMap = list.stream().filter(((menu)-> menu.getParentId() != null)).collect(Collectors.groupingBy(MenuDto::getParentId));

        for (MenuDto moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }

        for (MenuDto moduleMenu : list) {
            moduleMenu.setState("open");
            if(moduleMenu.getParentId() == null){
                treeList.add(moduleMenu);
            }
        }

        return treeList;
    }

    @Override
    public List<ModuleMenu> findForMenu() {
        User currentUser = arsUtil.getCurrentUser();
        List<ModuleMenu> list = moduleMenuDao.findByUserAndMenuType(currentUser, Constants.MENUTYPE_MENU);

        List<ModuleMenu> treeList = new ArrayList<>();
        Map<Long,List<ModuleMenu>> groupMap = list.stream().filter(((menu)-> menu.getParentId() != null && menu.getMenuType().equals(Constants.MENUTYPE_MENU))).collect(Collectors.groupingBy(ModuleMenu::getParentId));

        for (ModuleMenu moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }

        for (ModuleMenu moduleMenu : list) {
            if(moduleMenu.getChildren() != null && moduleMenu.getChildren().size() > 0){

            }else{
                moduleMenu.setState("open");
            }
            if(moduleMenu.getParentId() == null){
                treeList.add(moduleMenu);
            }
        }

        return treeList;
    }

    @Override
    public List<ModuleMenu> setMenuTree(List<ModuleMenu> list) {
        List<ModuleMenu> treeList = new ArrayList<>();
        Map<Long,List<ModuleMenu>> groupMap = list.stream().filter(((menu)-> menu.getParentId() != null && menu.getMenuType().equals(Constants.MENUTYPE_MENU))).collect(Collectors.groupingBy(ModuleMenu::getParentId));

        for (ModuleMenu moduleMenu : list) {
            moduleMenu.setChildren(groupMap.get(moduleMenu.getId()));
        }

        for (ModuleMenu moduleMenu : list) {
            if(moduleMenu.getChildren() != null && moduleMenu.getChildren().size() > 0){

            }else{
                moduleMenu.setState("open");
            }
            if(moduleMenu.getParentId() == null){
                treeList.add(moduleMenu);
            }
        }

        return treeList;
    }

    @Override
    public List<MenuTree> findMenuTreeForPermission(Long roleId){
        User currentUser = arsUtil.getCurrentUser();
        List<MenuTree> result = new ArrayList<>();
        List<MenuTree> list = moduleMenuDao.findMenuTreeForPermission(currentUser,roleId);
        List<ModulePermission> permissionList = modulePermissionDao.findByRoleId(roleId);

        Map<Long, ModulePermission> permissionMap = permissionList.stream().collect(Collectors.toMap(ModulePermission::getModuleMenuId, Function.identity()));

        if(list != null && list.size() > 0) {
            boolean disabled = false;
            if(roleId != null) {
                List<PoliceRole> roleList = currentUser.getRoles();
                if (roleList != null && roleList.size() > 0) {
                    for (PoliceRole role : roleList) {
                        if (role.getId().longValue() == roleId.longValue()) {
                            disabled = true;
                        }
                    }
                }
            }

            List<MenuTree> treeList = new ArrayList<>();

            String mainId = "1";
            MenuTree mainTree = new MenuTree();
            mainTree.setId(mainId);
            mainTree.setLabel("全选");
            mainTree.setSpread(true);
            mainTree.setDisabled(disabled);
            Map<String, List<MenuTree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(MenuTree::getParentId));

            for (MenuTree menuTree : list) {
                menuTree.setDisabled(disabled);

                if(permissionMap.get(Long.parseLong(menuTree.getId())) != null){
                    menuTree.setChecked(true);
                }

                menuTree.setChildren(groupMap.get(menuTree.getId()));
                if (menuTree.getChildren() != null && menuTree.getChildren().size() > 0) {
                    menuTree.setChecked(false);
                }
                if (menuTree.getParentId() == null) {
                    menuTree.setParentId(mainId);
                    treeList.add(menuTree);
                }
            }

            mainTree.setChildren(treeList);
            result.add(mainTree);
        }

        //List<ModuleMenu> menus = moduleMenuDao.getOldData1();
        //List<ModuleMenu> menus = moduleMenuDao.getOldData3("2");
        //for (ModuleMenu moduleMenu : menus) {
        //    moduleMenu.setId(idWorker.nextId());
        //    moduleMenu.setActive(true);
        //    moduleMenu.setCreateTime(new Date());
        //    moduleMenu.setUpdateTime(new Date());
        //    moduleMenu.setParentIds(moduleMenu.getParentIds()+moduleMenu.getId()+"/");
        //    moduleMenu.setUpdateBy("system");
        //    moduleMenuDao.save(moduleMenu);
        //}
        return result;
    }

    @Override
    public List<LayTree> findForLayTree(){
        User currentUser = arsUtil.getCurrentUser();
        List<LayTree> list = moduleMenuDao.findForLayTree(currentUser);
        List<LayTree> resultList = new ArrayList<>();
        if(list != null && list.size() > 0) {
            Map<String, List<LayTree>> treeMap = list.stream().collect(Collectors.groupingBy(LayTree::getId));
            Map<String, List<LayTree>> groupMap = list.stream().filter(((menu) -> menu.getParentId() != null)).collect(Collectors.groupingBy(LayTree::getParentId));

            for (LayTree tree : list) {
                if (groupMap.get(tree.getId()) != null) {
                    tree.setChildren(groupMap.get(tree.getId()));
                }else{
                    tree.setOpen(true);
                }

                if (tree.getParentId() == null || treeMap.get(tree.getParentId()) == null) {
                    resultList.add(tree);
                }
            }
        }

        return resultList;
    }

    @Override
    public List<ModuleMenu> findForPermission(User user) {
        return moduleMenuDao.findForPermission(user);
    }

    @Override
    public void useOld(ModuleMenu moduleMenu) {
        List<ModuleMenu> menus = moduleMenuDao.getOldData2(moduleMenu.getPlatform());
        for (ModuleMenu menu : menus) {
            menu.setId(idWorker.nextId());
            menu.setActive(true);
            menu.setCreateTime(new Date());
            menu.setUpdateTime(new Date());
            menu.setParentIds(menu.getParentIds()+menu.getId()+"/");
            menu.setUpdateBy("system");
            moduleMenuDao.save(menu);
        }
        menus = moduleMenuDao.getOldData3(moduleMenu.getPlatform());
        for (ModuleMenu menu : menus) {
            menu.setId(idWorker.nextId());
            menu.setActive(true);
            menu.setCreateTime(new Date());
            menu.setUpdateTime(new Date());
            menu.setParentIds(menu.getParentIds()+menu.getId()+"/");
            menu.setUpdateBy("system");
            moduleMenuDao.save(menu);
        }
    }

    @Override
    public ModuleMenu findByUniqueId(String uniqueId) {
        return moduleMenuDao.findByUniqueId(uniqueId);
    }

    @Override
    public void searchForPage(ModuleMenuPageSearchDto dto, AjaxPageResponse page) {
        arsUtil.setPoliceSearch(dto);
        moduleMenuDao.searchForPage(dto,page);
    }

}
