package com.bcxin.ars.service.sys.impl;


import com.abcxin.smart.validator.annotation.MinisterialAttr;
import com.abcxin.smart.validator.annotation.MinisterialEntity;
import com.bcxin.ars.dao.sys.MinisterialLogDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.enums.MinisterialDataType;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.MinisterialLog;
import com.bcxin.ars.service.sys.MinisterialLogService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据上报部级接口记录Service业务层处理
 * 
 * @author linqinglin
 * @date 2021-03-04
 */
@Service
@Transactional
public class MinisterialLogServiceImpl implements MinisterialLogService {
    
    Logger logger = LoggerFactory.getLogger(MinisterialLogServiceImpl.class);
    
    @Autowired
    private MinisterialLogDao ministerialLogDao;


    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Override
    public int delete(MinisterialLog ministerialLog) {
        User currentUser = arsUtil.getCurrentUser();
        ministerialLog.setUpdateTime(new Date());
        ministerialLog.setUpdateBy(currentUser.getUsername());
        return ministerialLogDao.delete(ministerialLog);
    }

    @Override
    public int save(MinisterialLog ministerialLog) {
        User currentUser = arsUtil.getCurrentUser();
        if(ministerialLog.getId() == null){
            ministerialLog.setCreateTime(new Date());
        }else{
            MinisterialLog dbMinisterialLog = ministerialLogDao.findById(ministerialLog.getId());
            BeanUtils.copyPropertiesIgnore(ministerialLog,dbMinisterialLog,true);
            BeanUtils.copyPropertiesIgnore(dbMinisterialLog,ministerialLog,false);
        }

        ministerialLog.setActive(true);
        ministerialLog.setUpdateBy(currentUser.getUsername());
        ministerialLog.setUpdateTime(new Date());
        ministerialLog.setAreaCode(currentUser.getPolice().getAreacode());
        return ministerialLogDao.save(ministerialLog);
    }

    @Override
    public MinisterialLog findById(Long id) {
        return ministerialLogDao.findById(id);
    }

    @Override
    public MinisterialLog find(MinisterialLog ministerialLog) {
        return ministerialLogDao.find(ministerialLog);
    }

    @Override
    public void importBatch(List<MinisterialLog> list) {
        List<MinisterialLog> dbList = ministerialLogDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (MinisterialLog ministerialLog : list) {
                ministerialLog.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                        ministerialLog.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, ministerialLog.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ministerialLogDao.saveBatch(list);
        }
    }

    @Override
    public List<MinisterialLog> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return ministerialLogDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<MinisterialLog> findDSOutList(String startDate) {
        return ministerialLogDao.findDSOutList(startDate);
    }

    @Override
    public List<MinisterialLog> findByBatchId(List<MinisterialLog> list) {
        return ministerialLogDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(MinisterialLog ministerialLog) {
        User currentUser = arsUtil.getCurrentUser();
        ministerialLog.setUpdateTime(new Date());
        ministerialLog.setUpdateBy(currentUser.getUsername());
        ministerialLogDao.updateSelective(ministerialLog);
    }


    @Override
    public List<Map> getBusinessDatas(MinisterialDataType dataType,int limit){
        Class entityClass = dataType.getDataClazz();
        if(!entityClass.isAnnotationPresent(MinisterialEntity.class)){
            return null;
        }
        MinisterialEntity entityAnno = (MinisterialEntity)entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();
        String extraWhere = entityAnno.extraWhere();

        StringBuilder tableColumns = new StringBuilder();
        Field[] fields = entityClass.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(MinisterialAttr.class)) {
                MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                if (StringUtil.isNotEmpty(resource.DATE_FORMAT())){
                    tableColumns
                            .append("DATE_FORMAT( t1.")
                            .append(resource.column())
                            .append(",'")
                            .append(resource.DATE_FORMAT())
                            .append("') as ")
                            .append(field.getName())
                            .append(",");
                } else {
                    // 子查询就不加t1了
                    if (!resource.isSubQuery()) {
                        tableColumns
                                .append(" t1.");
                    }
                    tableColumns
                            .append(resource.column())
                            .append(" as ")
                            .append(field.getName())
                            .append(",");
                }
            }
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("dataType",dataType.getCode());
        paramMap.put("tableName",tableName);
        paramMap.put("tableColumns",columns);
        paramMap.put("limit",limit);
        paramMap.put("extraWhere",extraWhere);
        return ministerialLogDao.findByType(paramMap);
    }

    @Override
    public List<Map> getBusinessDatasByParam(MinisterialDataType dataType,Map paramMap){
        Class entityClass = dataType.getDataClazz();
        MinisterialEntity entityAnno = (MinisterialEntity)entityClass.getAnnotation(MinisterialEntity.class);
        String tableName = entityAnno.tableName();

        StringBuilder tableColumns = new StringBuilder();
        Field[] fields = entityClass.getDeclaredFields();
        for (Field field : fields) {
            if (field.isAnnotationPresent(MinisterialAttr.class)) {
                MinisterialAttr resource = field.getAnnotation(MinisterialAttr.class);
                if (StringUtil.isNotEmpty(resource.DATE_FORMAT())){
                    tableColumns
                            .append("DATE_FORMAT( t1.")
                            .append(resource.column())
                            .append(",'")
                            .append(resource.DATE_FORMAT())
                            .append("') as ")
                            .append(field.getName())
                            .append(",");
                }else{
                    // 子查询就不加t1了
                    if (!resource.isSubQuery()) {
                        tableColumns
                                .append(" t1.");
                    }
                    tableColumns
                            .append(resource.column())
                            .append(" as ")
                            .append(field.getName())
                            .append(",");
                }
            }
        }
        String columns = tableColumns.toString();
        columns = columns.substring(0, columns.length() - 1);

        paramMap.put("dataType",dataType.getCode());
        paramMap.put("tableName",tableName);
        paramMap.put("tableColumns",columns);
        return ministerialLogDao.findByParam(paramMap);
    }

    @Override
    public void saveByType(MinisterialLog ministerialLog, List subList) {
        ministerialLogDao.saveByType(ministerialLog,subList);

    }
}
