package com.bcxin.ars.service.sys.impl;

import com.bcxin.ars.dao.sys.DataChangeDao;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.DataChange;
import com.bcxin.ars.service.sys.DataChangeService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.IdWorker;
import com.bcxin.ars.util.BeanUtils;
import com.bcxin.ars.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
/**
 * 数据变更记录表Service实现类
 *
 * @author linqinglin
 * @Date 2020-05-09 14:18:13
 */
@Service
@Transactional
public class DataChangeServiceImpl implements DataChangeService {

    Logger logger = LoggerFactory.getLogger(DataChangeServiceImpl.class);

    @Autowired
    private DataChangeDao dataChangeDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    @Autowired
    private IdWorker idWorker;

    @Override
    public int delete(DataChange dataChange) {
        User currentUser = arsUtil.getCurrentUser();
        dataChange.setUpdateTime(new Date());
        dataChange.setUpdateBy(currentUser.getUsername());
        return dataChangeDao.delete(dataChange);
    }

    @Override
    public int save(DataChange dataChange) {
        User currentUser = arsUtil.getCurrentUser();
        if(dataChange.getId() == null){
            dataChange.setId(idWorker.nextId());
            dataChange.setCreateTime(new Date());
        }else{
            DataChange dbDataChange = dataChangeDao.findById(dataChange.getId());
            BeanUtils.copyPropertiesIgnore(dataChange,dbDataChange,true);
            BeanUtils.copyPropertiesIgnore(dbDataChange,dataChange,false);
        }

        dataChange.setActive(true);
        dataChange.setUpdateTime(new Date());
        dataChange.setUpdateflag(true);
        if(currentUser != null) {
            dataChange.setUpdateBy(currentUser.getUsername());
        }else{
            dataChange.setUpdateBy("system");
        }
        return dataChangeDao.save(dataChange);
    }

    @Override
    public DataChange findById(Long id) {
        return dataChangeDao.findById(id);
    }

    @Override
    public void importBatch(List<DataChange> list) {
        List<DataChange> dbList = dataChangeDao.findByBatchId(list);
        //去掉重复的
        //通过重写 equals跟hashCode方法 实现根据id与updatetime判断是否需要更新。
        list.removeAll(dbList);
        if (list.size()>0){
            for (DataChange dataChange : list) {
                dataChange.setUpdateflag(false);
                try {
                    if(!configUtils.isIntranet()){
                       dataChange.setUpdateTime(DateUtil.dateAdd(DateUtil.DATATYPE_SECOND, dataChange.getUpdateTime(), 1));
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            dataChangeDao.saveBatch(list);
        }
    }

    @Override
    public List<DataChange> searchForDataSynchronization(DataSynchronizationSearchDto dto) {
        return dataChangeDao.searchForDataSynchronization(dto);
    }

    @Override
    public List<DataChange> findDSOutList(String startDate) {
        return dataChangeDao.findDSOutList(startDate);
    }

    @Override
    public List<DataChange> findByBatchId(List<DataChange> list) {
        return dataChangeDao.findByBatchId(list);
    }

    @Override
    public void updateSelective(DataChange dataChange) {
        User currentUser = arsUtil.getCurrentUser();
        dataChange.setUpdateTime(new Date());
        dataChange.setUpdateBy(currentUser.getUsername());
        dataChangeDao.updateSelective(dataChange);
    }
}
