package com.bcxin.ars.service.syncDepart;

import com.bcxin.ars.dao.*;
import com.bcxin.ars.dao.sb.*;
import com.bcxin.ars.fingerPrint.FingerPrint;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.model.sb.Investor;
import com.bcxin.ars.model.sb.ManagementInfo;
import com.bcxin.ars.model.sb.Vehicle;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.webservice.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/** 上报部级接口（这些表目前业务系统不存在）
 * Created by llc on 2018/1/24
 */
@Service
@Transactional
public class SyncDepartServiceImpl implements SyncDepartService {

    @Autowired
    private ClientUtil clientUtil;
    @Autowired
    private NationService nationService;
    private static Logger logger = LoggerFactory.getLogger(ClientUtil.class);

    @Autowired
    private PoliceService policeService;

    @Autowired
    private SecurityCompanyService securityCompanyService;
    @Autowired
    private InvestorDao investorDao;
    @Autowired
    private FirearmsDao firearmsDao;
    @Autowired
    private SbRewardDao sbRewardDao;
    @Autowired
    private SbBusinessOutsideManagementDao sbBusinessOutsideManagementDao;
    @Autowired
    private UserDao userDao;
    @Autowired
    private SecurityCompanyDao securityCompanyDao;
    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;
    @Autowired
    private ManagementInfoDao managementInfoDao;
    @Autowired
    private Bdgk_baService bdgk_baService;
    @Autowired
    private CyCheckDao cyCheckDao;
    @Value("${base-folder}")
    private String baseFolder;
    @Autowired
    private ConfigDao configDao;
    @Autowired
    private VehicleDao vehicleDao;
    //北京ftp临时目录
    @Value("${ftpServerTemp}")
    private String ftpServerTemp;


    @Autowired
    private CyAssociationDao cyAssociationDao;
    /**
     * 上报保安从业单位押运车辆配备情况基本信息（已完成对接测试）
     * @param bacydwclpbxx
     */
   @Override
    public void syncBacydwclpbxx(Bacydwclpbxx bacydwclpbxx){
           logger.info("上报部级数据【上报保安从业单位押运车辆配备情况基本信】……");
           try {
               //调用send方法完成对接
               Result result =  clientUtil.send(Constants.XXBA_BACYDWCLPBXX, bacydwclpbxx);
               logger.info("返回编码："+result.getCODE());
               logger.info("上报成功……");
           } catch (Exception e) {
               logger.error(e.getMessage(),e);
           }


    }

    @Autowired
    private ApprovalService approvalService;
    /**
     * 上报保安从业单位及保安培训机构监督检查被处理人基本信息 （已完成对接测试）
     * @param badwjdjcbclrxx
     */
    @Override
    public void syncBadwjdjcbclrxx(Badwjdjcbclrxx badwjdjcbclrxx){
            logger.info("上报部级数据【上报保安从业单位及保安培训机构监督检查被处理人基本信息】……");
            badwjdjcbclrxx.setBagsbm("BAG610003");  // BAG + 两位省编码 + 阿拉伯数字顺序号，以0001开始
            badwjdjcbclrxx.setJcrq("20170101");
            badwjdjcbclrxx.setJclx("1");
            badwjdjcbclrxx.setSfzh("360502197908195017");
            badwjdjcbclrxx.setZw("保安小队长");
            badwjdjcbclrxx.setCljg("01");
            badwjdjcbclrxx.setFkje("1000");
            badwjdjcbclrxx.setMswfsdje("2000");
            badwjdjcbclrxx.setBz1("");
            badwjdjcbclrxx.setBz2("");
            badwjdjcbclrxx.setBz3("");
            try {
//           //确定对接的属性对应关系
//           //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
//           String[] key={"bagsmc","bagsbm"};
//           String[] value={user.getRealname(),securityCompany.getCompanyCode()};
//           //源实体类的列，目标实体类的列
//           sbBusinessOutsideManagement.setNational(CodeChangeUtil.getValue(sbBusinessOutsideManagement.getNational()));
//           String[] srccol = {"national","securityType","businessModel","businessStartTime","businessEndTime","filingAuthorityName","filingAuthorityDate"};
//           String[] desccol = {"gj","fwlx","jyms","jyksrq","jyjsrq","bajgmc","barq"};
//           //生成实体
//           Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sbBusinessOutsideManagement,new Hwjyxx(),key,value);
//           Hwjyxx hwjyxx =(Hwjyxx)desc;
                //调用send方法完成对接
                Result result =  clientUtil.send(Constants.XXBA_BADWJDJCBCLRXX, badwjdjcbclrxx);
                logger.info("返回编码："+result.getCODE());
                logger.info("上报成功……");
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
            }

    }


    /**
     * 参与协助公安工作情况基本信息 （已完成对接测试）
     * @param bacyxzgzxx
     */
    @Override
    public void syncBacyxzgzxx(Bacyxzgzxx bacyxzgzxx){
            logger.info("上报部级数据【参与协助公安工作情况基本信息】……");
            bacyxzgzxx.setBm("610102198706167896");
            bacyxzgzxx.setLb("1");
            bacyxzgzxx.setSj("帮助公安破案111");
            bacyxzgzxx.setWhjjss("20000");
            bacyxzgzxx.setZhxyr("6");
            bacyxzgzxx.setXzgzlx("01");
            bacyxzgzxx.setXzgzrq("20170302");
            bacyxzgzxx.setBz1("");
            bacyxzgzxx.setBz2("");
            bacyxzgzxx.setBz3("");

            try {
//           //确定对接的属性对应关系
//           //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
//           String[] key={"bagsmc","bagsbm"};
//           String[] value={user.getRealname(),securityCompany.getCompanyCode()};
//           //源实体类的列，目标实体类的列
//           sbBusinessOutsideManagement.setNational(CodeChangeUtil.getValue(sbBusinessOutsideManagement.getNational()));
//           String[] srccol = {"national","securityType","businessModel","businessStartTime","businessEndTime","filingAuthorityName","filingAuthorityDate"};
//           String[] desccol = {"gj","fwlx","jyms","jyksrq","jyjsrq","bajgmc","barq"};
//           //生成实体
//           Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sbBusinessOutsideManagement,new Hwjyxx(),key,value);
//           Hwjyxx hwjyxx =(Hwjyxx)desc;
                //调用send方法完成对接
                Result result =  clientUtil.send(Constants.XXBA_BACYXZGZXX, bacyxzgzxx);
                logger.info("返回编码："+result.getCODE());
                logger.info("上报成功……");
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
            }

    }

    /**
     * 上报培训机构培训开展情况基本信息
     * @param baypxqk
     */
    @Override
    public void syncBaypxqk(Baypxqk baypxqk){
            logger.info("上报部级数据【上报培训机构培训开展情况基本信息】……");
            baypxqk.setPxdwbm("BAG610002");
            baypxqk.setPxlx("1");
            baypxqk.setPxksrq("20170601");
            baypxqk.setPxjsrq("20170701");
            baypxqk.setPxrs("20");
            baypxqk.setBz1("");
            baypxqk.setBz2("");
            baypxqk.setBz3("");

            try {
//           //确定对接的属性对应关系
//           //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
//           String[] key={"bagsmc","bagsbm"};
//           String[] value={user.getRealname(),securityCompany.getCompanyCode()};
//           //源实体类的列，目标实体类的列
//           sbBusinessOutsideManagement.setNational(CodeChangeUtil.getValue(sbBusinessOutsideManagement.getNational()));
//           String[] srccol = {"national","securityType","businessModel","businessStartTime","businessEndTime","filingAuthorityName","filingAuthorityDate"};
//           String[] desccol = {"gj","fwlx","jyms","jyksrq","jyjsrq","bajgmc","barq"};
//           //生成实体
//           Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sbBusinessOutsideManagement,new Hwjyxx(),key,value);
//           Hwjyxx hwjyxx =(Hwjyxx)desc;
                //调用send方法完成对接
                Result result =   clientUtil.send(Constants.XXBA_BAYPXQK, baypxqk);
                logger.info("返回编码："+result.getCODE());
                logger.info("上报成功……");
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
            }

    }

    /**
     * 上报其他信息
     * @param baqtxx  （已完成对接测试）
     */
    @Override
    public void syncBaqtxx(Baqtxx baqtxx){
        logger.info("上报部级数据【上报其他信息】……");
            baqtxx.setSbm("61");
            baqtxx.setSjglyxm("张三");
            baqtxx.setSjglyxb("");
            baqtxx.setSjglyzw("管理员");
            baqtxx.setSjglydw("xxx公司");
            baqtxx.setKfdw("百川信网络技术有限公司");
            baqtxx.setKffzrxm("苏炳辉");
            baqtxx.setWhdw("百川信网络技术有限公司");
            baqtxx.setWhfzrxm("苏炳辉");
            baqtxx.setBz1("");
            baqtxx.setBz2("");
            baqtxx.setBz3("");

            try {
//           //确定对接的属性对应关系
//           //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
//           String[] key={"bagsmc","bagsbm"};
//           String[] value={user.getRealname(),securityCompany.getCompanyCode()};
//           //源实体类的列，目标实体类的列
//           sbBusinessOutsideManagement.setNational(CodeChangeUtil.getValue(sbBusinessOutsideManagement.getNational()));
//           String[] srccol = {"national","securityType","businessModel","businessStartTime","businessEndTime","filingAuthorityName","filingAuthorityDate"};
//           String[] desccol = {"gj","fwlx","jyms","jyksrq","jyjsrq","bajgmc","barq"};
//           //生成实体
//           Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,sbBusinessOutsideManagement,new Hwjyxx(),key,value);
//           Hwjyxx hwjyxx =(Hwjyxx)desc;
                //调用send方法完成对接
                Result result =   clientUtil.send(Constants.XXBA_BAQTXX, baqtxx);
                logger.info("返回编码："+result.getCODE());
                logger.info("上报成功……");
            } catch (Exception e) {
                logger.error(e.getMessage(),e);
            }
        }

    /**
     * 创建WebService数据实体类
     *
     * @param person
     */
    @Override
    public void buildWebServiceEntity(SecurityPerson person) throws Exception {
        logger.info("上报部级数据【保安员信息】……");
        //System.out.println("person==" + person.toString());
        Bayxxb bayxxb = new Bayxxb();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("sfzh", new KeyAndDefauleVal("idNumber", null));
        map.put("xm", new KeyAndDefauleVal("realname", person.getRealName()));
        //性别
         String gender = IdNumUtil.getSexByIdCard(person.getIdNumber());

        map.put("xb", new KeyAndDefauleVal("gender", gender.equals("男") ? "1" : "2"));
        map.put("csrq", new KeyAndDefauleVal("idNumber", IdNumUtil.getBirthByIdCard(person.getIdNumber())));
        Nation nation = nationService.findByName(person.getNation());
        if(nation!=null) {
            map.put("mz", new KeyAndDefauleVal("nation", nation.getCode()));
        }else{
            map.put("mz", new KeyAndDefauleVal("nation","01"));
        }
        map.put("whcd", new KeyAndDefauleVal("edu", person.getEdu() != null ? person.getEdu().toString() : ""));
        map.put("zzmm", new KeyAndDefauleVal("politics", null));
        map.put("hj", new KeyAndDefauleVal("natives", person.getNatives() != null ? person.getNatives().toString() : ""));
        map.put("xxdz", new KeyAndDefauleVal("idCardAddress", null));
        map.put("hyzk", new KeyAndDefauleVal("marriage", "90"));
        map.put("byzk", new KeyAndDefauleVal("enrolled", person.getEnrolled() != null ? "1" : "0"));
        map.put("sg", new KeyAndDefauleVal("stature", person.getStature() != null ? person.getStature().toString() : ""));
        map.put("fzjgbm", new KeyAndDefauleVal("certificatejgno", null));
        map.put("fzjgmc", new KeyAndDefauleVal("certificatejgname", null));
        if(StringUtil.isNotEmpty(person.getCertificatejgtime())){
            map.put("fzrq", new KeyAndDefauleVal("certificatejgtime", person.getCertificatejgtime().replaceAll("-","")));
        }else {
            map.put("fzrq", new KeyAndDefauleVal("certificatejgtime", null));
        }

        map.put("zwxx", new KeyAndDefauleVal("fingerprintsno", null));
        map.put("zpxx", new KeyAndDefauleVal("photo", StringUtil.isNotEmpty(person.getPhoto())? person.getPhoto().substring(person.getPhoto().lastIndexOf("/")+1):""));
        map.put("pxdwbm", new KeyAndDefauleVal("traincompanyno", null));
        map.put("baydj", new KeyAndDefauleVal("starLevel", person.getStarLevel() != null ? person.getStarLevel().toString() : ""));
        map.put("sflz", new KeyAndDefauleVal("guardStatus", person.getGuardStatus() != null ? person.getGuardStatus().toString() : ""));

        //无
        map.put("bayzbm", new KeyAndDefauleVal("realname", ""));
        map.put("dxjdjgbm", new KeyAndDefauleVal("realname", ""));
        map.put("dxjdjg", new KeyAndDefauleVal("realname", ""));
        map.put("lrjgbm", new KeyAndDefauleVal("realname", ""));
        map.put("lrjgmc", new KeyAndDefauleVal("realname", ""));
        map.put("lrd", new KeyAndDefauleVal("realname", ""));
        map.put("bz1", new KeyAndDefauleVal("realname", ""));
        map.put("bz2", new KeyAndDefauleVal("realname", ""));
        map.put("bz3", new KeyAndDefauleVal("realname", ""));
        map.put("sfybaz", new KeyAndDefauleVal("realname", ""));

        try {
            EntityForWebServiceUtil.copy(map, person, bayxxb);
            System.out.println("bayxxb==" + bayxxb.toString());
            clientUtil.send(Constants.XXBA_BAYXXB, bayxxb);
            logger.info("上报成功……");
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }
    public static String addZeroForNum(String str, int strLength) {
        int strLen = str.length();
        if (strLen < strLength) {
            while (strLen < strLength) {
                StringBuffer sb = new StringBuffer();
                sb.append("0").append(str);// 左补0
                // sb.append(str).append("0");//右补0
                str = sb.toString();
                strLen = str.length();
            }
        }

        return str;
    }

    public static void main(String[] args) {
        String photo ="getResource.do?path=upload/2019-09-09/1568023334117132.jpg";
        if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=")) {
            System.out.println(photo);
        }

        System.out.println( photo.substring(photo.lastIndexOf("/")+1));
    }
    /**
     * 创建WebService数据实体类
     *
     * @param company
     */
    private void buildWebServiceEntity(SecurityCompany company) throws Exception {

        logger.info("上报部级数据【保安公司】……");
        System.out.println("company==" + company.toString());
        Bagsxxb bagsxxb = new Bagsxxb();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        //必填
        Config config =  configDao.findByKey("current_native");
        bagsxxb.setBagsbm(company.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("bagsbm", bagsxxb.getBagsbm()));
        map.put("bagsmc", new KeyAndDefauleVal("name", null));
        if(config!=null){
             map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", config.getValue()+"GBF" + company.getPublicSecurityLicenseNumber()));
        }else{
            map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", "GBF" + company.getPublicSecurityLicenseNumber()));
        }
        //非必填
        map.put("gj", new KeyAndDefauleVal("national", null));
        map.put("zcdxz", new KeyAndDefauleVal("location", null));
        map.put("zczj", new KeyAndDefauleVal("registeredMoney", null));
        map.put("frsfzh", new KeyAndDefauleVal("legalPersonNo", null));
        map.put("frxm", new KeyAndDefauleVal("legalPerson", null));
        map.put("fzrsfzh", new KeyAndDefauleVal("principalId", null));
        map.put("fzrxm", new KeyAndDefauleVal("principal", null));
        map.put("fzrdh", new KeyAndDefauleVal("principalPhone", null));
        map.put("jjlx", new KeyAndDefauleVal("economicType", null));
        map.put("gdzc", new KeyAndDefauleVal("fixedAssets", null));
        map.put("nyye", new KeyAndDefauleVal("turnoverYear", null));
        map.put("nls", new KeyAndDefauleVal("annualProfits", null));
        map.put("gslx", new KeyAndDefauleVal("companyType", null));



//        map.put("rlffdj", new KeyAndDefauleVal("humanDefenseLevel", StringUtil.isNotEmpty(company.getHumanDefenseLevel()) ? Integer.parseInt(company.getHumanDefenseLevel()) : 0));
//        map.put("wzyydj", new KeyAndDefauleVal("armedEscortLevel", StringUtil.isNotEmpty(company.getArmedEscortLevel()) ? Integer.parseInt(company.getArmedEscortLevel()) : 0));
//        map.put("aqjsdj", new KeyAndDefauleVal("securityTechnologyLevel", StringUtil.isNotEmpty(company.getSecurityTechnologyLevel()) ? Integer.parseInt(company.getSecurityTechnologyLevel()) : 0));
//        map.put("fxpgdj", new KeyAndDefauleVal("riskAssessmentLevel", StringUtil.isNotEmpty(company.getRiskAssessmentLevel()) ? Integer.parseInt(company.getRiskAssessmentLevel()) : 0));
//        map.put("sfslzgs", new KeyAndDefauleVal("isSubsidiary", company.getIsSubsidiary() != null ? Integer.parseInt(company.getIsSubsidiary()) : 0));

        //无
       /* map.put("zcd", new KeyAndDefauleVal("national", ""));
        map.put("frdh", new KeyAndDefauleVal("national", ""));
        map.put("fwlx", new KeyAndDefauleVal("national", ""));
        map.put("fzjgbm", new KeyAndDefauleVal("national", ""));
        map.put("fzjgmc", new KeyAndDefauleVal("national", ""));
        map.put("fzrq", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("dxjg", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("dxrq", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("zgsmc", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("bz1", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("bz2", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));
        map.put("bz3", new KeyAndDefauleVal("publicSecurityLicenseNumber", ""));*/

        try {
            EntityForWebServiceUtil.copy(map, company, bagsxxb);
            logger.info("bagsxxb==" + bagsxxb.toString());

            //TODO 缺失字段
            bagsxxb.setKhsl("1");
            bagsxxb.setBgbs("1");
            bagsxxb.setZjjk("1");
            bagsxxb.setGslx("1");

            clientUtil.send(Constants.XXBA_BAGSXXB, bagsxxb);
            logger.info("上报成功保安公司……");
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }
    /**
     * 指纹采集实体类xml
     * @param fingerPrint
     */
    @Override
    public StringBuffer testBho(FingerPrint fingerPrint){


        StringBuffer personInfoXml = new StringBuffer();
        personInfoXml.append("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"yes\"? >");
        personInfoXml.append("<MIS>");
        personInfoXml.append("<PersonInfo>");

        Field[] field = fingerPrint.getClass().getDeclaredFields();

        try {
            for (int j = 0; j < field.length; j++) { // 遍历所有属性

                String name = field[j].getName(); // 获取属性的名字
                String valuestr = "";
                name = name.substring(0, 1).toUpperCase() + name.substring(1); // 将属性的首字符大写
                Method m = fingerPrint.getClass().getMethod("get" + name);
                String value = (String) m.invoke(fingerPrint); // 调用getter方法获取属性值
                if (value != null && !"null".equals(value)) {
                    valuestr = value ;
                }
                personInfoXml.append("<" + name + ">" + valuestr + "</" + name +  ">");
            }
        }
         catch (NoSuchMethodException e) {
                logger.error(e.getMessage(),e);
            } catch (SecurityException e) {
                logger.error(e.getMessage(),e);
            } catch (IllegalAccessException e) {
                logger.error(e.getMessage(),e);
            } catch (IllegalArgumentException e) {
                logger.error(e.getMessage(),e);
            } catch (InvocationTargetException e) {
                logger.error(e.getMessage(),e);
            }

        personInfoXml.append("</PersonInfo>");
        personInfoXml.append("</MIS>");
        return  personInfoXml ;
    }

    @Autowired
    private PersoncertificateDao personcertificateDao;
    @Override
    public void bjsc() {
        logger.info("背景筛查start……");
        new Thread(()->{
            List<Bdgk_ba> list =  bdgk_baService.findAll();
            logger.info("人员总数："+list.size());
            for (Bdgk_ba ba :
                    list) {
                bdgk_baService.update(ba);
            }




        }).start();
        logger.info("背景筛查end……");


    }


    /**
     * 创建WebService数据实体类
     *
     * @param investor
     */
    private void buildWebServiceEntity(Investor investor) throws Exception {
        Bafwgsczrxx bafwgsczrxx = new Bafwgsczrxx();

        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("gj", new KeyAndDefauleVal("national", null));
        map.put("xb", new KeyAndDefauleVal("sex", investor.getSex()!=null?investor.getSex().equals("男") ? "1" : "2":"2"));
      //  map.put("mz", new KeyAndDefauleVal("nation", null));
        map.put("xxdz", new KeyAndDefauleVal("nowaddress", null));
        map.put("zzje", new KeyAndDefauleVal("nowaddress", null));
        map.put("szbl", new KeyAndDefauleVal("stockProportion", null));

        //无
        map.put("sffr", new KeyAndDefauleVal("investorsType", investor.getInvestorsType().equals("2")?"1":"0"));
        map.put("zjlx", new KeyAndDefauleVal("investorsType", investor.getInvestorsType().equals("2")?"02":"01"));
//        map.put("zjlx", new KeyAndDefauleVal("national", ""));
//        map.put("zjhm", new KeyAndDefauleVal("national", ""));
//        map.put("bz1", new KeyAndDefauleVal("national", ""));
//        map.put("bz2", new KeyAndDefauleVal("national", ""));
//        map.put("bz3", new KeyAndDefauleVal("national", ""));

        //从外部获取
        SecurityCompany securityCompany = securityCompanyDao.findByUserid(investor.getUserid());


        //公司编号
        investor.setPublicSecurityLicenseNumber(securityCompany.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("publicSecurityLicenseNumber", investor.getPublicSecurityLicenseNumber()));


        map.put("frmc", new KeyAndDefauleVal("companyCode", securityCompany.getLegalPerson()));
//        map.put("jllx", new KeyAndDefauleVal("companyCode", securityCompany.getEconomicType()));
        map.put("gdsfzh", new KeyAndDefauleVal("idNumber", investor.getIdNumber()));

        // map.put("csrq", new KeyAndDefauleVal("idNumber",IdNumUtil.getBirthByIdCard(investor.getIdNumber())));

        try {
            EntityForWebServiceUtil.copy(map, investor, bafwgsczrxx);
            //System.out.println("bafwgsczrxx==" + bafwgsczrxx.toString());
            clientUtil.send(Constants.XXBA_BAFWGSCZRXX, bafwgsczrxx);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }


    /**
     * 创建WebService数据实体类
     *
     * @param managementInfo
     */
    private void buildWebServiceEntity(ManagementInfo managementInfo, User user
    ) throws Exception {
        Bafwgsglry bafwgsglry = new Bafwgsglry();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        SecurityCompany securityCompany = securityCompanyDao.findByUserid(user.getId());
        //公司编号
        bafwgsglry.setBagsbm(securityCompany.getCompanyCode());
        map.put("bagsbm", new KeyAndDefauleVal("bagsbm",bafwgsglry.getBagsbm() ));
        map.put("sfzh", new KeyAndDefauleVal("managerId", managementInfo.getManagerId()));
        //  map.put("csrq", new KeyAndDefauleVal("idNumber", IdNumUtil.getBirthByIdCard(managementInfo.getManagerId())));
        map.put("xm", new KeyAndDefauleVal("name", null));
        map.put("xb", new KeyAndDefauleVal("sex", managementInfo.getSex() == "男" ? 1 : 0));
        map.put("mz", new KeyAndDefauleVal("manageNation", null));
        map.put("zw", new KeyAndDefauleVal("jobName", null));
        map.put("baydj", new KeyAndDefauleVal("jobLevel", null));
        map.put("lxdh", new KeyAndDefauleVal("phone", null));
        map.put("gatlx", new KeyAndDefauleVal("managerLicenseType", "0"+managementInfo.getManagerLicenseType()));
        //无
        map.put("gj", new KeyAndDefauleVal("manageNation", ""));
        map.put("bz1", new KeyAndDefauleVal("manageNation", ""));
        map.put("bz2", new KeyAndDefauleVal("manageNation", ""));
        map.put("bz3", new KeyAndDefauleVal("manageNation", ""));

        try {
            EntityForWebServiceUtil.copy(map, managementInfo, bafwgsglry);
            clientUtil.send(Constants.XXBA_BAFWGSGLRY, bafwgsglry);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }
    @Override
    public void person() {
        new Thread(()-> {
            int i = 0;
            List<SecurityPerson> lsit = securityPersonService.findALl(i * 5000, 5000);
            do {
                for (SecurityPerson dbperson :
                        lsit) {
                        try {
                            //人员基本信息
                            SecurityPerson person = new SecurityPerson();
                            BeanUtils.copyProperties(dbperson, person);
                            //婚姻状况
                            Map<String, String> marriage = new HashMap<>();
                            marriage.put("1", "10");
                            marriage.put("2", "20");
                            marriage.put("3", "30");
                            marriage.put("4", "40");
                            marriage.put("9", "90");
                            person.setMarriage(marriage.get(person.getMarriage()));
                            buildWebServiceEntity(person);
                            //从业信息
                            SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonService.findSingleByPerson(person);
                            if(securityCompanyPerson!=null && securityCompanyPerson.getCompany()!=null) {
                                Baycyqkxx baycyqkxx = new Baycyqkxx();
                                baycyqkxx.setXm(person.getRealName());
                                baycyqkxx.setSfzh(person.getIdNumber());
                                baycyqkxx.setCydwlx("1");
                                baycyqkxx.setRzrq(DateUtil.convertDateToString(securityCompanyPerson.getCreateTime(),DateUtil.FORMAT11));
                                baycyqkxx.setCydwmc(securityCompanyPerson.getCompany().getName());
                                baycyqkxx.setCydwbh(securityCompanyPerson.getCompany().getCompanyCode());
                                //调用send方法完成对接
                                clientUtil.send(Constants.XXBA_BAYCYQKXX,baycyqkxx);
                            }

                    }catch(Exception e){
                        logger.error(e.getMessage(), e);
                    }
                }
                i++;
                lsit = securityPersonService.findALl(i * 5000, 5000);
            }while (lsit.size()!=0);


        }).start();
    }
    @Override
    public void img() {
        new Thread(()-> {
            int i = 0;
            List<SecurityPerson> lsit = securityPersonService.findALl(i * 5000, 5000);
            do {
                for (SecurityPerson dbperson :
                        lsit) {
                    try {
                        SecurityPerson person = new SecurityPerson();
                        BeanUtils.copyProperties(dbperson, person);
                        String photo = person.getPhoto();
                        if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=")) {
                            //照片分类	zpfl	2	Y	字符	01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                            String fileType = photo.substring(photo.lastIndexOf("."));
                            //图片转BASE64字符串
                            if (!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                                photo = Base64Img.encodeBase64File(photo, baseFolder);
                            } else {
                                photo = Base64Img.encodeBase64FileBJ(photo, ftpServerTemp);
                            }
                            //BASE64字符串转图片 --测试用
                            Zpxxb zpxxb = new Zpxxb();
                            zpxxb.setSfzh(person.getIdNumber());
                            zpxxb.setZpxx(person.getIdNumber() + fileType);
                            zpxxb.setZpnr(photo);
                            zpxxb.setZpfl("01");//01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                            //调用send方法完成对接
                            clientUtil.send(Constants.XXBA_ZPXXB, zpxxb);
                        }
                    }catch(Exception e){
                        logger.error(e.getMessage(), e);
                    }
                }
                i++;
                lsit = securityPersonService.findALl(i * 5000, 5000);
            }while (lsit.size()!=0);


        }).start();
    }
    /**
     * 创建WebService数据实体类
     *
     * @param dbSbSubsidiaryBase
     */
    private void buildWebServiceEntity(SbSubsidiaryBase dbSbSubsidiaryBase) throws Exception {
        Bafwgsfgsxx bafwgsfgsxx = new Bafwgsfgsxx();
        Map<String, KeyAndDefauleVal> map = new HashMap<String, KeyAndDefauleVal>();
        map.put("fgsmc", new KeyAndDefauleVal("companyName", dbSbSubsidiaryBase.getCompanyName()));
        map.put("xxdz", new KeyAndDefauleVal("registerAddress", null));
        map.put("jydxz", new KeyAndDefauleVal("businessPlace", null));
        map.put("bajgbm", new KeyAndDefauleVal("filingAuthorityCode", null));
        map.put("bajgmc", new KeyAndDefauleVal("filingAuthorityName", null));
//        map.put("barq", new KeyAndDefauleVal("filingAuthorityDate", dbSbSubsidiaryBase.getFilingAuthorityDate()));
        //无
        map.put("zcdz", new KeyAndDefauleVal("registerAddress", ""));
        map.put("jydz", new KeyAndDefauleVal("registerAddress", ""));
        map.put("bz1", new KeyAndDefauleVal("filingAuthorityName", ""));
        map.put("bz2", new KeyAndDefauleVal("filingAuthorityName", ""));
        map.put("bz3", new KeyAndDefauleVal("filingAuthorityName", ""));
        //从外部获取
        map.put("bafwxkz", new KeyAndDefauleVal("publicSecurityLicenseNumber", dbSbSubsidiaryBase.getCode()));
        try {
            EntityForWebServiceUtil.copy(map, dbSbSubsidiaryBase, bafwgsfgsxx);
            clientUtil.send(Constants.XXBA_BAFWGSFGSXX, bafwgsfgsxx);
        } catch (Exception e) {
            logger.error(e.getMessage(),e);
        }
    }
    @Override
    public void bjRest() {
        logger.info("部级接口start……");
        //上报公司信息
        new Thread(()->{
        //公司
        try{
            //保安服务公司
            List<SecurityCompany> list = securityCompanyService.findByAllForBj("0102");
            for (SecurityCompany dbcompany:
                    list) {
                try {
                    SecurityCompany company = new SecurityCompany();
                    BeanUtils.copyProperties(dbcompany, company);
                    buildWebServiceEntity(company);
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }
            }
            //培训单位
            List<SecurityCompany> list2 = securityCompanyService.findByAllForBj("0103");
            for (SecurityCompany dbcompany:
                    list2) {
                try {

                    Bapxdwxx bapxdwxx =new Bapxdwxx();
                    bapxdwxx.setPxdwbm(dbcompany.getCompanyCode());
                    bapxdwxx.setPxdwmc(dbcompany.getName());
                    //调用send方法完成对接
                    clientUtil.send(Constants.XXBA_BAPXDWXX,bapxdwxx);
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }
            }
            //自行招用
            List<SecurityCompany> list3 = securityCompanyService.findByAllForBj("0104");
            for (SecurityCompany dbcompany:
                    list3) {
                try {
                    //生成实体
                    Zxzybaydwxx zxzybaydwxx =new Zxzybaydwxx();
                    //自行招用保安员的单位编码
                    zxzybaydwxx.setDwbm(dbcompany.getCompanyCode());
                    zxzybaydwxx.setDwmc(dbcompany.getName());
                    //调用send方法完成对接
                    clientUtil.send(Constants.XXXBA_ZXZYBAYDWXX,zxzybaydwxx);
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }
            }
            //分公司
            List<SecurityCompany> list4 = securityCompanyService.findByAll("0105");
            for (SecurityCompany dbcompany:
                    list4) {
                try {
                    //生成实体
                    SbSubsidiaryBase sbSubsidiaryBase =new SbSubsidiaryBase();
                    if(StringUtil.isNotEmpty(dbcompany.getParentId())) {
                        SecurityCompany pcompany = securityCompanyService.findById(Long.valueOf(dbcompany.getParentId()));
                        sbSubsidiaryBase.setCode(pcompany.getCompanyCode());
                        sbSubsidiaryBase.setCompanyName(dbcompany.getName());
                    }
                    //调用send方法完成对接
                    buildWebServiceEntity(sbSubsidiaryBase);
                }catch (Exception e ){
                    logger.error(e.getMessage(),e);
                }
            }
        }catch (Exception e){
            logger.error(e.getMessage(),e);
        }
        }).start();
        //上报保安从业单位押运车辆配备情况基本信息
        new Thread(()->{
            List<Vehicle> list =  vehicleDao.findAll();
            for (Vehicle dbVehicle:
                    list ) {
                try{
                    Bacydwclpbxx bacydwclpbxx = new Bacydwclpbxx();
                    SecurityCompany securityCompany = securityCompanyDao.findByUserid(dbVehicle.getUserid());
                    bacydwclpbxx.setBagsbm(securityCompany.getCompanyCode());
                    //车辆识别代号
                    bacydwclpbxx.setVin(dbVehicle.getFramenum());
                    //车牌号
                    bacydwclpbxx.setCph(dbVehicle.getVehiclenum());
                    //发动机号
                    bacydwclpbxx.setFdzh(dbVehicle.getEnginenum());
                    //购买日期
                    if(dbVehicle.getProductiondate()!=null) {
                        bacydwclpbxx.setGmrq(DateUtil.convertDateToString(dbVehicle.getProductiondate(), DateUtil.FORMAT11));
                    }
                    //报废日期
                    if(dbVehicle.getScrapdate()!=null) {
                        bacydwclpbxx.setBfrq(DateUtil.convertDateToString(dbVehicle.getScrapdate(), DateUtil.FORMAT11));
                    }
                    syncBacydwclpbxx(bacydwclpbxx);
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                }
            }

        }).start();
        //保安服务公司出资人信息
        new Thread(()->{
            List<Investor> list = investorDao.findByAll();
            for (Investor dbInvestor:
                    list ) {
                try{
                    buildWebServiceEntity(dbInvestor);
                }catch (Exception e){
                    logger.error(e.getMessage(),e);
                }
            }

        }).start();
        //保安服务公司主要管理人员信息
        new Thread(()->{
            List<ManagementInfo> list = managementInfoDao.findByAll();
            for (ManagementInfo dbManagementInfo:
            list) {
                try {
                User user = userDao.findById(dbManagementInfo.getUserid());
                buildWebServiceEntity(dbManagementInfo,user);
                } catch(Exception e) {
                    logger.error(e.getMessage(),e);
                }
            }
        }).start();
        //保安服务公司枪支配备情况基本信息
        new Thread(()->{
                List<Firearms> list = firearmsDao.findByAll();
                    for (Firearms dbFirearms:
                            list) {
                        try {
                            SecurityCompany dbcompany = securityCompanyService.findByUserid(dbFirearms.getUserid());
                            //确定对接的属性对应关系
                            //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
                            String[] key={"bagsbm","qzbh"};
                            String[] value={dbcompany.getCompanyCode(),"1"};
                            //源实体类的列，目标实体类的列
                            String[] srccol = {"firearmsnum","firearmscompany","firearmcertification"};
                            String[] desccol = {"qh","zzqymc","fzdwmc"};
                            //生成实体
                            Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,dbFirearms,new Bacydwqzpbxx(),key,value);
                            Bacydwqzpbxx bacydwqzpbxx =(Bacydwqzpbxx)desc;
                            //调用send方法完成对接
                            clientUtil.send(Constants.XXBA_BACYDWQZPBXX,bacydwqzpbxx);
                        } catch(Exception e) {
                            e.printStackTrace();
                            logger.error(e.getMessage(),e);
                        }
                    }

        }).start();
        //保安监管力量基本信息
        new Thread(()->{
            List<User> list  = userDao.findByAllPolice();
            for (User user:
                    list) {
                try {
                    Police org = policeService.findById(user.getOrgid());
                     Bajgll bajgll = new Bajgll();
                    if(StringUtil.isNotEmpty(user.getIdNumber())) {
                        //姓名
                        bajgll.setXm(user.getRealname());

                        String sex = IdNumUtil.getGenderByIdCard(user.getIdNumber());
                        if(StringUtil.isNotEmpty(sex)){
                             bajgll.setXb((sex.equals("男") ? "1" : "0"));
                        }
                        bajgll.setJgjgbh(org.getCode());
                        bajgll.setJgjgmc(org.getOrgname());
                        bajgll.setJgjgdz(org.getAreacode());
                        bajgll.setJgjgxz(org.getAddress());
                        bajgll.setJgzt("1");
                        bajgll.setSfzh(user.getIdNumber());
                        bajgll.setSj(user.getPhone());
                        //调用send方法完成对接
                        clientUtil.send(Constants.XXBA_BAJGLL, bajgll);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    logger.error(e.getMessage(),e);
                }
            }
        }).start();
        //公安机关保安监管机构基本信息
        new Thread(()->{
            List<Police> list = policeService.findAll();
            for (Police police:
                    list) {
                try {
                        //确定对接的属性对应关系
                        //源实体类的列，目标实体类的列
                        String[] srccol = {"code","orgname","address","contact","tel","phone"};
                        String[] desccol = {"jgjgbm","jgjgmc","bgdz","fzrmc","zbdh","czdh"};
                        //key中存放的是特殊情况下的列，1源实体类没有，而目标实体类必填的2源实体类跟目标实体类值类型不匹配的，比如性别等，value存放特殊列的值。如果没有，则放空
                        String[] key = {};
                        String[] value = {};
                        //生成实体
                        Object desc = BuildWebServiceEntity.buildWebServiceEntity(srccol,desccol,police,new Policesecsuporg(),key,value);
                        Policesecsuporg policesecsuporg =(Policesecsuporg)desc;
                        //调用send方法完成对接
                        clientUtil.send(Constants.XXBA_POLICESECSUPORG,policesecsuporg);
                } catch(Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
        //保安员基本信息
        new Thread(()-> {
            int i = 0;
            List<SecurityPerson> lsit = securityPersonService.findALl(i * 5000, 5000);
            do {
                for (SecurityPerson dbperson :
                        lsit) {
                    try {
                        //人员基本信息
                        SecurityPerson person = new SecurityPerson();
                        BeanUtils.copyProperties(dbperson, person);
                        //婚姻状况
                        Map<String, String> marriage = new HashMap<>();
                        marriage.put("1", "10");
                        marriage.put("2", "20");
                        marriage.put("3", "30");
                        marriage.put("4", "40");
                        marriage.put("9", "90");
                        person.setMarriage(marriage.get(person.getMarriage()));
                        buildWebServiceEntity(person);
                        //从业信息
                        SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonService.findSingleByPerson(person);
                        if(securityCompanyPerson!=null && securityCompanyPerson.getCompany()!=null) {
                            Baycyqkxx baycyqkxx = new Baycyqkxx();
                            baycyqkxx.setXm(person.getRealName());
                            baycyqkxx.setSfzh(person.getIdNumber());
                            baycyqkxx.setCydwlx("1");
                            baycyqkxx.setRzrq(DateUtil.convertDateToString(securityCompanyPerson.getCreateTime(),DateUtil.FORMAT11));
                            baycyqkxx.setCydwmc(securityCompanyPerson.getCompany().getName());
                            baycyqkxx.setCydwbh(securityCompanyPerson.getCompany().getCompanyCode());
                            //调用send方法完成对接
                            clientUtil.send(Constants.XXBA_BAYCYQKXX,baycyqkxx);
                        }
                        //头像信息
                        String photo = person.getPhoto();
                        if (StringUtil.isNotEmpty(photo) && photo.startsWith("getResource.do?path=")) {
                            //照片分类	zpfl	2	Y	字符	01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                            String fileType = photo.substring(photo.lastIndexOf("."));
                            //图片转BASE64字符串
                            if (!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
                                photo = Base64Img.encodeBase64File(photo, baseFolder);
                            } else {
                                photo = Base64Img.encodeBase64FileBJ(photo, ftpServerTemp);
                            }
                            //BASE64字符串转图片 --测试用
                            Zpxxb zpxxb = new Zpxxb();
                            zpxxb.setSfzh(person.getIdNumber());
                            zpxxb.setZpxx(person.getIdNumber() + fileType);
                            zpxxb.setZpnr(photo);
                            zpxxb.setZpfl("01");//01：保安员；02:保安服务公司；03：自招单位；04：培训单位
                            //调用send方法完成对接
                            clientUtil.send(Constants.XXBA_ZPXXB, zpxxb);
                        }
                    }catch(Exception e){
                        logger.error(e.getMessage(), e);
                    }
                }
                i++;
                lsit = securityPersonService.findALl(i * 5000, 5000);
            }while (lsit.size()!=0);


        }).start();
        logger.info("部级接口end……");
    }
}
